/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.outbill;

import java.util.Date;
import java.util.Set;
import java.util.TimeZone;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.inte.api.IInteService;
import kd.bos.service.ServiceFactory;
import kd.scmc.im.utils.IMStringUtils;

public class MaterialReqDateValidator
extends AbstractValidator {
    private IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);

    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add("lotnumber");
        set.add("producedate");
        set.add("expirydate");
        set.add("supplyownertype");
        return set;
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.lotNumValidator(dataEntity);
            this.checkBizTime(dataEntity);
            this.shelfLifeDateValidator(dataEntity);
            this.checkSupplierOwnerType(dataEntity);
        }
    }

    private void checkSupplierOwnerType(ExtendedDataEntity dataEntity) {
        String supplyOwnerType;
        DynamicObject billEntity = dataEntity.getDataEntity();
        DynamicObject bizType = billEntity.getDynamicObject("biztype");
        if (bizType != null && "6".equals(bizType.get("domain")) && !"bd_supplier".equals(supplyOwnerType = billEntity.getString("supplyownertype"))) {
            String msg = ResManager.loadKDString((String)"VMI\u4e1a\u52a1\u7c7b\u578b\u4ec5\u80fd\u9886\u7528\u8d27\u4e3b\u4e3a\u4f9b\u5e94\u5546\u7684\u5e93\u5b58\uff0c\u8bf7\u4fee\u6539\u4e1a\u52a1\u7c7b\u578b\u6216\u8d27\u4e3b\u7c7b\u578b\u3002", (String)"MaterialReqDateValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, msg, ErrorLevel.Error);
        }
    }

    private void lotNumValidator(ExtendedDataEntity dataEntity) {
        DynamicObject billEntity = dataEntity.getDataEntity();
        DynamicObjectCollection col = billEntity.getDynamicObjectCollection("billentry");
        for (DynamicObject row : col) {
            String lotNum = row.getString("lotnumber");
            if (row.getBoolean("material.enablelot")) {
                if (StringUtils.isEmpty((CharSequence)(lotNum = lotNum.replaceAll("\u3000", " ").trim()))) continue;
                row.set("lotnumber", (Object)lotNum);
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)(lotNum = lotNum.replaceAll("\u3000", " ").trim()))) continue;
            String msg = ResManager.loadKDString((String)"\u7b2c%s\u884c\u7269\u6599\u672a\u5f00\u542f\u6279\u53f7\u7ba1\u7406\uff0c\u6279\u53f7\u4e0d\u5141\u8bb8\u6709\u503c\u3002", (String)"MaterialReqDateValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, String.format(msg, row.getInt("seq")), ErrorLevel.Error);
        }
    }

    private void shelfLifeDateValidator(ExtendedDataEntity dataEntity) {
        DynamicObject billEntity = dataEntity.getDataEntity();
        DynamicObjectCollection col = billEntity.getDynamicObjectCollection("billentry");
        int count = 0;
        for (DynamicObject row : col) {
            Date produceDate = row.getDate("producedate");
            Date expiryDate = row.getDate("expirydate");
            DynamicObject materialInvInfo = row.getDynamicObject("material");
            if (materialInvInfo == null || materialInvInfo.getBoolean("enableshelflifemgr") || produceDate == null && expiryDate == null) continue;
            String msg = ResManager.loadKDString((String)"\u7b2c%s\u884c\u7269\u6599\u672a\u5f00\u542f\u4fdd\u8d28\u671f\u7ba1\u7406\uff0c\u201c\u751f\u4ea7\u65e5\u671f\u201d\u548c\u201c\u5230\u671f\u65e5\u671f\u201d\u4e0d\u5141\u8bb8\u6709\u503c\u3002", (String)"MaterialReqDateValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, String.format(msg, row.getInt("seq")), ErrorLevel.Error);
            if (++count < 1000) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5931\u8d25\u4fe1\u606f\u8fc7\u591a\uff0c\u65e0\u6cd5\u5c55\u793a\uff0c\u5efa\u8bae\u5148\u5904\u7406\u73b0\u5728\u7684\u5931\u8d25\u539f\u56e0\u3002", (String)"MaterialReqDateValidator_5", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            break;
        }
    }

    private void checkBizTime(ExtendedDataEntity dataEntity) {
        LocaleString bizTimeName = dataEntity.getDataEntity().getDynamicObjectType().getProperty("biztime").getDisplayName();
        DynamicObject org = dataEntity.getDataEntity().getDynamicObject("org");
        TimeZone orgZone = this.getOrgZone(org);
        if (orgZone == null) {
            this.addMessage(dataEntity, IMStringUtils.append((String)bizTimeName.getLocaleValue(), (Object[])new Object[]{ResManager.loadKDString((String)"\u83b7\u53d6\u201c\u7ec4\u7ec7\u65f6\u533a\u201d\u548c\u201c\u7cfb\u7edf\u65f6\u533a\u201d\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MaterialReqDateValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0])}), ErrorLevel.FatalError);
        }
    }

    private TimeZone getOrgZone(DynamicObject org) {
        TimeZone timeZone = null;
        DynamicObject timezone = org.getDynamicObject("timezone");
        if (timezone == null) {
            timeZone = this.getSysTimezone();
        } else {
            String timeArea = timezone.getString("number");
            timeZone = TimeZone.getTimeZone(timeArea);
        }
        return timeZone;
    }

    private TimeZone getSysTimezone() {
        DynamicObject sysTimezoneMeta = this.service.getSysTimezone();
        String timeArea = sysTimezoneMeta.getString("number");
        return TimeZone.getTimeZone(timeArea);
    }
}

