/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.outbill;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.im.business.helper.CurrencyHelper;

public class MaterialReqOutQueryPriceValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(MaterialReqOutQueryPriceValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject settleCurrency;
            String mainOrg;
            StringBuilder alertMsg = new StringBuilder(ResManager.loadKDString((String)"\u5355\u636e", (String)"MaterialReqOutQueryPriceValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObject org = bill.getDynamicObject(mainOrg = ((BillEntityType)bill.getDataEntityType()).getMainOrg());
            if (org == null) {
                this.addNewLine(alertMsg, "\u3001");
                alertMsg.append(ResManager.loadKDString((String)"\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e3a\u7a7a", (String)"MaterialReqOutQueryPriceValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            } else {
                Long orgId = org.getLong("id");
                Map currencyAndExRateTable = CurrencyHelper.getCurrencyAndExRateTableCache((Long)orgId);
                if (currencyAndExRateTable == null || currencyAndExRateTable.values().isEmpty()) {
                    this.addNewLine(alertMsg, "\u3001");
                    alertMsg.append(ResManager.loadKDString((String)"\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u6c47\u7387\u8868\u3002", (String)"MaterialReqOutQueryPriceValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]));
                }
            }
            Date exrateDate = bill.getDate("biztime");
            if (exrateDate == null) {
                this.addNewLine(alertMsg, "\u3001");
                alertMsg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u4e3a\u7a7a", (String)"MaterialReqOutQueryPriceValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            }
            if ((settleCurrency = bill.getDynamicObject("settlecurrency")) == null) {
                this.addNewLine(alertMsg, "\u3001");
                alertMsg.append(ResManager.loadKDString((String)"\u5e01\u79cd\u4e3a\u7a7a", (String)"MaterialReqOutQueryPriceValidator_5", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            }
            this.checkMaterial(bill, alertMsg);
            if (alertMsg.length() <= 3) continue;
            String errorMsg = alertMsg.toString();
            alertMsg.append(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u4ef7\u683c\u3002", (String)"MaterialReqOutQueryPriceValidator_6", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }

    private void checkMaterial(DynamicObject bill, StringBuilder alertMsg) {
        DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
        if (billEntry.isEmpty()) {
            return;
        }
        ArrayList<String> rowIndex = new ArrayList<String>(billEntry.size());
        for (int i = 0; i < billEntry.size(); ++i) {
            DynamicObject entry = (DynamicObject)billEntry.get(i);
            DynamicObject materialInfo = entry.getDynamicObject("material");
            if (materialInfo != null) continue;
            rowIndex.add(String.valueOf(i));
        }
        if (!rowIndex.isEmpty()) {
            alertMsg.append(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5206\u5f55\u7b2c%s\u884c\u7269\u6599\u3002", (String)"MaterialReqOutQueryPriceValidator_7", (String)"scmc-im-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", rowIndex)));
        }
    }

    private void addNewLine(StringBuilder alterMsg, String symbol) {
        if (alterMsg.length() > 3) {
            alterMsg.append(symbol);
        }
    }
}

