/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.outbill;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import org.apache.commons.collections.CollectionUtils;

public class ProductlineValidator
extends AbstractValidator {
    private Map<Object, Set<Object>> orgGroupCache = new HashMap<Object, Set<Object>>(16);

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"ProductlineValidator", (String)"validate");){
            this.cacheProductline();
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                this.checkProductline(dataEntity);
            }
        }
    }

    private void cacheProductline() {
        HashMap orgGroup = new HashMap(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject invBill = dataEntity.getDataEntity();
            DynamicObjectCollection collect = invBill.getDynamicObjectCollection("billentry");
            DynamicObject org = invBill.getDynamicObject("org");
            if (org == null || CollectionUtils.isEmpty((Collection)collect)) continue;
            Object orgId = org.getPkValue();
            HashSet productlineSet = (HashSet)orgGroup.get(orgId);
            if (null == productlineSet) {
                productlineSet = new HashSet(16);
                orgGroup.put(orgId, productlineSet);
            }
            for (DynamicObject entry : collect) {
                DynamicObject productline = entry.getDynamicObject("productline");
                CollectionUtils.addIgnoreNull(productlineSet, (Object)this.getPkId(productline));
            }
        }
        if (orgGroup.isEmpty()) {
            return;
        }
        for (Map.Entry entry : orgGroup.entrySet()) {
            Long orgId = (Long)entry.getKey();
            Set productGrp = (Set)entry.getValue();
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_productline", (Long)orgId);
            qFilter.and("id", "in", (Object)productGrp);
            qFilter.and("enable", "=", (Object)Boolean.TRUE);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_productline", (String)"id", (QFilter[])qFilter.toArray(), null);
            Set productlineIdSet = dynamicObjects.stream().map(item -> item.get("id")).collect(Collectors.toSet());
            this.orgGroupCache.put(orgId, productlineIdSet);
        }
    }

    private Long getPkId(DynamicObject dynamicObject) {
        if (null != dynamicObject) {
            return (Long)dynamicObject.getPkValue();
        }
        return null;
    }

    private void checkProductline(ExtendedDataEntity dataEntity) {
        DynamicObject invBill = dataEntity.getDataEntity();
        DynamicObjectCollection collect = invBill.getDynamicObjectCollection("billentry");
        DynamicObject orgDym = invBill.getDynamicObject("org");
        if (orgDym == null || CollectionUtils.isEmpty((Collection)collect)) {
            return;
        }
        Long orgId = this.getPkId(orgDym);
        for (DynamicObject entry : collect) {
            Set<Object> productIds;
            DynamicObject productlineDym = entry.getDynamicObject("productline");
            if (productlineDym == null || (productIds = this.orgGroupCache.get(orgId)).contains(this.getPkId(productlineDym))) continue;
            String proNum = productlineDym.getString("number");
            String message = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u4ea7\u54c1\u7ebf\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\u3002", (String)"ProductlineValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), proNum);
            this.addMessage(dataEntity, message, ErrorLevel.Error);
        }
    }
}

