/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.outbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.CollectionUtils;

public class SalOutBillSaveValidator
extends AbstractValidator {
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"SalOutBillSaveValidator", (String)"validate");){
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                this.checkNum(dataEntity);
            }
        }
    }

    private void checkNum(ExtendedDataEntity dataEntity) {
        DynamicObject outObj = dataEntity.getDataEntity();
        DynamicObjectCollection entryList = outObj.getDynamicObjectCollection("billentry");
        if (CollectionUtils.isEmpty((Collection)entryList)) {
            return;
        }
        DynamicObjectCollection linkColl = ((DynamicObject)entryList.get(0)).getDynamicObjectCollection("billentry_lk");
        if (CollectionUtils.isEmpty((Collection)linkColl)) {
            return;
        }
        ArrayList outEntryIdList = new ArrayList();
        entryList.forEach(entry -> {
            Long entryId = (Long)entry.getPkValue();
            outEntryIdList.add(entryId);
        });
        List relationBackMapList = (List)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msisv", (String)"MsisvUnionPushRecordService", (String)"queryAllRelationUnionPushRecord", (Object[])new Object[]{"im_saloutbill", outEntryIdList, "im_invinspectbill"});
        if (CollectionUtils.isEmpty((Collection)relationBackMapList)) {
            return;
        }
        boolean isFirstPush = entryList.size() == relationBackMapList.size();
        HashMap<List, BigDecimal> salOutMap = new HashMap<List, BigDecimal>(entryList.size());
        if (isFirstPush) {
            entryList.forEach(entry -> {
                Long entryId = (Long)entry.getPkValue();
                salOutMap.put(Collections.singletonList(entryId), BigDecimal.ZERO);
            });
        }
        ArrayList<Long> inspectEntryIdList = new ArrayList<Long>(entryList.size());
        ArrayList<Long> outEntryIdForRelaList = new ArrayList<Long>(entryList.size());
        HashMap relaIdMap = new HashMap(relationBackMapList.size());
        for (Map relationEntryMap : relationBackMapList) {
            Long inspectEntryId = (Long)relationEntryMap.get("relentryid");
            inspectEntryIdList.add(inspectEntryId);
            Long salOutEntryId = (Long)relationEntryMap.get("tgtentryid");
            Object salOutEntryIdList = new ArrayList<Long>();
            if (relaIdMap.containsKey(inspectEntryId)) {
                salOutEntryIdList = (List)relaIdMap.get(inspectEntryId);
            }
            salOutEntryIdList.add(salOutEntryId);
            if (!isFirstPush && !outEntryIdList.contains(salOutEntryId)) {
                outEntryIdForRelaList.add(salOutEntryId);
            }
            relaIdMap.put(inspectEntryId, salOutEntryIdList);
        }
        QFilter inspectQ = new QFilter("billentry.id", "in", inspectEntryIdList);
        DynamicObjectCollection inspectEntryList = QueryServiceHelper.query((String)"im_invinspectbill", (String)"billentry.id,billentry.qualifiedbaseqty qualifiedbaseqty", (QFilter[])new QFilter[]{inspectQ});
        if (!isFirstPush) {
            Iterator salOutQ = new QFilter("billentry.id", "in", outEntryIdForRelaList);
            DynamicObjectCollection salOutDbEntryList = QueryServiceHelper.query((String)"im_saloutbill", (String)"billentry.id,billentry.baseqty baseqty", (QFilter[])new QFilter[]{salOutQ});
            for (Map.Entry entry2 : relaIdMap.entrySet()) {
                List salOutEntryIdValueList = (List)entry2.getValue();
                for (DynamicObject dynamicObject : salOutDbEntryList) {
                    if (!salOutEntryIdValueList.contains(dynamicObject.getLong("billentry.id"))) continue;
                    BigDecimal baseQty = dynamicObject.getBigDecimal("baseqty");
                    baseQty = baseQty.add(salOutMap.get(salOutEntryIdValueList) == null ? BigDecimal.ZERO : (BigDecimal)salOutMap.get(salOutEntryIdValueList));
                    salOutMap.put(salOutEntryIdValueList, baseQty);
                }
            }
        }
        for (DynamicObject inspectEntry : inspectEntryList) {
            List salOutIdList = (List)relaIdMap.get(inspectEntry.getLong("billentry.id"));
            BigDecimal bigDecimal2 = (BigDecimal)salOutMap.get(salOutIdList);
            bigDecimal2 = bigDecimal2 == null ? BigDecimal.ZERO : bigDecimal2;
            BigDecimal qualifiedBaseQty = inspectEntry.getBigDecimal("qualifiedbaseqty");
            salOutMap.put(salOutIdList, qualifiedBaseQty.subtract(bigDecimal2));
        }
        block4: for (int i = 0; i < entryList.size(); ++i) {
            DynamicObject entry2 = (DynamicObject)entryList.get(i);
            long entryId = entry2.getLong("id");
            BigDecimal baseQty = entry2.getBigDecimal("baseqty");
            if (isFirstPush) {
                BigDecimal salOutSubQty = (BigDecimal)salOutMap.get(Collections.singletonList(entryId));
                if (baseQty.compareTo(salOutSubQty) <= 0) continue;
                String string = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c{0}\u884c\uff1a\u68c0\u9a8c\u5408\u683c\u5269\u4f59\u53ef\u51fa\u5e93\u57fa\u672c\u6570\u91cf{1}\uff0c\u57fa\u672c\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u68c0\u9a8c\u5408\u683c\u5269\u4f59\u53ef\u51fa\u5e93\u57fa\u672c\u6570\u91cf\u3002", (String)"SalOutBillSaveValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[]{i + 1, salOutSubQty});
                this.addErrorMessage(dataEntity, string);
                continue;
            }
            for (Map.Entry entry3 : salOutMap.entrySet()) {
                List keyList = (List)entry3.getKey();
                if (!keyList.contains(entryId)) continue;
                BigDecimal salOutSubQty = (BigDecimal)entry3.getValue();
                if (baseQty.compareTo(salOutSubQty) <= 0) continue block4;
                String msg = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c{0}\u884c\uff1a\u68c0\u9a8c\u5408\u683c\u5269\u4f59\u53ef\u51fa\u5e93\u57fa\u672c\u6570\u91cf{1}\uff0c\u57fa\u672c\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u68c0\u9a8c\u5408\u683c\u5269\u4f59\u53ef\u51fa\u5e93\u57fa\u672c\u6570\u91cf\u3002", (String)"SalOutBillSaveValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[]{i + 1, salOutSubQty});
                this.addErrorMessage(dataEntity, msg);
                continue block4;
            }
        }
    }
}

