/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.plugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.utils.IMStringUtils;

public class BillTplBaseValidatorPlugin {
    private AddValidatorsEventArgs validators;
    private String op;
    private String formId;

    public BillTplBaseValidatorPlugin(AddValidatorsEventArgs validators, String op, String formId) {
        this.validators = validators;
        this.op = op;
        this.formId = formId;
    }

    public void validate() {
        HashSet<String> implClassSet = new HashSet<String>(16);
        this.boforeBizValidate(implClassSet);
        List<QFilter> validateCfgFilters = this.getBizValidateCfgFilters();
        DynamicObject cfg = BusinessDataServiceHelper.loadSingleFromCache((String)"im_validatorcfg", (QFilter[])validateCfgFilters.toArray(new QFilter[validateCfgFilters.size()]));
        if (cfg == null) {
            implClassSet.addAll(this.baseValidate());
        } else {
            implClassSet.addAll(this.bizValidate(cfg));
        }
        this.afterBizValidate(implClassSet);
        this.newInstanceValidate(implClassSet);
    }

    private void newInstanceValidate(Set<String> implClassSet) {
        for (String implClass : implClassSet) {
            try {
                Class<?> clazz = Class.forName(implClass);
                this.validators.addValidator((AbstractValidator)clazz.newInstance());
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", IMStringUtils.append((String)ResManager.loadKDString((String)"\u6821\u9a8c\u5668\u521d\u59cb\u5316\u5931\u8d25\uff1a", (String)"BillTplBaseValidatorPlugin_1", (String)"scmc-im-opplugin", (Object[])new Object[0]), (Object[])new Object[]{implClass, e.getMessage()})), new Object[0]);
            }
        }
    }

    private Set<String> baseValidate() {
        HashSet<String> implClassSet = new HashSet<String>(16);
        List<QFilter> validateCfgFilters = this.getValidateCfgFilters();
        if (validateCfgFilters.isEmpty()) {
            return implClassSet;
        }
        Map cfgs = BusinessDataServiceHelper.loadFromCache((String)"im_validatorcfg", (String)"entryentity.implclass,entryentity.op", (QFilter[])validateCfgFilters.toArray(new QFilter[validateCfgFilters.size()]));
        for (DynamicObject col : cfgs.values()) {
            DynamicObjectCollection entrys = col.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                String validateOp = entry.getString("op");
                if (!this.op.equalsIgnoreCase(validateOp)) continue;
                implClassSet.add(entry.getString("implclass"));
            }
        }
        return implClassSet;
    }

    protected void boforeBizValidate(Set<String> implClassSet) {
    }

    protected Set<String> bizValidate(DynamicObject cfg) {
        DynamicObjectCollection entrys = cfg.getDynamicObjectCollection("entryentity");
        HashSet<String> implClassSet = new HashSet<String>(entrys.size());
        for (DynamicObject entry : entrys) {
            String validateOp = entry.getString("op");
            if (!this.op.equalsIgnoreCase(validateOp)) continue;
            if (entry.getBoolean("isenable")) {
                implClassSet.add(entry.getString("implclass"));
                continue;
            }
            implClassSet.remove(entry.getString("implclass"));
        }
        return implClassSet;
    }

    protected void afterBizValidate(Set<String> implClassSet) {
    }

    private List<QFilter> getBizValidateCfgFilters() {
        ArrayList<QFilter> pluginFilterList = new ArrayList<QFilter>(16);
        pluginFilterList.add(new QFilter("validatebill", "=", (Object)this.formId));
        pluginFilterList.add(new QFilter("enable", "=", (Object)true));
        pluginFilterList.add(new QFilter("entryentity.op", "=", (Object)this.op));
        return pluginFilterList;
    }

    private List<QFilter> getValidateCfgFilters() {
        ArrayList<QFilter> pluginFilterList = new ArrayList<QFilter>(16);
        String validatorPluginName = this.getValidatorPluginName();
        if (StringUtils.isBlank((CharSequence)validatorPluginName)) {
            return pluginFilterList;
        }
        pluginFilterList.add(new QFilter("loadplugin", "=", (Object)validatorPluginName));
        pluginFilterList.add(new QFilter("validatebill", "=", (Object)" "));
        pluginFilterList.add(new QFilter("enable", "=", (Object)true));
        pluginFilterList.add(new QFilter("entryentity.op", "=", (Object)this.op));
        pluginFilterList.add(new QFilter("entryentity.isenable", "=", (Object)true));
        return pluginFilterList;
    }

    protected String getValidatorPluginName() {
        return BillTplBaseValidatorPlugin.class.getName();
    }

    public String getOp() {
        return this.op;
    }
}

