/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.setup;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.WarehouseHelper;

public class DefaultWarehouseSaveValidator
extends AbstractValidator {
    private static final String SCMC_IM_OPPLUGIN = "scmc-im-opplugin";
    private Map<Object, Set<Object>> entryLocation = new HashMap<Object, Set<Object>>();

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"DefaultWarehouseSaveValidator", (String)"validate");){
            for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
                this.validateMaterial(extendedDataEntity);
                this.validateWarehouse(extendedDataEntity);
                this.validateLocation(extendedDataEntity);
            }
        }
    }

    private void validateWarehouse(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dym = extendedDataEntity.getDataEntity();
        Object orgId = dym.getDynamicObject("org").get("id");
        DynamicObjectCollection col = new DynamicObjectCollection();
        col.add((Object)dym);
        Map whSetupMap = WarehouseHelper.getAllWarehouseSetup((Long)((Long)orgId), (DynamicObjectCollection)col, (String)"defaultwarehouse");
        DynamicObject wh = dym.getDynamicObject("defaultwarehouse");
        if (wh == null) {
            return;
        }
        boolean result = whSetupMap.containsKey(wh.getPkValue());
        if (!result) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u9ed8\u8ba4\u4ed3\u5e93\u4e0d\u5728\u4ed3\u5e93\u8bbe\u7f6e\u4e2d\u3002", (String)"DefaultWarehouseSaveValidator_2", (String)SCMC_IM_OPPLUGIN, (Object[])new Object[0]), ErrorLevel.Error);
        }
    }

    private void validateMaterial(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dym = extendedDataEntity.getDataEntity();
        DynamicObject materiel = dym.getDynamicObject("materialnumber");
        DynamicObject materielGrp = dym.getDynamicObject("materialgrpnumber");
        if (null == materiel && null == materielGrp) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7269\u6599\u3001\u7269\u6599\u5206\u7c7b\u4e0d\u53ef\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"DefaultWarehouseSaveValidator_0", (String)SCMC_IM_OPPLUGIN, (Object[])new Object[0]), ErrorLevel.Error);
            return;
        }
        if (null != materiel && null != materielGrp) {
            this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7269\u6599\u3001\u7269\u6599\u5206\u7c7b\u4e0d\u53ef\u540c\u65f6\u5b58\u5728\u3002", (String)"DefaultWarehouseSaveValidator_1", (String)SCMC_IM_OPPLUGIN, (Object[])new Object[0]), ErrorLevel.Error);
            return;
        }
    }

    private void validateLocation(ExtendedDataEntity extendedDataEntity) {
        DynamicObject dym = extendedDataEntity.getDataEntity();
        DynamicObject warehouse = dym.getDynamicObject("defaultwarehouse");
        if (null == warehouse) {
            return;
        }
        String warehouseNum = warehouse.getString("number");
        boolean isopenlocation = warehouse.getBoolean("isopenlocation");
        DynamicObject defaultLocation = dym.getDynamicObject("defaultlocation");
        if (null != defaultLocation) {
            Set<Object> locationIds;
            if (!isopenlocation) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u9ed8\u8ba4\u4ed3\u5e93{0}\u672a\u542f\u7528\u4ed3\u4f4d\u7ba1\u7406\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"DefaultWarehouseSaveValidator_3", (String)SCMC_IM_OPPLUGIN, (Object[])new Object[]{warehouseNum}), ErrorLevel.Error);
                return;
            }
            Object whId = warehouse.getPkValue();
            if (!this.entryLocation.containsKey(whId)) {
                List locationIdList = WarehouseHelper.getLocationIds((Object)whId);
                locationIds = new HashSet(locationIdList);
                this.entryLocation.put(whId, locationIds);
            }
            Object checkLocationId = defaultLocation.getPkValue();
            locationIds = this.entryLocation.get(whId);
            if (!locationIds.contains(checkLocationId)) {
                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u9ed8\u8ba4\u4ed3\u4f4d\u4e0d\u5728\u9ed8\u8ba4\u4ed3\u5e93\u4e0b\u3002", (String)"DefaultWarehouseSaveValidator_6", (String)SCMC_IM_OPPLUGIN, (Object[])new Object[0]), ErrorLevel.Error);
            }
        }
    }
}

