/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.setup;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.utils.CommonUtils;

public class WarehouseSetupDelValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add("initstatus");
        set.add("startstatus");
        set.add("warehouse");
        return set;
    }

    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            this.checkEnableStatus(entity);
            this.checkInitStatus(entity);
            this.checkRef(entity);
        }
    }

    private void checkRef(ExtendedDataEntity entity) {
        DynamicObject invWare = entity.getDataEntity();
        DynamicObject wh = invWare.getDynamicObject("warehouse");
        DynamicObject org = invWare.getDynamicObject("org");
        QFilter filter = new QFilter("org", "=", org.getPkValue());
        filter.and(new QFilter("billentry.warehouse", "=", wh.getPkValue()));
        DynamicObject res = BusinessDataServiceHelper.loadSingle((String)"im_initbill", (String)"id", (QFilter[])new QFilter[]{filter});
        if (!CommonUtils.isNull((Object)res)) {
            this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u201c%s\u201d\u5220\u9664\u5931\u8d25\uff0c\u521d\u59cb\u5e93\u5b58\u4e2d\u5df2\u5b58\u5728\u8be5\u4ed3\u5e93\u3002", (String)"WarehouseSetupDelValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), wh.getString("name")), ErrorLevel.Error);
        }
    }

    private void checkInitStatus(ExtendedDataEntity entity) {
        DynamicObject invWare = entity.getDataEntity();
        String initStatus = invWare.getString("initstatus");
        DynamicObject wh = invWare.getDynamicObject("warehouse");
        if ("B".equals(initStatus)) {
            this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u201c%s\u201c\u5220\u9664\u5931\u8d25,\u8be5\u4ed3\u5e93\u5df2\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"WarehouseSetupDelValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]), wh.getString("name")), ErrorLevel.Error);
        }
    }

    private void checkEnableStatus(ExtendedDataEntity entity) {
        DynamicObject invWare = entity.getDataEntity();
        String enableStatus = invWare.getString("startstatus");
        DynamicObject wh = invWare.getDynamicObject("warehouse");
        if ("B".equals(enableStatus)) {
            this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u201c%s\u201c\u5220\u9664\u5931\u8d25,\u8be5\u4ed3\u5e93\u5df2\u542f\u7528\u3002", (String)"WarehouseSetupDelValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]), wh.getString("name")), ErrorLevel.Error);
        }
    }
}

