/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.setup;

import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class WarehouseSetupMaterialRelValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            this.existsWarehouseSetup(entity);
            this.validateMaterialAndMaterialGroup(entity);
            this.validateMaterialAndMaterialGroupExist(entity);
            this.orgPermissionMaterial(entity);
        }
    }

    private void orgPermissionMaterial(ExtendedDataEntity entity) {
        DynamicObject dataEntity = entity.getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject material = dataEntity.getDynamicObject("materialnumber");
        if (org == null || material == null) {
            return;
        }
        Long orgId = (Long)org.getPkValue();
        Long materialId = (Long)material.getPkValue();
        QFilter permissionMaterialFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)orgId).and("id", "=", (Object)materialId);
        boolean exists = QueryServiceHelper.exists((String)"bd_materialinventoryinfo", (QFilter[])permissionMaterialFilter.toArray());
        if (!exists) {
            this.addMessage(entity, ResManager.loadKDString((String)"\u7269\u6599\u4e0d\u5728\u5e93\u5b58\u7ec4\u7ec7\u7ba1\u63a7\u7b56\u7565\u8303\u56f4\u5185\u3002", (String)"WarehouseSetupMaterialRelValidator_5", (String)"scmc-im-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }

    private void existsWarehouseSetup(ExtendedDataEntity entity) {
        Object warehouseId;
        Object orgId;
        QFilter qFilter;
        boolean exists;
        DynamicObject dataEntity = entity.getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject warehouse = dataEntity.getDynamicObject("warehouse");
        if (org != null && warehouse != null && !(exists = QueryServiceHelper.exists((String)"im_warehousesetup", (QFilter[])(qFilter = new QFilter("org", "=", orgId = org.getPkValue()).and("warehouse", "=", warehouseId = warehouse.getPkValue())).toArray()))) {
            this.addMessage(entity, ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u4e0d\u5b58\u5728\u3002", (String)"WarehouseSetupMaterialRelValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }

    private void existsMaterialOrMaterialGroup(DynamicObject setUp, ExtendedDataEntity entity) {
        DynamicObject dataEntity = entity.getDataEntity();
        DynamicObject material = dataEntity.getDynamicObject("materialnumber");
        DynamicObject materialGroup = dataEntity.getDynamicObject("materialgrpnumber");
        DynamicObjectCollection entryEntity = setUp.getDynamicObjectCollection("materialentity");
        this.existsMaterialOrMaterialGroup(material, entryEntity, entity, 0, dataEntity.getInt("seqfield"));
        this.existsMaterialOrMaterialGroup(materialGroup, entryEntity, entity, 1, dataEntity.getInt("seqfield"));
    }

    private void existsMaterialOrMaterialGroup(DynamicObject materialOoMaterialGroup, DynamicObjectCollection entryEntity, ExtendedDataEntity entity, int type, int seq) {
        if (materialOoMaterialGroup != null) {
            seq = seq == 0 ? entryEntity.size() + 1 : seq;
            HashMap<Long, HashSet<Integer>> seqMap = new HashMap<Long, HashSet<Integer>>(16);
            Long pkValue = (Long)materialOoMaterialGroup.getPkValue();
            HashSet<Integer> currentAddMaterialSeqSet = (HashSet<Integer>)seqMap.get(pkValue);
            if (currentAddMaterialSeqSet == null) {
                currentAddMaterialSeqSet = new HashSet<Integer>(16);
                seqMap.put(pkValue, currentAddMaterialSeqSet);
            }
            currentAddMaterialSeqSet.add(seq);
            String entryConst = "";
            String msg = "";
            if (type == 0) {
                entryConst = "materialnumber";
                msg = ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u4e0b\u5df2\u7ecf\u5b58\u5728\u6b64\u7269\u6599\u7f16\u7801\u3002", (String)"WarehouseSetupMaterialRelValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            } else if (type == 1) {
                entryConst = "materialgrpnumber";
                msg = ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u4e0b\u5df2\u7ecf\u5b58\u5728\u6b64\u7269\u6599\u5206\u7c7b\u7f16\u7801\u3002", (String)"WarehouseSetupMaterialRelValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            }
            for (DynamicObject entry : entryEntity) {
                DynamicObject materialEntry = entry.getDynamicObject(entryConst);
                if (materialEntry == null) continue;
                Long entryPkValue = (Long)materialEntry.getPkValue();
                HashSet<Integer> entrySeqSet = (HashSet<Integer>)seqMap.get(entryPkValue);
                if (entrySeqSet == null) {
                    entrySeqSet = new HashSet<Integer>(16);
                    seqMap.put(entryPkValue, entrySeqSet);
                }
                entrySeqSet.add(entry.getInt("seq"));
            }
            if (currentAddMaterialSeqSet.size() > 1) {
                this.addMessage(entity, msg, ErrorLevel.Error);
                return;
            }
        }
    }

    private void validateMaterialAndMaterialGroup(ExtendedDataEntity entity) {
        DynamicObject dataEntity = entity.getDataEntity();
        DynamicObject material = dataEntity.getDynamicObject("materialnumber");
        DynamicObject materialGroup = dataEntity.getDynamicObject("materialgrpnumber");
        if (material == null && materialGroup == null) {
            this.addMessage(entity, ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\u548c\u7269\u6599\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"WarehouseSetupMaterialRelValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            return;
        }
        if (null != material && null != materialGroup) {
            this.addMessage(entity, ResManager.loadKDString((String)"\u7269\u6599\u3001\u7269\u6599\u5206\u7c7b\u4e0d\u53ef\u540c\u65f6\u5b58\u5728\u3002", (String)"WarehouseSetupMaterialRelValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            return;
        }
    }

    private void validateMaterialAndMaterialGroupExist(ExtendedDataEntity entity) {
        QFilter qFilter;
        DynamicObject setUp;
        DynamicObject dataEntity = entity.getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject warehouse = dataEntity.getDynamicObject("warehouse");
        if (org != null && warehouse != null && (setUp = BusinessDataServiceHelper.loadSingle((String)"im_warehousesetup", (String)"id, materialentity.materialnumber, materialentity.materialgrpnumber, materialentity.seq", (QFilter[])(qFilter = new QFilter("org", "=", org.getPkValue()).and("warehouse", "=", warehouse.getPkValue())).toArray())) != null) {
            this.existsMaterialOrMaterialGroup(setUp, entity);
        }
    }
}

