/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.setup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;

public class WarehouseSetupValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            this.validateUser(entity);
            this.validateMaterial(entity);
        }
    }

    private void validateMaterial(ExtendedDataEntity entity) {
        DynamicObject invWare = entity.getDataEntity();
        DynamicObjectCollection cols = invWare.getDynamicObjectCollection("materialentity");
        if (cols.isEmpty()) {
            return;
        }
        HashMap<Long, ArrayList<Integer>> matIdAndSeqMap = new HashMap<Long, ArrayList<Integer>>(cols.size());
        HashMap<Long, ArrayList<Integer>> matGroIdAndSeqMap = new HashMap<Long, ArrayList<Integer>>(cols.size());
        for (DynamicObject col : cols) {
            List<Integer> seqs;
            DynamicObject material = col.getDynamicObject("materialnumber");
            DynamicObject materialGroup = col.getDynamicObject("materialgrpnumber");
            int seq = col.getInt("seq");
            if (material == null && materialGroup == null) {
                this.addMessage(entity, ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\u3001\u7269\u6599\u5206\u7c7b\u7f16\u7801\u4e0d\u53ef\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"WarehouseSetupValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                break;
            }
            if (material != null) {
                Long materialId = (Long)material.getPkValue();
                seqs = (ArrayList<Integer>)matIdAndSeqMap.get(materialId);
                if (seqs == null) {
                    seqs = new ArrayList<Integer>(16);
                    matIdAndSeqMap.put(materialId, (ArrayList<Integer>)seqs);
                }
                seqs.add(seq);
            }
            if (materialGroup == null) continue;
            Long matgroupId = (Long)materialGroup.getPkValue();
            seqs = (List)matGroIdAndSeqMap.get(matgroupId);
            if (seqs == null) {
                seqs = new ArrayList(16);
                matGroIdAndSeqMap.put(matgroupId, (ArrayList<Integer>)seqs);
            }
            seqs.add(seq);
        }
        for (List seqs : matIdAndSeqMap.values()) {
            if (seqs.size() <= 1) continue;
            this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u7f16\u7801\u91cd\u590d\u3002", (String)"WarehouseSetupValidator_7", (String)"scmc-im-opplugin", (Object[])new Object[0]), seqs), ErrorLevel.Error);
        }
        for (List seqs : matGroIdAndSeqMap.values()) {
            if (seqs.size() <= 1) continue;
            this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u5206\u7c7b\u7f16\u7801\u91cd\u590d\u3002", (String)"WarehouseSetupValidator_8", (String)"scmc-im-opplugin", (Object[])new Object[0]), seqs), ErrorLevel.Error);
        }
    }

    private void validateUser(ExtendedDataEntity entity) {
        DynamicObject invWare = entity.getDataEntity();
        DynamicObjectCollection uCol = invWare.getDynamicObjectCollection("operatorentity");
        if (uCol.size() != 0) {
            this.checkSameUser(uCol, entity);
        }
    }

    private void checkSameUser(DynamicObjectCollection cols, ExtendedDataEntity entity) {
        if (cols.isEmpty()) {
            return;
        }
        HashMap<Long, ArrayList<Integer>> OpeIdAndSeqMap = new HashMap<Long, ArrayList<Integer>>(cols.size());
        for (DynamicObject entry : cols) {
            DynamicObject operator = entry.getDynamicObject("operatoruser");
            if (operator == null) continue;
            Object pkValue = operator.getPkValue();
            ArrayList<Integer> seqs = (ArrayList<Integer>)OpeIdAndSeqMap.get(pkValue);
            if (seqs == null) {
                seqs = new ArrayList<Integer>(16);
                OpeIdAndSeqMap.put((Long)pkValue, seqs);
            }
            seqs.add(entry.getInt("seq"));
        }
        for (List seqs : OpeIdAndSeqMap.values()) {
            if (seqs.size() <= 1) continue;
            this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4e1a\u52a1\u5458\u8bbe\u7f6e\u91cd\u590d\u3002", (String)"WarehouseSetupValidator_6", (String)"scmc-im-opplugin", (Object[])new Object[0]), seqs), ErrorLevel.Error);
        }
    }
}

