/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.tpl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.JSONUtils;
import kd.scmc.im.business.helper.MetaDataHelper;

public class AuxptyMustInputValidator
extends AbstractValidator {
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"AuxptyMustInputValidator", (String)"validate");){
            Map<Object, DynamicObject> materialObjs = this.getMaterialObjs();
            for (ExtendedDataEntity entity : this.dataEntities) {
                this.checkAuxpty(entity, materialObjs);
            }
        }
    }

    private void checkAuxpty(ExtendedDataEntity entity, Map<Object, DynamicObject> materialObjs) {
        String biztypeNum;
        DynamicObject bizType;
        DynamicObject billEntity = entity.getDataEntity();
        if (!MetaDataHelper.isExistField((MainEntityType)((MainEntityType)billEntity.getDataEntityType()), (String)"billentry", (String)"auxpty")) {
            return;
        }
        DynamicObjectCollection col = billEntity.getDynamicObjectCollection("billentry");
        if (col == null || col.isEmpty()) {
            return;
        }
        String form = entity.getDataEntity().getDynamicObjectType().getName();
        if (!"im_initbill".equals(form) && !"im_invcountbill".equals(form) && (bizType = billEntity.getDynamicObject("biztype")) != null && ("380".equals(biztypeNum = bizType.getString("number")) || "370".equals(biztypeNum))) {
            return;
        }
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject auxpty;
            DynamicObject mat;
            DynamicObject row = (DynamicObject)col.get(i);
            DynamicObject billMat = row.getDynamicObject("material");
            if (billMat == null) continue;
            if ("bd_material".equals(billMat.getDataEntityType().getName())) {
                mat = billMat;
                if (!row.getBoolean("material.isuseauxpty")) {
                    continue;
                }
            } else {
                mat = row.getDynamicObject("material.masterid");
                if (!row.getBoolean("material.masterid.isuseauxpty")) continue;
            }
            if (null != (auxpty = row.getDynamicObject("auxpty"))) {
                DynamicObjectCollection auxCol;
                if (!materialObjs.containsKey(mat.getPkValue()) || (auxCol = (mat = materialObjs.get(mat.getPkValue())).getDynamicObjectCollection("auxptyentry")) == null || auxCol.size() == 0) continue;
                String auxValue = auxpty.get("value").toString();
                try {
                    Map map = (Map)JSONUtils.cast((String)auxValue, HashMap.class);
                    int billAuxSize = map.size();
                    if (auxCol.size() == billAuxSize) continue;
                    this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u5f55\u5165\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\u201c\u8f85\u52a9\u5c5e\u6027\u201d\u5b57\u6bb5\u3002", (String)"AuxptyMustInputValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
                    continue;
                }
                catch (IOException e) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89e3\u6790\u201c\u8f85\u52a9\u5c5e\u6027\u503c\u201d\u5f02\u5e38\uff1a%1$s\u3002", (String)"AuxptyMustInputValidator_5", (String)"scmc-im-opplugin", (Object[])new Object[0]), e.getMessage()));
                }
            }
            this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c\u201c\u8f85\u52a9\u5c5e\u6027\u201d\u5b57\u6bb5\u3002", (String)"AuxptyMustInputValidator_6", (String)"scmc-im-opplugin", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
        }
    }

    private Map<Object, DynamicObject> getMaterialObjs() {
        ArrayList<Long> allMasterId = new ArrayList<Long>();
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject billEntity = entity.getDataEntity();
            DynamicObjectCollection col = billEntity.getDynamicObjectCollection("billentry");
            for (int i = 0; i < col.size(); ++i) {
                DynamicObject row = (DynamicObject)col.get(i);
                DynamicObject billMat = row.getDynamicObject("material");
                if (billMat == null) continue;
                if ("bd_material".equals(billMat.getDataEntityType().getName())) {
                    if (!row.getBoolean("material.isuseauxpty")) continue;
                    allMasterId.add((Long)billMat.getPkValue());
                    continue;
                }
                if (!row.getBoolean("material.masterid.isuseauxpty")) continue;
                DynamicObject mat = row.getDynamicObject("material.masterid");
                allMasterId.add((Long)mat.getPkValue());
            }
        }
        QFilter filter = new QFilter("id", "in", allMasterId);
        Map res = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id,auxptyentry", (QFilter[])filter.toArray());
        return res;
    }
}

