/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.tpl;

import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.inte.api.IInteService;
import kd.bos.service.ServiceFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.AppParameterHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.helper.DaysCalcHelper;
import kd.scmc.im.utils.IMStringUtils;

public class BillBizDateValidator
extends AbstractValidator {
    private IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"BillBizDateValidator", (String)"validate");){
            boolean includeInitBizBill = MetaDataHelper.isExistField((IDataEntityType)EntityMetadataCache.getDataEntityType((String)this.getEntityKey()), (String)"isinitbill");
            HashMap orgIdToAfterDays = new HashMap();
            HashMap orgIdToBeforeDays = new HashMap();
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                Date bizTime;
                DynamicObject org = dataEntity.getDataEntity().getDynamicObject("org");
                if (org == null || includeInitBizBill && dataEntity.getDataEntity().getBoolean("isinitbill") || (bizTime = dataEntity.getDataEntity().getDate("biztime")) == null) continue;
                LocaleString bizTimeName = dataEntity.getDataEntity().getDynamicObjectType().getProperty("biztime").getDisplayName();
                Date currentDate = new Date();
                TimeZone orgZone = this.getOrgZone(org);
                if (orgZone == null) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u201c\u7ec4\u7ec7\u65f6\u533a\u201d\u548c\u201c\u7cfb\u7edf\u65f6\u533a\u201d\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BillBizDateValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]), bizTimeName.getLocaleValue()), ErrorLevel.FatalError);
                    continue;
                }
                long orgId = org.getLong("id");
                int fallowDays = 0;
                int differDays = 0;
                boolean before = false;
                if (bizTime.before(currentDate)) {
                    Object afterDays = orgIdToAfterDays.get("fallowafterdays_" + orgId);
                    if (afterDays == null) {
                        afterDays = AppParameterHelper.getAppParameter((String)"=9Q86DR2P+Q", (String)"05", (Long)orgId, (String)"fallowafterdays");
                        orgIdToAfterDays.put("fallowafterdays_" + orgId, afterDays);
                    }
                    fallowDays = Integer.parseInt(afterDays == null ? "0" : afterDays.toString());
                    differDays = DaysCalcHelper.differentDays((Date)currentDate, (Date)bizTime, (ZoneId)orgZone.toZoneId());
                    differDays = Math.abs(differDays);
                } else if (bizTime.after(currentDate)) {
                    Object beforeDays = orgIdToBeforeDays.get("fallowbeforedays_" + orgId);
                    if (beforeDays == null) {
                        beforeDays = AppParameterHelper.getAppParameter((String)"=9Q86DR2P+Q", (String)"05", (Long)orgId, (String)"fallowbeforedays");
                        orgIdToBeforeDays.put("fallowbeforedays_" + orgId, beforeDays);
                    }
                    fallowDays = Integer.parseInt(beforeDays == null ? "0" : beforeDays.toString());
                    differDays = DaysCalcHelper.differentDays((Date)bizTime, (Date)currentDate, (ZoneId)orgZone.toZoneId());
                    differDays = Math.abs(differDays);
                    before = true;
                }
                if (differDays <= fallowDays) continue;
                String tip = before ? ResManager.loadKDString((String)"\u5141\u8bb8\u63d0\u524d\u5f55\u5355\u671f\u9650", (String)"BillBizDateValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5141\u8bb8\u4e8b\u540e\u8865\u5f55\u671f\u9650", (String)"BillBizDateValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, IMStringUtils.append((String)bizTimeName.getLocaleValue(), (Object[])new Object[]{String.format(ResManager.loadKDString((String)"\u8d85\u51fa%s\uff0c\u8bf7\u5230\u7cfb\u7edf\u53c2\u6570\u4e2d\u4fee\u6539\u76f8\u5173\u8bbe\u7f6e\u3002", (String)"BillBizDateValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]), tip)}), ErrorLevel.FatalError);
            }
        }
    }

    private TimeZone getOrgZone(DynamicObject org) {
        TimeZone timeZone = null;
        DynamicObject timezone = null;
        MainEntityType entityType = (MainEntityType)org.getDataEntityType();
        IDataEntityProperty property = entityType.findProperty("timezone");
        if (property != null) {
            timezone = org.getDynamicObject(property.getName());
        }
        if (timezone == null) {
            timeZone = this.getSysTimezone();
        } else {
            String timeArea = timezone.getString("number");
            timeZone = TimeZone.getTimeZone(timeArea);
        }
        return timeZone;
    }

    private TimeZone getSysTimezone() {
        DynamicObject sysTimezoneMeta = this.service.getSysTimezone();
        String timeArea = sysTimezoneMeta.getString("number");
        return TimeZone.getTimeZone(timeArea);
    }
}

