/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.tpl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.SystemCallParamHelper;

public class BillTplCalSyncValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(BillTplCalSyncValidator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"BillTplCalSyncValidator", (String)"validate");){
            ArrayList<Object> pkIds = new ArrayList<Object>(this.dataEntities.length);
            ArrayList<DynamicObject> invBills = new ArrayList<DynamicObject>(this.dataEntities.length);
            HashMap<Integer, Long> entityMap = new HashMap<Integer, Long>(this.dataEntities.length);
            String dynamicObjectName = this.dataEntities[0].getDataEntity().getDynamicObjectType().getName();
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)dynamicObjectName);
            String mainOrgName = dataEntityType.getMainOrg();
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject dataEntity = entity.getDataEntity();
                DynamicObject invBill = BusinessDataServiceHelper.newDynamicObject((String)dynamicObjectName);
                invBill.set("id", dataEntity.get("id"));
                invBill.set("billno", dataEntity.get("billno"));
                invBill.set(mainOrgName, dataEntity.get(mainOrgName));
                invBill.set("billstatus", dataEntity.get("billstatus"));
                invBill.set("auditor", dataEntity.get("auditor"));
                invBill.set("biztime", dataEntity.get("biztime"));
                invBill.set("bookdate", dataEntity.get("bookdate"));
                invBills.add(invBill);
                entityMap.put(entity.getDataEntityIndex(), (Long)dataEntity.getPkValue());
                pkIds.add(dataEntity.getPkValue());
            }
            if (this.dataEntities == null || this.dataEntities.length <= 0) {
                return;
            }
            if (!SystemCallParamHelper.isEnable((String)"sbs_intersystemcallconf", (String)"KC0001")) {
                logger.info("\u7cfb\u7edf\u8054\u7528\u53c2\u6570\u672a\u542f\u7528,\u4e0d\u8c03\u7528\u6838\u7b97\u670d\u52a1\uff1a" + dynamicObjectName + "|AUDIT|" + pkIds);
                return;
            }
            if (!SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"INV0005")) {
                logger.info("\u542f\u7528\u4e1a\u8d22\u4e00\u4f53\u5316\u53c2\u6570\u672a\u542f\u7528,\u4e0d\u8c03\u7528\u6838\u7b97\u670d\u52a1\uff1a" + dynamicObjectName + "|AUDIT|" + pkIds);
                return;
            }
            String requestId = RequestContext.get().getRequestId();
            if (requestId == null) {
                requestId = DB.genStringId((String)"t_im_taskcollaborate");
                RequestContext.get().setRequestId(requestId);
            }
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid, fbillid from t_im_taskcollaborate where ", new Object[0]);
            sqlBuilder.appendIn("fbillid", pkIds.toArray());
            HashSet<Object> existBills = new HashSet<Object>(16);
            try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)new DBRoute("scm"), (SqlBuilder)sqlBuilder);){
                for (Row row : dataSet) {
                    Object fBillId = row.get("fbillid");
                    existBills.add(fBillId);
                }
            }
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject dataEntity = entity.getDataEntity();
                Iterator pkValue = dataEntity.getPkValue();
                String object = dataEntity.getString("billno");
                if (!existBills.contains(pkValue)) continue;
                this.addMessage(entity, String.format(ResManager.loadKDString((String)"%s\u540c\u6b65\u6838\u7b97\u7684\u4e1a\u52a1\u672a\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"BillTplCalSyncValidator_2", (String)"scmc-im-opplugin", (Object[])new Object[0]), object), ErrorLevel.Error);
            }
            ValidateResult validateResult = this.getValidateResult();
            List allErrorInfo = validateResult.getAllErrorInfo();
            if (!allErrorInfo.isEmpty()) {
                return;
            }
            String insertSql = "insert into t_im_taskcollaborate (fid, fbillid, fentitynum, frequestid, fcreatetime) values (?, ?, ?, ?, ?)";
            ArrayList<Object[]> insertParams = new ArrayList<Object[]>(16);
            Date date = new Date();
            for (Object e : pkIds) {
                long l = this.getId();
                Object[] param = new Object[]{l, e, dynamicObjectName, requestId, date};
                insertParams.add(param);
            }
            Throwable throwable = null;
            try (TXHandle tx = TX.requiresNew();){
                DB.executeBatch((DBRoute)new DBRoute("scm"), (String)insertSql, insertParams);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            try {
                Map syncResult = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doServiceSync", (Object[])new Object[]{"AUDIT", null, invBills.toArray(new DynamicObject[0])});
                for (Map.Entry entry : entityMap.entrySet()) {
                    Long billId = (Long)entry.getValue();
                    if (syncResult.get(billId) == null) continue;
                    ExtendedDataEntity dataEntity = this.dataEntities[(Integer)entry.getKey()];
                    this.addMessage(dataEntity, (String)syncResult.get(billId), ErrorLevel.Error);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u6838\u7b97\u63a5\u53e3\u5931\u8d25\u3002", (String)"BillTplCalSyncValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private long getId() {
        return DB.genLongId((String)"t_im_taskcollaborate");
    }
}

