/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.tpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.settle.SettleBillHelper;

public class BillTplIsPushValidator
extends AbstractValidator {
    private static final String PUR_IN_STOCK = "pur_instock";
    private static final String PUR_RETURN = "pur_return";
    private static final String PUR_RECEIPT = "pur_receipt";
    private static final String PUR_RECEIPT_RETURN = "pur_receipt_return";
    private static final String PM_TRANSFERBILL = "pm_transferbill";
    private static final String BBC_DELIVERY_RECORD = "bbc_delivery_record";
    private static final String OCBSOC_DELIVERY_RECORD = "ocbsoc_delivery_record";
    private static final String IM_SALOUTBILL = "im_saloutbill";
    private static final String PUR_MODULE = "pur_moduledelivery";
    private static Map<String, List<String>> skipMap = new HashMap<String, List<String>>(4);
    private static List<String> skipList = new ArrayList<String>(4);

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"BillTplIsPushValidator", (String)"validate");){
            ArrayList<Long> billIds = new ArrayList<Long>(this.dataEntities.length);
            String billType = null;
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                Long id = dataEntity.getDataEntity().getLong("id");
                if (billType == null) {
                    billType = dataEntity.getDataEntity().getDynamicObjectType().getName();
                }
                billIds.add(id);
            }
            Map settleBills = SettleBillHelper.getGenerateSettleBills(billIds);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                Set<String> settleIds;
                Long id = dataEntity.getDataEntity().getLong("id");
                boolean isPushed = this.isPushed(id, billType, settleIds = this.parseBillMap((Map)settleBills.get(id)));
                if (!isPushed) continue;
                String pushMsg = ResManager.loadKDString((String)"\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"BillTplIsPushValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, pushMsg, ErrorLevel.FatalError);
            }
        }
    }

    private boolean isPushed(Long id, String srcBillType, Set<String> settleIds) {
        Map pushedBills = BFTrackerServiceHelper.findTargetBills((String)srcBillType, (Long[])new Long[]{id});
        if (pushedBills == null || pushedBills.isEmpty()) {
            return false;
        }
        boolean skipPushCheck = this.canSkipValidate(srcBillType, pushedBills.keySet());
        if (skipPushCheck) {
            return false;
        }
        Set<String> ids = this.parseBillMap(pushedBills);
        ids.removeAll(settleIds);
        return !ids.isEmpty();
    }

    private boolean canSkipValidate(String srcBillType, Set<String> targetEntities) {
        List<String> subBillTypes = skipMap.get(srcBillType);
        if (subBillTypes == null || subBillTypes.isEmpty()) {
            subBillTypes = new ArrayList<String>();
        }
        Iterator<String> iterator = targetEntities.iterator();
        while (iterator.hasNext()) {
            String targetEntity = iterator.next();
            if (!subBillTypes.contains(targetEntity) && !skipList.contains(targetEntity)) continue;
            iterator.remove();
        }
        return targetEntities.isEmpty();
    }

    private Set<String> parseBillMap(Map<String, HashSet<Long>> maps) {
        HashSet<String> ids = new HashSet<String>();
        if (maps != null) {
            for (Map.Entry<String, HashSet<Long>> entry : maps.entrySet()) {
                HashSet<Long> targetIds = entry.getValue();
                for (Long targetId : targetIds) {
                    ids.add(entry.getKey() + "-" + targetId);
                }
            }
        }
        return ids;
    }

    static {
        List<String> targetBills = new ArrayList<String>();
        targetBills.add(PUR_RECEIPT);
        targetBills.add(PUR_RECEIPT_RETURN);
        skipMap.put("im_purreceivebill", targetBills);
        targetBills = new ArrayList();
        targetBills.add(IM_SALOUTBILL);
        skipMap.put("im_purinbill", targetBills);
        targetBills = new ArrayList();
        targetBills.add(PM_TRANSFERBILL);
        skipMap.put("im_materialreqoutbill", targetBills);
        targetBills = new ArrayList();
        targetBills.add(BBC_DELIVERY_RECORD);
        targetBills.add(OCBSOC_DELIVERY_RECORD);
        targetBills.add(PM_TRANSFERBILL);
        skipMap.put(IM_SALOUTBILL, targetBills);
        targetBills = Collections.singletonList(PM_TRANSFERBILL);
        skipMap.put("im_otheroutbill", targetBills);
        skipMap.put("im_transdirbill", Arrays.asList(PM_TRANSFERBILL, PUR_MODULE));
        skipMap.put("im_mdc_mftproorder", targetBills);
        skipMap.put("im_mdc_mftreturnorder", targetBills);
        skipMap.put("im_mdc_mftfeedorder", targetBills);
        skipMap.put("im_mdc_omproorder", targetBills);
        skipMap.put("im_mdc_omreturnorder", targetBills);
        skipMap.put("im_mdc_omfeedorder", targetBills);
        skipMap.put("im_mdc_mftproorder", targetBills);
        skipMap.put("im_mdc_mftreturnorder", targetBills);
        skipMap.put("im_mdc_mftfeedorder", targetBills);
        skipMap.put("im_mdc_omoutbill", targetBills);
        skipMap.put("im_mdc_omreturnbill", targetBills);
        skipMap.put("im_mdc_omfeedbill", targetBills);
        skipList.add(PUR_IN_STOCK);
        skipList.add(PUR_RETURN);
    }
}

