/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.tpl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.DateHelper;
import kd.scmc.im.business.helper.MetaDataHelper;

public class BillTplUnAuditValidator
extends AbstractValidator {
    protected static final Log logger = LogFactory.getLog(BillTplUnAuditValidator.class);

    public void validate() {
        block21: {
            try (TraceSpan span = Tracer.create((String)"BillTplUnAuditValidator", (String)"validate");){
                ArrayList<DynamicObject> invBills = new ArrayList<DynamicObject>(this.dataEntities.length);
                HashMap<Integer, Long> entityMap = new HashMap<Integer, Long>(this.dataEntities.length);
                String dynamicObjectName = this.dataEntities[0].getDataEntity().getDynamicObjectType().getName();
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)dynamicObjectName);
                String mainOrgName = dataEntityType.getMainOrg();
                for (ExtendedDataEntity entity : this.dataEntities) {
                    DynamicObject dataEntity = entity.getDataEntity();
                    DynamicObject invBill = BusinessDataServiceHelper.newDynamicObject((String)dynamicObjectName);
                    Date bizDate = dataEntity.getDate("biztime");
                    Date closeBalDate = DateHelper.getCloseDate((Long)Long.parseLong(dataEntity.getDynamicObject("org").getPkValue().toString()));
                    if (bizDate != null && closeBalDate != null && bizDate.before(closeBalDate)) {
                        String msg = ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u5df2\u5173\u8d26\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"BillTplUnAuditValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                        this.addMessage(entity, msg, ErrorLevel.Error);
                    }
                    invBill.set("id", dataEntity.get("id"));
                    invBill.set("billno", dataEntity.get("billno"));
                    invBill.set(mainOrgName, dataEntity.get(mainOrgName));
                    invBill.set("billstatus", dataEntity.get("billstatus"));
                    invBill.set("auditor", dataEntity.get("auditor"));
                    invBills.add(invBill);
                    entityMap.put(entity.getDataEntityIndex(), (Long)dataEntity.getPkValue());
                }
                if (!MetaDataHelper.isBizAppExistCal()) break block21;
                if (this.dataEntities == null || this.dataEntities.length <= 0) {
                    return;
                }
                try {
                    Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCheckService", (String)"doService", (Object[])new Object[]{"UNAUDIT", null, invBills.toArray(new DynamicObject[0])});
                    for (Map.Entry entry : entityMap.entrySet()) {
                        Long invBillId = (Long)entry.getValue();
                        if (result.get(invBillId) == null) continue;
                        this.addMessage(this.dataEntities[(Integer)entry.getKey()], (String)result.get(invBillId), ErrorLevel.Error);
                    }
                }
                catch (Exception ex) {
                    logger.error((Throwable)ex);
                    throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u6838\u7b97\u670d\u52a1\u6821\u9a8c\u662f\u5426\u5b58\u5728\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5931\u8d25\u3002", (String)"BillTplUnAuditValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }
}

