/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.tpl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.MetaDataHelper;

public class LotNumSaveValidator
extends AbstractValidator {
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"LotNumSaveValidator", (String)"validate");){
            Iterator inOrg;
            String transType;
            String eKey = this.getEntityKey();
            String lotName = "im_transdirbill".equals(eKey) ? ResManager.loadKDString((String)"\u8c03\u51fa\u6279\u53f7", (String)"LotNumSaveValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6279\u53f7", (String)"LotNumSaveValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            HashMap<Long, Set<Long>> orgAndMatMaps = new HashMap<Long, Set<Long>>(this.dataEntities.length);
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject billEntity = entity.getDataEntity();
                DynamicObjectCollection col = billEntity.getDynamicObjectCollection("billentry");
                String string = transType = "im_transdirbill".equals(eKey) ? billEntity.getString("transtype") : null;
                if ("B".equals(transType) && (inOrg = billEntity.getDynamicObject("org")) != null) {
                    Set mIds = orgAndMatMaps.computeIfAbsent((Long)billEntity.getDynamicObject("org").getPkValue(), v -> new HashSet());
                    for (DynamicObject row : col) {
                        mIds.add(row.getLong("material.masterid.id"));
                    }
                }
                inOrg = col.iterator();
                while (inOrg.hasNext()) {
                    DynamicObject row = (DynamicObject)inOrg.next();
                    boolean enableLot = row.getBoolean("material.enablelot");
                    this.validLotnumEmpty(entity, col, row, "lotnumber", lotName, enableLot);
                    if (!"A".equals(transType)) continue;
                    this.validLotnumEmpty(entity, col, row, "inlotnumber", ResManager.loadKDString((String)"\u8c03\u5165\u6279\u53f7", (String)"LotNumSaveValidator_5", (String)"scmc-im-opplugin", (Object[])new Object[0]), enableLot);
                }
            }
            if (orgAndMatMaps.isEmpty()) {
                return;
            }
            Map<String, DynamicObject> matInvMap = this.getMaterialInvMap(orgAndMatMaps);
            if ("im_transdirbill".equals(eKey)) {
                for (ExtendedDataEntity entity : this.dataEntities) {
                    DynamicObject billEntity = entity.getDataEntity();
                    transType = billEntity.getString("transtype");
                    if ("A".equals(transType) || (inOrg = billEntity.getDynamicObject("org")) == null) continue;
                    Long orgId = (Long)inOrg.getPkValue();
                    DynamicObjectCollection col = billEntity.getDynamicObjectCollection("billentry");
                    for (DynamicObject row : col) {
                        DynamicObject matInv = matInvMap.get(orgId + "_" + row.getLong("material.masterid.id"));
                        if (matInv == null) continue;
                        this.validLotnumEmpty(entity, col, row, "inlotnumber", ResManager.loadKDString((String)"\u8c03\u5165\u6279\u53f7", (String)"LotNumSaveValidator_5", (String)"scmc-im-opplugin", (Object[])new Object[0]), matInv.getBoolean("enablelot"));
                    }
                }
            }
        }
    }

    private Map<String, DynamicObject> getMaterialInvMap(Map<Long, Set<Long>> orgAndMatMaps) {
        HashMap<String, DynamicObject> matInvMap = new HashMap<String, DynamicObject>(16);
        for (Map.Entry<Long, Set<Long>> orgAndMatEntry : orgAndMatMaps.entrySet()) {
            Long orgId = orgAndMatEntry.getKey();
            Set<Long> matIds = orgAndMatEntry.getValue();
            Map<Object, Set<DynamicObject>> materialInvs = this.getMaterialInvs(orgId, matIds);
            String privateCtrlStrategy = "7";
            for (Map.Entry<Object, Set<DynamicObject>> matInvEntry : materialInvs.entrySet()) {
                Long masterId = (Long)matInvEntry.getKey();
                Set<DynamicObject> materialinventory = matInvEntry.getValue();
                DynamicObject materialInfo = materialinventory.iterator().next();
                for (DynamicObject dynamicObject : materialinventory) {
                    String ctrlStrategy = dynamicObject.getString("ctrlstrategy");
                    if (!privateCtrlStrategy.equals(ctrlStrategy)) continue;
                    materialInfo = dynamicObject;
                    break;
                }
                matInvMap.put(orgId + "_" + masterId, materialInfo);
            }
        }
        return matInvMap;
    }

    private void validLotnumEmpty(ExtendedDataEntity entity, DynamicObjectCollection col, DynamicObject row, String lotnumCol, String lotName, boolean enableLot) {
        String lotNum = row.getString(lotnumCol);
        if (enableLot) {
            if (StringUtils.isEmpty((CharSequence)(lotNum = lotNum.replaceAll("\u3000", " ").trim()))) {
                String msg = ResManager.loadKDString((String)"\u7b2c%1s\u884c\u7269\u6599\u5df2\u5f00\u542f\u6279\u53f7\u7ba1\u7406\uff0c%2s\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"LotNumSaveValidator_6", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                this.addMessage(entity, String.format(msg, row.getInt("seq"), lotName), ErrorLevel.Error);
            } else {
                row.set(lotnumCol, (Object)lotNum);
            }
        } else {
            boolean containAfterEntity = MetaDataHelper.isExistField((IDataEntityType)row.getDataEntityType(), (String)"afterentity");
            if (!StringUtils.isEmpty((CharSequence)(lotNum = lotNum.replaceAll("\u3000", " ").trim()))) {
                if (containAfterEntity) {
                    String entryName = col.getDynamicObjectType().getDisplayName().getLocaleValue();
                    String msg = ResManager.loadKDString((String)"%1s\u7b2c%2s\u884c\u7269\u6599\u672a\u5f00\u542f\u6279\u53f7\u7ba1\u7406\uff0c%3s\u4e0d\u5141\u8bb8\u6709\u503c\u3002", (String)"LotNumSaveValidator_7", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                    this.addMessage(entity, String.format(msg, entryName, row.getInt("seq"), lotName), ErrorLevel.Error);
                } else {
                    String msg = ResManager.loadKDString((String)"\u7b2c%1s\u884c\u7269\u6599\u672a\u5f00\u542f\u6279\u53f7\u7ba1\u7406\uff0c%2s\u4e0d\u5141\u8bb8\u6709\u503c\u3002", (String)"LotNumSaveValidator_8", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                    this.addMessage(entity, String.format(msg, row.getInt("seq"), lotName), ErrorLevel.Error);
                }
            }
        }
    }

    private Map<Object, Set<DynamicObject>> getMaterialInvs(Long orgId, Set<Long> matIds) {
        HashMap<Object, Set<DynamicObject>> masterIdToInvsMap = new HashMap<Object, Set<DynamicObject>>(matIds.size());
        if (matIds.isEmpty()) {
            return masterIdToInvsMap;
        }
        QFilter enableF = new QFilter("enable", "=", (Object)true);
        QFilter auditF = new QFilter("status", "=", (Object)"C");
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)orgId);
        Map materialInventory = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (String)"enablelot,ctrlstrategy", (QFilter[])new QFilter[]{new QFilter("masterid", "in", matIds), baseDataFilter, enableF, auditF});
        for (DynamicObject materialInv : materialInventory.values()) {
            Object masterId = materialInv.get("masterid.id");
            Set set = masterIdToInvsMap.computeIfAbsent(masterId, key -> new HashSet());
            set.add(materialInv);
        }
        return masterIdToInvsMap;
    }
}

