/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.tpl;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.im.business.helper.MetaDataHelper;

public class ShelfLifeDateValidator
extends AbstractValidator {
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"ShelfLifeDateValidator", (String)"validate");){
            int count = 0;
            for (ExtendedDataEntity entity : this.dataEntities) {
                DynamicObject billEntity = entity.getDataEntity();
                DynamicObjectCollection col = billEntity.getDynamicObjectCollection("billentry");
                for (DynamicObject row : col) {
                    Date produceDate = row.getDate("producedate");
                    Date expiryDate = row.getDate("expirydate");
                    DynamicObject materialInvInfo = row.getDynamicObject("material");
                    if (materialInvInfo != null && materialInvInfo.getBoolean("enableshelflifemgr")) {
                        if (produceDate != null && expiryDate != null) continue;
                        String msg = ResManager.loadKDString((String)"\u7b2c%s\u884c\u7269\u6599\u5df2\u5f00\u542f\u4fdd\u8d28\u671f\u7ba1\u7406\uff0c\u751f\u4ea7\u65e5\u671f\u548c\u5230\u671f\u65e5\u671f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ShelfLifeDateValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                        this.addMessage(entity, String.format(msg, row.getInt("seq")), ErrorLevel.Error);
                        if (++count < 1000) continue;
                        this.addMessage(entity, ResManager.loadKDString((String)"\u5931\u8d25\u4fe1\u606f\u8fc7\u591a\uff0c\u65e0\u6cd5\u5c55\u793a\uff0c\u5efa\u8bae\u5148\u5904\u7406\u73b0\u5728\u7684\u5931\u8d25\u539f\u56e0\u3002", (String)"ShelfLifeDateValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (materialInvInfo == null || materialInvInfo.getBoolean("enableshelflifemgr") || produceDate == null && expiryDate == null) continue;
                    boolean containAfterEntity = MetaDataHelper.isExistField((IDataEntityType)row.getDataEntityType(), (String)"afterentity");
                    if (containAfterEntity) {
                        String entryName = col.getDynamicObjectType().getDisplayName().getLocaleValue();
                        String msg = ResManager.loadKDString((String)"%1s\u7b2c%2s\u884c\u7269\u6599\u672a\u5f00\u542f\u4fdd\u8d28\u671f\u7ba1\u7406\uff0c\u751f\u4ea7\u65e5\u671f\u548c\u5230\u671f\u65e5\u671f\u4e0d\u5141\u8bb8\u6709\u503c\u3002", (String)"ShelfLifeDateValidator_4", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                        this.addMessage(entity, String.format(msg, entryName, row.getInt("seq")), ErrorLevel.Error);
                    } else {
                        String msg = ResManager.loadKDString((String)"\u7b2c%s\u884c\u7269\u6599\u672a\u5f00\u542f\u4fdd\u8d28\u671f\u7ba1\u7406\uff0c\u201c\u751f\u4ea7\u65e5\u671f\u201d\u548c\u201c\u5230\u671f\u65e5\u671f\u201d\u4e0d\u5141\u8bb8\u6709\u503c\u3002", (String)"ShelfLifeDateValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[0]);
                        this.addMessage(entity, String.format(msg, row.getInt("seq")), ErrorLevel.Error);
                    }
                    if (++count < 1000) continue;
                    this.addMessage(entity, ResManager.loadKDString((String)"\u5931\u8d25\u4fe1\u606f\u8fc7\u591a\uff0c\u65e0\u6cd5\u5c55\u793a\uff0c\u5efa\u8bae\u5148\u5904\u7406\u73b0\u5728\u7684\u5931\u8d25\u539f\u56e0\u3002", (String)"ShelfLifeDateValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }
    }
}

