/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.tpl;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;

public class Unit2ndMustInputValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            this.checkUnit2nd(entity);
        }
    }

    private void checkUnit2nd(ExtendedDataEntity entity) {
        DynamicObject billEntity = entity.getDataEntity();
        DynamicObjectCollection col = billEntity.getDynamicObjectCollection("billentry");
        if (col == null || col.size() == 0) {
            return;
        }
        String entryDisplayName = col.getDynamicObjectType().getDisplayName().getLocaleValue();
        for (int i = 0; i < col.size(); ++i) {
            boolean isUseUnit2nd;
            DynamicObject material;
            DynamicObject row = (DynamicObject)col.get(i);
            DynamicObject materialInvInfo = row.getDynamicObject("material");
            if (materialInvInfo == null || (material = materialInvInfo.getDynamicObject("masterid")) == null) continue;
            DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
            boolean bl = isUseUnit2nd = auxptyUnit != null;
            if (!isUseUnit2nd) continue;
            DynamicObject entryUnit2nd = row.getDynamicObject("unit2nd");
            BigDecimal qtyUnit2nd = row.getBigDecimal("qtyunit2nd");
            if (entryUnit2nd != null && qtyUnit2nd != null && qtyUnit2nd.compareTo(BigDecimal.ZERO) != 0) continue;
            String materialName = material.getString("name");
            String msg = ResManager.loadKDString((String)"{0}\u7b2c{1}\u884c\u7684\u7269\u6599\u201c{2}\u201d\u5df2\u542f\u7528\u8f85\u52a9\u5355\u4f4d\uff0c\u8f85\u52a9\u5355\u4f4d\u548c\u8f85\u52a9\u6570\u91cf\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"Unit2ndMustInputValidator_1", (String)"scmc-im-opplugin", (Object[])new Object[]{entryDisplayName, i + 1, materialName});
            this.addMessage(entity, msg, ErrorLevel.Error);
        }
    }
}

