/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.workbench;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class InterfaceCfgEnableValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set fieldSet = super.preparePropertys();
        fieldSet.add("tasktype");
        fieldSet.add("enable");
        return fieldSet;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities != null && dataEntities.length != 0) {
            Set<Object> taskIdSet = this.getTaskTypeId(dataEntities);
            String entityKey = this.getEntityKey();
            QFilter qFilter = new QFilter("tasktype", "in", taskIdSet);
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            DynamicObjectCollection query = QueryServiceHelper.query((String)entityKey, (String)"tasktype,enable", (QFilter[])qFilter.toArray());
            List taskTypeIdList = query.stream().map(p -> p.getLong("tasktype")).collect(Collectors.toList());
            String errorMsgTpl = ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u7c7b\u201c%1$s(%2$s)\u201d\uff0c\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u591a\u6761\u542f\u7528\u7684\u914d\u7f6e\uff0c\u8bf7\u7981\u7528\u539f\u6709\u914d\u7f6e\u540e\u91cd\u8bd5\u3002", (String)"InterfaceCfgEnableValidator_0", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            if (taskTypeIdList.isEmpty()) {
                this.checkBatchDataCanEnable(dataEntities, errorMsgTpl);
                return;
            }
            HashSet<Object> needEnableTaskType = new HashSet<Object>(8);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject bizData = dataEntity.getDataEntity();
                DynamicObject taskType = bizData.getDynamicObject("tasktype");
                boolean enable = bizData.getBoolean("enable");
                if (taskTypeIdList.contains(taskType.getLong("id")) && !enable) {
                    this.addErrorMessage(dataEntity, String.format(errorMsgTpl, taskType.get("name"), taskType.get("number")));
                    continue;
                }
                Object taskTypeId = taskType.getPkValue();
                if (needEnableTaskType.contains(taskTypeId)) {
                    this.addErrorMessage(dataEntity, String.format(errorMsgTpl, taskType.get("name"), taskType.get("number")));
                    continue;
                }
                needEnableTaskType.add(taskTypeId);
            }
        }
    }

    private void checkBatchDataCanEnable(ExtendedDataEntity[] dataEntities, String errorMsgTpl) {
        HashSet<Object> needEnableTaskType = new HashSet<Object>();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bizData = dataEntity.getDataEntity();
            DynamicObject taskType = bizData.getDynamicObject("tasktype");
            Object taskTypeId = taskType.getPkValue();
            if (needEnableTaskType.contains(taskTypeId)) {
                this.addErrorMessage(dataEntity, String.format(errorMsgTpl, taskType.get("name"), taskType.get("number")));
                continue;
            }
            needEnableTaskType.add(taskTypeId);
        }
    }

    private Set<Object> getTaskTypeId(ExtendedDataEntity[] dataEntities) {
        HashSet<Object> taskIdSet = new HashSet<Object>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bizData = dataEntity.getDataEntity();
            DynamicObject taskType = bizData.getDynamicObject("tasktype");
            boolean enable = bizData.getBoolean("enable");
            if (enable) continue;
            taskIdSet.add(taskType.getPkValue());
        }
        return taskIdSet;
    }
}

