/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.validator.workbench;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class InterfaceCfgSaveValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set fieldSet = super.preparePropertys();
        fieldSet.add("tasktype");
        fieldSet.add("enable");
        fieldSet.add("tarbill");
        fieldSet.add("entryentity.tarbillfield");
        return fieldSet;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities != null && dataEntities.length != 0) {
            this.taskUniqueCheck(dataEntities);
            this.interfaceFieldCheck(dataEntities);
        }
    }

    private void taskUniqueCheck(ExtendedDataEntity[] dataEntities) {
        Set<Object> taskIdSet = this.getTaskTypeId(dataEntities);
        if (taskIdSet.isEmpty()) {
            return;
        }
        String entityKey = this.getEntityKey();
        QFilter qFilter = new QFilter("tasktype", "in", taskIdSet);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityKey, (String)"id,tasktype,enable", (QFilter[])qFilter.toArray());
        List taskTypeIdList = query.stream().map(p -> p.getLong("tasktype")).collect(Collectors.toList());
        if (taskTypeIdList.isEmpty()) {
            return;
        }
        String errorMsgTpl = ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u7c7b\u201c%1$s(%2$s)\u201d\uff0c\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u591a\u6761\u542f\u7528\u7684\u914d\u7f6e\uff0c\u8bf7\u7981\u7528\u539f\u6709\u914d\u7f6e\u540e\u91cd\u8bd5\u3002", (String)"InterfaceCfgSaveOp_0", (String)"scmc-im-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bizData = dataEntity.getDataEntity();
            DynamicObject taskType = bizData.getDynamicObject("tasktype");
            if (!taskTypeIdList.contains(taskType.getLong("id"))) continue;
            this.addErrorMessage(dataEntity, String.format(errorMsgTpl, taskType.get("name"), taskType.get("number")));
        }
    }

    private void interfaceFieldCheck(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bizData = dataEntity.getDataEntity();
            this.srcBillFieldCheck(dataEntity);
            DynamicObject tarBill = bizData.getDynamicObject("tarbill");
            String tarBillNumber = tarBill.getString("number");
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)tarBillNumber);
            Map allFields = dataEntityType.getAllFields();
            Set<String> tarFieldSet = InterfaceCfgSaveValidator.getTarFieldSet(bizData);
            for (String tarBillField : tarFieldSet) {
                IDataEntityProperty iDataEntityProperty;
                if (tarBillField == null) continue;
                String[] keySplit = tarBillField.split("\\.");
                String entryKey = "";
                String fieldKey = "";
                if (keySplit.length == 2) {
                    entryKey = keySplit[0];
                    fieldKey = keySplit[1];
                } else {
                    fieldKey = tarBillField;
                }
                if (!((iDataEntityProperty = (IDataEntityProperty)allFields.get(fieldKey)) instanceof ItemClassProp)) continue;
                String typePropName = ((ItemClassProp)iDataEntityProperty).getTypePropName();
                IDataEntityProperty itemTypeProp = (IDataEntityProperty)allFields.get(typePropName);
                this.itemClassPropFieldCheck(dataEntity, tarFieldSet, entryKey, (ItemClassProp)iDataEntityProperty, (ItemClassTypeProp)itemTypeProp);
            }
        }
    }

    private void itemClassPropFieldCheck(ExtendedDataEntity dataEntity, Set<String> tarFieldSet, String entryKey, ItemClassProp itemClassProp, ItemClassTypeProp itemTypeProp) {
        String typePropName = itemClassProp.getTypePropName();
        if (!StringUtils.isEmpty((CharSequence)entryKey)) {
            typePropName = entryKey + "." + typePropName;
        }
        if (!tarFieldSet.contains(typePropName)) {
            IDataEntityType itemClassParent = itemClassProp.getParent();
            String displayName = itemClassProp.getDisplayName().getLocaleValue();
            if (itemClassParent instanceof EntryType) {
                displayName = itemClassParent.getDisplayName().getLocaleValue() + "." + itemClassProp.getDisplayName().getLocaleValue();
            }
            IDataEntityType itemTypePropParent = itemTypeProp.getParent();
            String displayTypeName = itemTypeProp.getDisplayName().getLocaleValue();
            if (itemTypePropParent instanceof EntryType) {
                displayTypeName = itemTypePropParent.getDisplayName().getLocaleValue() + "." + itemTypeProp.getDisplayName().getLocaleValue();
            }
            String errorMsgTpl = ResManager.loadKDString((String)"\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u201c%1$s\u201d\uff0c\u672a\u914d\u7f6e\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u5b57\u6bb5\u201c%2$s\u201d\uff0c\u8bf7\u914d\u7f6e\u540e\u91cd\u8bd5\u3002", (String)"InterfaceCfgSaveOp_1", (String)"scmc-im-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(errorMsgTpl, displayName, displayTypeName));
        }
    }

    public static Set<String> getTarFieldSet(DynamicObject interfaceCfgDy) {
        if (interfaceCfgDy == null) {
            return Collections.emptySet();
        }
        DynamicObjectCollection interfaceCfgColl = interfaceCfgDy.getDynamicObjectCollection("entryentity");
        return interfaceCfgColl.stream().map(p -> p.getString("tarbillfield")).collect(Collectors.toSet());
    }

    private Set<Object> getTaskTypeId(ExtendedDataEntity[] dataEntities) {
        HashSet<Object> taskIdSet = new HashSet<Object>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bizData = dataEntity.getDataEntity();
            DynamicObject taskType = bizData.getDynamicObject("tasktype");
            boolean isFromDataBase = bizData.getDataEntityState().getFromDatabase();
            if (isFromDataBase) continue;
            taskIdSet.add(taskType.getPkValue());
        }
        return taskIdSet;
    }

    private void srcBillFieldCheck(ExtendedDataEntity dataEntity) {
        DynamicObject bizData = dataEntity.getDataEntity();
        DynamicObject taskType = bizData.getDynamicObject("tasktype");
        boolean isRelationCreate = taskType.getBoolean("isrelationcreate");
        if (isRelationCreate) {
            DynamicProperty property;
            MainEntityType workBenchModal = EntityMetadataCache.getDataEntityType((String)"im_workbench_modal");
            HashSet<String> errorFieldNameSet = new HashSet<String>(4);
            Map<String, String> interfaceFieldMap = InterfaceCfgSaveValidator.getInterfaceFieldMap(bizData);
            String srcBillIdField = interfaceFieldMap.get("sourcebillid");
            String srcBillNoField = interfaceFieldMap.get("sourcebillno");
            String srcBillRowIdField = interfaceFieldMap.get("sourcerowid");
            if (StringUtils.isBlank((CharSequence)srcBillIdField)) {
                property = workBenchModal.getProperty("sourcebillid");
                errorFieldNameSet.add(property.getDisplayName().getLocaleValue());
            }
            if (StringUtils.isBlank((CharSequence)srcBillNoField)) {
                property = workBenchModal.getProperty("sourcebillno");
                errorFieldNameSet.add(property.getDisplayName().getLocaleValue());
            }
            if (StringUtils.isBlank((CharSequence)srcBillRowIdField)) {
                property = workBenchModal.getProperty("sourcerowid");
                errorFieldNameSet.add(property.getDisplayName().getLocaleValue());
            }
            if (!errorFieldNameSet.isEmpty()) {
                String errorMsgTpl = ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u7c7b\u4e3a\u5173\u8054\u751f\u6210\u65f6\uff0c\u201c{0}\u201d\u5fc5\u987b\u914d\u7f6e\u3002", (String)"IM-E-655671", (String)"scmc-im-opplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", errorFieldNameSet)});
                this.addErrorMessage(dataEntity, errorMsgTpl);
            }
        }
    }

    public static Map<String, String> getInterfaceFieldMap(DynamicObject interfaceCfgDy) {
        if (interfaceCfgDy == null) {
            return Collections.emptyMap();
        }
        DynamicObjectCollection interfaceCfgColl = interfaceCfgDy.getDynamicObjectCollection("entryentity");
        if (interfaceCfgColl == null || interfaceCfgColl.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> fieldMap = new HashMap<String, String>(interfaceCfgColl.size());
        for (DynamicObject interfaceCfg : interfaceCfgColl) {
            String interfaceField = interfaceCfg.getString("interfacefield");
            String tarBillField = interfaceCfg.getString("tarbillfield");
            if (!StringUtils.isNotBlank((CharSequence)interfaceField) || !StringUtils.isNotBlank((CharSequence)tarBillField)) continue;
            fieldMap.put(interfaceField, tarBillField);
        }
        return fieldMap;
    }
}

