/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.AuxQtyAndUnitHelper;
import kd.scmc.im.business.helper.BillQtyAndUnitHelper;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.business.helper.BillViewHelper;
import kd.scmc.im.business.helper.BizTypeHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.InvAvbQtyQueryHelper;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.business.helper.MaterialHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.SerialNumberHelper;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.helper.ShelfLifeDateUtil;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.FieldUtils;

public class ImApplyBillPropChanged {
    private IFormView view = null;
    private AbstractFormPlugin plugin = null;
    private Log logger = LogFactory.getLog(ImApplyBillPropChanged.class);
    private static List<String> qtyFields = new ArrayList<String>();

    public ImApplyBillPropChanged(IFormView view, AbstractFormPlugin plugin) {
        this.view = view;
        this.plugin = plugin;
    }

    protected IDataModel getModel() {
        return this.view.getModel();
    }

    protected IFormView getView() {
        return this.view;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        if (newValue instanceof BigDecimal && oldValue instanceof BigDecimal && newValue != null && oldValue != null && ((BigDecimal)newValue).compareTo((BigDecimal)oldValue) == 0) {
            return;
        }
        InvAvbQtyQueryHelper.clearAvbQty((String)propName, (int)valueSet[0].getRowIndex(), (IFormView)this.view);
        switch (propName) {
            case "material": {
                this.resetMaterial((DynamicObject)newValue, rowIndex);
                this.changeMaterialByMaterial(newValue, rowIndex);
                this.changeMaterialByBillAuxpty((DynamicObject)newValue, rowIndex);
                this.changeMaterialByBillLot((DynamicObject)newValue, rowIndex);
                this.update2Version((DynamicObject)newValue, rowIndex);
                this.subEntryUI(rowIndex);
                break;
            }
            case "materialname": {
                this.changeMaterialName(oldValue, newValue, rowIndex);
                break;
            }
            case "qty": {
                this.changeQty(newValue, rowIndex);
                break;
            }
            case "auditqty": {
                this.changeAuditQty(oldValue, newValue, rowIndex);
                break;
            }
            case "qtyunit2nd": {
                this.changeQtyOrUnitByBillBizQty(propName, newValue, rowIndex);
                break;
            }
            case "unit": 
            case "priceqty": 
            case "priceunit": {
                this.changeQtyOrUnitByBillBizQty(propName, newValue, rowIndex);
                break;
            }
            case "lot": {
                this.changeLotByBillLot(e, propName, rowIndex);
                break;
            }
            case "lotnumber": {
                this.relSpace(rowIndex, "lotnumber");
                this.changeLotNumber(oldValue, newValue, rowIndex);
                break;
            }
            case "serialnumber": {
                this.relSpace(rowIndex, "serialnumber");
                break;
            }
            case "billtype": {
                this.changeBillType(newValue, oldValue);
                break;
            }
            case "biztype": {
                this.changeBizType(oldValue);
                break;
            }
            case "linetype": {
                this.changeLineType(oldValue, newValue, rowIndex);
                break;
            }
            case "producedate": {
                this.changeProduceDate((Date)newValue, rowIndex);
            }
            case "applydept": {
                this.changeApplyDept();
                break;
            }
            case "expirydate": {
                this.changeExpirydate((Date)oldValue, (Date)newValue, rowIndex);
                break;
            }
        }
        if (qtyFields.contains(propName) && newValue instanceof BigDecimal) {
            BigDecimal value = (BigDecimal)newValue;
            BigDecimal oldValueBigDecimal = BigDecimal.ZERO;
            if (oldValue != null && ((BigDecimal)oldValue).compareTo(BigDecimal.ZERO) > 0) {
                oldValueBigDecimal = (BigDecimal)oldValue;
            }
            if (value.compareTo(BigDecimal.ZERO) < 0) {
                this.view.getModel().setValue(propName, (Object)oldValueBigDecimal, rowIndex);
            }
        }
    }

    private void changeMaterialName(Object oldValue, Object newValue, int rowIndex) {
        Object value;
        if ((newValue == null || newValue == "" || "".equalsIgnoreCase(newValue.toString().trim())) && oldValue != null && (value = this.getModel().getValue("material", rowIndex)) != null) {
            this.getModel().setValue("materialname", oldValue, rowIndex);
            this.getView().updateView("materialname", rowIndex);
        }
    }

    private void changeApplyDept() {
        Long deptId;
        Set userIds;
        DynamicObject applyDept = (DynamicObject)this.getModel().getValue("applydept");
        DynamicObject applyUser = (DynamicObject)this.getModel().getValue("applyuser");
        if (applyDept != null && applyUser != null && !(userIds = UserServiceHelper.getAllUsersOfOrg((int)6, Collections.singletonList(deptId = (Long)applyDept.getPkValue()), (boolean)false, (boolean)false)).contains((Long)applyUser.getPkValue())) {
            this.getModel().setValue("applyuser", null);
        }
    }

    private void changeAuditQty(Object oldValue, Object newValue, int rowIndex) {
        BigDecimal qty = (BigDecimal)this.view.getModel().getValue("qty", rowIndex);
        if (qty.compareTo((BigDecimal)newValue) < 0) {
            this.view.showErrorNotification(ResManager.loadKDString((String)"\u6838\u51c6\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u6570\u91cf\u3002", (String)"ImApplyBillPropChanged_4", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            this.view.getModel().setValue("auditqty", oldValue, rowIndex);
        } else {
            this.changeQtyOrUnitByBillBizQty("auditqty", newValue, rowIndex);
        }
    }

    private void changeQty(Object newValue, int rowIndex) {
        this.view.getModel().setValue("auditqty", newValue, rowIndex);
    }

    private void resetMaterial(DynamicObject material, int rowIndex) {
        IDataModel bill = this.view.getModel();
        this.clearMaterialInfo(bill, rowIndex);
        this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"configuredcode"});
        if (material != null) {
            this.resetMaterialInfo(bill, material, rowIndex);
        }
    }

    private void clearMaterialInfo(IDataModel bill, int rowindex) {
        bill.beginInit();
        this.clearEntryField("auditqty", rowindex);
        this.clearEntryField("unit", rowindex);
        this.clearEntryField("qty", rowindex);
        this.clearEntryField("baseunit", rowindex);
        this.clearEntryField("baseqty", rowindex);
        this.clearEntryField("priceqty", rowindex);
        this.clearEntryField("priceunit", rowindex);
        this.clearEntryField("priceunitrate", rowindex);
        this.clearEntryField("bizunit", rowindex);
        this.clearEntryField("qtybizunit", rowindex);
        this.clearEntryField("bizunitrate", rowindex);
        this.clearEntryField("unit2nd", rowindex);
        this.clearEntryField("qtyunit2nd", rowindex);
        this.clearEntryField("auxpty", rowindex);
        this.clearEntryField("producedate", rowindex);
        this.clearEntryField("expirydate", rowindex);
        this.clearEntryField("materialname", rowindex);
        this.clearEntryField("configuredcode", rowindex);
        this.clearEntryField("serialnumber", rowindex);
        bill.endInit();
        BillViewHelper.updateViewRow((IFormView)this.view, (int)rowindex, (String)"billentry");
    }

    private void clearEntryField(String fieldkey, int rowIndex) {
        IDataModel model = this.getModel();
        if (MetaDataHelper.isExistField((IDataModel)model, (String)"billentry", (String)fieldkey)) {
            model.setValue(fieldkey, null, rowIndex);
        }
    }

    private void resetMaterialInfo(IDataModel bill, DynamicObject material, int rowIndex) {
        DynamicObject masterMaterial = MaterialHelper.getMaterialByMatBiz((DynamicObject)material);
        boolean isdisposable = masterMaterial.getBoolean("isdisposable");
        String materialName = masterMaterial.getString("name");
        this.getView().setEnable(Boolean.valueOf("2".equals(masterMaterial.get("configproperties"))), rowIndex, new String[]{"configuredcode"});
        this.getModel().beginInit();
        if (isdisposable) {
            bill.setValue("materialname", (Object)materialName, rowIndex);
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"materialname"});
        } else {
            bill.setValue("materialname", (Object)materialName, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"materialname"});
        }
        this.getView().updateView("materialname", rowIndex);
        EntryGrid grid = (EntryGrid)this.getView().getControl("billentry");
        int[] selectRows = grid.getSelectRows();
        if (selectRows != null && selectRows.length != 0) {
            int selectedRow = grid.getSelectRows()[0];
            bill.setValue("linetype", bill.getValue("linetype", selectedRow), rowIndex);
            this.getView().updateView("linetype", rowIndex);
        }
        this.getModel().endInit();
        DynamicObject baseUnit = masterMaterial.getDynamicObject("baseunit");
        if (baseUnit == null) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MATERIAL_BASEUNIT(), (Object[])new Object[0]));
        }
        bill.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
        DynamicObject unit = material.getDynamicObject("inventoryunit");
        bill.setValue("unit", unit.getPkValue(), rowIndex);
        boolean isOnShelf = material.getBoolean("enableshelflifemgr");
        this.getView().setEnable(Boolean.valueOf(isOnShelf), rowIndex, new String[]{"producedate"});
        this.getView().setEnable(Boolean.valueOf(isOnShelf), rowIndex, new String[]{"expirydate"});
        boolean enableSerialNum = SerialNumberHelper.isEnableSerial((DynamicObject)material);
        this.getView().setEnable(Boolean.valueOf(enableSerialNum), rowIndex, new String[]{"serialnumber"});
        DynamicObject invUnit = material.getDynamicObject("inventoryunit");
        if (invUnit == null) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MATERIAL_INVUNIT(), (Object[])new Object[0]));
        }
        DynamicObject auxptyUnit = masterMaterial.getDynamicObject("auxptyunit");
        Boolean isUseAuxptyUnit = auxptyUnit != null;
        if (isUseAuxptyUnit.booleanValue()) {
            BigDecimal unit2ndRate = BillQtyAndUnitHelper.getUnitRateConv((Long)((Long)masterMaterial.getPkValue()), (Long)((Long)auxptyUnit.getPkValue()), (Long)((Long)baseUnit.getPkValue()));
            bill.setValue("unit2nd", auxptyUnit.getPkValue(), rowIndex);
            IPageCache pageCache = this.plugin.getPageCache();
            unit2ndRate = unit2ndRate == null ? BigDecimal.ZERO : unit2ndRate;
            pageCache.put("unit2ndrate_" + rowIndex, unit2ndRate.toString());
            this.getView().setVisible(Boolean.TRUE, new String[]{"unit2nd"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"qtyunit2nd"});
        }
        this.getView().setEnable(isUseAuxptyUnit, rowIndex, new String[]{"qtyunit2nd"});
        BillViewHelper.updateViewRow((IFormView)this.getView(), (int)rowIndex, (String)"billentry");
    }

    private void changeMaterialByMaterial(Object newValue, int rowIndex) {
        IDataModel bill = this.view.getModel();
        if (newValue instanceof DynamicObject) {
            DynamicObject material = (DynamicObject)newValue;
            if (CommonUtils.isNull((Object)material)) {
                if (MetaDataHelper.isExistField((IDataModel)bill, (String)"billentry", (String)"materialmasterid")) {
                    bill.beginInit();
                    bill.setValue("materialmasterid", null, rowIndex);
                    bill.endInit();
                }
                return;
            }
            DynamicObject masterMaterial = MaterialHelper.getMaterialByMatBiz((DynamicObject)material);
            if (MetaDataHelper.isExistField((IDataModel)bill, (String)"billentry", (String)"materialmasterid")) {
                bill.beginInit();
                bill.setValue("materialmasterid", (Object)masterMaterial, rowIndex);
                bill.endInit();
                BillViewHelper.updateViewField((IFormView)this.view, (int)rowIndex, (String)"billentry", (String[])new String[]{"materialmasterid"});
            }
            if (masterMaterial.getBoolean("isdisposable")) {
                this.view.setEnable(Boolean.TRUE, rowIndex, new String[]{"materialname"});
            } else {
                this.view.setEnable(Boolean.FALSE, rowIndex, new String[]{"materialname"});
            }
        }
    }

    private void changeMaterialByBillAuxpty(DynamicObject materialInvInfo, int rowIndex) {
        IDataModel bill = this.view.getModel();
        DynamicObject material = MaterialHelper.getMaterialByMatBiz((DynamicObject)materialInvInfo);
        if (!CommonUtils.isNull((Object)material)) {
            Boolean isuseauxpty = material.getBoolean("isuseauxpty");
            if (isuseauxpty.booleanValue() && FieldUtils.isExistField((IDataModel)bill, (String)"auxpty")) {
                this.view.setVisible(Boolean.TRUE, new String[]{"auxpty"});
            }
            this.view.setEnable(isuseauxpty, rowIndex, new String[]{"auxpty"});
        }
    }

    private void changeMaterialByBillLot(DynamicObject materialInvInfo, int rowIndex) {
        IDataModel bill = this.view.getModel();
        bill.setValue("lotnumber", null, rowIndex);
        if (null == materialInvInfo) {
            return;
        }
        Boolean enablelot = materialInvInfo.getBoolean("enablelot");
        this.view.setEnable(enablelot, rowIndex, new String[]{"lotnumber"});
        this.view.setEnable(enablelot, rowIndex, new String[]{"lot"});
    }

    private void changeQtyOrUnitByBillBizQty(String propName, Object newValue, int rowIndex) {
        Object material;
        if ("unit".equals(propName)) {
            this.view.setEnable(Boolean.valueOf(newValue != null), rowIndex, new String[]{"qty"});
        }
        IDataModel bill = this.getModel();
        Object masterMaterial = material = bill.getValue("material", rowIndex);
        if (MetaDataHelper.isExistField((IDataModel)bill, (String)"billentry", (String)"materialmasterid")) {
            masterMaterial = bill.getValue("materialmasterid", rowIndex);
        }
        if (StringUtils.isBlank((Object)material) && StringUtils.isBlank((Object)masterMaterial)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u4fe1\u606f\u3002", (String)"BillBizQtyPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        BillUnitAndQtytHelper.setBizQtyAndUnitWithAuditQty((IDataModel)bill, (int)rowIndex, (String)propName, (Object)newValue);
        AuxQtyAndUnitHelper.setAuxBizQtyAndUnit((IPageCache)this.plugin.getPageCache(), (IDataModel)bill, (int)rowIndex, (String)propName, (Object)newValue);
        BillViewHelper.updateViewRow((IFormView)this.getView(), (int)rowIndex, (String)"billentry");
    }

    private void changeLotByBillLot(PropertyChangedArgs e, String propName, int rowIndex) {
        String entryName = "billentry";
        String lotidField = "billentry." + propName;
        String lotnumberField = "lotnumber";
        LotMainFileHelper.changeLot((PropertyChangedArgs)e, (IDataModel)this.getModel(), (IFormView)this.getView(), (String)entryName, (int)rowIndex, (String)lotidField, (String)lotnumberField);
    }

    private void changeLotNumber(Object oldValue, Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        DataChangeHelper.setValue((IDataModel)model, (String)"lot", null, (int)rowIndex, (boolean)false);
        this.setLifeDateByLotNmber(rowIndex, (String)newValue, model);
    }

    private void setLifeDateByLotNmber(int rowIndex, String lotNumber, IDataModel model) {
        String orgKey = "org";
        String formId = this.getModel().getDataEntityType().getName();
        if ("im_materialreqbill".equals(formId)) {
            orgKey = "bizorg";
        }
        DynamicObject org = (DynamicObject)model.getValue(orgKey);
        DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
        if (org == null || material == null) {
            return;
        }
        if (!material.getBoolean("enableshelflifemgr")) {
            return;
        }
        QFilter qFilter = new QFilter("materialmaster", "=", (Object)material.getLong("masterid.id"));
        qFilter.and("org", "=", org.getPkValue());
        qFilter.and("lotnumber", "=", (Object)lotNumber);
        DynamicObjectCollection lotinTracks = QueryServiceHelper.query((String)"im_lotintrack", (String)"producedate,expirydate", (QFilter[])qFilter.toArray(), (String)"biztime desc, createtime desc", (int)1);
        if (lotinTracks != null && lotinTracks.size() > 0) {
            DynamicObject lotinTrack = (DynamicObject)lotinTracks.get(0);
            Date producedate = lotinTrack.getDate("producedate");
            Date expirydate = lotinTrack.getDate("expirydate");
            this.setValue("producedate", producedate, rowIndex, false);
            this.setValue("expirydate", expirydate, rowIndex, false);
        }
    }

    private void changeBillType(Object newValue, Object oldValue) {
        if (newValue == null) {
            this.getModel().beginInit();
            this.getModel().setValue("billtype", oldValue);
            this.getModel().endInit();
            return;
        }
        if (!CommonUtils.isNull((Object)newValue) && newValue instanceof DynamicObject) {
            DynamicObject billType;
            String formid = this.getModel().getDataEntityType().getName();
            DynamicObject bizType = BizTypeHelper.getBizTypeByBillType((String)formid, (DynamicObject)(billType = (DynamicObject)newValue));
            if (CommonUtils.isNull((Object)bizType)) {
                this.view.setVisible(Boolean.TRUE, new String[]{"biztype"});
                this.view.setEnable(Boolean.TRUE, new String[]{"biztype"});
            } else {
                this.view.getModel().setValue("biztype", (Object)bizType.getLong("id"));
            }
        }
    }

    private void changeBizType(Object oldValue) {
        this.showBizTypeChangeConfirm(oldValue);
    }

    private void showBizTypeChangeConfirm(Object oldValue) {
        IDataModel model = this.getModel();
        DynamicObject bizType = (DynamicObject)model.getValue("biztype");
        Object domain = bizType == null ? null : bizType.get("domain");
        DynamicObject oldBizType = oldValue == null ? null : (DynamicObject)oldValue;
        int entryRowCount = model.getEntryRowCount("billentry");
        String formId = this.getModel().getDataEntityType().getName();
        HashMap<Object, Object> confirmInfo = new HashMap<Object, Object>(4);
        ArrayList<Integer> clearEntryIndexList = new ArrayList<Integer>(entryRowCount);
        for (int i = 0; i < entryRowCount; ++i) {
            clearEntryIndexList.add(i);
        }
        confirmInfo.put("newBizDomain", domain);
        confirmInfo.put("clearEntryIndexList", clearEntryIndexList);
        confirmInfo.put("oldBizTypeId", oldBizType == null ? null : oldBizType.getPkValue());
        if (formId.equals("im_materialreqbill")) {
            this.validateClearInfo(confirmInfo);
        }
        ConfirmCallBackListener cb = new ConfirmCallBackListener("clearSupplierOrEntry", (IFormPlugin)this.plugin);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u4e1a\u52a1\u7c7b\u578b\u5c06\u6e05\u9664\u5f53\u524d\u5355\u636e\u5206\u5f55\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"ImApplyBillPropChanged_2", (String)"scmc-im-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(confirmInfo));
    }

    private void validateClearInfo(Map<Object, Object> confirmInfo) {
        confirmInfo.put("clearSupplier", false);
        boolean clearSupplier = this.checkIfClearSupplier();
        confirmInfo.put("clearSupplier", clearSupplier);
    }

    private boolean checkIfClearSupplier() {
        IDataModel model = this.getModel();
        boolean clearSupplier = false;
        DynamicObject supplier = (DynamicObject)model.getValue("supplyowner");
        String supplyownerType = (String)model.getValue("supplyownertype");
        if (supplier != null && "bd_supplier".equals(supplyownerType)) {
            clearSupplier = !(supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)supplier.getPkValue(), (String)"bd_supplier", (String)"id,enablevmi")).getBoolean("enablevmi");
        }
        return clearSupplier;
    }

    private void changeLineType(Object oldValue, Object newValue, int rowIndex) {
        if (newValue == null && oldValue != null) {
            this.getModel().setValue("linetype", oldValue, rowIndex);
            return;
        }
        if (oldValue == null && newValue != null) {
            this.getModel().setValue("linetype", newValue, rowIndex);
            return;
        }
        DynamicObject oldLineType = oldValue == null ? null : (DynamicObject)oldValue;
        HashMap<String, Object> confirmInfo = new HashMap<String, Object>(4);
        confirmInfo.put("oldLineTypeId", oldLineType == null ? null : oldLineType.getPkValue());
        confirmInfo.put("rowIndex", rowIndex);
        ConfirmCallBackListener cb = new ConfirmCallBackListener("clearMaterial", (IFormPlugin)this.plugin);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u884c\u7c7b\u578b\u5c06\u6e05\u9664\u5f53\u524d\u5206\u5f55\u7684\u7269\u6599\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"ImApplyBillPropChanged_3", (String)"scmc-im-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(confirmInfo));
    }

    private void update2Version(DynamicObject materialInvInfo, int rowIndex) {
        if (materialInvInfo == null) {
            this.getModel().setValue("mversion", (Object)null, rowIndex);
            return;
        }
        try {
            String versionId = (String)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataService", (String)"getVersionByMaterial", (Object[])new Object[]{materialInvInfo.getLong("masterid_id")});
            if (StringUtils.isNotBlank((CharSequence)versionId) && !"0".equals(versionId)) {
                this.getModel().setValue("mversion", (Object)Long.valueOf(versionId), rowIndex);
            } else {
                this.getModel().setValue("mversion", (Object)null, rowIndex);
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u7269\u6599\u7248\u672c\u201c\u67e5\u8be2\u670d\u52a1\u201d\u51fa\u9519\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"ImApplyBillPropChanged_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
    }

    private void subEntryUI(int row) {
        if (row == -1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"seradvconap", "serialimptpanelap"});
            return;
        }
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("billentry", row);
        if (null == rowEntity) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"seradvconap", "serialimptpanelap"});
            return;
        }
        DynamicObject mat = rowEntity.getDynamicObject("material");
        if (null == mat) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"seradvconap", "serialimptpanelap"});
            return;
        }
        boolean enableSer = mat.getBoolean("enableserial");
        this.getView().setEnable(Boolean.valueOf(enableSer), new String[]{"seradvconap", "serialimptpanelap"});
    }

    private void changeProduceDate(Date date, int rowIndex) {
        String calculationForEndDate;
        int shelflife;
        if (date == null) {
            return;
        }
        DynamicObject materialInvInfo = (DynamicObject)this.getModel().getValue("material", rowIndex);
        if (materialInvInfo == null || !materialInvInfo.getBoolean("enableshelflifemgr")) {
            return;
        }
        if (!MaterialHelper.isCalShelflife((DynamicObject)materialInvInfo, (boolean)true)) {
            Date expirydate = (Date)this.getModel().getValue("expirydate", rowIndex);
            this.checkShelflifeDate(date, expirydate, rowIndex, "producedate", materialInvInfo);
            return;
        }
        String shelflifeUnit = materialInvInfo.getString("shelflifeunit");
        Date expirydate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)(shelflife = materialInvInfo.getInt("shelflife")), (Date)date, (String)(calculationForEndDate = materialInvInfo.getString("calculationforenddate")));
        if (expirydate.before(date)) {
            String newExpirydateStr = this.getDateStr(expirydate);
            String newProduceDateStr = this.getDateStr(date);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u7269\u6599\u201c%2$s\u201d\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165,\u8bf7\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u4fdd\u8d28\u671f\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u548c\u4fdd\u8d28\u671f\u8bbe\u7f6e\u3002", (String)"ImApplyBillPropChanged_1", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            this.getView().showErrorNotification(msg);
            this.setValue("producedate", null, rowIndex, false);
            return;
        }
        this.setValue("expirydate", expirydate, rowIndex, false);
    }

    private void changeExpirydate(Date oldExpirydate, Date date, int rowIndex) {
        Date oldProducedate;
        if (date == null) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject materialInvInfo = (DynamicObject)model.getValue("material", rowIndex);
        if (materialInvInfo == null || !materialInvInfo.getBoolean("enableshelflifemgr")) {
            return;
        }
        if (!MaterialHelper.isCalShelflife((DynamicObject)materialInvInfo, (boolean)false)) {
            Date oldProducedate2 = (Date)model.getValue("producedate", rowIndex);
            this.checkShelflifeDate(oldProducedate2, date, rowIndex, "expirydate", materialInvInfo);
            return;
        }
        String shelflifeUnit = materialInvInfo.getString("shelflifeunit");
        int shelflife = materialInvInfo.getInt("shelflife");
        String calculationForEndDate = materialInvInfo.getString("calculationforenddate");
        Date producedate = oldProducedate = (Date)model.getValue("producedate", rowIndex);
        if (!"2".equals(calculationForEndDate)) {
            producedate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)(shelflife * -1), (Date)date, (String)calculationForEndDate);
        } else if (producedate != null && date.before(producedate)) {
            if (oldExpirydate != null && oldExpirydate.before(producedate)) {
                oldExpirydate = null;
            }
            String newExpirydateStr = this.getDateStr(date);
            String newProduceDateStr = this.getDateStr(producedate);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u7269\u6599\u201c%2$s\u201d\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165,\u8bf7\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u4fdd\u8d28\u671f\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u548c\u4fdd\u8d28\u671f\u8bbe\u7f6e\u3002", (String)"ImApplyBillPropChanged_1", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            this.getView().showErrorNotification(msg);
            this.setValue("expirydate", oldExpirydate, rowIndex, false);
            return;
        }
        this.setValue("producedate", producedate, rowIndex, false);
    }

    private String getDateStr(Date date) {
        String dateStr = null;
        if (date == null) {
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        dateStr = sd.format(date);
        return dateStr;
    }

    public void setValue(String key, Object value, boolean isTriggerChangeEvent) {
        DataChangeHelper.setValue((IDataModel)this.getModel(), (String)key, (Object)value, (boolean)isTriggerChangeEvent);
    }

    public void setValue(String key, Object value, int i, boolean isTriggerChangeEvent) {
        DataChangeHelper.setValue((IDataModel)this.getModel(), (String)key, (Object)value, (int)i, (boolean)isTriggerChangeEvent);
    }

    private void relSpace(int row, String field) {
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("billentry", row);
        String fieldValue = dynamicObject.getString(field);
        if (fieldValue != null) {
            fieldValue = fieldValue.replaceAll("\u3000", " ").trim();
            this.setValue(field, fieldValue, row, false);
        }
    }

    private void checkShelflifeDate(Date produceDate, Date expirydate, int rowIndex, String key, DynamicObject materialInvInfo) {
        if (expirydate != null && produceDate != null && expirydate.before(produceDate)) {
            String newExpirydateStr = this.getDateStr(expirydate);
            String newProduceDateStr = this.getDateStr(produceDate);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u201c%2$s\u201d\u7684\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u8bf7\u4fee\u6539\u5230\u671f\u65e5\u671f\u6216\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u7684\u201c\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u201d\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImBillPropChanged_9", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            this.getView().showErrorNotification(msg);
            this.setValue(key, null, rowIndex, false);
        }
    }

    static {
        qtyFields.add("qty");
        qtyFields.add("baseqty");
        qtyFields.add("auditqty");
        qtyFields.add("qtyunit2nd");
    }
}

