/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.enums.BizCategoryEnum;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.AppParameterHelper;
import kd.scmc.im.business.helper.BizTypeHelper;
import kd.scmc.im.business.helper.ImBillEditHelper;
import kd.scmc.im.business.helper.InvBillHelper;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.business.helper.MaterialWhRelationHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.business.helper.OperatorGroupHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.business.helper.linetype.BillTypeMaterialHelper;
import kd.scmc.im.business.helper.linetype.LineTypeParam;
import kd.scmc.im.business.service.InvSchemeService;
import kd.scmc.im.business.service.InvSchemeServiceFactory;
import kd.scmc.im.enums.InvalidEnum;
import kd.scmc.im.enums.StatusEnum;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class ImBillBeforeF7Select {
    private static final String MASTERID_ENABLEVMI = "masterid.enablevmi";
    private IFormView view = null;

    public ImBillBeforeF7Select(IFormView view) {
        this.view = view;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        String formid = this.getModel().getDataEntityType().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        IDataModel bill = this.getModel();
        boolean isMainOrg = ImBillEditHelper.isMainOrgByF7((IFormView)this.view, (IDataModel)bill, (String)fieldKey);
        if (!isMainOrg) {
            e.setCancel(true);
            return;
        }
        int row = e.getRow();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        if ("biztype".equals(fieldKey)) {
            this.beforeBizTypeSelect(formid, showParameter);
        } else if ("linetype".equals(fieldKey)) {
            this.beforeLineType(showParameter, formid);
        } else if ("org".equals(fieldKey)) {
            this.beforeOrg(showParameter);
        } else if ("warehouse".equals(fieldKey) || "outwarehouse".equals(fieldKey)) {
            this.beforeWarehouse(e, showParameter, bill);
        } else if ("location".equals(fieldKey) || "outlocation".equals(fieldKey)) {
            this.beforeLocation(e, showParameter, bill, rowIndex, fieldKey);
        } else if ("invscheme".equals(fieldKey)) {
            this.beforeInvscheme(formid, showParameter);
        } else if ("invstatus".equals(fieldKey) && !this.isInitBill()) {
            this.beforeInvTypeOrStatus(e, formid, bill, "invstatusentry", "invstatus");
        } else if ("invtype".equals(fieldKey)) {
            this.beforeInvTypeOrStatus(e, formid, bill, "invtypeentry", "invtype");
        } else if ("outinvstatus".equals(fieldKey)) {
            this.beforeInvTypeOrStatus(e, formid, bill, "outinvstatusentry", "outinvstatus");
        } else if ("outinvtype".equals(fieldKey)) {
            this.beforeInvTypeOrStatus(e, formid, bill, "outinvtypeentry", "outinvtype");
        } else if ("material".equals(fieldKey)) {
            this.beforeMaterial(showParameter, bill, formid);
            MaterialWhRelationHelper.addWarehouseSetupFilter((BeforeF7SelectEvent)e, (ListShowParameter)showParameter, (IDataModel)bill, (String)"warehouse");
        } else if ("mversion".equals(fieldKey)) {
            this.beforeMversion(showParameter, bill, rowIndex);
        } else if ("unit".equals(fieldKey)) {
            this.beforeUnit(showParameter, bill, rowIndex);
        } else if (fieldKey.equalsIgnoreCase("operator") || fieldKey.equalsIgnoreCase("outoperator")) {
            this.beforeOperator(showParameter, bill, fieldKey);
        } else if (fieldKey.equalsIgnoreCase("operatorgroup") || fieldKey.equalsIgnoreCase("outoperatorgroup")) {
            this.beforeOperatorGroup(showParameter, bill, fieldKey);
        } else if (!fieldKey.contains("auxpty")) {
            if (fieldKey.equalsIgnoreCase("owner") || fieldKey.equalsIgnoreCase("keeper") || fieldKey.equalsIgnoreCase("outowner") || fieldKey.equalsIgnoreCase("outkeeper")) {
                InvSchemeService service = InvSchemeServiceFactory.getService((IFormView)this.view);
                if (service != null) {
                    switch (fieldKey) {
                        case "owner": {
                            service.setOwnerF7Select(e, row);
                            break;
                        }
                        case "keeper": {
                            service.setKeeperF7Select(e, row);
                            break;
                        }
                        case "outowner": {
                            service.setOutOwnerF7Select(e, row);
                            break;
                        }
                        case "outkeeper": {
                            service.setOutKeeperF7Select(e, row);
                            break;
                        }
                    }
                }
            } else if (fieldKey.equalsIgnoreCase("lot")) {
                this.beforeSelectInlot(e, fieldKey);
            } else if (fieldKey.equalsIgnoreCase("tracknumber")) {
                this.beforeTrackNumOrConfigCode(showParameter, rowIndex, fieldKey);
            } else if (fieldKey.equalsIgnoreCase("configuredcode")) {
                this.beforeTrackNumOrConfigCode(showParameter, rowIndex, fieldKey);
            }
        }
    }

    private void beforeTrackNumOrConfigCode(ListShowParameter showParameter, int rowIndex, String field) {
        QFilter qFilter = null;
        if (field.equalsIgnoreCase("configuredcode")) {
            Object value = this.getModel().getValue("material", rowIndex);
            if (value != null) {
                DynamicObject material = (DynamicObject)value;
                qFilter = InvBillHelper.getConfigureCodeFilter((Object)material.get("masterid.id"));
            }
        } else {
            qFilter = InvBillHelper.getTrackNumberFilter();
        }
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void beforeSelectInlot(BeforeF7SelectEvent e, String fieldKey) {
        IDataModel model = this.getModel();
        DynamicObject bill = model.getDataEntity();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        DynamicObject selectEntry = model.getEntryRowEntity("billentry", rowIndex);
        String lotidField = "billentry." + fieldKey;
        LotMainFileHelper.setLotMainfFileF7Filter((BeforeF7SelectEvent)e, (DynamicObject)bill, (DynamicObject)selectEntry, (String)lotidField);
    }

    private void beforeOperatorGroup(ListShowParameter showParameter, IDataModel bill, String filedKey) {
        String orgField = "org";
        if (filedKey.equals("outoperatorgroup")) {
            orgField = "outorg";
        }
        DynamicObject org = (DynamicObject)bill.getValue(orgField);
        DynamicObject operator = (DynamicObject)bill.getValue("operator");
        if (operator == null) {
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)0));
        } else {
            operator = BusinessDataServiceHelper.loadSingleFromCache((Object)operator.getPkValue(), (String)"bd_operator");
            QFilter qFilter = new QFilter("id", "in", this.getOperatorGroupByUser((Long)operator.getDynamicObject("operatorid").getPkValue(), org));
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private void beforeOperator(ListShowParameter showParameter, IDataModel bill, String fieldKey) {
        Object operatorGroupIsolate;
        DynamicObject org;
        String orgField = "org";
        if (fieldKey.equals("outoperator")) {
            orgField = "outorg";
        }
        if ((org = (DynamicObject)bill.getValue(orgField)) == null) {
            showParameter.getListFilterParameter().setFilter(new QFilter("1", "=", (Object)2));
            return;
        }
        long userId = UserServiceHelper.getCurrentUserId();
        String formId = this.getModel().getDataEntityType().getName();
        Map customParas = this.getView().getFormShowParameter().getCustomParams();
        if (customParas != null && customParas.get("sourceformid") != null && customParas.get("orgViewType") != null) {
            formId = (String)customParas.get("sourceformid");
        }
        if ((operatorGroupIsolate = AppParameterHelper.getAppParameterByFormId((String)formId, (Long)((Long)org.getPkValue()), (String)"foperatorgroupisolate")) instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
            QFilter qFilter1 = OperatorGroupHelper.getOperatorGroupByUserForAll((long)userId, (DynamicObject)org);
            QFilter qFilter2 = new QFilter("opergrptype", "=", (Object)this.getOperatorGroupType());
            QFilter qFilter3 = new QFilter("invalid", "=", (Object)InvalidEnum.NO.getValue());
            showParameter.getListFilterParameter().setFilter(qFilter2.and(qFilter3).and(qFilter1));
        } else {
            QFilter qFilter1 = new QFilter("operatorgrpid", "in", this.getOperatorGroupByOrg((Long)org.getPkValue()));
            QFilter qFilter2 = new QFilter("opergrptype", "=", (Object)this.getOperatorGroupType());
            QFilter qFilter3 = new QFilter("invalid", "=", (Object)InvalidEnum.NO.getValue());
            showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter1, qFilter2, qFilter3));
        }
    }

    private void beforeUnit(ListShowParameter showParameter, IDataModel bill, int rowIndex) {
        Object material;
        Long masterMaterialId = 0L;
        Object masterMaterial = material = bill.getValue("material", rowIndex);
        if (MetaDataHelper.isExistField((IDataModel)bill, (String)"billentry", (String)"materialmasterid")) {
            masterMaterial = bill.getValue("materialmasterid", rowIndex);
        }
        masterMaterialId = masterMaterial instanceof DynamicObject ? (Long)((DynamicObject)masterMaterial).getPkValue() : (Long)masterMaterial;
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowIndex);
        Long srcmuId = baseUnit == null ? Long.valueOf(0L) : (Long)baseUnit.getPkValue();
        List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)masterMaterialId, (Long)srcmuId, (String)"1", (Boolean)Boolean.TRUE);
        QFilter qFilter = new QFilter("id", "in", (Object)unitIds);
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void beforeMaterial(ListShowParameter showParameter, IDataModel bill, String formId) {
        DynamicObject org = (DynamicObject)bill.getValue("org");
        DynamicObject billType = (DynamicObject)bill.getValue("billtype");
        if (billType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5355\u636e\u7c7b\u578b\u3002", (String)"ImBillBeforeF7Select_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        DynamicObject bizType = (DynamicObject)bill.getValue("biztype");
        if (org != null) {
            QFilter qFilter = new QFilter("masterid.status", "=", (Object)"C");
            qFilter.and("masterid.enable", "=", (Object)"1");
            if (!formId.equals("im_initbill")) {
                Object value;
                if (bizType == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"ImBillBeforeF7Select_2", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                }
                DynamicObject lineType = (DynamicObject)bill.getValue("linetype");
                if (lineType == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u884c\u7c7b\u578b\u3002", (String)"ImBillBeforeF7Select_3", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                }
                QFilter[] qFilterByLineType = BillTypeMaterialHelper.getQFilterByLineType((Long)((Long)billType.getPkValue()), (Long)((Long)bizType.getPkValue()), (Long)((Long)lineType.getPkValue()), (boolean)true);
                if (qFilterByLineType != null && (value = qFilterByLineType[0].getValue()) != null && !value.equals(1)) {
                    QFilter serviceAttrFilter = QFilter.sqlExpress((String)"masterid.id", (String)"in", (String)(" ( select fid from t_bd_mtsserviceattribute where fbasedataid = " + value + " ) "));
                    qFilter.and(serviceAttrFilter);
                }
            }
            qFilter.and("status", "=", (Object)"C");
            qFilter.and("enable", "=", (Object)"1");
            if (bizType != null) {
                String bizCategory = BizCategoryEnum.BZ.getValue();
                String bizNum = bizType.getString("number");
                if (!("111".equals(bizNum) || "1111".equals(bizNum) || "322".equals(bizNum))) {
                    this.getMaterialFilterByMaterialType(showParameter, qFilter, bizCategory);
                }
                if ("6".equals(bizType.get("domain"))) {
                    switch (formId) {
                        case "im_purreceivebill": 
                        case "im_purinbill": 
                        case "im_materialreqoutbill": 
                        case "im_otheroutbill": 
                        case "im_saloutbill": {
                            qFilter.and(MASTERID_ENABLEVMI, "=", (Object)Boolean.TRUE);
                            break;
                        }
                    }
                }
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
            } else {
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        }
    }

    private void beforeInvTypeOrStatus(BeforeF7SelectEvent e, String formId, IDataModel bill, String entry, String entryField) {
        DynamicObject invScheme = this.getInvScheme(formId, bill);
        if (null == invScheme) {
            this.inventoryNotAllowNull();
        } else {
            DynamicObjectCollection entries = invScheme.getDynamicObjectCollection(entry);
            HashSet<Object> invTypeOrStatusIds = new HashSet<Object>();
            if (entries != null) {
                entries.forEach(c -> invTypeOrStatusIds.add(c.getDynamicObject(entryField).get("id")));
            }
            this.setInvTypeOrStatusF7Filter(e, invTypeOrStatusIds);
        }
    }

    private void beforeInvscheme(String formid, ListShowParameter showParameter) {
        IDataModel bill = this.getModel();
        DynamicObject bizType = (DynamicObject)bill.getValue("biztype");
        if (null == bizType) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getSELECT_BIZTYPE()));
        }
        QFilter qFilter = new QFilter("billform", "=", (Object)formid);
        qFilter.and("bitypeentry.biztype", "=", bizType.getPkValue());
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        qFilter.and("bitypeentry.allowmanualadd", "=", (Object)"1");
        showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter.toArray()));
    }

    private DynamicObject getInvScheme(String formId, IDataModel bill) {
        DynamicObject scheme = "im_locationtransfer".equals(formId) ? null : (DynamicObject)bill.getValue("invscheme");
        DynamicObject invScheme = null;
        if (scheme != null && scheme.getPkValue() != null) {
            invScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)scheme.getPkValue(), (String)"im_invscheme");
        }
        return invScheme;
    }

    private void beforeMversion(ListShowParameter showParameter, IDataModel bill, int rowIndex) {
        DynamicObject materialInvInfo = (DynamicObject)bill.getValue("material", rowIndex);
        if (materialInvInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599", (String)"ImBillBeforeF7Select_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("material", "=", (Object)materialInvInfo.getLong("masterid_id")));
    }

    private void beforeWarehouse(BeforeF7SelectEvent e, ListShowParameter showParameter, IDataModel bill) {
        DynamicObject org = (DynamicObject)bill.getValue("org");
        if (org == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ORG(), (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        int rowIdx = bill.getEntryCurrentRowIndex("billentry");
        DynamicObject row = bill.getEntryRowEntity("billentry", rowIdx);
        String formId = this.getModel().getDataEntityType().getName();
        WareHouseIsolateHelper.setWarehouseQFilterByDataCtrl((Long)org.getLong("id"), (ListShowParameter)showParameter, (String)formId, (DynamicObject)row, (String)e.getProperty().getName());
    }

    private void beforeLocation(BeforeF7SelectEvent e, ListShowParameter showParameter, IDataModel bill, int rowIndex, String fieldKey) {
        String warehousefieldKey = "location".equals(fieldKey) ? "warehouse" : "outwarehouse";
        DynamicObject warehouse = (DynamicObject)bill.getValue(warehousefieldKey, rowIndex);
        if (null == warehouse) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getSELECT_WAREHOUSE(), (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            QFilter qFilter1 = WarehouseHelper.buildLocationQFilter((DynamicObject)warehouse);
            showParameter.getListFilterParameter().setFilter(qFilter1);
        }
    }

    private void beforeOrg(ListShowParameter showParameter) {
        String formid = this.getModel().getDataEntityType().getName();
        Object[] orgIdList = NewInvOrgHelper.getHasPermissionAndStartedInvOrgIds((String)formid, (String)showParameter.getAppId());
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgIdList));
    }

    private void beforeBizType(String formid, ListShowParameter showParameter) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(3);
        QFilter qFilter1 = new QFilter("billentity.billform", "=", (Object)formid);
        QFilter qFilter2 = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter qFilter3 = new QFilter("enable", "=", (Object)"1");
        filterList.add(qFilter1);
        filterList.add(qFilter2);
        filterList.add(qFilter3);
        showParameter.getListFilterParameter().setQFilters(filterList);
    }

    private void beforeBizTypeSelect(String formId, ListShowParameter showParameter) {
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        if (billType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5355\u636e\u7c7b\u578b\u3002", (String)"ImBillBeforeF7Select_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        List bizTypeIds = BizTypeHelper.getBizTypeIds((Object)billType.getPkValue(), (String)formId);
        Object[] objects = new Object[]{1037687972641726464L, 1037688326724870144L};
        if ("im_otherinbill".equals(formId) && bizTypeIds.contains(objects[0])) {
            bizTypeIds.remove(objects[0]);
        } else if ("im_otheroutbill".equals(formId) && bizTypeIds.contains(objects[1])) {
            bizTypeIds.remove(objects[1]);
        }
        if (bizTypeIds != null) {
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)bizTypeIds));
        }
    }

    private void beforeLineType(ListShowParameter showParameter, String formId) {
        LineTypeParam lineTypeParam;
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        ArrayList<Long> bizTypes = new ArrayList<Long>(16);
        List lineTypes = new ArrayList(16);
        if (bizType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"ImBillBeforeF7Select_2", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        bizTypes.add(bizType.getLong("id"));
        Map lineTypeByBillType = BillTypeMaterialHelper.getLineTypeByBillType(bizTypes);
        if (lineTypeByBillType.size() != 0 && (lineTypes = (List)(lineTypeParam = (LineTypeParam)lineTypeByBillType.get(bizType.getLong("id"))).getLineTypeQf()[0].getValue()) != null && !"im_purreceivebill".equals(formId)) {
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bd_linetype", (QFilter[])new QFilter("id", "in", lineTypes).toArray());
            Iterator iterator = lineTypes.iterator();
            while (iterator.hasNext()) {
                Long next = (Long)iterator.next();
                DynamicObject lineType = (DynamicObject)dynamicObjectMap.get(next);
                if (lineType == null) {
                    iterator.remove();
                    continue;
                }
                DynamicObject entity = lineType.getDynamicObject("serviceattribute").getDynamicObject("entity");
                String entityNum = entity.getString("number");
                if ("bd_material".equals(entityNum)) continue;
                iterator.remove();
            }
        }
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", lineTypes));
    }

    private void getMaterialFilterByMaterialType(ListShowParameter showParameter, QFilter qFilter, String bizCategory) {
        List materialTypes = BizTypeHelper.getMaterialQFilterByBizCategory((String)bizCategory);
        if (materialTypes != null && materialTypes.size() != 0) {
            qFilter.and("masterid.materialtype", "in", (Object)materialTypes);
        }
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
    }

    private void setInvTypeF7Filter(BeforeF7SelectEvent e, Set<Object> invStatusIds) {
        ListFilterParameter listFilterParameter = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter();
        QFilter f = new QFilter("id", "in", invStatusIds);
        f.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        listFilterParameter.setFilter(f);
    }

    private void setInvTypeOrStatusF7Filter(BeforeF7SelectEvent e, Set<Object> invTypeOrStatusIds) {
        ListFilterParameter listFilterParameter = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter();
        QFilter f = new QFilter("id", "in", invTypeOrStatusIds);
        f.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        listFilterParameter.setFilter(f);
    }

    private ArrayList<Long> getOperatorGroupByUser(long userId, DynamicObject org) {
        ArrayList<Long> operatorGroupList = new ArrayList<Long>();
        QFilter qFilter1 = new QFilter("operatorid", "=", (Object)userId);
        QFilter qFilter2 = new QFilter("opergrptype", "=", (Object)this.getOperatorGroupType());
        qFilter2.and("invalid", "=", (Object)InvalidEnum.NO.getValue());
        QFilter qFilter3 = new QFilter("operatorgrpid", "in", this.getOperatorGroupByOrg((Long)org.getPkValue()));
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
        if (null == map || map.isEmpty()) {
            return operatorGroupList;
        }
        ArrayList list = new ArrayList(map.values());
        for (int i = 0; i < list.size(); ++i) {
            operatorGroupList.add(((DynamicObject)list.get(i)).getLong("operatorgrpid"));
        }
        return operatorGroupList;
    }

    private ArrayList<Long> getOperatorGroupByOrg(long orgId) {
        ArrayList<Long> operatorGroupList = new ArrayList<Long>();
        QFilter qFilter1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        QFilter qFilter2 = new QFilter("operatorgrouptype", "=", (Object)this.getOperatorGroupType());
        qFilter2.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        if (map == null || map.isEmpty()) {
            return operatorGroupList;
        }
        ArrayList list = new ArrayList(map.values());
        for (int i = 0; i < list.size(); ++i) {
            operatorGroupList.add((Long)((DynamicObject)list.get(i)).getPkValue());
        }
        return operatorGroupList;
    }

    private String getOperatorGroupType() {
        return OperatorGrpTypeEnum.INVENTORYGRP.getValue();
    }

    private List<Long> getLoactionIds(DynamicObjectCollection locationCol) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (locationCol == null || locationCol.size() == 0) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            DynamicObject location = locDym.getDynamicObject("location");
            ids.add(Long.valueOf(location.getPkValue().toString()));
        }
        return ids;
    }

    private IDataModel getModel() {
        return this.getView().getModel();
    }

    private IFormView getView() {
        return this.view;
    }

    private boolean isInitBill() {
        String formId = this.getModel().getDataEntityType().getName();
        return "im_initbill".equalsIgnoreCase(formId) || "im_locationtransfer".equalsIgnoreCase(formId);
    }

    private void inventoryNotAllowNull() {
        if (!this.isInitBill()) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_INVVENTORY_NOT_NULL()));
        }
    }
}

