/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.assigncfg.business.helper.AssignCfgHelper;
import kd.scmc.im.business.helper.AppParameterHelper;
import kd.scmc.im.business.helper.AuxQtyAndUnitHelper;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.business.helper.BizTypeHelper;
import kd.scmc.im.business.helper.CloseDateHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.ImLotHelper;
import kd.scmc.im.business.helper.InvAvbQtyQueryHelper;
import kd.scmc.im.business.helper.InvBillHelper;
import kd.scmc.im.business.helper.InvSchemeHelper;
import kd.scmc.im.business.helper.InverseBillHelper;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.business.helper.MaterialHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.SerialNumberHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;
import kd.scmc.im.business.helper.logisticsbill.LogisticsBillModel;
import kd.scmc.im.business.service.InvSchemeService;
import kd.scmc.im.business.service.InvSchemeServiceFactory;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.helper.DaysCalcHelper;
import kd.scmc.im.helper.ShelfLifeDateUtil;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.DateUtils;
import kd.scmc.im.utils.IMStringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ImBillPropChanged {
    private static final Log log = LogFactory.getLog(ImBillPropChanged.class);
    private static final String QUOTETYPE = "quoteType";
    private static final String EXCHANGERATE = "exchangeRate";
    private static String[] clearFields = new String[]{"materialmasterid", "auxpty", "producedate", "expirydate", "unit", "qty", "baseunit", "baseqty", "unit2nd", "qtyunit2nd", "lotnumber", "lot", "serialnumber", "mversion", "configuredcode"};
    private IFormView view;
    private IFormPlugin plugin;
    private LogisticsBillModel logisticsBillModel = null;
    private Set<String> inverseFields;
    private Map<String, Boolean> assignCfgMap = new HashMap<String, Boolean>(16);

    public ImBillPropChanged(IFormView view, IFormPlugin plugin) {
        this.view = view;
        this.plugin = plugin;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void propertyChanged(PropertyChangedArgs e) {
        EntryGrid grid;
        int[] selectRows;
        int rowIndex;
        if (!this.isChanged(e)) {
            return;
        }
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        InvAvbQtyQueryHelper.clearAvbQty((String)propName, (int)valueSet[0].getRowIndex(), (IFormView)this.view);
        String invQueryCallBack = this.view.getPageCache().get("isinvquerycallback");
        if (StringUtils.isBlank((CharSequence)invQueryCallBack)) {
            this.updateLogisticBill(propName);
        }
        if (propName.equals("billno")) {
            return;
        }
        if ("billtype".equals(propName)) {
            this.changeBillType((DynamicObject)newValue, (DynamicObject)oldValue);
        } else if ("biztype".equals(propName)) {
            this.changeBizType(newValue, oldValue);
        } else if ("warehouse".equals(propName)) {
            this.changeWarehouse(valueSet);
        } else if ("biztime".equals(propName)) {
            this.bizDateChange((Date)newValue);
        } else if ("invscheme".equals(propName)) {
            this.changeInvScheme(newValue);
        } else if (propName.equalsIgnoreCase("org")) {
            this.changeOrg(newValue);
        } else if (propName.equalsIgnoreCase("dept")) {
            this.changeDept(newValue);
        } else if (propName.equalsIgnoreCase("operatorgroup")) {
            this.changeOperatorGroup((DynamicObject)newValue);
        } else if (propName.equalsIgnoreCase("outoperatorgroup")) {
            this.changeOutOperatorGroup((DynamicObject)newValue);
        } else if (propName.equalsIgnoreCase("operator") || propName.equalsIgnoreCase("outoperator")) {
            this.changeOperatorOrOutOperator((DynamicObject)newValue, propName);
        } else if (propName.equalsIgnoreCase("producedate")) {
            rowIndex = valueSet[0].getRowIndex();
            this.changeProduceDate(oldValue, (Date)newValue, rowIndex);
        } else if (propName.equalsIgnoreCase("expirydate")) {
            rowIndex = valueSet[0].getRowIndex();
            this.changeExpiryDate(oldValue, (Date)newValue, rowIndex);
        } else if (propName.equalsIgnoreCase("lotnumber")) {
            rowIndex = valueSet[0].getRowIndex();
            this.relSpace(rowIndex, "lotnumber");
        } else if (propName.equalsIgnoreCase("serialnumber")) {
            rowIndex = valueSet[0].getRowIndex();
            this.relSpace(rowIndex, "serialnumber");
        }
        int selectedRow = -1;
        if ("material".equals(propName) && (selectRows = (grid = (EntryGrid)this.getView().getControl("billentry")).getSelectRows()) != null && selectRows.length != 0) {
            selectedRow = grid.getSelectRows()[0];
        }
        block26: for (int i = 0; i < valueSet.length; ++i) {
            newValue = valueSet[i].getNewValue();
            int rowIndex2 = valueSet[i].getRowIndex();
            if (this.inverseFields == null) {
                this.inverseFields = new HashSet<String>(Arrays.asList(this.getNeedInverseColumns()));
            }
            if (this.inverseFields.contains(propName) && newValue instanceof BigDecimal) {
                BigDecimal value = (BigDecimal)newValue;
                BigDecimal oldValueBigDecimal = BigDecimal.ZERO;
                if (oldValue != null && BigDecimal.ZERO.compareTo((BigDecimal)oldValue) < 0) {
                    oldValueBigDecimal = (BigDecimal)oldValue;
                }
                if (BigDecimal.ZERO.compareTo(value) > 0) {
                    if ("qty".equals(propName)) {
                        DataChangeHelper.setValue((IDataModel)this.getView().getModel(), (String)propName, (Object)oldValueBigDecimal, (int)rowIndex2, (boolean)true);
                        return;
                    }
                    DataChangeHelper.setValue((IDataModel)this.getView().getModel(), (String)propName, (Object)oldValueBigDecimal, (int)rowIndex2, (boolean)false);
                    return;
                }
            }
            switch (propName) {
                case "linetype": {
                    this.changeLineType(oldValue, newValue, rowIndex2);
                    break;
                }
                case "materialname": {
                    this.changeMaterialName(oldValue, newValue, rowIndex2);
                    break;
                }
                case "material": {
                    this.changeMaterial((DynamicObject)newValue, rowIndex2, selectedRow);
                    break block26;
                }
                case "baseqty": 
                case "qtybizunit": 
                case "qtyunit2nd": 
                case "unit": 
                case "qty": {
                    this.changeQtyOrUnit(propName, newValue, rowIndex2);
                    break;
                }
                case "lot": {
                    this.changeLot(e, propName, rowIndex2);
                    break;
                }
                case "lotnumber": {
                    this.changeLotNumber(oldValue, newValue, rowIndex2);
                    break;
                }
                case "invtype": {
                    this.changeInvType(newValue, rowIndex2);
                    break;
                }
                case "outinvtype": {
                    this.changeOutInvType(newValue, rowIndex2);
                }
            }
        }
        try {
            this.triggerByField(this.getModel(), e);
            return;
        }
        catch (Throwable throwable) {
            log.info("\u53d6\u503c\u914d\u7f6e\u6267\u884c\u5f02\u5e38", (Object)throwable);
        }
    }

    private void triggerByField(IDataModel model, PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        String entityNumber = model.getDataEntityType().getName();
        Boolean isCfg = this.assignCfgMap.get(entityNumber + propName);
        if (isCfg == null) {
            isCfg = AssignCfgHelper.hasAssignCfg((String)entityNumber, (String)propName);
            this.assignCfgMap.put(entityNumber + propName, isCfg);
        }
        if (!isCfg.booleanValue()) {
            return;
        }
        HashMap<Integer, String> updateRows = new HashMap<Integer, String>(e.getChangeSet().length);
        for (ChangeData changeData : e.getChangeSet()) {
            Map map;
            int rowIdx = changeData.getRowIndex();
            DynamicObject trgEntity = changeData.getDataEntity();
            if (entityNumber.equals(trgEntity.getDataEntityType().getName())) {
                trgEntity = model.getDataEntity(true);
            }
            if (!ObjectUtils.isNotEmpty((Object)(map = AssignCfgHelper.triggerByField((String)entityNumber, (DynamicObject)trgEntity, (String)propName)))) continue;
            Map rows = map;
            for (Map.Entry entry : rows.entrySet()) {
                DynamicObject dym = (DynamicObject)entry.getKey();
                String entryName = dym.getDataEntityType().getName();
                RowDataModel rowDataModel = new RowDataModel(entryName, model);
                rowDataModel.setRowContext(dym);
                model.beginInit();
                Map updateFields = (Map)entry.getValue();
                for (Map.Entry updateField : updateFields.entrySet()) {
                    rowDataModel.setValue((String)updateField.getKey(), updateField.getValue());
                }
                model.endInit();
                updateRows.put(rowIdx, entryName);
            }
        }
        for (Map.Entry entry : updateRows.entrySet()) {
            this.getView().updateView((String)entry.getValue(), ((Integer)entry.getKey()).intValue());
        }
    }

    private void changeInvType(Object newValue, int rowIndex) {
        if (this.noInvScheme()) {
            InvSchemeService service = InvSchemeServiceFactory.getService((IFormView)this.getView());
            if (newValue == null) {
                this.getModel().setValue("ownertype", null, rowIndex);
                this.getModel().setValue("keepertype", null, rowIndex);
                this.getModel().setValue("owner", null, rowIndex);
                this.getModel().setValue("keeper", null, rowIndex);
            } else {
                DynamicObject newInvType = (DynamicObject)newValue;
                DynamicObject invScheme = this.getModel().getDataEntity().getDynamicObject("invscheme");
                if (invScheme == null) {
                    return;
                }
                DynamicObjectCollection invTypeEntrys = invScheme.getDynamicObjectCollection("invtypeentry");
                if (invTypeEntrys != null && invTypeEntrys.size() > 0) {
                    for (DynamicObject invTypeEntry : invTypeEntrys) {
                        DynamicObject invType = invTypeEntry.getDynamicObject("invtype");
                        if (!newInvType.getPkValue().equals(invType.getPkValue())) continue;
                        String ownerType = invTypeEntry.getString("ownertype1");
                        String keeperType = invTypeEntry.getString("keepertype1");
                        this.getModel().setValue("ownertype", (Object)ownerType, rowIndex);
                        this.getModel().setValue("keepertype", (Object)keeperType, rowIndex);
                        break;
                    }
                }
                InvSchemeHelper.setDefaultInOwnerAndKeeper((InvSchemeService)service, (IFormView)this.getView(), (int)rowIndex);
            }
            InvSchemeHelper.setEntrySchemeInEnable((InvSchemeService)service, (int)rowIndex);
        }
    }

    private void changeOutInvType(Object newValue, int rowIndex) {
        if (this.noInvScheme()) {
            InvSchemeService service = InvSchemeServiceFactory.getService((IFormView)this.getView());
            if (newValue == null) {
                this.getModel().setValue("outownertype", null, rowIndex);
                this.getModel().setValue("outkeepertype", null, rowIndex);
                this.getModel().setValue("outowner", null, rowIndex);
                this.getModel().setValue("outkeeper", null, rowIndex);
            } else {
                DynamicObject newOutInvType = (DynamicObject)newValue;
                DynamicObject invScheme = this.getModel().getDataEntity().getDynamicObject("invscheme");
                if (invScheme == null) {
                    return;
                }
                DynamicObjectCollection outInvTypeEntrys = invScheme.getDynamicObjectCollection("outinvtypeentry");
                if (outInvTypeEntrys != null && outInvTypeEntrys.size() > 0) {
                    for (DynamicObject outInvTypeEntry : outInvTypeEntrys) {
                        DynamicObject outInvType = outInvTypeEntry.getDynamicObject("outinvtype");
                        if (!newOutInvType.getPkValue().equals(outInvType.getPkValue())) continue;
                        String outOwnerType = outInvTypeEntry.getString("outownertype1");
                        String outKeeperType = outInvTypeEntry.getString("outkeepertype1");
                        this.getModel().setValue("outownertype", (Object)outOwnerType, rowIndex);
                        this.getModel().setValue("outkeepertype", (Object)outKeeperType, rowIndex);
                        break;
                    }
                }
                InvSchemeHelper.setDefaultOutOwnerAndKeeper((InvSchemeService)service, (IFormView)this.getView(), (int)rowIndex);
            }
            InvSchemeHelper.setEntrySchemeOutEnable((InvSchemeService)service, (int)rowIndex);
        }
    }

    private boolean noInvScheme() {
        String formId = this.getModel().getDataEntityType().getName();
        return !"im_initbill".equalsIgnoreCase(formId) && !"im_locationtransfer".equalsIgnoreCase(formId);
    }

    private void changeMaterialName(Object oldValue, Object newValue, int rowIndex) {
        Object value;
        if ((newValue == null || newValue == "" || "".equalsIgnoreCase(newValue.toString().trim())) && oldValue != null && (value = this.getModel().getValue("material", rowIndex)) != null) {
            this.getModel().setValue("materialname", oldValue, rowIndex);
            this.getView().updateView("materialname", rowIndex);
        }
    }

    private void changeLot(PropertyChangedArgs e, String fieldKey, int rowIndex) {
        String entryName = "billentry";
        String lotidField = "billentry." + fieldKey;
        String lotnumberField = "lotnumber";
        LotMainFileHelper.changeLot((PropertyChangedArgs)e, (IDataModel)this.getModel(), (IFormView)this.getView(), (String)entryName, (int)rowIndex, (String)lotidField, (String)lotnumberField);
    }

    private void updateLogisticBill(String propName) {
        String formId;
        Set keySet;
        if (this.logisticsBillModel == null) {
            this.logisticsBillModel = LogisticsBillModel.getInstance();
        }
        if (!(keySet = this.logisticsBillModel.getKeySet(formId = this.getModel().getDataEntityType().getName())).isEmpty() && keySet.contains(propName)) {
            this.logisticsBillModel.matchLogisticsBill(this.getModel());
        }
    }

    private void changeProduceDate(Object oldValue, Date date, int rowIndex) {
        String calculationForEndDate;
        int shelflife;
        if (date == null) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject materialInvInfo = (DynamicObject)model.getValue("material", rowIndex);
        if (materialInvInfo == null || !materialInvInfo.getBoolean("enableshelflifemgr")) {
            return;
        }
        if (!MaterialHelper.isCalShelflife((DynamicObject)materialInvInfo, (boolean)true)) {
            Date oldExpirydate = (Date)model.getValue("expirydate", rowIndex);
            this.checkShelflifeDate(date, oldExpirydate, rowIndex, "producedate", materialInvInfo);
            return;
        }
        String shelflifeUnit = materialInvInfo.getString("shelflifeunit");
        Date expirydate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)(shelflife = materialInvInfo.getInt("shelflife")), (Date)date, (String)(calculationForEndDate = materialInvInfo.getString("calculationforenddate")));
        if (expirydate.before(date)) {
            String newExpirydateStr = this.getDateStr(expirydate);
            String newProduceDateStr = this.getDateStr(date);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u201c%2$s\u201d\u7684\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u8bf7\u4fee\u6539\u5230\u671f\u65e5\u671f\u6216\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u7684\u201c\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u201d\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImBillPropChanged_9", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            this.getView().showErrorNotification(msg);
            this.setValue("producedate", null, rowIndex, false);
            return;
        }
        Date oldExpirydate = (Date)model.getValue("expirydate", rowIndex);
        this.showExpiryDateConfirm(rowIndex, materialInvInfo, oldExpirydate, expirydate, (Date)oldValue, date);
    }

    private void changeExpiryDate(Object oldValue, Date date, int rowIndex) {
        if (date == null) {
            return;
        }
        IDataModel model = this.getModel();
        Date oldProducedate = (Date)model.getValue("producedate", rowIndex);
        DynamicObject materialInvInfo = (DynamicObject)model.getValue("material", rowIndex);
        if (materialInvInfo == null || !materialInvInfo.getBoolean("enableshelflifemgr")) {
            return;
        }
        if (!MaterialHelper.isCalShelflife((DynamicObject)materialInvInfo, (boolean)false)) {
            this.checkShelflifeDate(oldProducedate, date, rowIndex, "expirydate", materialInvInfo);
            this.showExpiryDateConfirm(rowIndex, materialInvInfo, (Date)oldValue, date, oldProducedate, oldProducedate);
            return;
        }
        String shelflifeUnit = materialInvInfo.getString("shelflifeunit");
        int shelflife = materialInvInfo.getInt("shelflife");
        String calculationForEndDate = materialInvInfo.getString("calculationforenddate");
        Date producedate = oldProducedate;
        if (!"2".equals(calculationForEndDate)) {
            producedate = ShelfLifeDateUtil.shelflifeDateCal((String)shelflifeUnit, (int)(shelflife * -1), (Date)date, (String)calculationForEndDate);
        } else if (producedate != null && date.before(producedate)) {
            Date oldExpirydate = (Date)oldValue;
            if (oldExpirydate != null && oldExpirydate.before(producedate)) {
                oldExpirydate = null;
            }
            String newExpirydateStr = this.getDateStr(date);
            String newProduceDateStr = this.getDateStr(producedate);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u7269\u6599\u201c%2$s\u201d\u7684\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u3002\u8bf7\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u4fdd\u8d28\u671f\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u548c\u4fdd\u8d28\u671f\u8bbe\u7f6e\u3002", (String)"ImBillPropChanged_99", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            this.getView().showErrorNotification(msg);
            this.setValue("expirydate", oldExpirydate, rowIndex, false);
            return;
        }
        this.showExpiryDateConfirm(rowIndex, materialInvInfo, (Date)oldValue, date, oldProducedate, producedate);
    }

    private void showExpiryDateConfirm(int rowIndex, DynamicObject materialInvInfo, Date oldExpiryDate, Date newExpiryDate, Date oldProducedate, Date newProducedate) {
        String billName = this.getModel().getDataEntityType().getName();
        String entryName = "billentry";
        boolean isOutBill = InvBillHelper.isOutEntry((String)billName, (String)entryName);
        boolean isInBill = InvBillHelper.isInEntry((String)billName, (String)entryName);
        String leadTimeUnit = materialInvInfo.getString("leadtimeunit");
        int dateOfOverdueForIn = materialInvInfo.getInt("dateofoverdueforin");
        int dateOfOverdueForOut = materialInvInfo.getInt("dateofoverdueforout");
        int dateOfOverdue = 0;
        if (isOutBill && isInBill) {
            dateOfOverdue = dateOfOverdueForOut > dateOfOverdueForIn ? dateOfOverdueForOut : dateOfOverdueForIn;
        } else if (isOutBill) {
            dateOfOverdue = dateOfOverdueForOut;
        } else if (isInBill) {
            dateOfOverdue = dateOfOverdueForIn;
        }
        Date overdueDate = ShelfLifeDateUtil.getDateOfOverdue((String)leadTimeUnit, (int)dateOfOverdue, (Date)newExpiryDate);
        Date nowDate = new Date();
        boolean dateOver = nowDate.after(overdueDate);
        ArrayList alertMsgList = new ArrayList(2);
        if (dateOver) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            String newExpirydateStr = this.getDateStr(newExpiryDate);
            String oldExpirydateStr = this.getDateStr(oldExpiryDate);
            String newProducedateStr = this.getDateStr(newProducedate);
            String oldProducedateStr = this.getDateStr(oldProducedate);
            params.put("newProduceDate", newProducedateStr);
            params.put("oldProduceDate", oldProducedateStr);
            params.put("newExpiryDate", newExpirydateStr);
            params.put("oldExpiryDate", oldExpirydateStr);
            params.put("index", rowIndex);
            alertMsgList.add(params);
            ConfirmCallBackListener cb = new ConfirmCallBackListener("MaterialLifeDate", this.plugin);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7684\u7269\u6599\u201c%2$s\u201d\u5230\u671f\u65e5\u671f\u4e3a\u201c%3$s\u201d,\u5373\u5c06\u8fc7\u671f\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\uff0c\u662f\u5426\u5141\u8bb8\u5f55\u5165\uff1f", (String)"ImBillPropChanged_7", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr);
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(alertMsgList));
        } else {
            this.setValue("producedate", newProducedate, rowIndex, false);
            this.setValue("expirydate", newExpiryDate, rowIndex, false);
        }
    }

    private String getDateStr(Date date) {
        String dateStr = null;
        if (date == null) {
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        dateStr = sd.format(date);
        return dateStr;
    }

    private void update2Version(DynamicObject materialInvInfo, int rowIndex) {
        try {
            IDataModel model = this.getModel();
            String versionIdStr = (String)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataService", (String)"getVersionByMaterial", (Object[])new Object[]{materialInvInfo.getLong("masterid_id")});
            Long versionId = null;
            if (StringUtils.isNotBlank((CharSequence)versionIdStr) && !"0".equals(versionIdStr)) {
                versionId = Long.valueOf(versionIdStr);
            }
            model.beginInit();
            model.setValue("mversion", (Object)versionId, rowIndex);
            model.endInit();
            this.getView().updateView("mversion", rowIndex);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7269\u6599\u7248\u672c\u201c\u67e5\u8be2\u670d\u52a1\u201d\u51fa\u9519\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"ImBillPropChanged_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
    }

    protected String getControlDisplayName(String key) {
        FieldEdit bizOrgEdit = (FieldEdit)this.getView().getControl(key);
        IDataEntityProperty orgProp = bizOrgEdit.getProperty();
        LocaleString displayName = orgProp.getDisplayName();
        return displayName.toString();
    }

    private boolean isChanged(PropertyChangedArgs e) {
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        if (newValue instanceof DynamicObject && oldValue instanceof DynamicObject && newValue != null && oldValue != null && ((DynamicObject)newValue).getPkValue().equals(((DynamicObject)oldValue).getPkValue())) {
            return false;
        }
        return !(newValue instanceof BigDecimal) || !(oldValue instanceof BigDecimal) || newValue == null || oldValue == null || ((BigDecimal)newValue).compareTo((BigDecimal)oldValue) != 0;
    }

    private void changeMaterial(DynamicObject materialInvInfo, int rowIndex, int selectedRow) {
        IDataModel bill = this.getModel();
        if (materialInvInfo != null && "2".equals(materialInvInfo.get("masterid.configproperties"))) {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"configuredcode"});
        } else {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"configuredcode"});
        }
        this.clearMaterialInfo(bill, rowIndex);
        if (materialInvInfo != null) {
            this.resetMaterialInfo(bill, materialInvInfo, rowIndex, selectedRow);
        }
    }

    private void clearMaterialInfo(IDataModel bill, int rowIndex) {
        String formId = this.getModel().getDataEntityType().getName();
        bill.beginInit();
        for (String key : clearFields) {
            bill.setValue(key, null, rowIndex);
        }
        bill.endInit();
        for (String key : clearFields) {
            this.getView().updateView(key, rowIndex);
        }
        if (!formId.equals("im_initbill")) {
            bill.setValue("materialname", null, rowIndex);
            this.getView().updateView("materialname", rowIndex);
        }
    }

    private void resetMaterialInfo(IDataModel bill, DynamicObject materialInvInfo, int rowIndex, int selectedRow) {
        DynamicObject material = null;
        material = materialInvInfo.getDynamicObject("masterid");
        if (material == null) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MATERIAL(), (Object[])new Object[0]));
        }
        String formId = this.getModel().getDataEntityType().getName();
        if (!formId.equals("im_initbill")) {
            boolean isdisposable = material.getBoolean("isdisposable");
            this.getModel().beginInit();
            String materialName = material.getString("name");
            if (isdisposable) {
                bill.setValue("materialname", (Object)materialName, rowIndex);
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"materialname"});
            } else {
                bill.setValue("materialname", (Object)materialName, rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"materialname"});
            }
            this.getView().updateView("materialname", rowIndex);
            if (selectedRow != -1) {
                bill.setValue("linetype", bill.getValue("linetype", selectedRow), rowIndex);
                this.getView().updateView("linetype", rowIndex);
            }
            this.getModel().endInit();
        }
        this.resetMaterialUnits(bill, materialInvInfo, material, rowIndex);
        Boolean isuseauxpty = material.getBoolean("isuseauxpty");
        this.getView().setEnable(isuseauxpty, rowIndex, new String[]{"auxpty"});
        bill.setValue("lotnumber", null, rowIndex);
        bill.setValue("lot", null, rowIndex);
        Boolean enablelot = materialInvInfo.getBoolean("enablelot");
        this.getView().setEnable(enablelot, rowIndex, new String[]{"lotnumber"});
        this.getView().setEnable(enablelot, rowIndex, new String[]{"lot"});
        boolean isOnShelf = materialInvInfo.getBoolean("enableshelflifemgr");
        this.getView().setEnable(Boolean.valueOf(isOnShelf), rowIndex, new String[]{"producedate"});
        this.getView().setEnable(Boolean.valueOf(isOnShelf), rowIndex, new String[]{"expirydate"});
        long srcbillid = 0L;
        if (!formId.equals("im_locationtransfer")) {
            srcbillid = (Long)bill.getValue("srcbillid", rowIndex);
        }
        boolean enableSerialNum = SerialNumberHelper.isEnableSerial((DynamicObject)materialInvInfo) && srcbillid == 0L;
        this.getView().setEnable(Boolean.valueOf(enableSerialNum), rowIndex, new String[]{"serialnumber"});
        boolean isVersionManage = material.getBoolean("isenablematerialversion");
        if (isVersionManage) {
            this.update2Version(materialInvInfo, rowIndex);
        }
        boolean isEnableShelfLife = materialInvInfo.getBoolean("enableshelflifemgr");
        this.view.setEnable(Boolean.valueOf(isEnableShelfLife), rowIndex, new String[]{"producedate"});
        this.view.setEnable(Boolean.valueOf(isEnableShelfLife), rowIndex, new String[]{"expirydate"});
    }

    private void resetMaterialUnits(IDataModel bill, DynamicObject materialInvInfo, DynamicObject material, int rowIndex) {
        bill.setValue("materialmasterid", (Object)material, rowIndex);
        DynamicObject baseUnit = material.getDynamicObject("baseunit");
        if (baseUnit == null) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MATERIAL_BASEUNIT(), (Object[])new Object[0]));
        }
        Object auxptyUnitId = null;
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        Boolean isUseAuxptyUnit = auxptyUnit != null;
        if (isUseAuxptyUnit.booleanValue()) {
            auxptyUnitId = auxptyUnit.getPkValue();
        }
        this.getView().setEnable(isUseAuxptyUnit, rowIndex, new String[]{"qtyunit2nd"});
        DynamicObject unit = materialInvInfo.getDynamicObject("inventoryunit");
        if (unit == null) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MATERIAL_BASEUNIT(), (Object[])new Object[0]));
        }
        this.setValue("unit", unit.getPkValue(), rowIndex, false);
        this.setValue("baseunit", baseUnit.getPkValue(), rowIndex, false);
        this.setValue("unit2nd", auxptyUnitId, rowIndex, false);
    }

    private void changeQtyOrUnit(String propName, Object newValue, int rowIndex) {
        DynamicObject bizType;
        if ("unit".equals(propName)) {
            this.view.setEnable(Boolean.valueOf(newValue != null), rowIndex, new String[]{"qty"});
        }
        IDataModel bill = this.getModel();
        String formId = this.getModel().getDataEntityType().getName();
        if (!"im_initbill".equals(formId) && (bizType = (DynamicObject)bill.getValue("biztype")) != null && ("370".equals(bizType.get("number")) || "380".equals(bizType.get("number")))) {
            return;
        }
        Object material = bill.getValue("material", rowIndex);
        Object masterMaterial = bill.getValue("materialmasterid", rowIndex);
        if (material == null && masterMaterial == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u4fe1\u606f\u3002", (String)"BillBizQtyPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        BillUnitAndQtytHelper.setBizQtyAndUnit((IDataModel)bill, (int)rowIndex, (String)propName, (Object)newValue);
        IPageCache pageCache = ((AbstractFormPlugin)this.plugin).getPageCache();
        AuxQtyAndUnitHelper.setAuxBizQtyAndUnit((IPageCache)pageCache, (IDataModel)bill, (int)rowIndex, (String)propName, (Object)newValue);
        this.getView().updateView("qty", rowIndex);
        this.getView().updateView("baseqty", rowIndex);
        this.getView().updateView("qtyunit2nd", rowIndex);
    }

    private void changeLotNumber(Object oldValue, Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        this.setValue("lot", null, rowIndex, false);
        this.setLifeDateByLotNumber(rowIndex, (String)newValue, model);
    }

    private void setLifeDateByLotNumber(int rowIndex, String lotNumber, IDataModel model) {
        DynamicObject org = (DynamicObject)model.getValue("org");
        DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
        if (org == null || material == null) {
            return;
        }
        if (!material.getBoolean("enableshelflifemgr")) {
            return;
        }
        ArrayList<Object> orgIds = new ArrayList<Object>(1);
        ArrayList<Object> materialIds = new ArrayList<Object>(1);
        ArrayList<String> lotNumbers = new ArrayList<String>(1);
        orgIds.add(org.getPkValue());
        materialIds.add(material.getPkValue());
        lotNumbers.add(lotNumber);
        Map lotIntrackMap = ImLotHelper.getLotIntrackMap(orgIds, materialIds, lotNumbers);
        String key = org.getPkValue() + "_" + material.getPkValue() + "_" + lotNumber;
        DynamicObject lotinTrack = (DynamicObject)lotIntrackMap.get(key);
        if (lotinTrack != null) {
            Date producedate = lotinTrack.getDate("producedate");
            Date oldProducedate = (Date)model.getValue("producedate", rowIndex);
            Date expirydate = lotinTrack.getDate("expirydate");
            Date oldExpirydate = (Date)model.getValue("expirydate", rowIndex);
            if (expirydate == null) {
                this.setValue("producedate", producedate, rowIndex, false);
                this.setValue("expirydate", expirydate, rowIndex, false);
            } else {
                if (oldExpirydate != null && expirydate.compareTo(oldExpirydate) == 0) {
                    return;
                }
                DynamicObject materialInvInfo = (DynamicObject)model.getValue("material", rowIndex);
                this.showExpiryDateConfirm(rowIndex, materialInvInfo, oldExpirydate, expirydate, oldProducedate, producedate);
            }
        }
    }

    private void changeOrg(Object newValue) {
        Map customParas = this.getView().getFormShowParameter().getCustomParams();
        if (customParas != null && customParas.get("sourceformid") != null && customParas.get("orgViewType") != null) {
            this.getModel().setValue("dept", null);
            this.getModel().setValue("operatorgroup", null);
            this.getModel().setValue("operator", null);
        }
    }

    private void changeDept(Object newValue) {
    }

    private void changeOperatorOrOutOperator(DynamicObject operator, String propName) {
        IDataModel model = this.getModel();
        if (operator == null) {
            if (propName.equalsIgnoreCase("operator")) {
                model.setValue("operatorgroup", null);
                model.setValue("dept", null);
            } else if (propName.equalsIgnoreCase("bizoperator")) {
                model.setValue("bizoperatorgroup", null);
                model.setValue("bizdept", null);
            } else {
                model.setValue("outoperatorgroup", null);
                model.setValue("outdept", null);
            }
            if (this.getView().getControl("operatorphone") != null) {
                ((Label)this.getView().getControl("operatorphone")).setText(null);
            }
        } else {
            operator = BusinessDataServiceHelper.loadSingleFromCache((Object)operator.getPkValue(), (String)"bd_operator");
            if (propName.equalsIgnoreCase("operator")) {
                model.setValue("operatorgroup", operator.get("operatorgrpid"));
            } else if (propName.equalsIgnoreCase("bizoperator")) {
                model.setValue("bizoperatorgroup", operator.get("operatorgrpid"));
            } else {
                model.setValue("outoperatorgroup", operator.get("operatorgrpid"));
            }
            DynamicObject org = this.getOrgDyc(propName);
            List deptids = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)((Long)org.getPkValue()), (boolean)false);
            String deptField = "dept";
            String fromID = model.getDataEntityType().getName();
            if ("im_transdirbill".equals(fromID) && "outoperator".equalsIgnoreCase(propName)) {
                deptField = "outdept";
            }
            if (deptids != null && deptids.size() > 0) {
                List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)operator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
                if (userdeptIds != null && userdeptIds.size() > 0) {
                    for (Long deptId : userdeptIds) {
                        if (!deptids.contains(deptId)) continue;
                        this.getModel().setValue(deptField, (Object)deptId);
                        break;
                    }
                }
            } else {
                List userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)operator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
                if (userdeptIds != null && userdeptIds.size() > 0) {
                    this.getModel().setValue(deptField, userdeptIds.get(0));
                }
            }
            if (this.getView().getControl("operatorphone") != null) {
                ((Label)this.getView().getControl("operatorphone")).setText((String)operator.getDynamicObject("operatorid").get("phone"));
            }
        }
    }

    private void changeOperatorGroup(DynamicObject operatorGroup) {
        if (operatorGroup == null) {
            this.getModel().setValue("operator", null);
        }
    }

    private void changeOutOperatorGroup(DynamicObject operatorGroup) {
        if (operatorGroup == null) {
            this.getModel().setValue("outoperator", null);
        }
    }

    private void changeInvScheme(Object newValue) {
        if (newValue == null) {
            this.clearOwnerAndKeeperInfo();
            return;
        }
        String[] needInverseColumns = this.getNeedInverseColumns();
        if (needInverseColumns != null && needInverseColumns.length > 0) {
            InverseBillHelper.setNegativeColumnColor((IFormView)this.view, (String[])needInverseColumns);
        }
        this.handleMatchingRuleEnable();
        IDataModel bill = this.view.getModel();
        DynamicObject scheme = (DynamicObject)bill.getValue("invscheme");
        if (scheme == null) {
            return;
        }
        DynamicObject invScheme = null;
        if (scheme != null && scheme.getPkValue() != null) {
            invScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)scheme.getPkValue(), (String)"im_invscheme");
        }
        if (invScheme == null) {
            return;
        }
        boolean isInUpdate = invScheme.getBoolean("isinupdate");
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        int size = bill.getEntryRowCount("billentry");
        int[] rows = new int[size];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = i;
        }
        InvSchemeService invSchemeservice = InvSchemeServiceFactory.getService((IFormView)this.view);
        InvSchemeHelper.initEntrysValue((IFormView)this.view, (DynamicObject)invScheme, (int[])rows);
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            InvSchemeHelper.setDefalutOwnerAndKeeeper((InvSchemeService)invSchemeservice, (IFormView)this.view, (int)rowIndex);
        }
        InvSchemeHelper.setViewByUpdate((IFormView)this.view, (boolean)isInUpdate, (boolean)isOutUpdate);
        for (int i = 0; i < size; ++i) {
            InvSchemeHelper.setEntrySchemeEnable((InvSchemeService)invSchemeservice, (IFormView)this.view, (int)i);
        }
    }

    private String[] getNeedInverseColumns() {
        String billEntity = this.view.getModel().getDataEntity().getDataEntityType().getName();
        String[] needInverseColumns = InverseBillHelper.getNeedInverseColumns((String)billEntity);
        return needInverseColumns;
    }

    private void clearOwnerAndKeeperInfo() {
        IDataModel bill = this.getModel();
        int size = bill.getEntryEntity("billentry").size();
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            this.setValue("owner", null, rowIndex, false);
            this.setValue("keeper", null, rowIndex, false);
            this.setValue("ownertype", null, rowIndex, false);
            this.setValue("keepertype", null, rowIndex, false);
            this.setValue("invstatus", null, rowIndex, false);
            this.setValue("invtype", null, rowIndex, false);
            this.setValue("outowner", null, rowIndex, false);
            this.setValue("outkeeper", null, rowIndex, false);
            this.setValue("outownertype", null, rowIndex, false);
            this.setValue("outkeepertype", null, rowIndex, false);
            this.setValue("outinvstatus", null, rowIndex, false);
            this.setValue("outinvtype", null, rowIndex, false);
        }
    }

    private void bizDateChange(Date bizDate) {
        if (bizDate == null) {
            return;
        }
        String formId = this.getModel().getDataEntityType().getName();
        boolean includeInitBizBill = MetaDataHelper.isExistField((IDataEntityType)EntityMetadataCache.getDataEntityType((String)formId), (String)"isinitbill");
        if ("im_initbill".equals(formId) || includeInitBizBill && ((Boolean)this.getModel().getValue("isinitbill")).booleanValue()) {
            this.getModel().setValue("bookdate", (Object)bizDate);
            return;
        }
        DynamicObject org = this.getOrgDyc(null);
        TimeZone orgZone = this.getOrgZone(org);
        if (orgZone == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u201c\u7ec4\u7ec7\u65f6\u533a\u201d\u548c\u201c\u7cfb\u7edf\u65f6\u533a\u201d\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImBillPropChanged_5", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        Date now = new Date();
        int fallowDays = 0;
        int differDays = 0;
        boolean before = false;
        if (now.before(bizDate)) {
            Object beforeDays = AppParameterHelper.getAppParameter((String)"=9Q86DR2P+Q", (String)"05", (Long)((Long)org.getPkValue()), (String)"fallowbeforedays");
            differDays = DaysCalcHelper.differentDays((Date)bizDate, (Date)now, (ZoneId)orgZone.toZoneId());
            differDays = Math.abs(differDays);
            fallowDays = Integer.parseInt(beforeDays == null ? "0" : beforeDays.toString());
            before = true;
        } else if (now.after(bizDate)) {
            Object afterDays = AppParameterHelper.getAppParameter((String)"=9Q86DR2P+Q", (String)"05", (Long)((Long)org.getPkValue()), (String)"fallowafterdays");
            differDays = DaysCalcHelper.differentDays((Date)bizDate, (Date)now, (ZoneId)orgZone.toZoneId());
            differDays = Math.abs(differDays);
            fallowDays = Integer.parseInt(afterDays == null ? "0" : afterDays.toString());
        }
        if (differDays > fallowDays) {
            LocaleString bizTimeName = this.getModel().getDataEntityType().findProperty("biztime").getDisplayName();
            String tip = before ? ResManager.loadKDString((String)"\u5141\u8bb8\u63d0\u524d\u5f55\u5355\u671f\u9650", (String)"ImBillPropChanged_16", (String)"scmc-im-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5141\u8bb8\u4e8b\u540e\u8865\u5f55\u671f\u9650", (String)"ImBillPropChanged_17", (String)"scmc-im-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(IMStringUtils.append((String)bizTimeName.getLocaleValue(), (Object[])new Object[]{String.format(ResManager.loadKDString((String)"\u8d85\u51fa%s\uff0c\u5982\u4ecd\u9700\u63d0\u4ea4\u5355\u636e\uff0c\u8bf7\u5230\u7cfb\u7edf\u53c2\u6570\u4e2d\u4fee\u6539\u76f8\u5173\u8bbe\u7f6e\u3002", (String)"ImBillPropChanged_6", (String)"scmc-im-formplugin", (Object[])new Object[0]), tip)}));
            return;
        }
        this.changeBookDate(bizDate);
    }

    private void changeBookDate(Date bizDate) {
        Date closeDate;
        Date addDate;
        DynamicObject bill;
        Map closeDateMap;
        String formId = this.getModel().getDataEntityType().getName();
        Date bookDate = bizDate;
        if (!SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"INV0004") && null != (closeDateMap = CloseDateHelper.getCloseDateMap((String)formId, (DynamicObject)(bill = this.getModel().getDataEntity(true)))) && bizDate.before(addDate = DateUtils.addOneDay((Date)(closeDate = (Date)closeDateMap.get("closeDate"))))) {
            bookDate = addDate;
        }
        this.getModel().setValue("bookdate", (Object)bookDate);
    }

    protected TimeZone getOrgZone(DynamicObject org) {
        TimeZone timeZone = null;
        DynamicObject timezone = org.getDynamicObject("timezone");
        if (timezone == null) {
            timeZone = this.getSysTimezone();
        } else {
            String timeArea = timezone.getString("number");
            timeZone = TimeZone.getTimeZone(timeArea);
        }
        return timeZone;
    }

    protected TimeZone getSysTimezone() {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        DynamicObject sysTimezoneMeta = service.getSysTimezone();
        String timeArea = sysTimezoneMeta.getString("number");
        return TimeZone.getTimeZone(timeArea);
    }

    private void changeWarehouse(ChangeData[] valueSet) {
        for (int i = 0; i < valueSet.length; ++i) {
            Object oldValue;
            Object newValue = valueSet[i].getNewValue();
            if (newValue == (oldValue = valueSet[i].getOldValue())) continue;
            int rowIndex = valueSet[i].getRowIndex();
            this.setValue("location", null, rowIndex, false);
            if (newValue != null) {
                boolean isOpenLocation = ((DynamicObject)newValue).getBoolean("isopenlocation");
                if (isOpenLocation) {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"location"});
                    continue;
                }
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"location"});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"location"});
        }
    }

    private void changeBizType(Object newValue, Object oldValue) {
        this.showBizTypeChangeConfirm(oldValue);
    }

    private void showBizTypeChangeConfirm(Object oldValue) {
        IDataModel model = this.getModel();
        DynamicObject bizType = (DynamicObject)model.getValue("biztype");
        DynamicObject oldBizType = oldValue == null ? null : (DynamicObject)oldValue;
        int entryRowCount = model.getEntryRowCount("billentry");
        String formId = this.getModel().getDataEntityType().getName();
        HashMap<Object, Object> confirmInfo = new HashMap<Object, Object>(4);
        ArrayList<Integer> clearEntryIndexList = new ArrayList<Integer>(entryRowCount);
        for (int i = 0; i < entryRowCount; ++i) {
            clearEntryIndexList.add(i);
        }
        confirmInfo.put("clearEntryIndexList", clearEntryIndexList);
        confirmInfo.put("oldBizTypeId", oldBizType == null ? null : oldBizType.getPkValue());
        confirmInfo.put("newBizTypeId", bizType == null ? null : bizType.getPkValue());
        if (formId.equals("im_materialreqoutbill") || formId.equals("im_purinbill") || formId.equals("im_purreceivebill")) {
            this.validateClearInfo(confirmInfo);
        }
        ConfirmCallBackListener cb = new ConfirmCallBackListener("clearSupplierOrEntry", this.plugin);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u4e1a\u52a1\u7c7b\u578b\u5c06\u6e05\u9664\u5f53\u524d\u5355\u636e\u5206\u5f55\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"ImBillPropChanged_14", (String)"scmc-im-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(confirmInfo));
    }

    private void validateClearInfo(Map<Object, Object> confirmInfo) {
        DynamicObject supplier;
        confirmInfo.put("clearSupplier", false);
        String formId = this.getModel().getDataEntityType().getName();
        if (formId.equals("im_materialreqoutbill")) {
            boolean clearSupplier = this.checkIfClearSupplier();
            confirmInfo.put("clearSupplier", clearSupplier);
        } else if ((formId.equals("im_purinbill") || formId.equals("im_purreceivebill")) && (supplier = (DynamicObject)this.getModel().getValue("supplier")) != null) {
            boolean clearSupplier = !supplier.getBoolean("enablevmi");
            confirmInfo.put("clearSupplier", clearSupplier);
        }
    }

    private void changeLineType(Object oldValue, Object newValue, int rowIndex) {
        if (newValue == null && oldValue != null) {
            this.getModel().setValue("linetype", oldValue, rowIndex);
            return;
        }
        if (oldValue == null && newValue != null) {
            this.getModel().setValue("linetype", newValue, rowIndex);
            return;
        }
        DynamicObject oldLineType = oldValue == null ? null : (DynamicObject)oldValue;
        HashMap<String, Object> confirmInfo = new HashMap<String, Object>(4);
        confirmInfo.put("oldLineTypeId", oldLineType == null ? null : oldLineType.getPkValue());
        confirmInfo.put("rowIndex", rowIndex);
        ConfirmCallBackListener cb = new ConfirmCallBackListener("clearMaterial", this.plugin);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u884c\u7c7b\u578b\u5c06\u6e05\u9664\u5f53\u524d\u5206\u5f55\u7684\u7269\u6599\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"ImBillPropChanged_15", (String)"scmc-im-formplugin", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, cb, null, SerializationUtils.toJsonString(confirmInfo));
    }

    private void handleMatchingRuleEnable() {
        boolean enable = true;
        if (InverseBillHelper.isNegativeBill((IDataModel)this.getModel())) {
            enable = false;
        }
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{"matchingruleout"});
    }

    private boolean checkIfClearSupplier() {
        IDataModel model = this.getModel();
        boolean clearSupplier = false;
        DynamicObject supplier = (DynamicObject)model.getValue("supplyowner");
        String supplyownerType = (String)model.getValue("supplyownertype");
        if (supplier != null && "bd_supplier".equals(supplyownerType)) {
            clearSupplier = !(supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)supplier.getPkValue(), (String)"bd_supplier", (String)"id,enablevmi")).getBoolean("enablevmi");
        }
        return clearSupplier;
    }

    private void changeBillType(DynamicObject newBillType, DynamicObject oldBillType) {
        if (newBillType == null) {
            this.getModel().beginInit();
            this.getModel().setValue("billtype", (Object)oldBillType);
            this.getModel().endInit();
            return;
        }
        String formId = this.view.getModel().getDataEntityType().getName();
        DynamicObject bizType = null;
        if (formId.equals("im_initbill")) {
            List bizTypes = BizTypeHelper.getBizTypeByEntityID((String)formId);
            if (!bizTypes.isEmpty() && (bizType = BizTypeHelper.getBillType((String)formId, (List)bizTypes, (DynamicObject)newBillType)) != null) {
                this.setValue("biztype", bizType.getPkValue(), false);
            }
        } else {
            bizType = BizTypeHelper.getBizTypeByBillType((String)formId, (DynamicObject)newBillType);
            if (bizType != null) {
                this.setValue("biztype", bizType.getLong("id"), false);
            }
        }
    }

    private IDataModel getModel() {
        return this.getView().getModel();
    }

    private IFormView getView() {
        return this.view;
    }

    public void setValue(String key, Object value, boolean isTriggerChangeEvent) {
        DataChangeHelper.setValue((IDataModel)this.getModel(), (String)key, (Object)value, (boolean)isTriggerChangeEvent);
    }

    public void setValue(String key, Object value, int i, boolean isTriggerChangeEvent) {
        DataChangeHelper.setValue((IDataModel)this.getModel(), (String)key, (Object)value, (int)i, (boolean)isTriggerChangeEvent);
    }

    private DynamicObject getOrgDyc(String propName) {
        DynamicObject org = null;
        String fromID = this.getModel().getDataEntityType().getName();
        org = "im_transdirbill".equals(fromID) && "outoperator".equalsIgnoreCase(propName) ? (DynamicObject)this.getModel().getValue("outorg") : (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u3002", (String)"ImBillPropChanged_8", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        return org;
    }

    private void relSpace(int row, String field) {
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("billentry", row);
        String fieldValue = dynamicObject.getString(field);
        if (fieldValue != null) {
            fieldValue = fieldValue.replaceAll("\u3000", " ").trim();
            this.setValue(field, fieldValue, row, false);
        }
    }

    private void checkShelflifeDate(Date produceDate, Date expirydate, int rowIndex, String key, DynamicObject materialInvInfo) {
        if (expirydate != null && produceDate != null && expirydate.before(produceDate)) {
            String newExpirydateStr = this.getDateStr(expirydate);
            String newProduceDateStr = this.getDateStr(produceDate);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u201c%2$s\u201d\u7684\u5230\u671f\u65e5\u671f\u201c%3$s\u201d\u5c0f\u4e8e\u751f\u4ea7\u65e5\u671f\u201c%4$s\u201d\uff0c\u8bf7\u4fee\u6539\u5230\u671f\u65e5\u671f\u6216\u786e\u8ba4\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u7684\u201c\u5230\u671f\u65e5\u8ba1\u7b97\u65b9\u5f0f\u201d\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImBillPropChanged_9", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1, materialInvInfo.get("masterid.name"), newExpirydateStr, newProduceDateStr);
            this.getView().showErrorNotification(msg);
            this.setValue(key, null, rowIndex, false);
        }
    }
}

