/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.acc.balance;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.sbd.enums.AuxPtyValueTypeEnum;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.FormatFieldData;
import kd.bos.entity.list.FormatRowData;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.plugin.operation.IQueryMaterialFilterPlugin;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.list.ListColumnAp;
import kd.bos.metadata.list.ListGridViewAp;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.bos.util.JSONUtils;
import kd.scmc.im.business.helper.AuxptyFilterHelper;
import kd.scmc.im.business.helper.BillViewHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.business.helper.SupplyChainParameterHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.business.helper.datactrl.DataCtrlSchemeResultHandle;
import kd.scmc.im.business.helper.datactrl.InvBizDataCtrlHelper;
import kd.scmc.im.business.helper.datactrl.WarehouseIsolateResultHandle;
import kd.scmc.im.business.helper.invquery.DefaultInvQueryExpand;
import kd.scmc.im.consts.InvAccConst;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.DateUtils;
import kd.scmc.im.utils.FormUtils;
import kd.scmc.im.utils.IMStringUtils;
import kd.scmc.sbs.business.reservation.ReserveHelper;
import kd.sdk.scmc.im.extpoint.IInvQueryExpand;

public class QueryMaterialInvAccPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
ListRowClickListener,
SelectRowsEventListener {
    private final String IMAPP_ID = "=9Q86DR2P+Q";
    protected static final List<String> AUXPTYPROPERTYLIST = Arrays.asList("auxproperty", "auxdetailbasebd", "auxdetailbasebdid", "auxdetailbd", "auxdetailtxt");
    protected static final List<String> QTYLIST = Arrays.asList("avbqty_h", "qty_h", "baseqty_h", "lockbaseqty_h", "avbbaseqty_h", "lockqty_h", "qty2nd_h", "lockqty2nd_h", "avbqty2nd_h");
    protected static final List<String> MULTI_VALUE_FIELDS = Arrays.asList("material_h", "invtype_h", "invstatus_h");
    private static Log logger = LogFactory.getLog(QueryMaterialInvAccPlugin.class);
    private static Integer MAX_SIZE = 2000;

    public void initialize() {
        super.initialize();
        this.addExecutionListDataProvider();
        String balTb = InvAccConst.getBalTb();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setBillFormId(balTb);
    }

    private List<Map<String, String>> getColumnsFromCache() {
        IPageCache pageCache = this.getPageCache();
        if (pageCache != null) {
            String lisColumns = pageCache.get("listcolumns");
            if (StringUtils.isEmpty((CharSequence)lisColumns)) {
                pageCache.put("listcolumns", SerializationUtils.toJsonString(this.getListColumns()));
            }
            return (List)SerializationUtils.fromJsonString((String)pageCache.get("listcolumns"), List.class);
        }
        return this.getListColumns();
    }

    private List<Map<String, String>> getListColumns() {
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)"im_materialinvacc", (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        ListGridViewAp billList = (ListGridViewAp)formMeta.getItem("KniUYz0J8g");
        List items = billList.getItems();
        ArrayList<Map<String, String>> columns = new ArrayList<Map<String, String>>();
        for (ControlAp item : items) {
            if (!(item instanceof ListColumnAp)) continue;
            ListColumnAp listColumnAp = (ListColumnAp)item;
            HashMap<String, String> columnInfo = new HashMap<String, String>();
            columnInfo.put("key", listColumnAp.getListFieldId());
            columnInfo.put("name", listColumnAp.getName().getLocaleValue());
            columns.add(columnInfo);
        }
        return columns;
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        String formid = showParameter.getFormId();
        if ("ide_formdesigner".equals(showParameter.getParentFormId())) {
            e.setCancel(true);
            e.setCancelMessage(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getIDEDESIGNER_OPEN_INVACCQUERY()));
            return;
        }
        List permissionOrgs = NewInvOrgHelper.getPermissionOrgsByAppId((String)formid, (String)showParameter.getAppId());
        if (permissionOrgs.isEmpty()) {
            e.setCancel(true);
            e.setCancelMessage(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_USE_INVORG()));
            return;
        }
        List orgs = NewInvOrgHelper.getHasPermissionAndStartedInvOrg((List)permissionOrgs);
        if (orgs == null || orgs.isEmpty()) {
            e.setCancel(true);
            e.setCancelMessage(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ENABLED_INV()));
            return;
        }
        ArrayList<Long> idList = new ArrayList<Long>(orgs.size());
        for (Map org : orgs) {
            Long orgId = Long.valueOf((String)org.get("id"));
            idList.add(orgId);
        }
        showParameter.getCustomParams().put("HasPermissionAndStartedInvOrg", SerializationUtils.toJsonString(idList));
    }

    public void registerListener(EventObject e) {
        BasedataEdit keeper;
        BasedataEdit owner;
        BasedataEdit unit;
        BasedataEdit locationEdit;
        BasedataEdit warehouseEdit;
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnquery", "btnok", "auxdetailbasebd", "lotnum_h", "auxdetailtxt"});
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"auxproperty", "auxdetailbd"});
        OrgEdit orgEdit = (OrgEdit)this.getView().getControl("org_h");
        if (orgEdit != null) {
            orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((warehouseEdit = (BasedataEdit)this.getView().getControl("warehouse_h")) != null) {
            warehouseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((locationEdit = (BasedataEdit)this.getView().getControl("location_h")) != null) {
            locationEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((unit = (BasedataEdit)this.getView().getControl("unit_h")) != null) {
            unit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((owner = (BasedataEdit)this.getView().getControl("owner_h")) != null) {
            owner.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((keeper = (BasedataEdit)this.getView().getControl("keeper_h")) != null) {
            keeper.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addListRowClickListener((ListRowClickListener)this);
        billList.addListRowSelectAllListeners(evt -> this.buildSelectEntryData());
        billList.addClearSelectionListener(evt -> {
            if (RequestContext.get().getQueryString().contains("clearSelection")) {
                this.buildSelectEntryData();
            } else {
                this.getPageCache().put("preselectrows", SerializationUtils.toJsonString(new HashSet()));
            }
        });
        billList.addItemClickListener((ItemClickListener)this);
        String lastQFilterStr = this.getPageCache().get("lastQFilter");
        if (lastQFilterStr != null && !lastQFilterStr.isEmpty()) {
            QFilter lastQFilter = QFilter.fromSerializedString((String)lastQFilterStr);
            billList.getFilterParameter().setQFilters(Collections.singletonList(lastQFilter));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    private void lotHClick() {
        FormShowParameter parameter = new FormShowParameter();
        Object lotValue = this.getModel().getValue("lotnum_h");
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCustomParam("params", lotValue);
        parameter.setCustomParam("maxlength", (Object)2000);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("im_multitext");
        parameter.setCaption(ResManager.loadKDString((String)"\u6279\u53f7", (String)"QueryMaterialInvAccPlugin_7", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "lotnum_h"));
        this.getView().showForm(parameter);
    }

    private void auxDetailTxtClick() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("auxentry");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObject value = (DynamicObject)this.getModel().getValue("auxproperty", selectRows[0]);
        String valueType = value.getString("valuetype");
        if (valueType == null || StringUtils.isEmpty((CharSequence)valueType) || !AuxPtyValueTypeEnum.BYHANDINPUT.getValue().equals(valueType)) {
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        Object auxDetailValue = this.getModel().getValue("auxdetailtxt", selectRows[0]);
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setCaption(ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027\u503c", (String)"QueryMaterialInvAccPlugin_6", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        parameter.setCustomParam("params", auxDetailValue);
        parameter.setCustomParam("maxlength", (Object)2000);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("im_multitext");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "auxdetailtxt"));
        this.getView().showForm(parameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        IDataModel bill = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "org_h": {
                String pkSet = (String)this.getView().getFormShowParameter().getCustomParams().get("HasPermissionAndStartedInvOrg");
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)pkSet, List.class)));
                break;
            }
            case "location_h": {
                this.setLocationFilter(e, bill, showParameter);
                break;
            }
            case "warehouse_h": {
                this.setWarehouseFilter(e, showParameter);
                break;
            }
            case "owner_h": {
                this.setOwnerFilter(e, bill, showParameter);
                break;
            }
            case "keeper_h": {
                this.setKeeperFilter(e, bill, showParameter);
                break;
            }
            case "unit_h": {
                this.setUnitFilter(bill, showParameter);
                break;
            }
            case "auxproperty": {
                AuxptyFilterHelper.beforeAuxProperty((ListShowParameter)showParameter);
                break;
            }
            case "auxdetailbd": {
                AuxptyFilterHelper.beforeAuxpropertydetail((ListShowParameter)showParameter, (IFormView)this.getView());
                break;
            }
        }
    }

    private void setUnitFilter(IDataModel bill, ListShowParameter showParameter) {
        DynamicObject material = (DynamicObject)bill.getValue("material_h1");
        if (null != material) {
            Long materialId = (Long)material.getPkValue();
            DynamicObject baseUnit = material.getDynamicObject("baseunit");
            Long srcmuId = baseUnit == null ? Long.valueOf(0L) : (Long)baseUnit.getPkValue();
            List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)materialId, (Long)srcmuId, (String)"1");
            QFilter qFilter = new QFilter("id", "in", (Object)unitIds);
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        if (null != newValue && newValue.equals(oldValue)) {
            return;
        }
        int rowIndex = valueSet[0].getRowIndex();
        switch (propName = e.getProperty().getName()) {
            case "material_h": {
                this.materialChange(newValue);
                break;
            }
            case "producedate_h": 
            case "expirydate_h": {
                this.dateChange(propName, newValue);
                break;
            }
            case "warehouse_h": {
                this.getModel().setValue("location_h", null);
                break;
            }
            case "auxproperty": {
                AuxptyFilterHelper.handleAuxpropertyChangeEvent((Object)newValue, (int)rowIndex, (IFormView)this.getView());
                break;
            }
            case "auxdetailbasebd": {
                this.getModel().setValue("auxdetailbasebdid", (Object)"", rowIndex);
                break;
            }
            case "orderreturn": {
                Boolean orderReturn = (Boolean)this.getModel().getValue("orderreturn");
                this.getView().setVisible(orderReturn, new String[]{"advconap"});
                if (!orderReturn.booleanValue()) break;
                BillList billList = (BillList)this.getControl("billlistap");
                billList.clearSelection();
                this.getPageCache().put("preselectrows", SerializationUtils.toJsonString(new HashSet()));
                this.getModel().deleteEntryData("selectedentity");
                this.getPageCache().put("selectedrows", SerializationUtils.toJsonString(new HashSet()));
                break;
            }
            case "defaultquery": {
                Boolean defaultQuery = (Boolean)this.getModel().getValue("defaultquery");
                this.saveUserParamSetting(propName, defaultQuery);
                break;
            }
            case "querynotzero": {
                Boolean queryNotZero = (Boolean)this.getModel().getValue("querynotzero");
                this.saveUserParamSetting(propName, queryNotZero);
                break;
            }
        }
        if (AUXPTYPROPERTYLIST.contains(propName)) {
            this.queryInventory();
        } else if (!(propName.equals("material_h1") || propName.endsWith("_s") || "orderreturn".equals(propName))) {
            this.queryInventory();
        }
    }

    private void saveUserParamSetting(String propName, Boolean paramValue) {
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject paramObj = BusinessDataServiceHelper.loadSingle((String)"im_userparam", (String)"user,type,value", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)propName).and("user", "=", (Object)userId)});
        MainEntityType imUserParam = EntityMetadataCache.getDataEntityType((String)"im_userparam");
        if (paramObj == null) {
            paramObj = new DynamicObject((DynamicObjectType)imUserParam);
            paramObj.set("user", (Object)userId);
            paramObj.set("type", (Object)propName);
        }
        paramObj.set("value", (Object)(paramValue != false ? "1" : "0"));
        SaveServiceHelper.save((IDataEntityType)imUserParam, (Object[])new Object[]{paramObj});
    }

    private void dateChange(String propName, Object newValue) {
        if ("producedate_h".equals(propName)) {
            DateEdit dateEdit = (DateEdit)this.getView().getControl("expirydate_h");
            if (newValue == null) {
                dateEdit.setMinDate(DateUtils.getDateBySpecifyValue((int)1900, (int)1, (int)1));
            } else {
                dateEdit.setMinDate((Date)newValue);
            }
        } else if ("expirydate_h".equals(propName)) {
            DateEdit dateEdit = (DateEdit)this.getView().getControl("producedate_h");
            if (newValue == null) {
                dateEdit.setMaxDate(DateUtils.getDateBySpecifyValue((int)2999, (int)12, (int)31));
            } else {
                dateEdit.setMaxDate((Date)newValue);
            }
        }
    }

    private void materialChange(Object newValue) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if (!(newValue instanceof DynamicObjectCollection)) {
            view.setEnable(Boolean.valueOf(true), new String[]{"auxpty_h", "unit_h"});
            return;
        }
        DynamicObjectCollection materialList = (DynamicObjectCollection)newValue;
        if (materialList.size() > 1) {
            model.setValue("material_h1", null);
            model.setValue("auxpty_h", null);
            model.setValue("unit_h", null);
            view.setEnable(Boolean.valueOf(false), new String[]{"auxpty_h", "unit_h"});
        } else if (materialList.size() == 1) {
            DynamicObject baseData = ((DynamicObject)materialList.get(0)).getDynamicObject("fbasedataid");
            model.setValue("material_h1", (Object)baseData);
            view.setEnable(Boolean.valueOf(true), new String[]{"unit_h"});
            view.setEnable(Boolean.valueOf(baseData.getBoolean("isuseauxpty")), new String[]{"auxpty_h"});
        } else {
            model.setValue("material_h1", null);
            view.setEnable(Boolean.valueOf(true), new String[]{"unit_h"});
            view.setEnable(Boolean.valueOf(false), new String[]{"auxpty_h"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        String expandQFilterStr;
        AuxptyFilterHelper.setAuxEntryEnable((IDataModel)this.getModel(), (IFormView)this.getView());
        JSONObject param = (JSONObject)this.getView().getFormShowParameter().getCustomParam("param");
        if (param == null) {
            return;
        }
        this.dealBtn(param);
        String kitResult = param.getString("kitResult");
        String billType = param.getString("billType");
        this.getPageCache().put("kitResult", kitResult);
        this.getPageCache().put("billType", billType);
        JSONArray allFieldKey = new JSONArray();
        JSONObject mapparam = param.getJSONObject("mapparam");
        if (mapparam == null) {
            return;
        }
        JSONArray fieldDatas = mapparam.getJSONArray("fielddata");
        if (fieldDatas == null) {
            return;
        }
        int size = fieldDatas.size();
        for (int i = 0; i < size; ++i) {
            JSONObject fieldData = fieldDatas.getJSONObject(i);
            String metaKey = fieldData.getString("metadatakey");
            allFieldKey.add((Object)metaKey);
            if (!"warehouse".equals(metaKey)) continue;
            String billWHKey = fieldData.getString("currentmetadatakey");
            this.getPageCache().put("billWHKey", billWHKey);
        }
        this.getPageCache().put("allfieldkey", allFieldKey.toJSONString());
        List warehouseIds = null;
        QFilter qFilter = new QFilter("baseqty", "<>", (Object)0);
        qFilter.or(new QFilter("qty", "<>", (Object)0));
        qFilter.or(new QFilter("qty2nd", "<>", (Object)0));
        JSONObject field = param.getJSONObject("qfilterfield");
        if (field != null && field.size() > 0) {
            qFilter = this.dealKeeperOwner(field, qFilter);
            Map<String, Object> resultMap = this.initControl(param, qFilter);
            qFilter = (QFilter)resultMap.get("qFilter");
            warehouseIds = (List)resultMap.get("warehouseIds");
        }
        qFilter = this.addWarehouseFilter(warehouseIds, qFilter);
        boolean containOrgFilter = this.containOrgFilter(qFilter);
        IFormView view = this.getView();
        IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
        String formId = parentView.getEntityId();
        if (formId.equals("im_transapply") && !containOrgFilter) {
            Object[] hasPermission = NewInvOrgHelper.getHasPermission((String)formId, (String)view.getFormShowParameter().getAppId());
            qFilter.and("org", "in", (Object)hasPermission);
        }
        if ((expandQFilterStr = param.getString("expandQFilter")) != null) {
            QFilter expandQFilter = QFilter.fromSerializedString((String)expandQFilterStr);
            qFilter.and(expandQFilter);
            this.getPageCache().put("expandQFilter", expandQFilterStr);
        }
        String pluginName = param.getJSONObject("mapparam").getJSONObject("settingparam").getString("filterpluginname");
        this.getPageCache().put("filterpluginName", pluginName);
        QFilter filter = this.executePlugin(pluginName, qFilter);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.getFilterParameter().setQFilters(Collections.singletonList(filter));
        this.userParamDeal();
        Boolean value = (Boolean)this.getModel().getValue("defaultquery");
        Boolean queryNotZero = (Boolean)this.getModel().getValue("querynotzero");
        if (!value.booleanValue()) {
            filter.and(new QFilter("1", "<>", (Object)1));
        }
        if (queryNotZero.booleanValue()) {
            filter.and(new QFilter("baseqty-lockbaseqty", "<>", (Object)0, true).or(new QFilter("qty-lockqty", "<>", (Object)0, true)).or(new QFilter("qty2nd-lockqty2nd", "<>", (Object)0, true)));
        }
        this.putLastFilterCache(filter);
    }

    private void userParamDeal() {
        long userid = RequestContext.get().getCurrUserId();
        String defaultQuery = this.getUserParamByUserAndType(userid, "defaultquery");
        this.getModel().setValue("defaultquery", (Object)"1".equals(defaultQuery));
        String queryNotZero = this.getUserParamByUserAndType(userid, "querynotzero");
        this.getModel().setValue("querynotzero", (Object)"1".equals(queryNotZero));
    }

    private String getUserParamByUserAndType(long userid, String type) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"im_userparam", (String)"type,value", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userid).and("type", "=", (Object)type)});
        String value = null;
        value = "querynotzero".equals(type) ? (obj == null ? "0" : obj.getString("value")) : (obj == null ? "1" : obj.getString("value"));
        return value;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        AuxptyFilterHelper.setAuxEntryEnable((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("deleteselectentry".equals(operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("selectedentity");
            int[] rowIndexs = entryGrid.getSelectRows();
            Set selectIds = new HashSet();
            String selectRowStr = this.getPageCache().get("selectedrows");
            if (!StringUtils.isEmpty((CharSequence)selectRowStr)) {
                selectIds = (Set)SerializationUtils.fromJsonString((String)selectRowStr, Set.class);
            }
            for (int rowIndex : rowIndexs) {
                String invId = this.getModel().getValue("id_s", rowIndex).toString();
                selectIds.remove(invId);
            }
            this.getPageCache().put("selectedrows", SerializationUtils.toJsonString(selectIds));
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if (entryName.equals("auxentry")) {
            this.queryInventory();
        }
    }

    private QFilter executePlugin(String pluginName, QFilter currentFilter) {
        QFilter qFilter = currentFilter;
        DefaultInvQueryExpand defExpand = new DefaultInvQueryExpand();
        PluginProxy pluginProxy = PluginProxy.create((Object)defExpand, IInvQueryExpand.class, (String)"SCMC_IM_INVQUERY_FILTERANDRETURN");
        List expandFilters = pluginProxy.callAfter(p -> p.getExpandFilterFromQueryView(this.getView()));
        if (expandFilters != null && !expandFilters.isEmpty()) {
            for (QFilter expandFilter : expandFilters) {
                if (expandFilter == null) continue;
                qFilter = qFilter.and(expandFilter);
            }
        }
        if (StringUtils.isEmpty((CharSequence)pluginName)) {
            return qFilter;
        }
        try {
            Class<?> pluginClass = Class.forName(pluginName);
            IQueryMaterialFilterPlugin getFilterPlugin = (IQueryMaterialFilterPlugin)pluginClass.newInstance();
            return getFilterPlugin.getExpandFilter(this.getView(), qFilter);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException var5) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d2\u4ef6\u201c%1$s\u201d\u4e0d\u5b58\u5728\u6216\u8005\u8be5\u63d2\u4ef6\u6ca1\u6709\u5b9e\u73b0\u63a5\u53e3\u201c%2$s\u201d,\u8bf7\u68c0\u67e5\u5143\u6570\u636e\u5e93\u5b58\u67e5\u8be2\u914d\u7f6e\u3002", (String)"QueryMaterialInvAccPlugin_5", (String)"scmc-im-formplugin", (Object[])new Object[0]), pluginName, "kd.bos.ext.scmc.plugin.operation.IQueryMaterialFilterPlugin"));
        }
    }

    private QFilter dealKeeperOwner(JSONObject field, QFilter qFilter) {
        Set keySet = field.keySet();
        String wonerTypeKey = this.dealKey("ownertype");
        if (keySet.contains("ownertype")) {
            Object ownerTypeValue = field.get((Object)"ownertype");
            this.getModel().setValue(wonerTypeKey, ownerTypeValue);
            if (StringUtils.isNotBlank((Object)ownerTypeValue)) {
                qFilter = qFilter == null ? new QFilter("ownertype", "=", ownerTypeValue) : qFilter.and(new QFilter("ownertype", "=", ownerTypeValue));
            }
        } else {
            this.getModel().setValue(wonerTypeKey, (Object)"bos_org");
        }
        String keeperTypeKey = this.dealKey("keepertype");
        if (keySet.contains("keepertype")) {
            Object keeperTypeValue = field.get((Object)"keepertype");
            this.getModel().setValue(keeperTypeKey, keeperTypeValue);
            if (StringUtils.isNotBlank((Object)keeperTypeValue)) {
                qFilter = qFilter == null ? new QFilter("keepertype", "=", keeperTypeValue) : qFilter.and(new QFilter("keepertype", "=", keeperTypeValue));
            }
        } else {
            this.getModel().setValue(keeperTypeKey, (Object)"bos_org");
        }
        return qFilter;
    }

    private Map<String, Object> initControl(JSONObject param, QFilter qFilter) {
        JSONObject field = param.getJSONObject("qfilterfield");
        Set fieldEntries = field.entrySet();
        IFormView view = this.getView();
        IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
        int[] currRows = BillViewHelper.getCurrentRowIndexs((IFormView)parentView, (String)"billentry");
        List<Object> warehouseIds = new ArrayList(16);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (Map.Entry fieldMap : fieldEntries) {
            Object auxptyId;
            String key = (String)fieldMap.getKey();
            String headKey = this.dealKey(key);
            this.getView().setVisible(Boolean.TRUE, new String[]{headKey});
            if (this.getControl(headKey) == null) continue;
            if ("auxpty".equals(key) && null != (auxptyId = fieldMap.getValue())) {
                AuxptyFilterHelper.bindAuxptyEntryById(auxptyId, (IDataModel)this.getModel(), (IFormView)this.getView());
                List ids = AuxptyFilterHelper.getAuxptyIds((IDataModel)this.getModel());
                if (ids == null || ids.isEmpty()) continue;
                qFilter = qFilter.and(new QFilter(key, "in", (Object)ids));
                continue;
            }
            if (key.equals("ownertype") || key.equals("keepertype")) continue;
            Date value = null;
            if (key.equals("expirydate") || key.equals("producedate")) {
                try {
                    Object fieldValue = fieldMap.getValue();
                    if (fieldValue != null) {
                        value = dateFormat.parse((String)fieldValue);
                    }
                }
                catch (ParseException e) {
                    logger.warn("\u5e93\u5b58\u67e5\u8be2\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff1a", (Throwable)e);
                }
            } else {
                value = (Date)fieldMap.getValue();
            }
            if ("material".equals(key) && param.getBoolean("isDraw").booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{headKey});
            }
            if ("org".equals(key)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{headKey});
                this.getModel().setValue(headKey, (Object)value);
                if (null == value) continue;
                qFilter = qFilter == null ? new QFilter(key, "=", (Object)value) : qFilter.and(new QFilter(key, "=", (Object)value));
                continue;
            }
            if (currRows == null || currRows.length > 1) continue;
            if ("warehouse_h".equals(headKey)) {
                warehouseIds = this.getWarehouseIds(null);
                if (warehouseIds != null && !warehouseIds.contains(value)) {
                    this.getModel().setValue(headKey, null);
                    continue;
                }
                if (!StringUtils.isNotBlank((Object)value)) continue;
                this.getModel().setValue(headKey, (Object)value);
                qFilter = qFilter == null ? new QFilter(key, "=", (Object)value) : qFilter.and(new QFilter(key, "=", (Object)value));
                continue;
            }
            if (!StringUtils.isNotBlank((Object)value)) continue;
            if (MULTI_VALUE_FIELDS.contains(headKey)) {
                Object[] valueArr = new Object[]{value};
                this.getModel().setValue(headKey, (Object)valueArr);
                if ("material_h".equals(headKey)) {
                    this.getModel().setValue("material_h1", valueArr[0]);
                }
            } else {
                this.getModel().setValue(headKey, (Object)value);
            }
            qFilter = qFilter == null ? new QFilter(key, "=", (Object)value) : qFilter.and(new QFilter(key, "=", (Object)value));
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("qFilter", qFilter);
        resultMap.put("warehouseIds", warehouseIds);
        return resultMap;
    }

    private boolean containOrgFilter(QFilter qFilter) {
        List nests = qFilter.getNests(true);
        for (QFilter.QFilterNest qFilterNest : nests) {
            String property = qFilterNest.getFilter().getProperty();
            if (!property.equals("org")) continue;
            return true;
        }
        return false;
    }

    private QFilter addWarehouseFilter(List<Long> warehouseIds, QFilter qFilter) {
        if (warehouseIds != null && !warehouseIds.isEmpty()) {
            if (qFilter == null) {
                qFilter = new QFilter("warehouse", "in", warehouseIds);
                return qFilter;
            }
            boolean hasWarehouseFilter = false;
            List nests = qFilter.getNests(false);
            for (QFilter.QFilterNest nest : nests) {
                String property = nest.getFilter().getProperty();
                if (!"warehouse".equals(property)) continue;
                hasWarehouseFilter = true;
                break;
            }
            if (!hasWarehouseFilter) {
                qFilter = qFilter.and("warehouse", "in", warehouseIds);
            }
        }
        return qFilter;
    }

    private List<Long> getWarehouseIds(List<Long> orgIds) {
        if (orgIds == null) {
            Object org = this.getModel().getValue("org_h");
            if (org == null) {
                return null;
            }
            Long orgId = ((DynamicObject)org).getLong("id");
            orgIds = Collections.singletonList(orgId);
        }
        String billType = this.getPageCache().get("billType");
        String billWHKey = this.getPageCache().get("billWHKey");
        if (StringUtils.isBlank((CharSequence)billType)) {
            return null;
        }
        Set warehouseIds = InvBizDataCtrlHelper.buildLimitHelper((DataCtrlSchemeResultHandle[])new DataCtrlSchemeResultHandle[]{new WarehouseIsolateResultHandle()}).getDataByUser(orgIds, billType, billWHKey);
        if (warehouseIds.isEmpty()) {
            return null;
        }
        return new ArrayList<Long>(warehouseIds);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.checkParentModelStatus();
        this.setAuxptyEnable();
        Boolean orderReturn = (Boolean)this.getModel().getValue("orderreturn");
        this.getView().setVisible(orderReturn, new String[]{"advconap"});
    }

    private void setAuxptyEnable() {
        IFormView view = this.getView();
        Object value = view.getModel().getValue("material_h1");
        if (value instanceof DynamicObject) {
            DynamicObject material = (DynamicObject)value;
            view.setEnable(Boolean.valueOf(material.getBoolean("isuseauxpty")), new String[]{"auxpty_h"});
        } else {
            view.setEnable(Boolean.FALSE, new String[]{"auxpty_h"});
        }
    }

    public void click(EventObject e) {
        Control c = (Control)e.getSource();
        String key = c.getKey();
        if (StringUtils.isNotBlank((CharSequence)key)) {
            if ("btnok".equals(key)) {
                String kitResult = this.getPageCache().get("kitResult");
                if (StringUtils.isNotBlank((CharSequence)kitResult)) {
                    this.getView().showTipNotification(kitResult);
                    return;
                }
                this.returnData();
            } else if ("auxdetailbasebd".equals(key)) {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("auxentry");
                int[] selectRows = entryGrid.getSelectRows();
                this.getPageCache().put("clickIndex", String.valueOf(selectRows[0]));
                AuxptyFilterHelper.showAuxBaseForm((String)key, (int)selectRows[0], (IFormView)this.getView(), (IDataModel)this.getModel(), (IFormPlugin)this);
            } else if ("lotnum_h".equals(key)) {
                this.lotHClick();
            } else if ("auxdetailtxt".equals(key)) {
                this.auxDetailTxtClick();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "auxdetailbasebd": {
                String clickIndex = this.getPageCache().get("clickIndex");
                AuxptyFilterHelper.handleClosedCallBack((Object)returnDataObj, (IDataModel)this.getModel(), (String)clickIndex);
                break;
            }
            case "lotnum_h": {
                this.lotHCallBack(closedCallBackEvent);
                break;
            }
            case "auxdetailtxt": {
                this.auxDetailTxtCallBack(closedCallBackEvent);
                break;
            }
        }
    }

    private void auxDetailTxtCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnDataObj = closedCallBackEvent.getReturnData();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("auxentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (returnDataObj instanceof Map) {
            Map returnData = (Map)returnDataObj;
            String value = String.valueOf(returnData.get("content"));
            String operateType = String.valueOf(returnData.get("operateType"));
            if ("btnok".equals(operateType)) {
                value = value.replace("\n", ",");
                this.getModel().setValue("auxdetailtxt", (Object)value, selectRows[0]);
            }
        }
    }

    private void lotHCallBack(ClosedCallBackEvent evt) {
        Object returnDataObj = evt.getReturnData();
        if (returnDataObj instanceof Map) {
            Map returnData = (Map)returnDataObj;
            String value = String.valueOf(returnData.get("content"));
            String operateType = String.valueOf(returnData.get("operateType"));
            if ("btnok".equals(operateType)) {
                value = value.replace("\n", ",");
                this.getModel().setValue("lotnum_h", (Object)value);
            }
        }
    }

    private void returnData() {
        ArrayList<Object> selectIds = new ArrayList<Object>();
        Boolean orderReturn = (Boolean)this.getModel().getValue("orderreturn");
        if (!orderReturn.booleanValue()) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            List ids = Arrays.stream(primaryKeyValues).map(value -> (Long)value).collect(Collectors.toList());
            selectIds.addAll(ids);
        } else {
            DynamicObjectCollection entries = this.getModel().getEntryEntity("selectedentity");
            for (DynamicObject entry : entries) {
                selectIds.add(entry.getLong("id_s"));
            }
        }
        if (selectIds.size() > MAX_SIZE) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u7684\u884c\u6570\uff0c\u8d85\u8fc7\u6700\u5927\u884c\u6570\uff08%1$s\uff09\u9650\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"QueryMaterialInvAccPlugin_1", (String)"bos-ext-scmc", (Object[])new Object[0]), MAX_SIZE));
            return;
        }
        if (selectIds.size() > 0) {
            QFilter filter = new QFilter("id", "in", selectIds);
            DynamicObjectCollection invAccColl = QueryServiceHelper.query((String)InvAccConst.getBalTb(), (String)"id", (QFilter[])filter.toArray());
            List invAccIds = null;
            if (invAccColl != null && !invAccColl.isEmpty()) {
                invAccIds = invAccColl.stream().map(invAcc -> invAcc.getLong("id")).collect(Collectors.toList());
            }
            if (invAccIds == null || invAccIds.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u5237\u65b0\u518d\u8bd5\u3002", (String)"QueryMaterialInvAccPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                return;
            }
            Iterator iterator = selectIds.iterator();
            while (iterator.hasNext()) {
                Long id = (Long)iterator.next();
                if (invAccIds.contains(id)) continue;
                iterator.remove();
            }
            JSONObject returnData = new JSONObject();
            JSONObject param = (JSONObject)this.getView().getFormShowParameter().getCustomParam("param");
            Map mapParam = (Map)param.get((Object)"mapparam");
            mapParam.put("isDraw", param.getBoolean("isDraw"));
            returnData.put("mapparam", (Object)mapParam);
            Map settingParam = (Map)mapParam.get("settingparam");
            String returnType = (String)settingParam.get("returntype");
            if ("null".equals(returnType)) {
                returnData = null;
            } else if ("single".equals(returnType)) {
                returnData.put("data", (Object)new Long[]{(Long)selectIds.get(0)});
            } else if ("multi".equals(returnType)) {
                returnData.put("data", (Object)selectIds.toArray(new Long[0]));
            }
            this.getView().returnDataToParent((Object)returnData);
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"QueryMaterialInvAccPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
    }

    private void queryInventory() {
        List auxptyFilterList;
        List<Long> warehouseIds;
        this.getPageCache().put("preselectrows", SerializationUtils.toJsonString(new HashSet()));
        QFilter qFilter = this.getQFilter();
        String expandQFilterStr = this.getPageCache().get("expandQFilter");
        if (expandQFilterStr != null) {
            QFilter expandQFilter = QFilter.fromSerializedString((String)expandQFilterStr);
            qFilter.and(expandQFilter);
        }
        String pluginName = this.getPageCache().get("filterpluginName");
        QFilter filter = this.executePlugin(pluginName, qFilter);
        BillList billList = (BillList)this.getControl("billlistap");
        if (this.getModel().getValue("warehouse_h") == null && (warehouseIds = this.getWarehouseIds(null)) != null) {
            filter = filter.and("warehouse", "in", warehouseIds);
        }
        if (null == (auxptyFilterList = AuxptyFilterHelper.getAuxptyFilter(null, (IDataModel)this.getModel()))) {
            filter = new QFilter("'1'", "!=", (Object)"1");
        } else if (!auxptyFilterList.isEmpty()) {
            for (QFilter auxptyFilter : auxptyFilterList) {
                filter = filter.and(auxptyFilter);
            }
        }
        billList.getFilterParameter().setQFilters(Collections.singletonList(filter));
        this.putLastFilterCache(filter);
        billList.refresh();
    }

    private QFilter getQFilter() {
        IDataModel model = this.getModel();
        JSONArray fieldKey = JSONArray.parseArray((String)this.getPageCache().get("allfieldkey"));
        QFilter qFilter = new QFilter("baseqty", "<>", (Object)0);
        qFilter.or(new QFilter("qty", "<>", (Object)0));
        qFilter.or(new QFilter("qty2nd", "<>", (Object)0));
        if (fieldKey == null) {
            return qFilter;
        }
        int count = fieldKey.size();
        for (int i = 0; i < count; ++i) {
            boolean isList;
            IDataEntityProperty property;
            String key = fieldKey.getString(i);
            String headKey = this.dealKey(key);
            if (QTYLIST.contains(headKey) || (property = model.getProperty(headKey)) == null) continue;
            Object value = model.getValue(headKey);
            List<Object> valueList = new ArrayList(16);
            if (value instanceof DynamicObject) {
                Object id = ((DynamicObject)value).get("id");
                if (id instanceof Long && id.equals(0L)) continue;
                valueList.add(id);
            } else if (value instanceof DynamicObjectCollection) {
                valueList = this.getMultiValueIdList(value);
                if (valueList.isEmpty()) {
                    continue;
                }
            } else if ("lotnum_h".equals(headKey)) {
                if (!StringUtils.isEmpty((CharSequence)((String)value))) {
                    String[] lotArr = ((String)value).split(",");
                    List lotList = Arrays.stream(lotArr).map(lot -> lot.trim()).filter(lot -> !StringUtils.isEmpty((CharSequence)lot)).collect(Collectors.toList());
                    valueList.addAll(lotList);
                }
            } else {
                valueList.add(value);
            }
            if (!StringUtils.isNotBlank((Object)value) || valueList.isEmpty()) continue;
            boolean bl = isList = valueList.size() > 1;
            qFilter = qFilter == null ? new QFilter(key, isList ? "in" : "=", isList ? valueList : valueList.get(0)) : qFilter.and(key, isList ? "in" : "=", isList ? valueList : valueList.get(0));
        }
        Boolean queryNotZero = (Boolean)this.getModel().getValue("querynotzero");
        if (queryNotZero.booleanValue()) {
            qFilter.and(new QFilter("baseqty-lockbaseqty", "<>", (Object)0, true).or(new QFilter("qty-lockqty", "<>", (Object)0, true)).or(new QFilter("qty2nd-lockqty2nd", "<>", (Object)0, true)));
        }
        return qFilter;
    }

    private List<Object> getMultiValueIdList(Object value) {
        DynamicObjectCollection materialList = (DynamicObjectCollection)value;
        ArrayList<Object> materialIdList = new ArrayList<Object>(materialList.size());
        for (DynamicObject material : materialList) {
            Object materialId;
            DynamicObject baseData = material.getDynamicObject("fbasedataid");
            if (baseData == null || !((materialId = baseData.get("id")) instanceof Long) || materialId.equals(0L)) continue;
            materialIdList.add(materialId);
        }
        return materialIdList;
    }

    private String dealKey(String key) {
        String headKey = key + "_h";
        return headKey;
    }

    private String subDealKey(String key) {
        return key.substring(0, key.indexOf("_h"));
    }

    protected void setLocationFilter(BeforeF7SelectEvent e, IDataModel bill, ListShowParameter showParameter) {
        DynamicObject warehouse = (DynamicObject)bill.getValue("warehouse_h");
        if (warehouse == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ed3\u5e93\u4fe1\u606f\u3002", (String)"QueryMaterialInvAccPlugin_4", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            QFilter qFilter1 = WarehouseHelper.buildLocationQFilter((DynamicObject)warehouse);
            showParameter.getListFilterParameter().setFilter(qFilter1);
        }
    }

    protected void setWarehouseFilter(BeforeF7SelectEvent e, ListShowParameter showParameter) {
        List<Long> wareHIds;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org_h");
        ArrayList<Object> orgIds = new ArrayList<Object>();
        if (org == null) {
            String pkSet = (String)this.getView().getFormShowParameter().getCustomParams().get("HasPermissionAndStartedInvOrg");
            orgIds = pkSet == null || pkSet.isEmpty() ? orgIds : (List)SerializationUtils.fromJsonString((String)pkSet, List.class);
        } else {
            orgIds.add(org.getPkValue());
        }
        ArrayList<Long> isolateOrgList = new ArrayList<Long>(orgIds.size());
        ArrayList notIsolateOrgList = new ArrayList(orgIds.size());
        WareHouseIsolateHelper.buildIsolateList(this.getLongOrgIds(orgIds), isolateOrgList, notIsolateOrgList);
        List wareHouseIds = new ArrayList<Long>(16);
        if (!isolateOrgList.isEmpty() && (wareHIds = this.getWarehouseIds(isolateOrgList)) != null) {
            wareHouseIds.addAll(wareHIds);
        }
        if (!notIsolateOrgList.isEmpty()) {
            wareHouseIds.addAll(WarehouseHelper.getAllWarehouse(new ArrayList(notIsolateOrgList)));
        }
        if (isolateOrgList.isEmpty() && notIsolateOrgList.isEmpty()) {
            wareHouseIds = WarehouseHelper.getAllWarehouse(orgIds);
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        if (wareHouseIds.isEmpty()) {
            wareHouseIds = WarehouseHelper.getAllWarehouse(orgIds);
        }
        filterList.add(new QFilter("id", "in", wareHouseIds));
        showParameter.getListFilterParameter().setQFilters(filterList);
    }

    private List<Long> getLongOrgIds(List<Object> orgIds) {
        ArrayList<Long> LongOrgIds = new ArrayList<Long>(orgIds.size());
        if (orgIds.isEmpty()) {
            return LongOrgIds;
        }
        for (Object orgId : orgIds) {
            if (orgId instanceof Integer) {
                LongOrgIds.add(Long.parseLong(orgId.toString()));
                continue;
            }
            LongOrgIds.add((Long)orgId);
        }
        return LongOrgIds;
    }

    private void setKeeperFilter(BeforeF7SelectEvent e, IDataModel bill, ListShowParameter showParameter) {
        String keeperType = (String)bill.getValue("keepertype_h");
        if ("bos_org".equals(keeperType)) {
            showParameter.setCustomParam("orgFuncId", (Object)"05");
        }
    }

    private void setOwnerFilter(BeforeF7SelectEvent e, IDataModel bill, ListShowParameter showParameter) {
        String ownerType = (String)bill.getValue("ownertype_h");
        if ("bos_org".equals(ownerType)) {
            showParameter.setCustomParam("orgFuncId", (Object)"10");
        }
    }

    private void addExecutionListDataProvider() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        if (list == null) {
            return;
        }
        list.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent setFilterEvent) {
                List auxptyFilterList = AuxptyFilterHelper.getAuxptyFilter(null, (IDataModel)QueryMaterialInvAccPlugin.this.getModel());
                if (null == auxptyFilterList) {
                    setFilterEvent.getQFilters().add(new QFilter("'1'", "!=", (Object)"1"));
                } else if (!auxptyFilterList.isEmpty()) {
                    for (QFilter auxptyFilter : auxptyFilterList) {
                        setFilterEvent.getQFilters().add(auxptyFilter);
                    }
                }
            }
        });
        list.addCreateListDataProviderListener(new CreateListDataProviderListener(){

            public void createListDataProvider(BeforeCreateListDataProviderArgs e) {
                e.setListDataProvider((IListDataProvider)new ListDataProvider(){

                    public DynamicObjectCollection getData(int start, int limit) {
                        DataEntityPropertyCollection properties;
                        DynamicObjectCollection cols = super.getData(start, limit);
                        HashSet<Long> invIds = new HashSet<Long>();
                        for (DynamicObject col : cols) {
                            invIds.add(col.getLong("id"));
                        }
                        QFilter filter = new QFilter("id", "in", invIds);
                        DataSet invaccAvbbaseqty = ReserveHelper.getInvaccAvbbaseqty((QFilter[])filter.toArray());
                        DataEntityPropertyCollection dataEntityPropertyCollection = properties = cols == null || cols.isEmpty() ? null : cols.getDynamicObjectType().getProperties();
                        block1: while (invaccAvbbaseqty.hasNext()) {
                            Row row = invaccAvbbaseqty.next();
                            for (DynamicObject co : cols) {
                                if (!co.get("id").equals(row.get("id"))) continue;
                                QueryMaterialInvAccPlugin.this.setListField(properties, co, "avbqty", row.get("avbbqty"));
                                QueryMaterialInvAccPlugin.this.setListField(properties, co, "avbbaseqty", row.get("avbbaseqty"));
                                QueryMaterialInvAccPlugin.this.setListField(properties, co, "avbqty2nd", row.get("avbbtndqty"));
                                QueryMaterialInvAccPlugin.this.setListField(properties, co, "lockqty", row.get("reserveqty"));
                                QueryMaterialInvAccPlugin.this.setListField(properties, co, "lockbaseqty", row.get("reservebaseqty"));
                                QueryMaterialInvAccPlugin.this.setListField(properties, co, "lockqty2nd", row.get("reserveunit2ndqty"));
                                continue block1;
                            }
                        }
                        return cols;
                    }
                });
            }
        });
    }

    protected void setListField(DataEntityPropertyCollection properties, DynamicObject co, String listQty, Object value) {
        if (properties.containsKey((Object)listQty)) {
            co.set(listQty, value);
        }
    }

    private void dealBtn(JSONObject param) {
        JSONObject mapparam = param.getJSONObject("mapparam");
        if (null == mapparam) {
            return;
        }
        JSONObject settingParm = mapparam.getJSONObject("settingparam");
        if (null == settingParm) {
            return;
        }
        IFormView view = this.getView();
        IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
        DynamicObject parentEntity = parentView.getModel().getDataEntity();
        String key = parentView.getModel().getDataEntityType().getName();
        if ("im_workbench_editlist".equalsIgnoreCase(key)) {
            String targetBillEntityStr = mapparam.getString("targetBillEntity");
            String targetBillType = mapparam.getString("targetBillType");
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)targetBillType);
            Object[] targetBillEntity = DynamicObjectSerializeUtil.deserialize((String)targetBillEntityStr, (DynamicObjectType)dataEntityType);
            parentEntity = (DynamicObject)targetBillEntity[0];
        }
        String status = parentEntity.getString("billstatus");
        int[] currRows = BillViewHelper.getCurrentRowIndexs((IFormView)parentView, (String)"billentry");
        try {
            boolean isSubmitOrAudit;
            Map setting = (Map)JSONUtils.cast((String)settingParm.toJSONString(), Map.class);
            String returntype = (String)setting.get("returntype");
            boolean typeIsNull = StringUtils.isBlank((CharSequence)returntype) || "null".equals(returntype);
            boolean isOneRow = null == currRows || currRows.length > 1;
            boolean bl = isSubmitOrAudit = null == status || "C".equals(status) || "B".equals(status);
            if (typeIsNull || isOneRow || isSubmitOrAudit) {
                view.setVisible(Boolean.FALSE, new String[]{"btnok"});
            }
        }
        catch (IOException e) {
            this.getView().showErrorNotification(IMStringUtils.append((String)ResManager.loadKDString((String)"\u89e3\u6790\u53c2\u6570\u65f6\u5f02\u5e38\uff1a", (String)"QueryMaterialInvAccPlugin_3", (String)"scmc-im-formplugin", (Object[])new Object[0]), (Object[])new Object[]{e.getMessage()}));
            view.setVisible(Boolean.FALSE, new String[]{"btnok"});
            logger.error((Throwable)e);
        }
    }

    private void checkParentModelStatus() {
        try {
            IFormView view = this.getView();
            IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
            IDataModel parentModel = parentView.getModel();
            String status = (String)parentModel.getValue("billstatus");
            if ("D".equals(status)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnok"});
            }
        }
        catch (Exception ex) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btnok"});
        }
    }

    private void putLastFilterCache(QFilter filter) {
        if (filter != null) {
            this.getPageCache().put("lastQFilter", filter.toSerializedString());
        } else {
            this.getPageCache().put("lastQFilter", "");
        }
    }

    private void mergeReverseSp(DynamicObjectCollection cols) {
        if (cols == null || cols.isEmpty() || !SupplyChainParameterHelper.getScmParam()) {
            return;
        }
        List invIdList = cols.stream().map(invAcc -> invAcc.getLong("id")).collect(Collectors.toList());
        QFilter spFilter = new QFilter("invid", "in", invIdList);
        DataSet spReserveDataSet = QueryServiceHelper.queryDataSet((String)"QueryMaterialInvAccPlugin.mergeReverseSp", (String)"msmod_reserve_bal_sp", (String)"invid,baseqty as lockbaseqty,qty as lockqty,qty2nd as lockqty2nd", (QFilter[])spFilter.toArray(), null);
        if (!spReserveDataSet.hasNext()) {
            return;
        }
        spReserveDataSet = spReserveDataSet.groupBy(new String[]{"invid"}).sum("lockbaseqty").sum("lockqty").sum("lockqty2nd").finish();
        DataEntityPropertyCollection properties = cols.getDynamicObjectType().getProperties();
        block0: while (spReserveDataSet.hasNext()) {
            Row row = spReserveDataSet.next();
            for (DynamicObject invAcc2 : cols) {
                if (!row.getLong("invid").equals(invAcc2.getLong("id"))) continue;
                this.setMergeQty(properties, invAcc2, row, "lockqty");
                this.setMergeQty(properties, invAcc2, row, "lockbaseqty");
                this.setMergeQty(properties, invAcc2, row, "lockqty2nd");
                this.setAvbMergeQty(properties, invAcc2);
                continue block0;
            }
        }
    }

    protected void setMergeQty(DataEntityPropertyCollection properties, DynamicObject co, Row row, String qtyFiled) {
        if (properties.containsKey((Object)qtyFiled)) {
            BigDecimal lockQty = co.getBigDecimal(qtyFiled) != null ? co.getBigDecimal(qtyFiled) : BigDecimal.ZERO;
            BigDecimal lockQtySp = row.getBigDecimal(qtyFiled) != null ? row.getBigDecimal(qtyFiled) : BigDecimal.ZERO;
            co.set(qtyFiled, (Object)lockQty.add(lockQtySp));
        }
    }

    protected void setAvbMergeQty(DataEntityPropertyCollection properties, DynamicObject co) {
        BigDecimal lockQty;
        BigDecimal qty;
        if (properties.containsKey((Object)"avbqty")) {
            qty = co.getBigDecimal("qty") != null ? co.getBigDecimal("qty") : BigDecimal.ZERO;
            lockQty = co.getBigDecimal("lockqty") != null ? co.getBigDecimal("lockqty") : BigDecimal.ZERO;
            co.set("avbqty", (Object)qty.subtract(lockQty));
        }
        if (properties.containsKey((Object)"avbbaseqty")) {
            qty = co.getBigDecimal("baseqty") != null ? co.getBigDecimal("baseqty") : BigDecimal.ZERO;
            lockQty = co.getBigDecimal("lockbaseqty") != null ? co.getBigDecimal("lockbaseqty") : BigDecimal.ZERO;
            co.set("avbbaseqty", (Object)qty.subtract(lockQty));
        }
        if (properties.containsKey((Object)"avbqty2nd")) {
            qty = co.getBigDecimal("qty2nd") != null ? co.getBigDecimal("qty2nd") : BigDecimal.ZERO;
            lockQty = co.getBigDecimal("lockqty2nd") != null ? co.getBigDecimal("lockqty2nd") : BigDecimal.ZERO;
            co.set("avbqty2nd", (Object)qty.subtract(lockQty));
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        this.buildSelectEntryData();
    }

    private void buildSelectEntryData() {
        Boolean orderReturn = (Boolean)this.getModel().getValue("orderreturn");
        if (!orderReturn.booleanValue()) {
            return;
        }
        String preSelectRowStr = this.getPageCache().get("preselectrows");
        Set preSelectIds = new HashSet();
        if (!StringUtils.isEmpty((CharSequence)preSelectRowStr)) {
            preSelectIds = (Set)SerializationUtils.fromJsonString((String)preSelectRowStr, Set.class);
        }
        HashSet removeIds = new HashSet(preSelectIds);
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Set curSelectIds = Arrays.stream(selectedRows.getPrimaryKeyValues()).map(id -> id.toString()).collect(Collectors.toSet());
        this.getPageCache().put("preselectrows", SerializationUtils.toJsonString(curSelectIds));
        removeIds.removeAll(curSelectIds);
        curSelectIds.removeAll(preSelectIds);
        String invRowStr = this.getPageCache().get("selectedrows");
        Set<String> selectedIds = new HashSet();
        if (!StringUtils.isEmpty((CharSequence)invRowStr)) {
            selectedIds = (Set)SerializationUtils.fromJsonString((String)invRowStr, Set.class);
        }
        selectedIds.removeAll(removeIds);
        if (!removeIds.isEmpty()) {
            DynamicObjectCollection entries = this.getModel().getEntryEntity("selectedentity");
            ArrayList<Integer> ids = new ArrayList<Integer>(removeIds.size());
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject entry = (DynamicObject)entries.get(i);
                String invId = entry.getString("id_s");
                if (!removeIds.contains(invId)) continue;
                ids.add(i);
            }
            int[] indexArr = new int[ids.size()];
            for (int i = 0; i < ids.size(); ++i) {
                indexArr[i] = (Integer)ids.get(i);
            }
            this.getModel().deleteEntryRows("selectedentity", indexArr);
        }
        QueryResult queryResult = billList.getSelectedRowDatas(new ArrayList(), selectedRows);
        DynamicObjectCollection selectDatas = queryResult.getCollection();
        List formatRowDatas = queryResult.getFormatRowDatas();
        List<Map<String, String>> columns = this.getColumnsFromCache();
        for (int i = 0; i < selectDatas.size(); ++i) {
            DynamicObject selectedData = (DynamicObject)selectDatas.get(i);
            String invId = selectedData.getString("id");
            if (!curSelectIds.contains(invId)) continue;
            if (!selectedIds.contains(invId)) {
                int index = this.getModel().createNewEntryRow("selectedentity");
                this.getModel().setValue("id_s", (Object)invId, index);
                FormatRowData formatRowData = (FormatRowData)formatRowDatas.get(i);
                for (Map<String, String> column : columns) {
                    String fieldKey = column.get("key");
                    FormatFieldData formatFieldData = formatRowData.get(fieldKey);
                    if ("auxpty".equals(fieldKey)) {
                        this.formatAuxProp(formatFieldData);
                    }
                    String selectField = fieldKey.replace(".", "") + "_s";
                    if (this.getModel().getProperty(selectField) == null) continue;
                    Object value = formatFieldData.getFieldValueDesc();
                    if (value instanceof Object[] && ((Object[])value)[1] != null && ((Object[])value)[1] instanceof BigDecimal) {
                        value = ((Object[])value)[1];
                    }
                    this.getModel().setValue(selectField, value, index);
                }
            }
            selectedIds.add(invId);
        }
        this.getPageCache().put("selectedrows", SerializationUtils.toJsonString(selectedIds));
    }

    private void formatAuxProp(FormatFieldData formatFieldData) {
        Object fieldValue = formatFieldData.getFieldValue();
        if (fieldValue instanceof List) {
            List fieldValueList = (List)fieldValue;
            StringBuilder valueBuilder = new StringBuilder();
            for (Object listValue : fieldValueList) {
                if (!(listValue instanceof Map)) continue;
                Map fieldValueTmp = (Map)listValue;
                Object flexValueVObject = fieldValueTmp.get("alias");
                if (valueBuilder.length() > 0) {
                    valueBuilder.append(";");
                }
                if (flexValueVObject instanceof Object[] && ((Object[])flexValueVObject).length > 1) {
                    valueBuilder.append(((Object[])flexValueVObject)[1]);
                    continue;
                }
                if (!(flexValueVObject instanceof String)) continue;
                valueBuilder.append(flexValueVObject);
            }
            formatFieldData.setFieldValueDesc((Object)valueBuilder.toString());
        }
    }
}

