/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.acc.close;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.EnumBillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.executor.ExecutorService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.business.balance.recal.BalReCalCache;
import kd.scmc.im.business.helper.acct.CloseAcctHelper;
import kd.scmc.im.consts.CloseAccountConst;
import kd.scmc.im.formplugin.acc.close.CloseAcctHandler;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.DateUtils;

public class CloseAccountTask
extends AbstractTask {
    private static Log log = LogFactory.getLog(CloseAccountTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        List<Object> pks;
        Map customParams = (Map)map.get("customParams");
        if (customParams == null) {
            return;
        }
        String requestId = (String)customParams.get("requestId");
        String selectRowsStr = (String)customParams.get("selectRows");
        int totalRows = (Integer)customParams.get("totalRows");
        String successRowsStr = (String)customParams.get("successRows");
        String dateEqualLastDateRowsStr = customParams.get("dateEqualLastDateRows").toString();
        List rows = (List)SerializationUtils.fromJsonString((String)selectRowsStr, List.class);
        List successRows = (List)SerializationUtils.fromJsonString((String)successRowsStr, List.class);
        List dateEqualLastDateRows = (List)SerializationUtils.fromJsonString((String)dateEqualLastDateRowsStr, List.class);
        int[] selectRows = Arrays.stream(rows.toArray(new Integer[0])).mapToInt(Integer::valueOf).toArray();
        log.info("taskid={},\u9009\u4e2d\u884c\u4e0b\u6807={}", (Object)this.taskId, (Object)Arrays.toString(selectRows));
        String itemKey = customParams.get("itemKey") == null ? "" : (String)customParams.get("itemKey");
        HashMap<String, Boolean> checkMap = customParams.get("checkMap") == null ? new HashMap(4) : (Map)customParams.get("checkMap");
        List list = pks = customParams.get("pks") == null ? new ArrayList(4) : (List)customParams.get("pks");
        if (pks == null || pks.isEmpty()) {
            return;
        }
        Map rowIdxToDate = customParams.get("rowIdxToDate") == null ? new HashMap(1) : (Map)customParams.get("rowIdxToDate");
        DynamicObjectCollection dataEntities = this.getData(pks, rowIdxToDate);
        if (dataEntities == null || dataEntities.isEmpty()) {
            return;
        }
        HashMap<String, Object> returnData = new HashMap<String, Object>(4);
        Map<Boolean, List<DLock>> locksMap = this.getLocks(dataEntities, selectRows);
        Boolean allLocks = locksMap.keySet().toArray(new Boolean[0])[0];
        if (!allLocks.booleanValue()) {
            this.unLocks(locksMap.get(allLocks));
            Map<Integer, Map<String, Object>> result = this.getLockFailMsg(selectRows, itemKey);
            returnData.put("returndata", result);
            this.feedbackProgressing(totalRows, selectRows.length, returnData, requestId);
            this.feedbackCustomdata(returnData);
            return;
        }
        try (TXHandle h = TX.requiresNew((String)String.format("scm/im/%s", itemKey));){
            try {
                Map<Integer, Map<String, Object>> result = "asynccloseaccountbtn".equals(itemKey) ? this.handleClose(dataEntities, selectRows, successRows, dateEqualLastDateRows, checkMap) : this.handleUnclose(dataEntities, selectRows, checkMap);
                returnData.put("returndata", result);
                this.feedbackProgressing(totalRows, selectRows.length, returnData, requestId);
                this.feedbackCustomdata(returnData);
            }
            catch (Exception e) {
                h.markRollback();
                log.error("\u6267\u884c\u51fa\u9519\uff0c\u64cd\u4f5ckey=" + itemKey + ",\u9009\u4e2d\u884c=" + Arrays.toString(selectRows) + ",taskid=" + this.taskId + ",exception={}", (Throwable)e);
                throw e;
            }
            finally {
                this.unLocks(locksMap.get(allLocks));
            }
        }
    }

    private Map<Integer, Map<String, Object>> getLockFailMsg(int[] selectRows, String itemKey) {
        HashMap<Integer, Map<String, Object>> failIndexToReasonMap = new HashMap<Integer, Map<String, Object>>(selectRows.length * 2);
        for (int selectRow : selectRows) {
            Map propKeyToReasonMap = failIndexToReasonMap.computeIfAbsent(selectRow, key -> new HashMap(8));
            propKeyToReasonMap.put("failreason", ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u5173\u8d26/\u53cd\u5173\u8d26\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"imCloseaccount_7", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            if ("asynccloseaccountbtn".equals(itemKey)) {
                propKeyToReasonMap.put("result", EnumBillStatus.B);
                continue;
            }
            propKeyToReasonMap.put("result", EnumBillStatus.D);
        }
        return failIndexToReasonMap;
    }

    private Map<Integer, Map<String, Object>> handleUnclose(DynamicObjectCollection dataEntity, int[] selectRows, Map<String, Boolean> checkMap) {
        HashMap<Integer, Map<String, Object>> failIndexToReasonMap = new HashMap<Integer, Map<String, Object>>(dataEntity.size() * 2);
        ArrayList deleteIds = new ArrayList();
        ArrayList<Integer> successRows = new ArrayList<Integer>();
        Map execInfos = CloseAcctHelper.checkLastCloseDate((DynamicObjectCollection)dataEntity, (int[])selectRows, successRows, deleteIds);
        this.getCloseDateCheckInfo(EnumBillStatus.D.toString(), execInfos, failIndexToReasonMap);
        if (deleteIds.isEmpty()) {
            return failIndexToReasonMap;
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"im_closeaccountrecord");
        DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])deleteIds.toArray(new Object[0]));
        Map lastCloseDateMap = CloseAcctHelper.batchGetCloseDateMap((DynamicObjectCollection)dataEntity, successRows, (boolean)true);
        ArrayList<AppLogInfo> appLogInfoList = new ArrayList<AppLogInfo>(selectRows.length);
        for (int rowIndex : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)dataEntity.get(rowIndex);
            Object name = dynamicObject.getDynamicObject("org").get("name");
            Object warehouseName = dynamicObject.getDynamicObject("warehouse").get("name");
            Date closeDate = dynamicObject.getDate("lastclosedate");
            String description = successRows.contains(rowIndex) ? String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d+\u4ed3\u5e93\u201c%2$s\u201d\u53cd\u5173\u8d26\u6210\u529f\uff0c\u5173\u8d26\u65e5\u671f%3$s\u3002", (String)"imCloseaccount_5", (String)"scmc-im-formplugin", (Object[])new Object[0]), name.toString(), warehouseName.toString(), DateUtils.getDateString((Date)closeDate)) : String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d+\u4ed3\u5e93\u201c%2$s\u201d\u53cd\u5173\u8d26\u5931\u8d25\u3002", (String)"imCloseaccount_6", (String)"scmc-im-formplugin", (Object[])new Object[0]), name.toString(), warehouseName.toString());
            appLogInfoList.add(this.getAppLogInfo(description));
        }
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        service.addBatchLog(appLogInfoList);
        this.getDataAfterClose(dataEntity, successRows, failIndexToReasonMap, lastCloseDateMap);
        return failIndexToReasonMap;
    }

    public Map<Integer, Map<String, Object>> handleClose(DynamicObjectCollection dataEntity, int[] selectRows, List<Integer> successRows, List<Integer> dateEqualLastDateRows, Map<String, Boolean> checkMap) {
        HashMap<Integer, Map<String, Object>> failIndexToReasonMap = new HashMap<Integer, Map<String, Object>>(dataEntity.size() * 2);
        ArrayList updateDycs = new ArrayList(16);
        Map unAuditCheckMsgMap = CloseAcctHelper.checkUnAuditBill((DynamicObjectCollection)dataEntity, successRows, checkMap);
        Map omcToAPBillCheckMsgMap = CloseAcctHelper.checkOmcToAPBill((DynamicObjectCollection)dataEntity, successRows, checkMap);
        Map settleBillCheckMsgMap = CloseAcctHelper.checkUnSettleBill((DynamicObjectCollection)dataEntity, successRows, checkMap);
        List<Integer> failRows = CloseAcctHandler.getFailRows(dataEntity, successRows, unAuditCheckMsgMap, omcToAPBillCheckMsgMap, settleBillCheckMsgMap);
        CloseAcctHelper.updateCloseRecord((DynamicObjectCollection)dataEntity, successRows, updateDycs, dateEqualLastDateRows, failRows);
        List<Integer> rows = Arrays.stream(selectRows).boxed().collect(Collectors.toList());
        rows.removeAll(successRows);
        this.getFailReason(dataEntity, unAuditCheckMsgMap, omcToAPBillCheckMsgMap, settleBillCheckMsgMap, rows, failIndexToReasonMap);
        if (!successRows.isEmpty()) {
            new CloseAcctHandler(null).changeBillBookDate(successRows, dataEntity, checkMap);
            SaveServiceHelper.save((DynamicObject[])updateDycs.toArray(new DynamicObject[0]));
            this.getDataAfterClose(dataEntity, successRows, failIndexToReasonMap, null);
        }
        ArrayList<AppLogInfo> appLogInfoList = new ArrayList<AppLogInfo>(selectRows.length);
        for (int rowIndex : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)dataEntity.get(rowIndex);
            Object name = dynamicObject.getDynamicObject("org").get("name");
            Object warehouseName = dynamicObject.getDynamicObject("warehouse").get("name");
            Date closeDate = dynamicObject.getDate("closedate");
            String description = successRows.contains(rowIndex) ? String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d+\u4ed3\u5e93\u201c%2$s\u201d\u5173\u8d26\u6210\u529f\uff0c\u5173\u8d26\u65e5\u671f%3$s\u3002", (String)"imCloseaccount_2", (String)"scmc-im-formplugin", (Object[])new Object[0]), name.toString(), warehouseName.toString(), DateUtils.getDateString((Date)closeDate)) : String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d+\u4ed3\u5e93\u201c%2$s\u201d\u5173\u8d26\u5931\u8d25\uff0c\u5173\u8d26\u65e5\u671f%3$s\u3002", (String)"imCloseaccount_3", (String)"scmc-im-formplugin", (Object[])new Object[0]), name.toString(), warehouseName.toString(), DateUtils.getDateString((Date)closeDate));
            appLogInfoList.add(this.getAppLogInfo(description));
        }
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        service.addBatchLog(appLogInfoList);
        return failIndexToReasonMap;
    }

    protected void getDataAfterClose(DynamicObjectCollection dataEntity, List<Integer> successRows, Map<Integer, Map<String, Object>> failIndexToReasonMap, Map<String, DynamicObject> lastCloseDateMap) {
        for (Integer rowIndex : successRows) {
            Map propKeyToReasonMap = failIndexToReasonMap.computeIfAbsent(rowIndex, key -> new HashMap(8));
            propKeyToReasonMap.put("unauditbill_tag", null);
            propKeyToReasonMap.put("unomcbill_tag", null);
            propKeyToReasonMap.put("unsettlebill_tag", null);
            propKeyToReasonMap.put("failreason", null);
            if (lastCloseDateMap == null) {
                propKeyToReasonMap.put("lastclosedate", ((DynamicObject)dataEntity.get(rowIndex.intValue())).get("closedate"));
                propKeyToReasonMap.put("result", EnumBillStatus.A);
                continue;
            }
            DynamicObject orgDyc = ((DynamicObject)dataEntity.get(rowIndex.intValue())).getDynamicObject("org");
            DynamicObject warehouseDyc = ((DynamicObject)dataEntity.get(rowIndex.intValue())).getDynamicObject("warehouse");
            String closeDateKey = orgDyc.getPkValue() + "," + warehouseDyc.getPkValue();
            DynamicObject record = lastCloseDateMap.get(closeDateKey);
            propKeyToReasonMap.put("lastclosedate", CommonUtils.isNull((Object)record) ? null : record.getDate("closedate"));
            propKeyToReasonMap.put("result", EnumBillStatus.C);
            propKeyToReasonMap.put("closedate", DateUtils.getDayStartTime((Date)new Date()));
        }
    }

    protected void getCloseDateCheckInfo(String result, Map<Integer, String> execInfoMap, Map<Integer, Map<String, Object>> failIndexToReasonMap) {
        if (execInfoMap.keySet().isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, String> item : execInfoMap.entrySet()) {
            Integer rowIndex = item.getKey();
            Map propKeyToReasonMap = failIndexToReasonMap.computeIfAbsent(rowIndex, key -> new HashMap(8));
            propKeyToReasonMap.put("unauditbill_tag", null);
            propKeyToReasonMap.put("unomcbill_tag", null);
            propKeyToReasonMap.put("unsettlebill_tag", null);
            propKeyToReasonMap.put("failreason", item.getValue());
            propKeyToReasonMap.put("result", result);
        }
    }

    protected Map<Integer, Map<String, Object>> getFailReason(DynamicObjectCollection dataEntity, Map<String, Map<String, String>> unAuditBillInfo, Map<String, Map<String, String>> omcToAPBillInfo, Map<String, Map<String, String>> settleBillInfo, List<Integer> failRows, Map<Integer, Map<String, Object>> failIndexToReasonMap) {
        for (Integer failRow : failRows) {
            Map propKeyToReasonMap = failIndexToReasonMap.computeIfAbsent(failRow, key -> new HashMap(8));
            DynamicObject org = ((DynamicObject)dataEntity.get(failRow.intValue())).getDynamicObject("org");
            DynamicObject warehouse = ((DynamicObject)dataEntity.get(failRow.intValue())).getDynamicObject("warehouse");
            if (org == null || warehouse == null) continue;
            Long orgId = org.getLong("id");
            Long warehouseId = warehouse.getLong("id");
            String orgWarehouseKey = CloseAcctHelper.getOrgWarehouseKey((String)orgId.toString(), (String)warehouseId.toString());
            Map unAuditInfos = unAuditBillInfo.getOrDefault(orgWarehouseKey, new HashMap());
            Map omcApInfos = omcToAPBillInfo.getOrDefault(orgWarehouseKey, new HashMap());
            Map settleInfos = settleBillInfo.getOrDefault(orgWarehouseKey, new HashMap());
            propKeyToReasonMap.put("result", EnumBillStatus.B.toString());
            if (unAuditInfos.isEmpty() && omcApInfos.isEmpty() && settleInfos.isEmpty()) continue;
            StringBuilder failReason = new StringBuilder();
            if (!unAuditInfos.isEmpty()) {
                if (!omcApInfos.isEmpty() && !settleInfos.isEmpty()) {
                    failReason.append(CloseAccountConst.getSubmitOrSaveBill()).append(CloseAccountConst.getOmcBill()).append(CloseAccountConst.getSettleBill());
                } else if (!omcApInfos.isEmpty()) {
                    failReason.append(CloseAccountConst.getSubmitOrSaveBill()).append(CloseAccountConst.getOmcBill());
                } else if (!settleInfos.isEmpty()) {
                    failReason.append(CloseAccountConst.getSubmitOrSaveBill()).append(CloseAccountConst.getSettleBill());
                } else {
                    failReason.append(CloseAccountConst.getSubmitOrSaveBill());
                }
            } else if (!omcApInfos.isEmpty()) {
                if (!settleInfos.isEmpty()) {
                    failReason.append(CloseAccountConst.getOmcBill()).append(CloseAccountConst.getSettleBill());
                } else {
                    failReason.append(CloseAccountConst.getOmcBill());
                }
            } else if (!settleInfos.isEmpty()) {
                failReason.append(CloseAccountConst.getSettleBill());
            }
            if (failReason.lastIndexOf(";") != -1) {
                failReason.deleteCharAt(failReason.lastIndexOf(";"));
            }
            propKeyToReasonMap.put("failreason", failReason);
            propKeyToReasonMap.put("unauditbill_tag", SerializationUtils.toJsonString((Object)unAuditInfos));
            propKeyToReasonMap.put("unomcbill_tag", SerializationUtils.toJsonString((Object)omcApInfos));
            propKeyToReasonMap.put("unsettlebill_tag", SerializationUtils.toJsonString((Object)settleInfos));
        }
        return failIndexToReasonMap;
    }

    private Map<String, String> getFailBillsMapByOrgAndWarehouse(Map<String, DynamicObjectCollection> failInfosMap, String checkMsg, Long orgId, Long warehouseId) {
        HashMap<String, String> failBillsMap = new HashMap<String, String>(16);
        for (Map.Entry<String, DynamicObjectCollection> map : failInfosMap.entrySet()) {
            DynamicObjectCollection failBills = this.getFailBillsByOrgAndWareHouse(orgId, warehouseId, map.getValue());
            if (failBills.isEmpty()) continue;
            String entityName = "";
            String tipMsg = "";
            switch (checkMsg) {
                case "checkboxsubmit": {
                    entityName = map.getKey();
                    tipMsg = this.getBillStatus(failBills);
                    break;
                }
                case "checkomctoap": {
                    entityName = map.getKey();
                    tipMsg = CloseAccountConst.getNotConvertAp();
                    break;
                }
                case "checksettlestatus": {
                    String formMsg = map.getKey();
                    String[] splits = formMsg.split(",");
                    entityName = splits[0];
                    String resultMsg = splits[1];
                    tipMsg = this.getSettleMsg(resultMsg);
                    break;
                }
            }
            tipMsg = tipMsg + "#" + entityName;
            String localEntityName = EntityMetadataCache.getDataEntityType((String)entityName).getDisplayName().getLocaleValue();
            HashSet<String> numbers = new HashSet<String>(16);
            for (DynamicObject failBill : failBills) {
                String billNo = failBill.getString("billno");
                numbers.add(billNo);
            }
            String billNo = StringUtils.join((Object[])numbers.toArray(), (String)",");
            failBillsMap.put(String.format(tipMsg, localEntityName), billNo);
        }
        return failBillsMap;
    }

    private String getBillStatus(DynamicObjectCollection dynamicCollection) {
        String billHint = CloseAccountConst.getUNAUDITFORMAT();
        HashSet billStatus = new HashSet();
        dynamicCollection.forEach(oneBill -> billStatus.add((String)oneBill.get("billstatus")));
        if (CollectionUtils.isEmpty(billStatus)) {
            return billHint;
        }
        if (billStatus.contains(EnumBillStatus.A.toString()) && billStatus.contains(EnumBillStatus.B.toString())) {
            billHint = CloseAccountConst.getTEMPORARYANDSUBMITFORMAT();
        } else if (billStatus.contains(EnumBillStatus.A.toString())) {
            billHint = CloseAccountConst.getTEMPORARYSTORAGEFORMAT();
        } else if (billStatus.contains(EnumBillStatus.B.toString())) {
            billHint = CloseAccountConst.getSUBMITFORMAT();
        }
        return billHint;
    }

    private String getSettleMsg(String resultMSg) {
        String settleMsg = null;
        if ("nosettle".equals(resultMSg)) {
            settleMsg = CloseAccountConst.getNotSETTLE();
        } else if ("settlefail".equals(resultMSg)) {
            settleMsg = CloseAccountConst.getSETTLEFAILED();
        }
        return settleMsg;
    }

    private DynamicObjectCollection getFailBillsByOrgAndWareHouse(Object orgId, Object warehouseId, DynamicObjectCollection dyc) {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        for (DynamicObject item : dyc) {
            if (!item.get("org").equals(orgId) || !item.get("warehouse").equals(warehouseId)) continue;
            dynamicObjectCollection.add((Object)item);
        }
        return dynamicObjectCollection;
    }

    private AppLogInfo getAppLogInfo(String opDescription) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setBizObjID("im_closeaccount");
        appLogInfo.setBizAppID("=9Q86DR2P+Q");
        appLogInfo.setUserID(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        appLogInfo.setOpTime(new Date());
        MultiLangEnumBridge langEnumBridge = new MultiLangEnumBridge("\u5173\u8d26", "imCloseaccount_1", "scmc-im-formplugin");
        appLogInfo.setOpName("close", langEnumBridge);
        appLogInfo.setOpDescription(opDescription);
        return appLogInfo;
    }

    private DynamicObjectCollection getData(List<Object> pks, Map<Integer, Object> rowIdxToDate) {
        Map orgWarehouseMap = BusinessDataServiceHelper.loadFromCache((Object[])pks.toArray(), (String)"im_warehousesetup");
        DynamicObject[] orgWarehouses = orgWarehouseMap.values().toArray(new DynamicObject[0]);
        if (CommonUtils.isNull((Object)orgWarehouses)) {
            return null;
        }
        int size = orgWarehouses.length;
        int MaxNum = 128;
        HashMap closeDateMap = new HashMap(16);
        HashSet<DynamicObject> orgWareHouseSet = new HashSet<DynamicObject>(16);
        if (size >= MaxNum) {
            for (DynamicObject orgWarehouse : orgWarehouses) {
                orgWareHouseSet.add(orgWarehouse);
                if (orgWareHouseSet.size() != MaxNum) continue;
                closeDateMap.putAll(CloseAcctHelper.getCloseDateMap((DynamicObject[])orgWareHouseSet.toArray(new DynamicObject[0])));
                orgWareHouseSet.clear();
            }
            if (!orgWareHouseSet.isEmpty()) {
                closeDateMap.putAll(CloseAcctHelper.getCloseDateMap((DynamicObject[])orgWareHouseSet.toArray(new DynamicObject[0])));
            }
        } else {
            closeDateMap.putAll(CloseAcctHelper.getCloseDateMap((DynamicObject[])orgWarehouses));
        }
        DynamicObject closeAccountDy = BusinessDataServiceHelper.newDynamicObject((String)"im_closeaccount");
        DynamicObjectCollection dataEntities = closeAccountDy.getDynamicObjectCollection("billentry");
        for (int i = 0; i < orgWarehouses.length; ++i) {
            DynamicObject orgDyc = orgWarehouses[i].getDynamicObject("org");
            DynamicObject warehouseDyc = orgWarehouses[i].getDynamicObject("warehouse");
            DynamicObject row = dataEntities.addNew();
            row.set("org", (Object)orgDyc);
            row.set("warehouse", (Object)warehouseDyc);
            if (orgDyc != null && warehouseDyc != null) {
                String closeDateKey = orgDyc.getPkValue() + "," + warehouseDyc.getPkValue();
                DynamicObject record = (DynamicObject)closeDateMap.get(closeDateKey);
                row.set("lastclosedate", CommonUtils.isNull((Object)record) ? null : record.getDate("closedate"));
            }
            row.set("closedate", (Object)DateUtils.getDayStartTime((Date)new Date()));
            if (rowIdxToDate.get(i) == null) continue;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                row.set("closedate", (Object)sdf.parse(rowIdxToDate.get(i).toString()));
                continue;
            }
            catch (ParseException e) {
                throw new KDBizException(e.getMessage());
            }
        }
        return dataEntities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void feedbackProgressing(int total, int complete, Map<String, Object> returnData, String requestId) {
        block20: {
            returnData.put("total", String.valueOf(total));
            returnData.put("complete", String.valueOf(complete));
            try (DLock lock = DLock.create((String)(RequestContext.get().getAccountId() + requestId)).fastMode();){
                if (!lock.tryLock()) break block20;
                try {
                    IAppCache imAppCache = BalReCalCache.getImAppCache();
                    Object completedCount = imAppCache.get(requestId, String.class);
                    if (completedCount != null) {
                        complete += Integer.parseInt(completedCount.toString());
                    }
                    imAppCache.put(requestId, (Object)complete);
                    int progress = 0;
                    if (total != 0) {
                        progress = complete * 100 / total;
                    }
                    if (progress >= 100) {
                        progress = 99;
                    } else if (progress < 0) {
                        progress = 0;
                    }
                    String desc = String.format(ResManager.loadKDString((String)"\u5171%2$s\u6761\uff0c\u5df2\u5904\u7406%1$s\u6761\u3002", (String)"ClosingAccountPlugin_3", (String)"scmc-im-formplugin", (Object[])new Object[0]), complete, total);
                    ExecutorService.getInstance().getObjectFactory().getTaskDao().updateProgress(this.taskId, progress, desc, returnData);
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    private Map<Boolean, List<DLock>> getLocks(DynamicObjectCollection dataEntity, int[] selectRows) {
        HashMap<Boolean, List<DLock>> result = new HashMap<Boolean, List<DLock>>();
        ArrayList locks = new ArrayList();
        Map allowOp = CloseAcctHelper.isAllowOp((DynamicObjectCollection)dataEntity, (int[])selectRows, locks);
        Boolean allow = allowOp.keySet().toArray(new Boolean[0])[0];
        result.put(allow, locks);
        return result;
    }

    protected void unLocks(List<DLock> locks) {
        for (DLock item : locks) {
            item.unlock();
        }
    }
}

