/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.acc.close;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.RouteMode;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;

public class ClosingAccountPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    public static final String CACHEKEY_TASKID = "closeaccount_taskid";
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String TO_BACKGROUND = "btncancel";
    private static final String CONFIRMED_TOBACKGROUND = "CLOSE_CONFIRMED_TOBACKGROUND";
    private static final String CACHEKEY_ISSTART = "isstart";
    private static final String KEY_TOTAL = "total";
    private static final String KEY_COMPLETE = "complete";
    private static Log log = LogFactory.getLog(ClosingAccountPlugin.class);
    private boolean canClose = false;

    public void initialize() {
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESSBARAP);
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{TO_BACKGROUND});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter params = this.getView().getFormShowParameter();
        Map customParams = params.getCustomParams();
        List selectRowList = customParams.get("selectRows") == null ? new ArrayList(1) : (List)customParams.get("selectRows");
        this.getView().getPageCache().put("selectRows", SerializationUtils.toJsonString(selectRowList));
        DynamicObject acctTaskConf = BusinessDataServiceHelper.loadSingle((String)"im_closeacct_taskconf", (String)"execrowspertask", (QFilter[])new QFilter("number", "=", (Object)"im_closeacct_execrows").toArray());
        Object execRowsPerTask = acctTaskConf.get("execrowspertask");
        this.getView().getPageCache().put("execrowspertask", execRowsPerTask.toString());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
        try {
            progressBar.start();
        }
        catch (Throwable ex) {
            progressBar.setPercent(100, ResManager.loadKDString((String)"\u5f02\u5e38\u4e2d\u65ad", (String)"ClosingAccountPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            String errMsg = ex instanceof KDBizException ? ex.getMessage() : ResManager.loadKDString((String)"\u5173\u8d26\u5931\u8d25\u3002", (String)"ClosingAccountPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
        }
        String taskId = this.getTaskId();
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            progressBar.setPercent(progress);
        }
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(CACHEKEY_TASKID)) {
            return (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_TASKID);
        }
        return this.getPageCache().get(CACHEKEY_TASKID);
    }

    public void click(EventObject evt) {
        String controlKey;
        super.click(evt);
        switch (controlKey = ((Control)evt.getSource()).getKey()) {
            case "btncancel": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u628a\u5173\u8d26\u8f6c\u4e3a\u540e\u53f0\u6267\u884c?", (String)"ClosingAccountPlugin_2", (String)"scmc-im-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMED_TOBACKGROUND, (IFormPlugin)this));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        String callBackId;
        super.confirmCallBack(messageboxclosedevent);
        switch (callBackId = messageboxclosedevent.getCallBackId()) {
            case "CLOSE_CONFIRMED_TOBACKGROUND": {
                this.confirmToBackGround(messageboxclosedevent);
                break;
            }
        }
    }

    private void confirmToBackGround(MessageBoxClosedEvent messageboxclosedevent) {
        if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.toBackground();
        }
    }

    private void toBackground() {
        this.closeForm();
        String taskIdList = this.getView().getPageCache().get("taskIdList");
        if (taskIdList == null || StringUtils.isEmpty((CharSequence)taskIdList)) {
            return;
        }
        List taskIds = (List)SerializationUtils.fromJsonString((String)taskIdList, List.class);
        String jobFormInfoStr = this.getView().getPageCache().get("jobFormInfo");
        Map jobFormInfoMap = (Map)SerializationUtils.fromJsonString((String)jobFormInfoStr, Map.class);
        for (String taskId : taskIds) {
            if (StringUtils.isBlank((CharSequence)taskId)) continue;
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (TaskClientProxy.isExistTask((String)taskId)) continue;
            Object jobFormObj = jobFormInfoMap.get(taskId);
            JobFormInfo jobFormInfo = null;
            if (jobFormObj instanceof LinkedHashMap) {
                jobFormInfo = this.getJobFormInfo((LinkedHashMap)jobFormObj);
            }
            if (jobFormInfo == null) continue;
            TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
            ThreadPools.executeOnce((String)("accttask-background-monitor" + taskId), (Runnable)subscriber);
        }
    }

    private JobFormInfo getJobFormInfo(LinkedHashMap jobFormObj) {
        if (jobFormObj == null || jobFormObj.get("jobInfo") == null) {
            return null;
        }
        LinkedHashMap jobInfoMap = (LinkedHashMap)jobFormObj.get("jobInfo");
        JobInfo jobInfo = new JobInfo();
        jobInfo.setParams((Map)jobInfoMap.get("params"));
        jobInfo.setName((String)jobInfoMap.get("name"));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRouteMode(RouteMode.SHARDINGTASK);
        jobInfo.setTaskClassname("kd.scmc.im.formplugin.acc.close.CloseAccountTask");
        jobInfo.setAppId("im");
        jobInfo.setRunConcurrently(true);
        jobInfo.setNumber((String)jobInfoMap.get("number"));
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(this.getView().getFormShowParameter().getParentPageId());
        jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
        jobFormInfo.setTimeout(300);
        CloseCallBack closeCallBack = new CloseCallBack("kd.scmc.im.formplugin.acc.close.ClosingAcctCallBack", "taskclosecallback");
        jobFormInfo.setCloseCallBack(closeCallBack);
        return jobFormInfo;
    }

    private void closeForm() {
        this.canClose = true;
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getView().close();
    }

    public void onProgress(ProgressEvent e) {
        boolean start = this.isStart();
        this.setStart(true);
        String taskIdList = this.getView().getPageCache().get("taskIdList");
        List taskIds = taskIdList == null || StringUtils.isEmpty((CharSequence)taskIdList) ? new ArrayList(64) : (List)SerializationUtils.fromJsonString((String)taskIdList, List.class);
        if (!start && taskIds.isEmpty()) {
            this.dispatchTask(taskIds);
            log.info("\u5206\u53d1\u4efb\u52a1\uff1ataskId\u96c6\u5408={}", taskIds);
            return;
        }
        if (taskIds.isEmpty()) {
            return;
        }
        String completedTaskStr = this.getView().getPageCache().get("taskInfoMap");
        Map completedTaskInfoMap = completedTaskStr == null || StringUtils.isEmpty((CharSequence)completedTaskStr) ? new HashMap(64) : (Map)SerializationUtils.fromJsonString((String)completedTaskStr, Map.class);
        if (completedTaskInfoMap.keySet().containsAll(taskIds)) {
            this.processReturnData(completedTaskInfoMap);
            e.setProgress(100);
            this.stopBar();
            this.closeForm();
            return;
        }
        for (String taskId : taskIds) {
            TaskInfo taskInfo;
            if (completedTaskInfoMap.containsKey(taskId) || !(taskInfo = ScheduleServiceHelper.queryTask((String)taskId)).isTaskEnd()) continue;
            completedTaskInfoMap.put((String)taskInfo.getId(), (Object)taskInfo);
        }
        this.getView().getPageCache().put("taskInfoMap", SerializationUtils.toJsonString(completedTaskInfoMap));
        this.dealProcessDetial(e, completedTaskInfoMap);
    }

    private void processReturnData(Map<String, Object> completedTaskInfoMap) {
        HashMap result = new HashMap(4);
        HashMap returnData = new HashMap(completedTaskInfoMap.size());
        for (Map.Entry<String, Object> taskInfoEntry : completedTaskInfoMap.entrySet()) {
            Map taskData;
            Object taskInfoVal = taskInfoEntry.getValue();
            String strData = null;
            if (taskInfoVal instanceof TaskInfo) {
                TaskInfo taskInfo = (TaskInfo)taskInfoVal;
                strData = taskInfo.getData();
            } else if (taskInfoVal instanceof LinkedHashMap) {
                LinkedHashMap taskInfoMap = (LinkedHashMap)taskInfoVal;
                String string = strData = taskInfoMap.get("data") == null ? null : (String)taskInfoMap.get("data");
            }
            if (StringUtils.isBlank(strData) || !(taskData = (Map)SerializationUtils.fromJsonString((String)strData, Map.class)).containsKey("returndata")) continue;
            LinkedHashMap data = (LinkedHashMap)taskData.get("returndata");
            returnData.putAll(data);
        }
        result.put("returndata", returnData);
        this.getView().returnDataToParent(result);
    }

    private void dealProcessDetial(ProgressEvent e, Map<String, Object> completedTaskInfoMap) {
        int completeCounter = 0;
        for (Map.Entry<String, Object> taskInfoEntry : completedTaskInfoMap.entrySet()) {
            Map data;
            Object taskInfoVal = taskInfoEntry.getValue();
            String strData = null;
            if (taskInfoVal instanceof TaskInfo) {
                TaskInfo taskInfo = (TaskInfo)taskInfoVal;
                strData = taskInfo.getData();
            } else if (taskInfoVal instanceof LinkedHashMap) {
                LinkedHashMap taskInfoMap = (LinkedHashMap)taskInfoVal;
                String string = strData = taskInfoMap.get("data") == null ? null : (String)taskInfoMap.get("data");
            }
            if (StringUtils.isBlank(strData) || !(data = (Map)SerializationUtils.fromJsonString((String)strData, Map.class)).containsKey(KEY_COMPLETE)) continue;
            completeCounter += Integer.parseInt(String.valueOf(data.get(KEY_COMPLETE)));
        }
        String selectRowsString = this.getView().getPageCache().get("selectRows");
        List selectList = (List)SerializationUtils.fromJsonString((String)selectRowsString, List.class);
        Label totalLabel = (Label)this.getControl(KEY_TOTAL);
        totalLabel.setText(String.valueOf(selectList.size()));
        Label completeLabel = (Label)this.getControl(KEY_COMPLETE);
        completeLabel.setText(String.valueOf(completeCounter));
        int process = completeCounter * 100 / selectList.size();
        if (process >= 100) {
            process = 99;
        }
        e.setProgress(process);
    }

    private void dispatchTask(List<String> taskIds) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String selectRowsString = this.getView().getPageCache().get("selectRows");
        String execRowsPerTask = this.getView().getPageCache().get("execrowspertask");
        List selectList = (List)SerializationUtils.fromJsonString((String)selectRowsString, List.class);
        int[] selectRows = Arrays.stream(selectList.toArray(new Integer[0])).mapToInt(Integer::valueOf).toArray();
        int rowsLimitPerTask = Integer.parseInt(execRowsPerTask);
        HashMap<String, JobFormInfo> taskIdToJobFom = new HashMap<String, JobFormInfo>(selectRows.length * 2);
        int index = 0;
        for (int i = 0; i < selectRows.length; i += rowsLimitPerTask) {
            ++index;
            HashMap params = new HashMap();
            int end = Math.min(i + rowsLimitPerTask, selectRows.length);
            int[] currentExecRows = Arrays.copyOfRange(selectRows, i, end);
            HashMap<String, String> param = new HashMap<String, String>(8);
            param.putAll(customParams);
            String selectRowStr = SerializationUtils.toJsonString(Arrays.stream(currentExecRows).boxed().collect(Collectors.toList()));
            param.put("selectRows", selectRowStr);
            param.put("successRows", selectRowStr);
            params.put("customParams", param);
            JobInfo jobInfo = new JobInfo();
            jobInfo.setParams(params);
            if ("asynccloseaccountbtn".equals(customParams.get("itemKey"))) {
                jobInfo.setName(ResManager.loadKDString((String)"\u5173\u8d26", (String)"imCloseaccount_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            } else {
                jobInfo.setName(ResManager.loadKDString((String)"\u53cd\u5173\u8d26", (String)"imCloseaccount_4", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            jobInfo.setJobType(JobType.REALTIME);
            jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
            jobInfo.setRunByLang(Lang.get());
            jobInfo.setRouteMode(RouteMode.SHARDINGTASK);
            jobInfo.setAppId("im");
            jobInfo.setTaskClassname("kd.scmc.im.formplugin.acc.close.CloseAccountTask");
            jobInfo.setRunConcurrently(true);
            jobInfo.setNumber("SCMC_IM_ASYNC_CLOSEACCT_" + index);
            JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
            jobFormInfo.setParentPageId(this.getView().getFormShowParameter().getParentPageId());
            jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
            CloseCallBack closeCallBack = new CloseCallBack("kd.scmc.im.formplugin.acc.close.ClosingAcctCallBack", "taskclosecallback");
            jobFormInfo.setCloseCallBack(closeCallBack);
            String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
            taskIds.add(taskId);
            taskIdToJobFom.put(taskId, jobFormInfo);
        }
        this.getView().getPageCache().put("jobFormInfo", SerializationUtils.toJsonString(taskIdToJobFom));
        this.getView().getPageCache().put("taskIdList", SerializationUtils.toJsonString(taskIds));
        Label totalLabel = (Label)this.getControl(KEY_TOTAL);
        totalLabel.setText(String.valueOf(selectList.size()));
        Label completeLabel = (Label)this.getControl(KEY_COMPLETE);
        completeLabel.setText("0");
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        bar.stop();
    }

    private boolean isStart() {
        String start = this.getPageCache().get(CACHEKEY_ISSTART);
        if (StringUtils.isBlank((CharSequence)start)) {
            return false;
        }
        return Boolean.parseBoolean(start);
    }

    private void setStart(boolean start) {
        this.getPageCache().put(CACHEKEY_ISSTART, String.valueOf(start));
    }
}

