/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.acc.close;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.EnumBillStatus;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scmc.im.business.helper.acct.CloseAcctHelper;
import kd.scmc.im.formplugin.acc.close.CloseAccountPlugin;
import kd.scmc.im.formplugin.acc.close.ICloseAcctHandler;
import kd.scmc.im.utils.DateUtils;

public class UnCloseAcctHandler
implements ICloseAcctHandler {
    private final CloseAccountPlugin closeAccountPlugin;

    public UnCloseAcctHandler(CloseAccountPlugin closeAccountPlugin) {
        this.closeAccountPlugin = closeAccountPlugin;
    }

    @Override
    public void handle(DynamicObjectCollection dataEntity, int[] selectRows, List<Integer> successCloseRows, List<Integer> dateEqualLastDateRows, Map<String, Boolean> checkMap) {
        ArrayList deleteIds = new ArrayList();
        ArrayList<Integer> successRows = new ArrayList<Integer>();
        Map execInfos = CloseAcctHelper.checkLastCloseDate((DynamicObjectCollection)dataEntity, (int[])selectRows, successRows, deleteIds);
        this.closeAccountPlugin.showCloseDateCheckInfo(EnumBillStatus.D.toString(), execInfos);
        if (deleteIds.isEmpty()) {
            return;
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"im_closeaccountrecord");
        DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])deleteIds.toArray(new Object[0]));
        Map lastCloseDateMap = CloseAcctHelper.batchGetCloseDateMap((DynamicObjectCollection)dataEntity, successRows, (boolean)true);
        ArrayList<OpLogAppInfo> appLogInfoList = new ArrayList<OpLogAppInfo>(selectRows.length);
        for (int rowIndex : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)dataEntity.get(rowIndex);
            Object name = dynamicObject.getDynamicObject("org").get("name");
            Object warehouseName = dynamicObject.getDynamicObject("warehouse").get("name");
            Date closeDate = dynamicObject.getDate("lastclosedate");
            String description = successRows.contains(rowIndex) ? String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d+\u4ed3\u5e93\u201c%2$s\u201d\u53cd\u5173\u8d26\u6210\u529f\uff0c\u5173\u8d26\u65e5\u671f%3$s\u3002", (String)"imCloseaccount_5", (String)"scmc-im-formplugin", (Object[])new Object[0]), name.toString(), warehouseName.toString(), DateUtils.getDateString((Date)closeDate)) : String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u201c%1$s\u201d+\u4ed3\u5e93\u201c%2$s\u201d\u53cd\u5173\u8d26\u5931\u8d25\u3002", (String)"imCloseaccount_6", (String)"scmc-im-formplugin", (Object[])new Object[0]), name.toString(), warehouseName.toString());
            appLogInfoList.add(this.getAppLogInfo(description));
        }
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        service.addBatchLog(appLogInfoList);
        this.closeAccountPlugin.updateDataAfterUnClose(successRows, lastCloseDateMap);
    }

    private OpLogAppInfo getAppLogInfo(String opDescription) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setBizObjID("im_closeaccount");
        appLogInfo.setBizAppID("=9Q86DR2P+Q");
        appLogInfo.setUserID(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        appLogInfo.setOpTime(new Date());
        appLogInfo.setOpName("unclose", ResManager.loadKDString((String)"\u53cd\u5173\u8d26", (String)"imCloseaccount_4", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        appLogInfo.setOpDescription(opDescription);
        return appLogInfo;
    }
}

