/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.acc.init;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.UnitConvertDirEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.AuxQtyAndUnitHelper;
import kd.scmc.im.business.helper.BillQtyAndUnitHelper;
import kd.scmc.im.business.helper.BillViewHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.MaterialHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.formplugin.ImBillEditPlugin;
import kd.scmc.im.utils.BigDecimalUtils;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.FormUtils;

public class InitBillPlugin
extends ImBillEditPlugin
implements BeforeF7SelectListener {
    private static final int pricePrecision = 10;
    private static String[] clearFields = new String[]{"ystartqty", "yreceiveqty", "ysendqty", "ystartbaseqty", "yreceivebaseqty", "ysendbaseqty", "ystartqtyunit2nd", "yreceiveqtyunit2nd", "ysendqtyunit2nd", "ystartqty", "price", "amount"};

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"owner"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initCurrency();
        this.setAllEntryDefValue();
    }

    @Override
    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        List list = e.getRows();
        for (RowDataEntity row : list) {
            BillViewHelper.initPriceEnable((RowDataEntity)row, (IFormView)this.getView());
        }
    }

    private void initCurrency() {
        Map map;
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        boolean hasCurrency = false;
        if (org != null && (map = CurrencyHelper.getCurrencyAndExRateTable((Long)org.getLong("id"))) != null) {
            model.setValue("currency", map.get("baseCurrencyID"));
            hasCurrency = true;
        }
        if (!hasCurrency) {
            model.setValue("currency", null);
        }
        this.getView().setEnable(Boolean.valueOf(hasCurrency), new String[]{"price"});
    }

    @Override
    public String getCurrencyKey() {
        return "currency";
    }

    @Override
    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        Object currency = this.getModel().getValue("currency");
        if (currency == null) {
            this.initCurrency();
        }
        this.dealWarehouseAfterCopy();
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        if ("billentry".equalsIgnoreCase(e.getEntryProp().getName())) {
            RowDataEntity[] rowDataEntities;
            this.setDefault(this.getModel().getEntryRowCount("billentry") - 1);
            for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
                BillViewHelper.initPriceEnable((RowDataEntity)rowDataEntity, (IFormView)this.getView());
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        switch (e.getProperty().getName()) {
            case "owner": {
                this.setOwnerFilter(e, "ownertype");
                break;
            }
            case "outowner": {
                this.setOwnerFilter(e, "outownertype");
                break;
            }
            case "warehouse": {
                this.setWarehouseFilter(e);
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long orgId = CommonUtils.isNull((Object)org) ? 0L : org.getLong("id");
        boolean fieldRelateChange = false;
        IFormView view = this.getView();
        block39: for (int i = 0; i < valueSet.length; ++i) {
            Object newValue = valueSet[i].getNewValue();
            int rowIndex = valueSet[i].getRowIndex();
            switch (propName) {
                case "org": {
                    this.initCurrency();
                    fieldRelateChange = true;
                    continue block39;
                }
                case "qty": 
                case "qtyunit2nd": {
                    this.calPriceAndAmountByInputAmount(rowIndex);
                    continue block39;
                }
                case "price": {
                    this.calculatedAmount(rowIndex);
                    continue block39;
                }
                case "amount": {
                    this.calculatedPrice(rowIndex);
                    continue block39;
                }
                case "unit": {
                    this.changeQty2invByRate("ystartbaseqty", this.getModel().getValue("ystartqty", rowIndex), rowIndex);
                    this.changeQty2invByRate("yreceivebaseqty", this.getModel().getValue("yreceiveqty", rowIndex), rowIndex);
                    this.changeQty2invByRate("ysendbaseqty", this.getModel().getValue("ysendqty", rowIndex), rowIndex);
                    this.setConvertValue("ystartqtyunit2nd", (BigDecimal)this.getModel().getValue("ystartqty", rowIndex), rowIndex, Boolean.TRUE, Boolean.FALSE);
                    this.setConvertValue("yreceiveqtyunit2nd", (BigDecimal)this.getModel().getValue("yreceiveqty", rowIndex), rowIndex, Boolean.TRUE, Boolean.FALSE);
                    this.setConvertValue("ysendqtyunit2nd", (BigDecimal)this.getModel().getValue("ysendqty", rowIndex), rowIndex, Boolean.TRUE, Boolean.FALSE);
                    continue block39;
                }
                case "ystartqty": 
                case "yreceiveqty": 
                case "ysendqty": 
                case "ystartqtyunit2nd": 
                case "yreceiveqtyunit2nd": 
                case "ysendqtyunit2nd": {
                    this.changeQty(propName, newValue, rowIndex);
                    continue block39;
                }
                case "material": {
                    this.changeMaterial(newValue, rowIndex);
                    continue block39;
                }
                case "ownertype": {
                    this.initDefValueByType(OwnerHelper.getOwnerDefValue((Long)orgId), rowIndex, propName, "owner");
                    continue block39;
                }
                case "outownertype": {
                    this.initDefValueByType(OwnerHelper.getOwnerDefValue((Long)orgId), rowIndex, propName, "outowner");
                    continue block39;
                }
                case "keepertype": {
                    this.initDefValueByType(orgId, rowIndex, propName, "keeper");
                    continue block39;
                }
                case "outkeepertype": {
                    this.initDefValueByType(orgId, rowIndex, propName, "outkeeper");
                    continue block39;
                }
                case "biztype": 
                case "invscheme": {
                    this.setAllEntryDefValue();
                    fieldRelateChange = true;
                    continue block39;
                }
                case "ispresent": {
                    this.setPrice(rowIndex, newValue);
                    continue block39;
                }
                case "inputamount": {
                    this.calculatedAmountAndPrice(newValue);
                    fieldRelateChange = true;
                    continue block39;
                }
            }
        }
        if (fieldRelateChange) {
            this.getView().updateView("billentry");
        }
    }

    private void calPriceAndAmountByInputAmount(int rowIndex) {
        Object entryRow = this.getView().getFormShowParameter().getCustomParam("entryRowOp");
        if (null != entryRow) {
            this.calculatedAmount(rowIndex);
        } else {
            Boolean inputAmount = (Boolean)this.getModel().getValue("inputamount");
            if (inputAmount.booleanValue()) {
                this.calculatedPrice(rowIndex);
            } else {
                this.calculatedAmount(rowIndex);
            }
        }
    }

    private void calculatedAmountAndPrice(Object newValue) {
        if (newValue instanceof Boolean) {
            Boolean inputAmount = (Boolean)newValue;
            int rowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < rowCount; ++i) {
                Boolean isPresent = (Boolean)this.getModel().getValue("ispresent", i);
                this.getView().setEnable(isPresent != false ? Boolean.FALSE : inputAmount, i, new String[]{"amount"});
                this.getView().setEnable(Boolean.valueOf(isPresent != false ? Boolean.FALSE : inputAmount == false), i, new String[]{"price"});
                if (inputAmount.booleanValue()) {
                    this.calculatedPrice(i);
                    continue;
                }
                this.calculatedAmount(i);
            }
        }
    }

    private void setPrice(int rowIndex, Object newValue) {
        if (newValue instanceof Boolean) {
            Boolean isPresent = (Boolean)newValue;
            if (isPresent.booleanValue()) {
                BigDecimal price = (BigDecimal)this.getModel().getValue("price", rowIndex);
                if (BigDecimalUtils.isNullOrZero((BigDecimal)price)) {
                    this.getModel().setValue("amount", (Object)BigDecimal.ZERO, rowIndex);
                } else {
                    this.getModel().setValue("price", (Object)BigDecimal.ZERO, rowIndex);
                }
            }
            Boolean inputAmount = (Boolean)this.getModel().getValue("inputamount");
            this.getView().setEnable(Boolean.valueOf(isPresent != false ? Boolean.FALSE : inputAmount == false), rowIndex, new String[]{"price"});
            this.getView().setEnable(isPresent != false ? Boolean.FALSE : inputAmount, rowIndex, new String[]{"amount"});
        }
    }

    private void calculatedPrice(int rowIndex) {
        IDataModel model = this.getModel();
        BigDecimal price = BigDecimal.ZERO;
        BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex);
        BigDecimal amount = (BigDecimal)model.getValue("amount", rowIndex);
        if (qty != null && amount != null && amount.compareTo(BigDecimal.ZERO) != 0 && qty.compareTo(BigDecimal.ZERO) != 0) {
            price = amount.divide(qty, 10, 4);
        }
        model.beginInit();
        model.setValue("price", (Object)price, rowIndex);
        model.endInit();
        this.getView().updateView("price", rowIndex);
    }

    private void calculatedAmount(int rowIndex) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex);
        BigDecimal price = (BigDecimal)this.getModel().getValue("price", rowIndex);
        BigDecimal amount = BigDecimal.ZERO;
        if (BigDecimalUtils.isNullOrZero((BigDecimal)qty) || BigDecimalUtils.isNullOrZero((BigDecimal)price)) {
            this.getModel().setValue("amount", (Object)amount, rowIndex);
            return;
        }
        int precision = this.getPrecision("currency", "amtprecision");
        amount = qty.multiply(price);
        if (amount.compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) > 0) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MAX_AMOUNT()));
        }
        this.getModel().setValue("amount", (Object)amount.setScale(precision, 4), rowIndex);
    }

    protected void setDefault(int currentIndex) {
        QFilter qFilter1;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse", currentIndex);
        if (org == null || warehouse == null) {
            return;
        }
        QFilter qFilter = new QFilter("org", "=", org.getPkValue());
        DynamicObject invStart = QueryServiceHelper.queryOne((String)"im_invstart", (String)"startdate", (QFilter[])new QFilter[]{qFilter, qFilter1 = new QFilter("warehouse", "=", warehouse.getPkValue())});
        if (invStart != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(invStart.getDate("startdate"));
            c.set(5, c.get(5) - 1);
            this.getModel().setValue("stockindate", (Object)c.getTime(), currentIndex);
        }
        Object defOwner = OwnerHelper.getOwnerDefValue((Long)org.getLong("id"));
        this.initDefaultOwnerAndKeeper(org, defOwner, currentIndex);
    }

    protected void changeMaterial(Object newValue, int rowIndex) {
        IDataModel bill = this.getModel();
        this.clearMaterialInfo(bill, rowIndex);
        if (CommonUtils.isNull((Object)newValue)) {
            return;
        }
        this.setDefault(rowIndex);
    }

    private void clearMaterialInfo(IDataModel bill, int rowIndex) {
        bill.beginInit();
        for (String key : clearFields) {
            bill.setValue(key, null, rowIndex);
        }
        bill.endInit();
        for (String key : clearFields) {
            this.getView().updateView(key, rowIndex);
        }
    }

    protected void changeQty(String fieldName, Object value, int rowIndex) {
        BigDecimal valueDec = (BigDecimal)value;
        switch (fieldName) {
            case "ystartqty": {
                this.setConvertValue("ystartqtyunit2nd", valueDec, rowIndex, Boolean.TRUE, Boolean.FALSE);
                this.changeQty2invByRate("ystartbaseqty", valueDec, rowIndex);
                break;
            }
            case "yreceiveqty": {
                this.setConvertValue("yreceiveqtyunit2nd", valueDec, rowIndex, Boolean.TRUE, Boolean.FALSE);
                this.changeQty2invByRate("yreceivebaseqty", valueDec, rowIndex);
                break;
            }
            case "ysendqty": {
                this.setConvertValue("ysendqtyunit2nd", valueDec, rowIndex, Boolean.TRUE, Boolean.FALSE);
                this.changeQty2invByRate("ysendbaseqty", valueDec, rowIndex);
                break;
            }
            case "ystartqtyunit2nd": {
                this.setConvertValue("ystartqty", valueDec, rowIndex, Boolean.FALSE, Boolean.TRUE);
                this.changeNd2invByRate("ystartbaseqty", valueDec, rowIndex);
                break;
            }
            case "yreceiveqtyunit2nd": {
                this.setConvertValue("yreceiveqty", valueDec, rowIndex, Boolean.FALSE, Boolean.TRUE);
                this.changeNd2invByRate("yreceivebaseqty", valueDec, rowIndex);
                break;
            }
            case "ysendqtyunit2nd": {
                this.setConvertValue("ysendqty", valueDec, rowIndex, Boolean.FALSE, Boolean.TRUE);
                this.changeNd2invByRate("ysendbaseqty", valueDec, rowIndex);
                break;
            }
        }
    }

    protected void setConvertValue(String field, BigDecimal value, int rowIndex, Boolean inv2ndFlag, Boolean nd2invFlag) {
        IDataModel bill = this.getModel();
        DynamicObject materialInvInfo = (DynamicObject)bill.getValue("material", rowIndex);
        if (CommonUtils.isNull((Object)materialInvInfo)) {
            return;
        }
        DynamicObject material = MaterialHelper.getMaterialByMatBiz((DynamicObject)materialInvInfo);
        if (material == null) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MATERIAL_INV()));
        }
        BigDecimal unitRate = this.getUnit2BaseUnitRate(rowIndex);
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        Boolean isUseUnit2nd = auxptyUnit != null;
        String unitConvertDir = material.getString("unitconvertdir");
        BigDecimal unit2ndRate = AuxQtyAndUnitHelper.getRateCache((IPageCache)this.getPageCache(), (DynamicObject)material, (String)("unit2ndrate_" + rowIndex));
        if (unit2ndRate == null || unit2ndRate.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        boolean inv2nd = UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir);
        boolean nd2inv = UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir);
        boolean uInvAndU2nd = UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
        bill.beginInit();
        if (isUseUnit2nd.booleanValue() && (inv2nd || uInvAndU2nd) && inv2ndFlag.booleanValue()) {
            BigDecimal unit2ndQty = value.multiply(unitRate).divide(unit2ndRate, 4);
            if (unit2ndQty.abs().compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) > 0) {
                this.getView().showErrorNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MAX_BASE_QTY()));
            } else {
                this.getModel().setValue(field, (Object)unit2ndQty, rowIndex);
            }
        } else if (isUseUnit2nd.booleanValue() && (nd2inv || uInvAndU2nd) && nd2invFlag.booleanValue()) {
            BigDecimal ynd2invQty = value.multiply(unit2ndRate).divide(unitRate, 4);
            if (ynd2invQty.abs().compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) > 0) {
                this.getView().showErrorNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MAX_BASE_QTY()));
            } else {
                this.getModel().setValue(field, (Object)ynd2invQty, rowIndex);
            }
        }
        bill.endInit();
        this.getView().updateView(field, rowIndex);
    }

    protected void setAllEntryDefValue() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (CommonUtils.isNull((Object)org)) {
            return;
        }
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        Object defOwner = OwnerHelper.getOwnerDefValue((Long)org.getLong("id"));
        for (int i = 0; i < entryRowCount; ++i) {
            this.initDefaultOwnerAndKeeper(org, defOwner, i);
        }
    }

    protected void initDefaultOwnerAndKeeper(DynamicObject org, Object defOwnerId, int rowIndex) {
        Object item = this.getModel().getValue("srcbillid", 0);
        if (CommonUtils.isNull((Object)org) || !item.equals(0L)) {
            return;
        }
        this.initDefValueByType(defOwnerId, rowIndex, "ownertype", "owner");
        this.initDefValueByType(defOwnerId, rowIndex, "outownertype", "outowner");
        this.initDefValueByType(org.getLong("id"), rowIndex, "keepertype", "keeper");
        this.initDefValueByType(org.getLong("id"), rowIndex, "outkeepertype", "outkeeper");
    }

    protected void initDefValueByType(Object orgId, int rowIndex, String type, String baseField) {
        if (!this.isPushOrDraw(rowIndex)) {
            if ("bos_org".equals(this.getModel().getValue(type, rowIndex))) {
                this.getModel().setValue(baseField, orgId, rowIndex);
                if ("keepertype".equals(type)) {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{baseField});
                }
            } else if ("keepertype".equals(type)) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{baseField});
            }
        }
    }

    protected BigDecimal getUnit2BaseUnitRate(int rowIndex) {
        BigDecimal result = BigDecimal.ZERO;
        DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
        DynamicObject masterMaterial = MaterialHelper.getMaterialByMatBiz((DynamicObject)material);
        DynamicObject unit = (DynamicObject)this.getModel().getValue("unit", rowIndex);
        DynamicObject baseUnit = (DynamicObject)this.getModel().getValue("baseunit", rowIndex);
        if (!(CommonUtils.isNull((Object)material) || CommonUtils.isNull((Object)masterMaterial) || CommonUtils.isNull((Object)unit) || CommonUtils.isNull((Object)baseUnit))) {
            result = BillQtyAndUnitHelper.getUnitRateConv((Long)((Long)masterMaterial.getPkValue()), (Long)((Long)unit.getPkValue()), (Long)((Long)baseUnit.getPkValue()));
        }
        return result;
    }

    protected void changeQty2invByRate(String field, Object qty, int rowIndex) {
        BigDecimal qty_all = ((BigDecimal)qty).multiply(this.getUnit2BaseUnitRate(rowIndex));
        this.compareToQty(field, rowIndex, qty_all);
    }

    protected void changeNd2invByRate(String field, Object qty, int rowIndex) {
        DynamicObject materialInfo = (DynamicObject)this.getModel().getValue("material", rowIndex);
        DynamicObject material = materialInfo.getDynamicObject("masterid");
        String unitConvertDir = material.getString("unitconvertdir");
        if (UnitConvertDirEnum.NONE.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir)) {
            return;
        }
        BigDecimal unit2ndRate = AuxQtyAndUnitHelper.getRateCache((IPageCache)this.getPageCache(), (DynamicObject)material, (String)("unit2ndrate_" + rowIndex));
        if (unit2ndRate == null || unit2ndRate.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal qty_unit2ndRate = ((BigDecimal)qty).multiply(unit2ndRate);
        this.compareToQty(field, rowIndex, qty_unit2ndRate);
    }

    private void compareToQty(String field, int rowIndex, BigDecimal qty_unit2ndRate) {
        if (qty_unit2ndRate.abs().compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) > 0) {
            this.getView().showErrorNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MAX_BASE_QTY()));
        } else {
            this.getModel().beginInit();
            this.getModel().setValue(field, (Object)qty_unit2ndRate, rowIndex);
            this.getModel().endInit();
            this.getView().updateView(field, rowIndex);
        }
    }

    protected void setWarehouseFilter(BeforeF7SelectEvent e) {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (CommonUtils.isNull((Object)org)) {
            return;
        }
        Object[] unFinishInitWHId = WarehouseHelper.getAllUnFinishInitWarehouseIDs((Long)((Long)org.getPkValue()));
        this.setF7IdFilter(e, unFinishInitWHId);
    }

    protected void dealWarehouseAfterCopy() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (CommonUtils.isNull((Object)org)) {
            return;
        }
        Long[] unFinishInitWHId = WarehouseHelper.getAllUnFinishInitWarehouseIDs((Long)((Long)org.getPkValue()));
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("billentry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject value = (DynamicObject)this.getModel().getValue("warehouse", i);
            if (!CommonUtils.isNull((Object)value) && !CommonUtils.isNull((Object)unFinishInitWHId) && Arrays.asList(unFinishInitWHId).contains(value.getPkValue())) continue;
            this.getModel().setValue("warehouse", null, i);
        }
    }
}

