/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.acc.init;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.enums.EnableStatusEnum;
import kd.scmc.im.enums.StatusEnum;

public class InvStartListPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Object[] orgColl = NewInvOrgHelper.getHasPermission((String)"im_invstart", (String)this.getView().getFormShowParameter().getAppId());
        QFilter periodFilter = new QFilter("org.id", "in", (Object)orgColl);
        e.getQFilters().add(periodFilter);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        InitDatProvider initDatProvider = new InitDatProvider();
        initDatProvider.setAppId(this.getView().getFormShowParameter().getAppId());
        args.setListDataProvider((IListDataProvider)initDatProvider);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BaseShowParameter baseShowParameter = (BaseShowParameter)e.getParameter();
        if (baseShowParameter.getStatus().equals((Object)OperationStatus.EDIT) && this.isStart()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5df2\u542f\u7528\uff0c\u65e0\u6cd5\u91cd\u65b0\u542f\u7528\u3002", (String)"InvStartListPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
    }

    private boolean isStart() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        for (ListSelectedRow listSelectedRow : selectedRows) {
            DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)listSelectedRow.getPrimaryKeyValue(), (String)"im_invstart");
            if (info == null || !info.getString("startstatus").equals("B")) continue;
            return true;
        }
        return false;
    }

    static class InitDatProvider
    extends ListDataProvider
    implements IListDataProvider {
        private String appId;

        InitDatProvider() {
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            Object[] orgColl = NewInvOrgHelper.getHasPermission((String)"im_invstart", (String)this.getAppId());
            if (orgColl != null && orgColl.length > 0) {
                MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"im_invstart");
                ArrayList<DynamicObject> unStartSetObjectList = new ArrayList<DynamicObject>();
                for (int i = 0; i < orgColl.length; ++i) {
                    long orgid = Long.parseLong(orgColl[i].toString());
                    QFilter qFilter = new QFilter("org", "=", (Object)orgid);
                    if (QueryServiceHelper.exists((String)"im_invstart", (QFilter[])new QFilter[]{qFilter})) continue;
                    DynamicObject startInfo = new DynamicObject((DynamicObjectType)entityType);
                    startInfo.set("org", (Object)orgid);
                    startInfo.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
                    startInfo.set("createtime", (Object)new Date());
                    startInfo.set("startstatus", (Object)"A");
                    startInfo.set("status", (Object)StatusEnum.SAVE.getValue());
                    startInfo.set("enable", (Object)EnableStatusEnum.ENABLE.getValue());
                    unStartSetObjectList.add(startInfo);
                }
                if (unStartSetObjectList != null && unStartSetObjectList.size() > 0) {
                    BusinessDataServiceHelper.save((IDataEntityType)entityType, (Object[])unStartSetObjectList.toArray());
                }
            }
            return super.getData(start, limit);
        }
    }
}

