/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.assemblybill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.LotMainFileHelper;
import kd.scmc.im.business.helper.MaterialHelper;
import kd.scmc.im.formplugin.ImTransformBillEditPlugin;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.FormUtils;
import org.apache.commons.lang3.StringUtils;

public class AssembBillEdit
extends ImTransformBillEditPlugin
implements RowClickEventListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"scmcgenlotnum"});
        EntryGrid grid = (EntryGrid)this.getControl("billentry");
        grid.addRowClickListener((RowClickEventListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap1"});
        EntryGrid afterGrid = (EntryGrid)this.getControl("afterentity");
        afterGrid.addRowClickListener((RowClickEventListener)this);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setAfterMaterialEntryKeeperEnable();
        this.setBeforeMaterialEntryLocationEnable();
    }

    @Override
    public void entryRowClick(RowClickEvent evt) {
        this.setBeforeMaterialEntryLocationEnable();
    }

    private void setBeforeMaterialEntryLocationEnable() {
        IDataModel model = this.getModel();
        DynamicObjectCollection collections = model.getEntryEntity("afterentity");
        if (collections != null && collections.size() != 0) {
            for (int i = 0; i < collections.size(); ++i) {
                DynamicObject single = (DynamicObject)collections.get(i);
                DynamicObject warehouse = single.getDynamicObject("warehouse1");
                if (warehouse != null && !warehouse.getBoolean("isopenlocation")) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"location1"});
                }
                DynamicObject material = single.getDynamicObject("material1");
                DynamicObject masterMaterial = null;
                if (material != null) {
                    masterMaterial = MaterialHelper.getMaterialByMatBiz((DynamicObject)material);
                }
                this.setSubEntryByMaterial(material, masterMaterial, i);
            }
        }
    }

    private void setAfterMaterialEntryKeeperEnable() {
        IDataModel model = this.getModel();
        DynamicObjectCollection collections = model.getEntryEntity("billentry");
        if (collections != null && collections.size() != 0) {
            for (int i = 0; i < collections.size(); ++i) {
                DynamicObject single = (DynamicObject)collections.get(i);
                String keeperType = single.getString("keepertype");
                if (keeperType == null || !"bos_org".equals(keeperType)) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"keeper"});
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "scmcgenlotnum": {
                this.getLotCode();
                this.saveLotMainFileInfo(itemKey, this.getModel());
                break;
            }
        }
    }

    private void getLotCode() {
        IDataModel model = this.getView().getModel();
        HashMap<String, String> param = new HashMap<String, String>(16);
        param.put("entryfield", "billentry");
        param.put("material", "material");
        param.put("lotmap", "lotnumber");
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection entryEntity = model.getEntryEntity("billentry");
        boolean flag = false;
        if (dataEntity != null) {
            for (DynamicObject row : entryEntity) {
                String lotnum = row.getString("lotnumber");
                if (!row.getBoolean("material.enablelot") || lotnum == null || !StringUtils.isEmpty((CharSequence)lotnum.trim())) continue;
                flag = true;
                break;
            }
        }
        if (!flag) {
            return;
        }
        Map map = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"LotCodeRuleService", (String)"getLotCode", (Object[])new Object[]{dataEntity, entryEntity, param});
        String lotKey = "lotnumber";
        StringBuilder sb = new StringBuilder();
        this.getView().getModel().beginInit();
        ArrayList<Integer> index = new ArrayList<Integer>();
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            Integer seq = (Integer)entry.getKey();
            String msg = (String)entry.getValue();
            if (msg.startsWith("ERROR")) {
                sb.append(msg.substring("ERROR".length())).append("\n");
                continue;
            }
            this.getView().getModel().setValue(lotKey, (Object)msg, seq - 1);
            index.add(seq - 1);
        }
        this.getView().getModel().endInit();
        index.forEach(p -> this.getView().updateView(lotKey, p.intValue()));
        if (sb.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u751f\u6210\u6279\u53f7\u5f02\u5e38", (String)"AssembBillEdit_0", (String)"scmc-im-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Commit);
        }
    }

    private void saveLotMainFileInfo(String itemKey, IDataModel model) {
        String lotidField = "billentry.lot";
        String lotnumber = "lotnumber";
        DynamicObject bill = model.getDataEntity();
        DynamicObjectCollection entryEntity = model.getEntryEntity("billentry");
        LotMainFileHelper.handleLotMainFileNumber((IFormView)this.getView(), (DynamicObject)bill, (DynamicObjectCollection)entryEntity, (String)itemKey, (String)lotidField, (String)lotnumber);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setCurrency();
    }

    private void setCurrency() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        Long orgId = (Long)org.getPkValue();
        Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)orgId);
        if (map == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        this.getModel().setValue("currency", map.get("baseCurrencyID"));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        IDataModel bill = this.getModel();
        switch (name) {
            case "material1": {
                this.beforeMaterial1Select(e);
                break;
            }
        }
        super.beforeF7Select(e);
    }

    private void beforeMaterial1Select(BeforeF7SelectEvent e) {
        int parentindex;
        IDataModel model = this.getModel();
        DynamicObject material = (DynamicObject)model.getValue("material", parentindex = model.getEntryCurrentRowIndex("billentry"));
        if (material == null) {
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("masterid.id", "!=", (Object)material.getLong("masterid.id")));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "qty": {
                this.qtyPropetyChange(e);
                break;
            }
            case "qtyunit2nd": {
                this.qtyUnit2PropetyChange(e);
                break;
            }
            case "usagerate": 
            case "material1": {
                this.useageratePropertyChange(e);
                break;
            }
            case "material": {
                this.materialPropertyChange(e);
                break;
            }
            case "invtype": 
            case "invstatus": 
            case "owner": 
            case "keeper": {
                this.setAllSubEntryValueAsParent(propName, e.getChangeSet()[0].getRowIndex());
                break;
            }
            case "qty1": {
                this.beforeQtyPropertyChange(e);
                break;
            }
            case "qtyunit2nd1": {
                this.beforeQtyUnit2PropertyChange(e);
                break;
            }
            case "warehouse1": {
                this.beforeWarehousePropertyChange(e);
                break;
            }
        }
    }

    private void setAllSubEntryValueAsParent(String parentKey, int parentIndex) {
        IDataModel model = this.getModel();
        model.beginInit();
        DynamicObject row = model.getEntryRowEntity("billentry", parentIndex);
        DynamicObjectCollection entries = row.getDynamicObjectCollection("afterentity");
        String subkey = parentKey + "1";
        Object value = row.get(parentKey);
        for (int i = 0; i < entries.size(); ++i) {
            ((DynamicObject)entries.get(i)).set(subkey, value);
        }
        model.endInit();
        int entryRowCount = this.getModel().getEntryRowCount("afterentity");
        for (int i = 0; i < entryRowCount; ++i) {
            this.getView().updateView(subkey, i);
        }
    }

    private void beforeWarehousePropertyChange(PropertyChangedArgs e) {
        ChangeData data = e.getChangeSet()[0];
        DynamicObject newWarehouse = (DynamicObject)data.getNewValue();
        if (newWarehouse != null && newWarehouse.getBoolean("isopenlocation")) {
            this.getView().setEnable(Boolean.TRUE, data.getRowIndex(), new String[]{"location1"});
        } else {
            this.getView().setEnable(Boolean.FALSE, data.getRowIndex(), new String[]{"location1"});
        }
        this.setValue("location1", null, data.getRowIndex(), false);
    }

    private void beforeQtyPropertyChange(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        ChangeData data = e.getChangeSet()[0];
        BigDecimal beforeMaterialQty = (BigDecimal)data.getNewValue();
        int parentRowIndex = data.getParentRowIndex();
        BigDecimal qty = (BigDecimal)model.getValue("qty", parentRowIndex);
        BigDecimal useageRate = null;
        useageRate = qty == null || qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : beforeMaterialQty.divide(qty, 10, 4);
        int rowIndex = data.getRowIndex();
        model.beginInit();
        model.setValue("usagerate", (Object)useageRate, rowIndex, parentRowIndex);
        model.endInit();
        this.getView().updateView("usagerate", rowIndex, parentRowIndex);
    }

    private void beforeQtyUnit2PropertyChange(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        ChangeData data = e.getChangeSet()[0];
        BigDecimal beforeMaterialQty = data.getDataEntity().getBigDecimal("qty1");
        int parentRowIndex = data.getParentRowIndex();
        BigDecimal qty = (BigDecimal)model.getValue("qty", parentRowIndex);
        BigDecimal useageRate = null;
        useageRate = qty == null || qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : beforeMaterialQty.divide(qty, 10, 4);
        int rowIndex = data.getRowIndex();
        this.setValue("usagerate", useageRate, rowIndex, false);
    }

    private void materialPropertyChange(PropertyChangedArgs e) {
        this.getModel().deleteEntryData("afterentity");
    }

    private void qtyPropetyChange(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        BigDecimal qty = (BigDecimal)changeData.getNewValue();
        int parentRowIndex = changeData.getRowIndex();
        DynamicObjectCollection subEntrys = (DynamicObjectCollection)model.getValue("afterentity", parentRowIndex);
        int size = subEntrys.size();
        for (int i = 0; i < size; ++i) {
            this.setBeforeAssembQty(i, qty, parentRowIndex);
        }
    }

    private void qtyUnit2PropetyChange(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        BigDecimal qty = changeData.getDataEntity().getBigDecimal("qty");
        int size = model.getEntryEntity("afterentity").size();
        for (int i = 0; i < size; ++i) {
            this.setBeforeAssembQty(i, qty, changeData.getRowIndex());
        }
    }

    private void useageratePropertyChange(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        int parentRowIndex = changeData.getParentRowIndex();
        BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", parentRowIndex);
        int rowIndex = changeData.getRowIndex();
        this.setBeforeAssembQty(rowIndex, qty, parentRowIndex);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = FormUtils.getOpKey((BeforeDoOperationEventArgs)args)) {
            case "newafterentry": 
            case "after_scmcinvquery": {
                IDataModel model = this.getModel();
                int parentindex = model.getEntryCurrentRowIndex("billentry");
                Object material = model.getValue("material", parentindex);
                if (material != null) break;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u88c5\u540e\u7684\u7269\u6599\u3002", (String)"AssembBillEdit_2", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        String name;
        super.afterAddRow(e);
        switch (name = e.getEntryProp().getName()) {
            case "afterentity": {
                this.afterentryAddRow(e);
                break;
            }
        }
    }

    private void afterentryAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities;
        IDataModel model = this.getModel();
        int parentRowIndex = model.getEntryCurrentRowIndex("billentry");
        BigDecimal qty = (BigDecimal)model.getValue("qty", parentRowIndex);
        for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
            int rowIndex = rowDataEntity.getRowIndex();
            this.setBeforeAssembQty(rowIndex, qty, parentRowIndex);
            this.setSubEntryValueFromParent(rowIndex, parentRowIndex, "invtype", "invstatus", "ownertype", "owner", "keepertype", "keeper");
        }
    }

    private BigDecimal setBeforeAssembQty(int rowIndex, BigDecimal qty, int parentRowIndex) {
        IDataModel model = this.getModel();
        BigDecimal useageRate = (BigDecimal)model.getValue("usagerate", rowIndex, parentRowIndex);
        BigDecimal beforeAssembQty = qty.multiply(useageRate);
        AssembBillEdit.showQtyErrorTip(beforeAssembQty);
        model.setValue("qty1", (Object)beforeAssembQty, rowIndex, parentRowIndex);
        return beforeAssembQty;
    }

    public static void showQtyErrorTip(BigDecimal qtyAmount) {
        CommonUtils.showQtyErrorTip((BigDecimal)qtyAmount);
    }

    private void setSubEntryValueFromParent(int rowIndex, int parentIndex, String ... parentKey) {
        IDataModel model = this.getModel();
        for (String key : parentKey) {
            String subkey = key + "1";
            Object value = model.getValue(key, parentIndex);
            this.setValue(subkey, value, rowIndex, true);
        }
    }

    @Override
    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        this.setCurrency();
    }
}

