/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.balanceinv;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.fs.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;

public class BalanceInvAdviceEditPlugin
extends AbstractFormPlugin {
    private Map<Long, Long> purOrg2AccountOrgCache = new HashMap<Long, Long>();
    private Map<Long, Long> purOrg2InvOrgCache = new HashMap<Long, Long>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap", "tbmain"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if ("entrycancel".equals(opKey)) {
            int[] rowIndex = this.getSelectedRowsIndex();
            List<DynamicObject> billEntrys = this.getSelectedEntryRow(rowIndex);
            Set entryIds = billEntrys.stream().map(entry -> entry.getString("id")).collect(Collectors.toSet());
            operate.getOption().setVariableValue("cancelentryids", SerializationUtils.toJsonString(entryIds));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String opKey;
        super.beforeItemClick(evt);
        switch (opKey = evt.getOperationKey()) {
            case "entrycancel": {
                this.checkEntryCancel(evt);
                break;
            }
            case "cancel": {
                this.checkCancel(evt);
                break;
            }
            case "entryrowsplitop": {
                this.checkSplitRow(evt);
            }
        }
    }

    private void checkSplitRow(BeforeItemClickEvent evt) {
        int[] rowIndex = this.getSelectedRowsIndex();
        if (rowIndex.length <= 0 || rowIndex.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"BalanceInvAdviceEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        String isClosed = (String)this.getModel().getValue("isclosed", rowIndex[0]);
        String isCancel = (String)this.getModel().getValue("iscancel", rowIndex[0]);
        if ("B".equals(isClosed) || "B".equals(isCancel)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5206\u5f55\u5df2\u7ecf\u5173\u95ed\u6216\u4f5c\u5e9f\uff0c\u8bf7\u9009\u62e9\u72b6\u6001\u6b63\u5e38\u7684\u5206\u5f55\u3002", (String)"BalanceInvAdviceEditPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    private void checkCancel(BeforeItemClickEvent evt) {
        boolean isChanged = this.getModel().getDataChanged();
        if (isChanged) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u8c03\u62e8\u5931\u8d25\uff1a\u68c0\u6d4b\u5230\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u8bf7\u5148\u4fdd\u5b58\u518d\u6267\u884c\u76f8\u5173\u64cd\u4f5c\u3002", (String)"BalanceInvAdviceEditPlugin_7", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    private void checkEntryCancel(BeforeItemClickEvent evt) {
        boolean isChanged = this.getModel().getDataChanged();
        if (isChanged) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u8c03\u62e8\u5931\u8d25\uff1a\u68c0\u6d4b\u5230\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u8bf7\u5148\u4fdd\u5b58\u518d\u6267\u884c\u76f8\u5173\u64cd\u4f5c\u3002", (String)"BalanceInvAdviceEditPlugin_7", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        String errorMsg = this.getValidateErrorMsg();
        if (!StringUtils.isEmpty((String)errorMsg)) {
            this.getView().showTipNotification(errorMsg);
            return;
        }
        int[] rowIndex = this.getSelectedRowsIndex();
        if (rowIndex.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"BalanceInvAdviceEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        List<DynamicObject> billEntrys = this.getSelectedEntryRow(rowIndex);
        if (billEntrys.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5206\u5f55\u5df2\u7ecf\u5173\u95ed\u6216\u4f5c\u5e9f\uff0c\u8bf7\u9009\u62e9\u72b6\u6001\u6b63\u5e38\u7684\u5206\u5f55\u3002", (String)"BalanceInvAdviceEditPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if ("cancel".equals(opKey) || "entrycancel".equals(opKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private String getValidateErrorMsg() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        String adviceType = (String)this.getModel().getValue("advicetype");
        boolean canPush = "D".equals(adviceType) || "E".equals(adviceType);
        String errorMsg = null;
        if (!"A".equals(billStatus)) {
            errorMsg = ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u7684\u5355\u636e\u624d\u5141\u8bb8\u53d6\u6d88\u8c03\u62e8\u3002", (String)"BalanceInvAdviceEditPlugin_2", (String)"scmc-im-formplugin", (Object[])new Object[0]);
        } else if (!canPush) {
            errorMsg = ResManager.loadKDString((String)"\u53ea\u6709\u5efa\u8bae\u7c7b\u578b\u4e3aVMI\u8c03\u62e8\u3001\u8c03\u62e8\u5efa\u8bae\u7684\u5355\u636e\u624d\u5141\u8bb8\u53d6\u6d88\u8c03\u62e8\u3002", (String)"BalanceInvAdviceEditPlugin_3", (String)"scmc-im-formplugin", (Object[])new Object[0]);
        }
        return errorMsg;
    }

    private List<DynamicObject> doPush(List<ListSelectedRow> selectedRows) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setRuleId("1681247403891635200");
        pushArgs.setSourceEntityNumber("im_balanceinv_advice");
        pushArgs.setTargetEntityNumber("im_balanceinv_advice");
        pushArgs.setHasRight(false);
        pushArgs.setAppId("im");
        pushArgs.setBuildConvReport(true);
        pushArgs.setSelectedRows(selectedRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            String errMessage = pushResult.getMessage();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff1a%s\u3002", (String)"BalanceInvAdviceEditPlugin_5", (String)"scmc-im-formplugin", (Object[])new Object[0]), errMessage));
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"im_balanceinv_advice");
        List targetBillObjs = pushResult.loadTargetDataObjects(new IRefrencedataProvider(){

            public void fillReferenceData(Object[] objs, IDataEntityType dType) {
                BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)dType);
            }
        }, targetMainType);
        return targetBillObjs;
    }

    private Map<String, List<ListSelectedRow>> getBotpSelectedRow(Set<Object> set, Object sourceBillId, List<DynamicObject> billEntrys) {
        ArrayList<ListSelectedRow> purOutRows = new ArrayList<ListSelectedRow>();
        ArrayList<ListSelectedRow> purFocusRows = new ArrayList<ListSelectedRow>();
        for (DynamicObject billEntry : billEntrys) {
            Object billEntryId = billEntry.getPkValue();
            ListSelectedRow currentRow = new ListSelectedRow();
            currentRow.setPrimaryKeyValue(sourceBillId);
            currentRow.setEntryEntityKey("entryentity");
            currentRow.setEntryPrimaryKeyValue(billEntry.getPkValue());
            if (set.contains(billEntryId)) {
                purFocusRows.add(currentRow);
                continue;
            }
            purOutRows.add(currentRow);
        }
        HashMap<String, List<ListSelectedRow>> result = new HashMap<String, List<ListSelectedRow>>(2);
        result.put("A", purOutRows);
        result.put("F", purFocusRows);
        return result;
    }

    private void updateSourceBillFields(int[] rowIndex) {
        Object invAdviceId = this.getView().getModel().getDataEntity(true).getPkValue();
        DynamicObject invAdvice = BusinessDataServiceHelper.loadSingle((Object)invAdviceId, (String)"im_balanceinv_advice", (String)"repealuser,repealtime,billstatus,entryentity.iscancel,entryentity.isclosed");
        DynamicObjectCollection invAdviceEntry = invAdvice.getDynamicObjectCollection("entryentity");
        boolean needUpdateUser = true;
        boolean needUpdateStatus = true;
        for (int i = 0; i < invAdviceEntry.size(); ++i) {
            DynamicObject entryBill = (DynamicObject)invAdviceEntry.get(i);
            if (this.isContains(rowIndex, i)) {
                entryBill.set("iscancel", (Object)"B");
                entryBill.set("isclosed", (Object)"B");
                continue;
            }
            String entryIsCancel = entryBill.getString("iscancel");
            String entryIsClosed = entryBill.getString("isclosed");
            if ("A".equals(entryIsCancel)) {
                needUpdateUser = false;
            }
            if (!"A".equals(entryIsClosed)) continue;
            needUpdateStatus = false;
        }
        if (needUpdateUser) {
            long currentUserId = RequestContext.get().getCurrUserId();
            invAdvice.set("repealuser", (Object)currentUserId);
            invAdvice.set("repealtime", (Object)new Date());
        }
        if (needUpdateStatus) {
            invAdvice.set("billstatus", (Object)"D");
        }
        IDataEntityType iDataEntityType = invAdvice.getDataEntityType();
        SaveServiceHelper.save((IDataEntityType)iDataEntityType, (Object[])new DynamicObject[]{invAdvice});
    }

    private boolean isContains(int[] rowIndex, int target) {
        for (int i : rowIndex) {
            if (i != target) continue;
            return true;
        }
        return false;
    }

    private List<DynamicObject> getSelectedEntryRow(int[] index) {
        ArrayList<DynamicObject> entryEntity = new ArrayList<DynamicObject>();
        IDataModel dataModel = this.getView().getModel();
        for (int rowIndex : index) {
            DynamicObject billEntry = dataModel.getEntryRowEntity("entryentity", rowIndex);
            String isCancel = billEntry.getString("iscancel");
            String isClosed = billEntry.getString("isclosed");
            if (!"A".equals(isCancel) || !"A".equals(isClosed)) continue;
            entryEntity.add(billEntry);
        }
        return entryEntity;
    }

    private void handleFieldValue(String adviceType, List<DynamicObject> adviceBills) {
        for (DynamicObject bill : adviceBills) {
            bill.set("advicetype", (Object)adviceType);
            bill.set("supplyorg", (Object)0);
            Long balanceOrgId = bill.getDynamicObject("org").getLong("id");
            DynamicObjectCollection entryCol = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryCol) {
                BalanceInvExecuteHelper.handlePurAdvice((DynamicObject)entry, (Long)balanceOrgId, this.purOrg2AccountOrgCache, this.purOrg2InvOrgCache);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("planfinishdate".equals(key) || "planstartdate".equals(key)) {
            ChangeData changeData = e.getChangeSet()[0];
            int index = changeData.getRowIndex();
            this.datePropertyChange(key, index);
        }
    }

    private void datePropertyChange(String key, int rowIndex) {
        Date startDate = (Date)this.getModel().getValue("planstartdate", rowIndex);
        Date finishedDate = (Date)this.getModel().getValue("planfinishdate", rowIndex);
        if (finishedDate != null && startDate != null && finishedDate.before(startDate)) {
            if ("planfinishdate".equals(key)) {
                this.getModel().setValue("planstartdate", (Object)finishedDate, rowIndex);
            } else {
                this.getModel().setValue("planfinishdate", (Object)startDate, rowIndex);
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u884c\u7b2c%s\u884c\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\uff0c\u5df2\u540c\u6b65\u4fee\u6539\u3002", (String)"BalanceInvAdviceEditPlugin_6", (String)"scmc-im-formplugin", (Object[])new Object[0]), rowIndex + 1), Integer.valueOf(3000));
        }
    }

    private int[] getSelectedRowsIndex() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        return entryGrid.getSelectRows();
    }
}

