/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.balanceinv;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scmc.im.business.balanceinv.constants.BalanceInvLogConstants;

public class BalanceInvLogEditPlugin
extends AbstractBillPlugIn
implements ProgresssListener {
    private static final String IMAGE_FAIL = "imgerror";
    private static final String IMAGE_SUCCESS = "imgsuccess";
    public static final String PROGRESSBAR = "progressbar";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBAR);
        if (progressBar != null) {
            progressBar.addProgressListener((ProgresssListener)this);
        }
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void onProgress(ProgressEvent evt) {
        this.getView().invokeOperation("refresh");
        Integer processRate = (Integer)this.getModel().getValue("processrate");
        evt.setProgress(processRate.intValue());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBAR);
        if (progressBar != null) {
            String status = (String)this.getModel().getValue("status");
            if (StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)BalanceInvLogConstants.STATUS_RUNNING)) {
                progressBar.start();
            }
            Integer processRate = (Integer)this.getModel().getValue("processrate");
            this.setProgressBarColorAndStatus(status);
            progressBar.setPercent(processRate.intValue());
            HashMap<String, String> value2ColorMap = new HashMap<String, String>();
            value2ColorMap.put(BalanceInvLogConstants.STEP_RESULT_A, "#1BA854");
            value2ColorMap.put(BalanceInvLogConstants.STEP_RESULT_B, "rgba(255,0,0,0.7)");
            value2ColorMap.put(BalanceInvLogConstants.STEP_RESULT_C, "rgba(255,0,0,0.7)");
            value2ColorMap.put(BalanceInvLogConstants.STEP_RESULT_E, "#fdc200");
            this.setCellColor(this.getView(), "entryentity", "stepresult", value2ColorMap);
            if (!StringUtils.equalsIgnoreCase((CharSequence)status, (CharSequence)BalanceInvLogConstants.STATUS_RUNNING)) {
                progressBar.stop();
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("advicequery".equals(itemKey)) {
            Object org = this.getModel().getValue(BalanceInvLogConstants.BALANCE_ORG);
            Long orgId = (Long)((DynamicObject)org).getPkValue();
            int per = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)orgId, (String)"im", (String)"im_balanceinv_advice", (String)"47150e89000000ac");
            if (per == 1) {
                String calNum = (String)this.getModel().getValue(BalanceInvLogConstants.CAL_NUM);
                this.adviceListFormShow(calNum, orgId);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5229\u5e93\u7ec4\u7ec7\u65e0\u201c\u5229\u5e93\u5efa\u8bae\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BalanceInvLogEditPlugin_3", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void setProgressBarColorAndStatus(String cStatus) {
        String color = "#1BA854";
        Label processDescription = (Label)this.getControl("processdescription");
        if (StringUtils.equalsIgnoreCase((CharSequence)cStatus, (CharSequence)BalanceInvLogConstants.STATUS_RUNNING)) {
            processDescription.setText(ResManager.loadKDString((String)"\u8fd0\u7b97\u4e2d...", (String)"BalanceInvLogEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{IMAGE_FAIL, IMAGE_SUCCESS});
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)cStatus, (CharSequence)BalanceInvLogConstants.STATUS_FAIL) || StringUtils.equalsIgnoreCase((CharSequence)cStatus, (CharSequence)BalanceInvLogConstants.STATUS_USER_STOP)) {
            color = "rgba(255,0,0,0.7)";
            processDescription.setText(ResManager.loadKDString((String)"\u8fd0\u7b97\u5931\u8d25", (String)"BalanceInvLogEditPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{IMAGE_SUCCESS});
            this.getView().setVisible(Boolean.TRUE, new String[]{IMAGE_FAIL});
        } else {
            processDescription.setText(ResManager.loadKDString((String)"\u8fd0\u7b97\u6210\u529f", (String)"BalanceInvLogEditPlugin_2", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{IMAGE_FAIL});
            this.getView().setVisible(Boolean.TRUE, new String[]{IMAGE_SUCCESS});
        }
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("fc", color);
        this.getView().updateControlMetadata(PROGRESSBAR, fieldMap);
    }

    private void setCellColor(IFormView fv, String entryKey, String fieldKey, Map<String, String> value2ColorMap) {
        if (fv == null || StringUtils.isBlank((CharSequence)entryKey) || StringUtils.isBlank((CharSequence)fieldKey)) {
            return;
        }
        IDataModel dm = fv.getModel();
        EntryGrid entryGrid = (EntryGrid)fv.getControl(entryKey);
        if (entryGrid == null) {
            return;
        }
        int rows = dm.getEntryRowCount(entryKey);
        ArrayList<CellStyle> cells = new ArrayList<CellStyle>();
        for (int i = 0; i < rows; ++i) {
            Object data = dm.getValue(fieldKey, i);
            String color = value2ColorMap.get(data.toString());
            if (StringUtils.isEmpty((CharSequence)color)) continue;
            CellStyle cell = new CellStyle();
            cell.setFieldKey(fieldKey);
            cell.setRow(i);
            cell.setForeColor(color);
            cells.add(cell);
        }
        if (!cells.isEmpty()) {
            entryGrid.setCellStyle(cells);
            fv.updateView(entryKey);
        }
    }

    private void adviceListFormShow(String calNum, Long orgId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId("im_balanceinv_advice");
        showParameter.setAppId("im");
        IFormView formView = this.getView();
        ShowType showType = formView.getFormShowParameter().getOpenStyle().getShowType();
        if (ShowType.Modal.equals((Object)showType) || ShowType.NonModal.equals((Object)showType)) {
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss style = new StyleCss();
            style.setWidth("80%");
            style.setHeight("80%");
            showParameter.getOpenStyle().setInlineStyleCss(style);
        } else {
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        }
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("calculatenum", "=", (Object)calNum));
        showParameter.setCustomParam("orgid", (Object)orgId.toString());
        formView.showForm((FormShowParameter)showParameter);
    }
}

