/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.balanceinv;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scmc.im.business.balanceinv.constants.BalanceInvLogConstants;
import kd.scmc.im.formplugin.balanceinv.helper.BalanceInvFormHelper;

public class BalanceInvLogListPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advicequerybar"});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BalanceInvFormHelper.checkLicense(e);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("advicequerybar".equals(itemKey)) {
            Object[] rows = this.getSelectedRows().getPrimaryKeyValues();
            if (rows.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BalanceInvLogListPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            } else {
                HasPermOrgResult permOrgResult = PermissionServiceHelper.getAuthorizedBizOrg((Long)RequestContext.get().getCurrUserId(), (String)"15", (String)"im", (String)"im_balanceinv_advice", (String)"47150e89000000ac");
                HashSet hasPermOrgSet = new HashSet(permOrgResult.getHasPermOrgs());
                DataSet logDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)BalanceInvLogConstants.ENTITY_NUM, (String)"calcnum, balanceorg", (QFilter[])new QFilter("id", "in", (Object)rows).toArray(), null);
                HashSet<String> calNum = new HashSet<String>(16);
                HashSet<Long> orgId = new HashSet<Long>(16);
                for (Row row : logDataSet) {
                    Long id = row.getLong(BalanceInvLogConstants.BALANCE_ORG);
                    if (!permOrgResult.hasAllOrgPerm() && !hasPermOrgSet.contains(id)) continue;
                    calNum.add(row.getString(BalanceInvLogConstants.CAL_NUM));
                    orgId.add(id);
                }
                if (orgId.size() <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5229\u5e93\u7ec4\u7ec7\u65e0\u201c\u5229\u5e93\u5efa\u8bae\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BalanceInvLogEditPlugin_3", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                } else {
                    this.adviceListFormShow(calNum, orgId);
                }
            }
        }
    }

    private void adviceListFormShow(Set<String> calNum, Set<Long> orgId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId("im_balanceinv_advice");
        showParameter.setAppId("im");
        IFormView formView = this.getView();
        showParameter.setParentPageId(formView.getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("calculatenum", "in", calNum));
        StringBuilder str = new StringBuilder();
        for (Long id : orgId) {
            str.append(id).append(",");
        }
        showParameter.setCustomParam("orgid", (Object)str.toString());
        formView.showForm((FormShowParameter)showParameter);
    }
}

