/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.balanceinv.workbenches.genadvice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.pojo.BalanceInventoryScheme;
import kd.scmc.im.business.balanceinv.pojo.StepResult;
import kd.scmc.im.formplugin.balanceinv.workbenches.genadvice.BalanceInvGenResult;
import kd.scmc.im.formplugin.balanceinv.workbenches.genadvice.BalanceInvWbGenMatchAdvice;
import kd.scmc.im.formplugin.balanceinv.workbenches.genadvice.BalanceInvWbGenUnMatchAdvice;
import kd.scmc.im.formplugin.balanceinv.workbenches.genadvice.BalanceInvWbSafeStockGenAdvice;

public class BalanceInvWbConfirm {
    private static final String SCMC_IM_FORM = "scmc-im-formplugin";
    private static final Log log = LogFactory.getLog(BalanceInvWbConfirm.class);

    public BalanceInvGenResult genBalanceAdvise(DynamicObjectCollection matchDetailCol, Long schemeId) {
        ArrayList<DynamicObject> matchDetailInfo = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> reqMatchEntry = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> reqUnMatchEntry = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> safeStockEntry = new ArrayList<DynamicObject>(16);
        this.matchDetailFilter(matchDetailCol, reqMatchEntry, reqUnMatchEntry, safeStockEntry, matchDetailInfo);
        DynamicObject scheme = BalanceInvExecuteHelper.getBalanceSchemeInfo((Long)schemeId);
        BalanceInventoryScheme inventoryScheme = new BalanceInventoryScheme(scheme);
        BalanceInvGenResult genResult = new BalanceInvGenResult();
        genResult.putMatchDetailEntry((Collection<DynamicObject>)matchDetailCol);
        if (!reqMatchEntry.isEmpty()) {
            new BalanceInvWbGenMatchAdvice().reqGenMatchBalanceAdvise(reqMatchEntry, inventoryScheme, genResult);
        }
        if (genResult.isSuccess() && !reqUnMatchEntry.isEmpty()) {
            new BalanceInvWbGenUnMatchAdvice().reqGenUnMatchBalanceAdvise(reqUnMatchEntry, inventoryScheme, genResult);
        }
        if (genResult.isSuccess() && !safeStockEntry.isEmpty()) {
            new BalanceInvWbSafeStockGenAdvice().safeStockGenBalanceAdvise(safeStockEntry, inventoryScheme, genResult);
        }
        if (genResult.isSuccess()) {
            this.saveAdviseWriteBack(matchDetailInfo, genResult);
        }
        if (genResult.isSuccess()) {
            try {
                Set adviceIdSet = genResult.getGenAdviceList().stream().map(advice -> advice.getLong("id")).collect(Collectors.toSet());
                StepResult stepResult = new StepResult();
                BalanceInvExecuteHelper.autoOutPut(adviceIdSet, (BalanceInventoryScheme)inventoryScheme, (StepResult)stepResult);
                log.info("\u81ea\u52a8\u6295\u653e\u6267\u884c\uff1a" + stepResult.getStepResult() + "\u65e5\u5fd7\u4fe1\u606f\uff1a" + stepResult.getDetailMsg());
            }
            catch (Exception e) {
                log.info("\u5229\u5e93\u5efa\u8bae\u81ea\u52a8\u6295\u653e\u6267\u884c\u5f02\u5e38\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
        return genResult;
    }

    private void matchDetailFilter(DynamicObjectCollection matchDetailCol, List<DynamicObject> reqMatchEntry, List<DynamicObject> reqUnMatchEntry, List<DynamicObject> safeStockMatchEntry, List<DynamicObject> matchDetailInfo) {
        for (DynamicObject entry : matchDetailCol) {
            boolean purOutOrFocus;
            String billType = entry.getString("demandbilltype");
            String stockType = entry.getString("invstocktype");
            String adviceType = entry.getString("advicetype");
            boolean bl = purOutOrFocus = "A".equals(adviceType) || "F".equals(adviceType);
            if ("B".equals(stockType)) continue;
            if ("pm_requirapplybill".equals(billType)) {
                if (purOutOrFocus) {
                    reqUnMatchEntry.add(entry);
                } else {
                    reqMatchEntry.add(entry);
                }
            } else if ("invp_safestock_record".equals(billType) && purOutOrFocus) {
                safeStockMatchEntry.add(entry);
            }
            matchDetailInfo.add(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAdviseWriteBack(List<DynamicObject> matchInfoList, BalanceInvGenResult genResult) {
        List<DynamicObject> balanceAdviseList = genResult.getGenAdviceList();
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                OperateOption option = OperateOption.create();
                option.setVariableValue("mutex_writeback", "false");
                OperationResult result = SaveServiceHelper.saveOperate((String)"im_balanceinv_advice", (DynamicObject[])balanceAdviseList.toArray(new DynamicObject[0]), (OperateOption)option);
                Map billNos = result.getBillNos();
                if (!result.isSuccess()) {
                    String errorInfo = this.parseErrorMsg(this.getOperateErrorMsg(result), genResult.getReqBillAdviceId(), genResult.getSafeStockAdviceId());
                    genResult.setErrorMsg(errorInfo);
                } else {
                    for (DynamicObject matchInfo : matchInfoList) {
                        matchInfo.set("invadvice", billNos.get(matchInfo.get("invadvice")));
                    }
                }
            }
            catch (Exception e) {
                StringBuilder exceptionMsg = new StringBuilder(ResManager.loadKDString((String)"\u5229\u5e93\u5efa\u8bae\u4fdd\u5b58\u53d1\u751f\u5f02\u5e38\uff1a", (String)"IM-N-027102", (String)SCMC_IM_FORM, (Object[])new Object[0]));
                exceptionMsg.append(BalanceInvExecuteHelper.getExceptionMessage((Throwable)e));
                genResult.setErrorMsg(exceptionMsg.toString());
            }
            finally {
                if (!genResult.isSuccess()) {
                    txHandle.markRollback();
                }
            }
        }
    }

    private Map<String, String> getOperateErrorMsg(OperationResult opResult) {
        String msg;
        HashMap<String, String> errorMap = new HashMap<String, String>();
        List allErrorOrValidateInfo = opResult.getAllErrorOrValidateInfo();
        if (allErrorOrValidateInfo != null && !allErrorOrValidateInfo.isEmpty()) {
            for (IOperateInfo operateInfo : allErrorOrValidateInfo) {
                Object billId = operateInfo.getPkValue();
                errorMap.putIfAbsent(billId.toString(), "");
                errorMap.put(billId.toString(), (String)errorMap.get(billId.toString()) + operateInfo.getMessage() + "\n");
            }
        }
        if (StringUtils.isNotEmpty((String)(msg = opResult.getMessage()))) {
            errorMap.put("0", msg);
        }
        return errorMap;
    }

    private String parseErrorMsg(Map<String, String> errorInfo, Set<String> reqIds, Set<String> safeStockIds) {
        StringBuilder reqMsg = new StringBuilder();
        StringBuilder stockMsg = new StringBuilder();
        StringBuilder otherInfo = new StringBuilder();
        for (Map.Entry<String, String> entry : errorInfo.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (reqIds.contains(key)) {
                reqMsg.append(value);
                continue;
            }
            if (safeStockIds.contains(key)) {
                stockMsg.append(value);
                continue;
            }
            otherInfo.append(value);
        }
        if (reqMsg.length() > 0) {
            reqMsg.insert(0, "\n");
            reqMsg.insert(0, ResManager.loadKDString((String)"\u9700\u6c42\u7533\u8bf7\u5355\u751f\u6210\u5229\u5e93\u5efa\u8bae\u5931\u8d25\uff1a", (String)"IM-N-810486", (String)SCMC_IM_FORM, (Object[])new Object[0]));
        }
        if (stockMsg.length() > 0) {
            stockMsg.insert(0, "\n");
            stockMsg.insert(0, ResManager.loadKDString((String)"\u5b89\u5168\u5e93\u5b58\u8bb0\u5f55\u751f\u6210\u5229\u5e93\u5efa\u8bae\u5931\u8d25\uff1a", (String)"IM-N-130526", (String)SCMC_IM_FORM, (Object[])new Object[0]));
            reqMsg.append("\n").append((CharSequence)stockMsg);
        }
        if (reqMsg.length() <= 0 && otherInfo.length() > 0) {
            reqMsg.append((CharSequence)otherInfo);
        }
        return reqMsg.toString();
    }
}

