/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.balanceinv.workbenches.genadvice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.pojo.BalanceInventoryScheme;
import kd.scmc.im.business.balanceinv.pojo.SumMatchInfo;
import kd.scmc.im.formplugin.balanceinv.workbenches.genadvice.BalanceInvGenResult;

public class BalanceInvWbGenMatchAdvice {
    public static final String SCMC_IM_FORM = "scmc-im-formplugin";

    public void reqGenMatchBalanceAdvise(List<DynamicObject> matchDetailEntry, BalanceInventoryScheme balanceScheme, BalanceInvGenResult genResult) {
        String outPutResultEntity = balanceScheme.getDemandModel().getOutPutResultEntity();
        Map<String, List<DynamicObject>> groupedMatchMap = this.buildGroupMatch(matchDetailEntry, balanceScheme);
        HashMap<Long, Long> demandOrgCache = new HashMap<Long, Long>(16);
        for (List<DynamicObject> matchInfoList : groupedMatchMap.values()) {
            if (!genResult.isSuccess() || matchInfoList == null || matchInfoList.isEmpty()) continue;
            DynamicObject topMatchInfoEntry = matchInfoList.get(0);
            String demandSrcBillEntityNum = topMatchInfoEntry.getString("demandbilltype");
            String botpRuleId = (String)balanceScheme.getDemandDsMap().get(demandSrcBillEntityNum);
            String demandEntryField = BalanceInvExecuteHelper.getDemandEntryField((String)demandSrcBillEntityNum, (BalanceInventoryScheme)balanceScheme);
            ArrayList<ListSelectedRow> rowList = new ArrayList<ListSelectedRow>(matchInfoList.size());
            HashMap<Long, SumMatchInfo> splitMap = new HashMap<Long, SumMatchInfo>();
            for (DynamicObject matchInfo : matchInfoList) {
                String invType = matchInfo.getString("invstocktype");
                if ("B".equals(invType)) continue;
                Long entryID = matchInfo.getLong("demandentryid");
                if (!splitMap.containsKey(entryID)) {
                    SumMatchInfo sumMatchInfo = new SumMatchInfo();
                    sumMatchInfo.setGroup(new String[]{"supplyinvorg", "supplywarehouse", "supplylocation", "supplystoretype", "invstatus"});
                    sumMatchInfo.setSum(new String[]{"matchbaseqty"});
                    splitMap.put(entryID, sumMatchInfo);
                }
                ((SumMatchInfo)splitMap.get(entryID)).addMatchResultInfo(matchInfo);
                ListSelectedRow selectedRow = this.buildListSelectedRow(demandEntryField, matchInfo);
                rowList.add(selectedRow);
            }
            if (rowList.size() <= 0) continue;
            List<DynamicObject> balanceAdviseList = this.convertAdvise(outPutResultEntity, demandSrcBillEntityNum, botpRuleId, rowList, genResult);
            if (!genResult.isSuccess()) {
                return;
            }
            for (DynamicObject balanceAdvise : balanceAdviseList) {
                this.handleAfterMatchAdviseConvert(topMatchInfoEntry, balanceAdvise, balanceScheme, splitMap, demandOrgCache);
            }
            genResult.addGenAdviceList(balanceAdviseList, true);
        }
    }

    private Map<String, List<DynamicObject>> buildGroupMatch(List<DynamicObject> matchDetailEntry, BalanceInventoryScheme scheme) {
        HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>(matchDetailEntry.size());
        List splitRuleFields = scheme.getSplitRuleFields();
        for (DynamicObject dynamicObject : matchDetailEntry) {
            String groupKey = this.buildMatchGroupKey(dynamicObject, splitRuleFields);
            result.computeIfAbsent(groupKey, k -> new ArrayList()).add(dynamicObject);
        }
        return result;
    }

    private String buildMatchGroupKey(DynamicObject matchEntryInfo, List<String> splitRuleFields) {
        StringBuilder matchedGroupValueSb = new StringBuilder();
        if (splitRuleFields.isEmpty()) {
            matchedGroupValueSb.append(matchEntryInfo.getString("advicetype")).append("$");
            matchedGroupValueSb.append(matchEntryInfo.getString("demandbilltype")).append("$");
            matchedGroupValueSb.append(matchEntryInfo.getString("demandorg")).append("$");
            matchedGroupValueSb.append(matchEntryInfo.getString("invorg")).append("$");
            matchedGroupValueSb.append(matchEntryInfo.getString("supplyorg")).append("$");
            if ("C".equals(matchEntryInfo.getString("supplytype")) || "D".equals(matchEntryInfo.getString("supplytype"))) {
                matchedGroupValueSb.append(matchEntryInfo.getString("supplyowner")).append("$");
            }
            matchedGroupValueSb.append(matchEntryInfo.getString("biztype")).append("$");
            matchedGroupValueSb.append(matchEntryInfo.getString("demandkind")).append("$");
            matchedGroupValueSb.append(matchEntryInfo.getString("invstatus")).append("$");
        } else {
            for (String splitRuleField : splitRuleFields) {
                matchedGroupValueSb.append(matchEntryInfo.getString(splitRuleField)).append("$");
            }
        }
        return matchedGroupValueSb.toString();
    }

    private ListSelectedRow buildListSelectedRow(String demandEntryField, DynamicObject matchInfo) {
        ListSelectedRow selectedRow = new ListSelectedRow();
        selectedRow.setPrimaryKeyValue((Object)matchInfo.getLong("demandbillid"));
        selectedRow.setBillNo(matchInfo.getString("demandbillno"));
        selectedRow.setEntryEntityKey(demandEntryField);
        selectedRow.setEntryPrimaryKeyValue((Object)matchInfo.getLong("demandentryid"));
        return selectedRow;
    }

    private List<DynamicObject> convertAdvise(String targetEntity, String sourceEntity, String botpRuleId, List<ListSelectedRow> rowList, BalanceInvGenResult genResult) {
        ConvertOperationResult covertResult = BalanceInvExecuteHelper.convertBill((String)sourceEntity, (String)targetEntity, rowList, (String)botpRuleId, (boolean)false);
        StringBuilder errorMsg = new StringBuilder();
        if (!covertResult.isSuccess()) {
            errorMsg.append(ResManager.loadKDString((String)"\u9700\u6c42\u7533\u8bf7\u5355\u751f\u6210\u5229\u5e93\u5efa\u8bae\u5931\u8d25\uff1a", (String)"IM-N-810486", (String)SCMC_IM_FORM, (Object[])new Object[0])).append("\n").append(ResManager.loadKDString((String)"\u8f6c\u6362\u5931\u8d25\uff1a", (String)"IM-N-078141", (String)SCMC_IM_FORM, (Object[])new Object[0]));
            errorMsg.append(BalanceInvExecuteHelper.getConvertErrorMsg((ConvertOperationResult)covertResult));
        }
        if (errorMsg.length() > 0) {
            genResult.setErrorMsg(errorMsg.toString());
        }
        MainEntityType balanceAdviseEntity = EntityMetadataCache.getDataEntityType((String)targetEntity);
        List balanceAdviseList = covertResult.loadTargetDataObjects((objects, dataEntityType) -> BusinessDataServiceHelper.loadRefence((Object[])objects, (IDataEntityType)dataEntityType), balanceAdviseEntity);
        return balanceAdviseList;
    }

    private void handleAfterMatchAdviseConvert(DynamicObject matchInfoEntry, DynamicObject balanceAdvise, BalanceInventoryScheme balanceScheme, Map<Long, SumMatchInfo> splitMap, Map<Long, Long> demandOrgCache) {
        ORM orm = ORM.create();
        String calculateNum = matchInfoEntry.getString("calculatenum");
        balanceAdvise.set("calculatenum", (Object)calculateNum);
        balanceAdvise.set("balanceinvscheme", (Object)orm.newDynamicObject("balanceinv_scheme", (Object)balanceScheme.getId()));
        balanceAdvise.set("advicetype", (Object)matchInfoEntry.getString("advicetype"));
        String supplyType = matchInfoEntry.getString("supplytype");
        if (!"C".equals(supplyType) && !"D".equals(supplyType)) {
            balanceAdvise.set("supplyorg", (Object)orm.newDynamicObject("bos_org", (Object)matchInfoEntry.getLong("supplyorg")));
        } else {
            balanceAdvise.set("supplier", (Object)orm.newDynamicObject("bd_supplier", (Object)matchInfoEntry.getLong("supplyorg")));
        }
        DynamicObjectCollection entries = balanceAdvise.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection newEntries = new DynamicObjectCollection();
        MainEntityType orgEntityType = MetadataServiceHelper.getDataEntityType((String)"bos_org");
        String ownerType = matchInfoEntry.getString("supplyownertype");
        MainEntityType ownerEntityType = MetadataServiceHelper.getDataEntityType((String)ownerType);
        MainEntityType warehouseEntityType = MetadataServiceHelper.getDataEntityType((String)"bd_warehouse");
        MainEntityType locationEntityType = MetadataServiceHelper.getDataEntityType((String)"bd_location");
        MainEntityType invTypeEntityType = MetadataServiceHelper.getDataEntityType((String)"bd_invtype");
        MainEntityType invStatusEntityType = MetadataServiceHelper.getDataEntityType((String)"bd_invstatus");
        int seq = 0;
        for (DynamicObject entry : entries) {
            Long demandInvOrgId;
            ++seq;
            DynamicObject demandInvOrg = entry.getDynamicObject("invorg");
            if (demandInvOrg == null && (demandInvOrgId = BalanceInvExecuteHelper.getDemandInvOrg((Object)entry.get("demandorg"), demandOrgCache)) != null) {
                entry.set("invorg", (Object)new DynamicObject((DynamicObjectType)orgEntityType, (Object)demandInvOrgId));
            }
            long demandSrcEntryId = entry.getLong("demandbillentryid");
            SumMatchInfo sumMatchInfo = splitMap.get(demandSrcEntryId);
            int i = 0;
            for (Map sumMatchInfoEntry : sumMatchInfo.getGroupedCollection()) {
                if (i > 0) {
                    ++seq;
                    entry = (DynamicObject)OrmUtils.clone((IDataEntityBase)entry, (boolean)false, (boolean)true);
                    entry.setParent((Object)balanceAdvise);
                    newEntries.add((Object)entry);
                }
                entry.set("ownertype", (Object)ownerType);
                entry.set("owner", (Object)new DynamicObject((DynamicObjectType)ownerEntityType, matchInfoEntry.get("supplyowner")));
                entry.set("adviseqty", sumMatchInfoEntry.get("matchbaseqty"));
                entry.set("baseqty", sumMatchInfoEntry.get("matchbaseqty"));
                entry.set("remaininbaseqty", sumMatchInfoEntry.get("matchbaseqty"));
                entry.set("supplyinvorg", (Object)new DynamicObject((DynamicObjectType)orgEntityType, sumMatchInfoEntry.get("supplyinvorg")));
                entry.set("supplywarehouse", (Object)new DynamicObject((DynamicObjectType)warehouseEntityType, sumMatchInfoEntry.get("supplywarehouse")));
                entry.set("supplylocation", (Object)new DynamicObject((DynamicObjectType)locationEntityType, sumMatchInfoEntry.get("supplylocation")));
                entry.set("supplystoretype", (Object)new DynamicObject((DynamicObjectType)invTypeEntityType, sumMatchInfoEntry.get("supplystoretype")));
                entry.set("supplystorestate", (Object)new DynamicObject((DynamicObjectType)invStatusEntityType, sumMatchInfoEntry.get("invstatus")));
                for (DynamicObject matchResultEntry : (List)sumMatchInfoEntry.get("resultList")) {
                    matchResultEntry.set("invadviceseq", (Object)seq);
                    matchResultEntry.set("invadvice", (Object)balanceAdvise.getString("id"));
                }
                entry.set("seq", (Object)seq);
                ++i;
            }
        }
        entries.addAll((Collection)newEntries);
    }
}

