/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.balanceinv.workbenches.genadvice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.pojo.BalanceInventoryScheme;
import kd.scmc.im.business.balanceinv.pojo.UnMatchInfo;
import kd.scmc.im.formplugin.balanceinv.workbenches.genadvice.BalanceInvGenResult;

public class BalanceInvWbGenUnMatchAdvice {
    public static final String SCMC_IM_FORM = "scmc-im-formplugin";
    private static Log logger = LogFactory.getLog((String)"kd.scmc.im.formplugin.balanceinv.workbenches.helper.BalanceInvWbGenUnMatchAdviceHelper");

    public void reqGenUnMatchBalanceAdvise(List<DynamicObject> matchDetailEntry, BalanceInventoryScheme balanceScheme, BalanceInvGenResult genResult) {
        HashMap<Long, List<UnMatchInfo>> entryIdUnMatchMap = new HashMap<Long, List<UnMatchInfo>>(16);
        HashMap<String, List<UnMatchInfo>> unMatchGroupInfo = new HashMap<String, List<UnMatchInfo>>(16);
        for (DynamicObject matchEntry : matchDetailEntry) {
            UnMatchInfo unMatchInfo = BalanceInvExecuteHelper.buildUnMatchInfo((DynamicObject)matchEntry, (String)"pm_requirapplybill");
            entryIdUnMatchMap.computeIfAbsent(unMatchInfo.getEntryId(), k -> new ArrayList()).add(unMatchInfo);
            String unMatchGroupKey = this.getUnMatchGroupValue(unMatchInfo, balanceScheme);
            unMatchGroupInfo.computeIfAbsent(unMatchGroupKey, k -> new ArrayList()).add(unMatchInfo);
        }
        this.genUnMatchedBalanceAdvise(balanceScheme, unMatchGroupInfo, entryIdUnMatchMap, matchDetailEntry, genResult);
    }

    private String getUnMatchGroupValue(UnMatchInfo unMatchInfo, BalanceInventoryScheme scheme) {
        List splitRuleFields = scheme.getSplitRuleFields();
        StringBuilder groupValueSb = new StringBuilder();
        groupValueSb.append(unMatchInfo.getAdviseType()).append("$");
        if (splitRuleFields.isEmpty()) {
            groupValueSb.append(unMatchInfo.getBalanceOrgId()).append("$");
            groupValueSb.append(unMatchInfo.getDemandOrgId()).append("$");
            groupValueSb.append(unMatchInfo.getDemandKind()).append("$");
            groupValueSb.append(unMatchInfo.getDemandSrcBillEntityNum()).append("$");
            groupValueSb.append(unMatchInfo.getBizType()).append("$");
        } else {
            DynamicObject matchEntryInfo = unMatchInfo.getMatchEntryInfo();
            for (String splitRuleField : splitRuleFields) {
                groupValueSb.append(matchEntryInfo.getString(splitRuleField)).append("$");
            }
        }
        return groupValueSb.toString();
    }

    private void genUnMatchedBalanceAdvise(BalanceInventoryScheme balanceScheme, Map<String, List<UnMatchInfo>> groupedUnMatchMap, Map<Long, List<UnMatchInfo>> entryIdUnMatchMap, List<DynamicObject> matchDetailEntry, BalanceInvGenResult genResult) {
        HashMap<Long, Long> demandOrgCache = new HashMap<Long, Long>(16);
        HashMap<Long, Long> purOrg2AccountOrgCache = new HashMap<Long, Long>(16);
        HashMap<Long, Long> purOrg2InvOrgCache = new HashMap<Long, Long>(16);
        String outPutResultEntity = balanceScheme.getDemandModel().getOutPutResultEntity();
        for (List<UnMatchInfo> unMatchInfoList : groupedUnMatchMap.values()) {
            if (!genResult.isSuccess() || unMatchInfoList == null || unMatchInfoList.isEmpty()) continue;
            String demandSrcBillEntityNum = unMatchInfoList.get(0).getDemandSrcBillEntityNum();
            String botpRuleId = (String)balanceScheme.getDemandDsMap().get(demandSrcBillEntityNum);
            String demandEntryField = BalanceInvExecuteHelper.getDemandEntryField((String)demandSrcBillEntityNum, (BalanceInventoryScheme)balanceScheme);
            ArrayList<ListSelectedRow> rowList = new ArrayList<ListSelectedRow>(unMatchInfoList.size());
            for (UnMatchInfo unMatchInfo : unMatchInfoList) {
                ListSelectedRow selectedRow = new ListSelectedRow();
                selectedRow.setPrimaryKeyValue((Object)unMatchInfo.getBillId());
                selectedRow.setEntryEntityKey(demandEntryField);
                selectedRow.setEntryPrimaryKeyValue((Object)unMatchInfo.getEntryId());
                rowList.add(selectedRow);
            }
            ConvertOperationResult covertResult = BalanceInvExecuteHelper.convertBill((String)demandSrcBillEntityNum, (String)outPutResultEntity, rowList, (String)botpRuleId, (boolean)false);
            if (!covertResult.isSuccess()) {
                StringBuilder errorMsg = new StringBuilder();
                errorMsg.append(ResManager.loadKDString((String)"\u9700\u6c42\u7533\u8bf7\u5355\u751f\u6210\u5229\u5e93\u5efa\u8bae\u5931\u8d25\uff1a", (String)"IM-N-810486", (String)SCMC_IM_FORM, (Object[])new Object[0])).append("\n").append(ResManager.loadKDString((String)"\u8f6c\u6362\u5931\u8d25\uff1a", (String)"IM-N-078141", (String)SCMC_IM_FORM, (Object[])new Object[0]));
                errorMsg.append(BalanceInvExecuteHelper.getConvertErrorMsg((ConvertOperationResult)covertResult));
                genResult.setErrorMsg(errorMsg.toString());
                continue;
            }
            MainEntityType balanceAdviseEntity = EntityMetadataCache.getDataEntityType((String)outPutResultEntity);
            List balanceAdviseList = covertResult.loadTargetDataObjects((objects, dataEntityType) -> BusinessDataServiceHelper.loadRefence((Object[])objects, (IDataEntityType)dataEntityType), balanceAdviseEntity);
            for (DynamicObject balanceAdvise : balanceAdviseList) {
                this.handleAfterUnMatchAdviseConvert(balanceScheme, unMatchInfoList.get(0), balanceAdvise, demandOrgCache, purOrg2AccountOrgCache, purOrg2InvOrgCache, entryIdUnMatchMap);
            }
            genResult.addGenAdviceList(balanceAdviseList, true);
        }
    }

    private void handleAfterUnMatchAdviseConvert(BalanceInventoryScheme balanceScheme, UnMatchInfo unMatchInfo, DynamicObject balanceAdvise, Map<Long, Long> demandOrgCache, Map<Long, Long> purOrg2AccountOrgCache, Map<Long, Long> purOrg2InvOrgCache, Map<Long, List<UnMatchInfo>> unMatchMapGByEntryId) {
        ORM orm = ORM.create();
        String adviceType = unMatchInfo.getAdviseType();
        Long balanceOrgId = balanceScheme.getBalanceOrgId();
        balanceAdvise.set("org", (Object)orm.newDynamicObject("bos_org", (Object)balanceOrgId));
        balanceAdvise.set("balanceinvscheme", (Object)orm.newDynamicObject("balanceinv_scheme", (Object)balanceScheme.getId()));
        balanceAdvise.set("calculatenum", (Object)unMatchInfo.getMatchEntryInfo().getString("calculatenum"));
        balanceAdvise.set("advicetype", (Object)adviceType);
        boolean isPurAdvice = "A".equals(adviceType);
        if (isPurAdvice) {
            balanceAdvise.set("supplyorg", (Object)0);
        }
        MainEntityType orgEntityType = MetadataServiceHelper.getDataEntityType((String)"bos_org");
        MainEntityType matEntityType = MetadataServiceHelper.getDataEntityType((String)"bd_material");
        MainEntityType unitEntityType = MetadataServiceHelper.getDataEntityType((String)"bd_measureunits");
        DynamicObjectCollection entries = balanceAdvise.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection newEntries = new DynamicObjectCollection();
        int seq = 0;
        for (DynamicObject entry : entries) {
            Long demandInvOrgId;
            ++seq;
            DynamicObject demandInvOrg = entry.getDynamicObject("invorg");
            if (demandInvOrg == null && (demandInvOrgId = BalanceInvExecuteHelper.getDemandInvOrg((Object)entry.get("demandorg"), demandOrgCache)) != null) {
                entry.set("invorg", (Object)new DynamicObject((DynamicObjectType)orgEntityType, (Object)demandInvOrgId));
            }
            if (isPurAdvice) {
                BalanceInvExecuteHelper.handlePurAdvice((DynamicObject)entry, (Long)balanceOrgId, purOrg2AccountOrgCache, purOrg2InvOrgCache);
            }
            long demandSrcEntryId = entry.getLong("demandbillentryid");
            List<UnMatchInfo> entryMatchList = unMatchMapGByEntryId.get(demandSrcEntryId);
            int size = entryMatchList.size();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    ++seq;
                    entry = (DynamicObject)OrmUtils.clone((IDataEntityBase)entry, (boolean)false, (boolean)true);
                    newEntries.add((Object)entry);
                }
                if ("invp_safestock_record".equals(unMatchInfo.getDemandSrcBillEntityNum())) {
                    if (entry.get("material") == null) {
                        entry.set("material", (Object)new DynamicObject((DynamicObjectType)matEntityType, (Object)unMatchInfo.getMaterialId()));
                    }
                    if (entry.get("baseunit") == null) {
                        entry.set("baseunit", (Object)new DynamicObject((DynamicObjectType)unitEntityType, (Object)unMatchInfo.getBaseUnitId()));
                    }
                }
                UnMatchInfo matchInfo = entryMatchList.get(i);
                DynamicObject matchEntry = matchInfo.getMatchEntryInfo();
                matchEntry.set("invadviceseq", (Object)seq);
                matchEntry.set("invadvice", (Object)balanceAdvise.getString("id"));
                entry.set("seq", (Object)seq);
                Date finishDate = entry.getDate("planfinishdate");
                entry.set("planstartdate", (Object)finishDate);
                entry.set("adviseqty", (Object)matchInfo.getUnMatchQty());
                entry.set("baseqty", (Object)matchInfo.getUnMatchQty());
                entry.set("remaininbaseqty", (Object)matchInfo.getUnMatchQty());
            }
        }
        entries.addAll((Collection)newEntries);
    }
}

