/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.balanceinv.workbenches.genadvice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.balanceinv.BalanceInvExecuteHelper;
import kd.scmc.im.business.balanceinv.pojo.BalanceInventoryScheme;
import kd.scmc.im.business.balanceinv.pojo.UnMatchInfo;
import kd.scmc.im.formplugin.balanceinv.workbenches.genadvice.BalanceInvGenResult;

public class BalanceInvWbSafeStockGenAdvice {
    public void safeStockGenBalanceAdvise(List<DynamicObject> matchDetailEntry, BalanceInventoryScheme balanceScheme, BalanceInvGenResult genResult) {
        List splitRuleFields = balanceScheme.getSplitRuleFields();
        HashMap<String, List<UnMatchInfo>> unMatchGroupInfo = new HashMap<String, List<UnMatchInfo>>(16);
        for (DynamicObject matchEntry : matchDetailEntry) {
            UnMatchInfo unMatchInfo = BalanceInvExecuteHelper.buildUnMatchInfo((DynamicObject)matchEntry, (String)"invp_safestock_record");
            String groupKey = this.getUnMatchGroupValue(unMatchInfo, splitRuleFields);
            unMatchGroupInfo.computeIfAbsent(groupKey, k -> new ArrayList()).add(unMatchInfo);
        }
        if (!unMatchGroupInfo.isEmpty()) {
            this.genUnMatchedBalanceAdvise(balanceScheme, unMatchGroupInfo, genResult);
        }
    }

    private String getUnMatchGroupValue(UnMatchInfo unMatchInfo, List<String> splitRuleFields) {
        StringBuilder groupValueSb = new StringBuilder();
        groupValueSb.append(unMatchInfo.getAdviseType()).append("$");
        if (splitRuleFields.isEmpty()) {
            groupValueSb.append(unMatchInfo.getBalanceOrgId()).append("$");
            groupValueSb.append(unMatchInfo.getDemandOrgId()).append("$");
            groupValueSb.append(unMatchInfo.getDemandKind()).append("$");
            groupValueSb.append(unMatchInfo.getDemandSrcBillEntityNum()).append("$");
            groupValueSb.append(unMatchInfo.getBizType()).append("$");
        } else {
            DynamicObject matchEntryInfo = unMatchInfo.getMatchEntryInfo();
            for (String splitRuleField : splitRuleFields) {
                groupValueSb.append(matchEntryInfo.getString(splitRuleField)).append("$");
            }
        }
        return groupValueSb.toString();
    }

    private void genUnMatchedBalanceAdvise(BalanceInventoryScheme balanceScheme, Map<String, List<UnMatchInfo>> groupedUnMatchMap, BalanceInvGenResult genResult) {
        ORM orm = ORM.create();
        int size = groupedUnMatchMap.size();
        ArrayList<DynamicObject> targetBillList = new ArrayList<DynamicObject>(size);
        Date systemDate = new Date();
        HashMap<Long, Long> demandOrgCache = new HashMap<Long, Long>(16);
        HashSet<Long> matIds = new HashSet<Long>(size);
        long[] adviceIds = DB.genGlobalLongIds((int)size);
        int i = 0;
        for (List<UnMatchInfo> unMatchInfoList : groupedUnMatchMap.values()) {
            if (unMatchInfoList == null || unMatchInfoList.isEmpty()) continue;
            DynamicObject balanceAdvice = orm.newDynamicObject("im_balanceinv_advice");
            balanceAdvice.set("id", (Object)adviceIds[i++]);
            this.handleAdvice(balanceScheme, unMatchInfoList, balanceAdvice, systemDate, matIds, demandOrgCache);
            targetBillList.add(balanceAdvice);
        }
        this.handleEntryPurchaseOrg(targetBillList, matIds, balanceScheme.getBalanceOrgId(), orm);
        genResult.addGenAdviceList(targetBillList, false);
    }

    private void handleAdvice(BalanceInventoryScheme balanceScheme, List<UnMatchInfo> unMatchInfos, DynamicObject balanceAdvise, Date systemDate, Set<Long> matIds, Map<Long, Long> demandOrgCache) {
        ORM orm = ORM.create();
        DynamicObject safeStockEntityObj = orm.newDynamicObject("bos_entityobject", (Object)"invp_safestock_record");
        balanceAdvise.set("org", (Object)orm.newDynamicObject("bos_org", (Object)balanceScheme.getBalanceOrgId()));
        balanceAdvise.set("balanceinvscheme", (Object)orm.newDynamicObject("balanceinv_scheme", (Object)balanceScheme.getId()));
        balanceAdvise.set("calculatenum", (Object)unMatchInfos.get(0).getMatchEntryInfo().getString("calculatenum"));
        balanceAdvise.set("advicetype", (Object)unMatchInfos.get(0).getAdviseType());
        String demandKind = unMatchInfos.get(0).getDemandKind();
        balanceAdvise.set("demandkind", (Object)demandKind);
        balanceAdvise.set("biztype", (Object)orm.newDynamicObject("bd_biztype", (Object)422857170485263360L));
        balanceAdvise.set("billstatus", (Object)"A");
        balanceAdvise.set("creator", (Object)orm.newDynamicObject("bos_user", (Object)RequestContext.get().getCurrUserId()));
        MainEntityType orgEntityType = MetadataServiceHelper.getDataEntityType((String)"bos_org");
        MainEntityType matEntityType = MetadataServiceHelper.getDataEntityType((String)"bd_material");
        MainEntityType unitEntityType = MetadataServiceHelper.getDataEntityType((String)"bd_measureunits");
        DynamicObjectCollection entries = balanceAdvise.getDynamicObjectCollection("entryentity");
        int seq = 0;
        for (UnMatchInfo unMatchInfo : unMatchInfos) {
            Long demandInvOrgId;
            DynamicObject entry = entries.addNew();
            Long demandBillId = unMatchInfo.getBillId();
            entry.set("seq", (Object)(++seq));
            DynamicObject matchEntry = unMatchInfo.getMatchEntryInfo();
            matchEntry.set("invadviceseq", (Object)seq);
            matchEntry.set("invadvice", (Object)balanceAdvise.getString("id"));
            entry.set("demandbillid", (Object)demandBillId);
            entry.set("isclosed", (Object)"A");
            entry.set("iscancel", (Object)"A");
            entry.set("demandorg", (Object)new DynamicObject((DynamicObjectType)orgEntityType, (Object)unMatchInfo.getDemandOrgId()));
            entry.set("applybilltype", (Object)safeStockEntityObj);
            Long materialId = unMatchInfo.getMaterialId();
            matIds.add(materialId);
            if ("invp_safestock_record".equals(unMatchInfo.getDemandSrcBillEntityNum())) {
                if (entry.get("material") == null) {
                    entry.set("material", (Object)new DynamicObject((DynamicObjectType)matEntityType, (Object)materialId));
                }
                if (entry.get("baseunit") == null) {
                    entry.set("baseunit", (Object)new DynamicObject((DynamicObjectType)unitEntityType, (Object)unMatchInfo.getBaseUnitId()));
                }
            }
            entry.set("planfinishdate", (Object)systemDate);
            entry.set("adviseqty", (Object)unMatchInfo.getUnMatchQty());
            entry.set("baseqty", (Object)unMatchInfo.getUnMatchQty());
            entry.set("remaininbaseqty", (Object)unMatchInfo.getUnMatchQty());
            DynamicObject demandInvOrg = entry.getDynamicObject("invorg");
            if (demandInvOrg == null && (demandInvOrgId = BalanceInvExecuteHelper.getDemandInvOrg((Object)entry.get("demandorg"), demandOrgCache)) != null) {
                entry.set("invorg", (Object)new DynamicObject((DynamicObjectType)orgEntityType, (Object)demandInvOrgId));
            }
            entry.set("pushstatus", (Object)"A");
        }
    }

    private void handleEntryPurchaseOrg(List<DynamicObject> targetBillList, Set<Long> matIds, Long balanceOrgId, ORM orm) {
        Object data;
        if (balanceOrgId == null) {
            return;
        }
        HashMap purOrg2AccountOrgCache = new HashMap(16);
        HashMap purOrg2InvOrgCache = new HashMap(16);
        ArrayList paramList = new ArrayList(matIds.size());
        for (Long matId : matIds) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
            paramMap.put("baseDataType", "2");
            paramMap.put("orgId", balanceOrgId);
            paramMap.put("baseDataId", matId);
            paramMap.put("bizType", "3");
            paramList.add(paramMap);
        }
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"pbd", (String)"ICategoryService", (String)"batchGetPurChaseOrg", (Object[])new Object[]{paramList, "invp_safestock_record"});
        Map dataMap = new HashMap(16);
        if (result != null && ((Boolean)result.get("success")).booleanValue() && (data = result.get("data")) != null) {
            dataMap = (Map)data;
        }
        HashMap<Long, Long> purRelationOrgCache = new HashMap<Long, Long>();
        for (DynamicObject advice : targetBillList) {
            DynamicObjectCollection entrySet = advice.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrySet) {
                Object material = entry.get("material");
                if (material == null) continue;
                Object materialId = ((DynamicObject)material).getPkValue();
                String cacheKey = balanceOrgId + "-" + materialId + "-" + "3" + "-" + "2";
                Object purchaseOrg = dataMap.get(cacheKey);
                if (purchaseOrg == null) {
                    purchaseOrg = this.getPurOrgByRelation(balanceOrgId, purRelationOrgCache);
                } else {
                    Map purchaseOrgMap = (Map)purchaseOrg;
                    purchaseOrg = purchaseOrgMap.get("orgId");
                }
                if (purchaseOrg != null) {
                    entry.set("purorg", (Object)orm.newDynamicObject("bos_org", purchaseOrg));
                }
                BalanceInvExecuteHelper.handlePurAdvice((DynamicObject)entry, (Long)balanceOrgId, purOrg2AccountOrgCache, purOrg2InvOrgCache);
            }
        }
    }

    private Long getPurOrgByRelation(Long balanceOrgId, Map<Long, Long> purRelationOrgCache) {
        Long purchaseOrgId = purRelationOrgCache.get(balanceOrgId);
        if (purchaseOrgId != null) {
            return purchaseOrgId;
        }
        DynamicObject purchaseOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)balanceOrgId, (String)"bos_org", (String)"fispurchase");
        if (purchaseOrg.getBoolean("fispurchase")) {
            purRelationOrgCache.put(balanceOrgId, balanceOrgId);
            return balanceOrgId;
        }
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(balanceOrgId.longValue());
        param.setToViewType("02");
        param.setDirectViewType("toorg");
        Map orgRelationMap = OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
        List orgRelations = (List)orgRelationMap.get("data");
        if (orgRelations != null && !orgRelations.isEmpty()) {
            for (Map orgRelation : orgRelations) {
                if (!Boolean.TRUE.equals(orgRelation.get("isDefault"))) continue;
                purchaseOrgId = (Long)orgRelation.get("orgId");
                break;
            }
            if (purchaseOrgId == null) {
                purchaseOrgId = (Long)((Map)orgRelations.get(0)).get("orgId");
            }
        }
        purRelationOrgCache.put(balanceOrgId, purchaseOrgId != null ? purchaseOrgId : 0L);
        return purchaseOrgId;
    }
}

