/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.balanceinv.workbenches.progress;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.RouteMode;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.scmc.im.business.balanceinv.constants.BalanceInvLogConstants;
import kd.scmc.im.business.balanceinv.workbench.helper.BalanceInvProgressHelper;
import kd.scmc.im.consts.BalanceInvWorkbenchLogConstant;
import kd.scmc.im.formplugin.balanceinv.workbenches.BalanceInvWorkbenchLog;

public class BalanceInvExecutingEditPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    public static final Log log = LogFactory.getLog(BalanceInvExecutingEditPlugin.class);
    private boolean canClose = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btnquerylog", "btncancel", "btnok"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.startBar();
        this.initProgress();
        this.setBtnVisible("btncancel", "btnok");
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.canClose || this.isFinished()) {
            return;
        }
        String message = ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u5e73\u8861\u5229\u5e93\u8fd0\u7b97\uff0c\u60a8\u70b9\u51fb\u4e86\u5173\u95ed\uff0c\u8bf7\u786e\u8ba4\u662f\u7ec8\u6b62\u8fd8\u662f\u8f6c\u5165\u540e\u53f0?", (String)"IM-C-458151", (String)"scmc-im-formplugin", (Object[])new Object[0]);
        HashMap<Integer, String> btNameMap = new HashMap<Integer, String>(4);
        btNameMap.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u8f6c\u5165\u540e\u53f0", (String)"IM-C-212763", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        btNameMap.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u7ec8\u6b62", (String)"IM-C-762255", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        this.getView().showConfirm(message, "", MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener("TOBACKGROUND_OR_SUSPEND_CONFIRM", (IFormPlugin)this), btNameMap);
        this.stopBar();
        e.setCancel(true);
    }

    public void click(EventObject evt) {
        String controlKey;
        super.click(evt);
        switch (controlKey = ((Control)evt.getSource()).getKey()) {
            case "btnquerylog": {
                this.queryBalanceInvLog();
                break;
            }
            case "btncancel": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u7ec8\u6b62\u5e73\u8861\u5229\u5e93\u8fd0\u7b97\u5417\uff1f", (String)"IM-C-271036", (String)"scmc-im-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("BALANCEINV_SUSPEND", (IFormPlugin)this));
                break;
            }
            case "btnok": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u628a\u5e73\u8861\u5229\u5e93\u8fd0\u7b97\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\u5417\uff1f", (String)"IM-C-750575", (String)"scmc-im-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("BALANCEINV_TOBACKGROUND", (IFormPlugin)this));
                break;
            }
        }
    }

    private void queryBalanceInvLog() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null) {
            log.info("BalanceInvExecutingEditPlugin#click\uff1acustomParams is null");
            return;
        }
        Object execLogId = customParams.get("balanceInvLogId");
        BalanceInvProgressHelper.showBalanceLogForm((Long)((Long)execLogId), (IFormView)this.getView());
        this.closeForm();
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "BALANCEINV_TOBACKGROUND": {
                this.confirmToBackGround(e);
                break;
            }
            case "BALANCEINV_SUSPEND": {
                this.confirmSuspend(e);
                break;
            }
            case "TOBACKGROUND_OR_SUSPEND_CONFIRM": {
                this.confirmCloseForm(e);
                break;
            }
        }
    }

    private void confirmCloseForm(MessageBoxClosedEvent e) {
        if (e.getResult() == MessageBoxResult.Yes) {
            this.toBackground();
        } else {
            this.doSuspend();
        }
    }

    private void confirmSuspend(MessageBoxClosedEvent e) {
        if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.doSuspend();
        }
    }

    private void doSuspend() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null) {
            log.info("BalanceInvExecutingEditPlugin#doSuspend\uff1acustomParams is null");
            return;
        }
        Object execLogId = customParams.get("balanceInvLogId");
        if (execLogId == null) {
            this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u8fd0\u7b97\u65e5\u5fd7\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"IM-W-405704", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject balanceInvLogInfo = BusinessDataServiceHelper.loadSingle((String)"im_balanceinv_log", (String)("status," + BalanceInvLogConstants.CAL_NUM), (QFilter[])new QFilter("id", "=", execLogId).toArray());
        String status = balanceInvLogInfo.getString(BalanceInvLogConstants.STATUS);
        if (BalanceInvLogConstants.STATUS_RUNNING.equals(status)) {
            String calNum = balanceInvLogInfo.getString(BalanceInvLogConstants.CAL_NUM);
            balanceInvLogInfo.set(BalanceInvLogConstants.STATUS, (Object)BalanceInvLogConstants.STATUS_USER_STOP);
            this.setStatus(calNum);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{balanceInvLogInfo});
        }
        this.stopBar();
        this.closeForm();
    }

    private void setStatus(String calNum) {
        DistributeSessionlessCache sessionLessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("balanceInventory");
        sessionLessCache.remove(calNum);
    }

    private void confirmToBackGround(MessageBoxClosedEvent e) {
        if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.toBackground();
        }
    }

    private void toBackground() {
        this.closeForm();
        JobFormInfo jobFormInfo = new JobFormInfo();
        String taskId = this.buildJobInfo(jobFormInfo);
        if (taskId == null) {
            return;
        }
        TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)ScheduleServiceHelper.queryTask((String)taskId));
        BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
        ThreadPools.executeOnce((String)"task-balanceinv-background-monitor", (Runnable)subscriber);
    }

    private String buildJobInfo(JobFormInfo jobFormInfo) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null) {
            log.info("BalanceInvExecutingEditPlugin#buildJobInfo\uff1acustomParams is null");
            return null;
        }
        Object benchLogId = customParams.get("benchLogId");
        Object execLogId = customParams.get("balanceInvLogId");
        Object execLogNum = customParams.get("balanceInvLogNum");
        Object pageId = customParams.get("pageId");
        if (benchLogId == null || execLogId == null || execLogNum == null || pageId == null) {
            return null;
        }
        JobInfo jobInfo = new JobInfo();
        HashMap params = new HashMap();
        params.put("benchLogId", benchLogId);
        params.put("balanceInvLogId", execLogId);
        params.put("balanceInvLogNum", execLogNum);
        params.put("pageId", pageId);
        jobInfo.setParams(params);
        jobInfo.setName(ResManager.loadKDString((String)"\u5e73\u8861\u5229\u5e93\u8fd0\u7b97", (String)"IM-D-304006", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRouteMode(RouteMode.SHARDINGTASK);
        jobInfo.setAppId("im");
        jobInfo.setTaskClassname("kd.scmc.im.formplugin.balanceinv.workbenches.progress.BalanceInvExecBackgroundTask");
        jobInfo.setRunConcurrently(false);
        jobInfo.setNumber("BALANCEINV_" + execLogNum);
        jobFormInfo.setJobInfo(jobInfo);
        jobFormInfo.setClickClassName("kd.scmc.im.formplugin.balanceinv.workbenches.progress.BalanceInvTaskClick");
        jobFormInfo.setParentPageId(this.getView().getFormShowParameter().getParentPageId());
        jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
        return ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
    }

    private void closeForm() {
        this.canClose = true;
        this.getView().close();
    }

    public void onProgress(ProgressEvent e) {
        DynamicObject execLog = this.queryProgressLog();
        if (execLog == null) {
            return;
        }
        String status = execLog.getString("status");
        int progress = execLog.getInt("processrate");
        if ("A".equals(status)) {
            if (progress >= 100) {
                progress = 99;
            }
            this.setProgress(progress, e);
        } else {
            this.complete(e, status, progress);
        }
    }

    private void complete(ProgressEvent e, String status, int progress) {
        boolean finished = this.isFinished();
        this.setFinished(true);
        Label processAp = (Label)this.getControl("processap");
        if ("C".equals(status)) {
            processAp.setText(ResManager.loadKDString((String)"\u8fd0\u7b97\u5931\u8d25", (String)"IM-D-134504", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            HashMap<String, String> fieldMap = new HashMap<String, String>();
            fieldMap.put("fc", "rgba(255,0,0,0.7)");
            this.getView().updateControlMetadata("progressbarap", fieldMap);
            if (!finished) {
                this.setProgress(progress, e);
                this.setBtnVisible("btnquerylog");
                return;
            }
            this.setProgress(progress, e);
            this.stopBar();
            return;
        }
        if (!finished) {
            this.updateWorkBenchLog();
            this.setProgress(99, e);
            return;
        }
        processAp.setText(ResManager.loadKDString((String)"\u8fd0\u7b97\u6210\u529f", (String)"IM-D-763480", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        this.setProgress(100, e);
        this.stopBar();
        this.getView().returnDataToParent((Object)"to_subresultview");
        this.closeForm();
    }

    private void updateWorkBenchLog() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null) {
            log.info("BalanceInvExecutingEditPlugin#updateWorkBenchLog\uff1acustomParams is null");
            return;
        }
        Object benchLog = customParams.get("benchLogId");
        Object execLogNum = customParams.get("balanceInvLogNum");
        if (benchLog != null && execLogNum != null) {
            Long benchLogId = benchLog instanceof Long ? (Long)benchLog : Long.parseLong(benchLog.toString());
            BalanceInvWorkbenchLog.updateLogStatus(benchLogId, execLogNum.toString(), BalanceInvWorkbenchLogConstant.STEP_RESULT_VIEW);
        } else {
            log.info("BalanceInvExecutingEditPlugin#updateWorkBenchLog\uff1abenchLogId = {} ,execLogNum = {}.", benchLog, execLogNum);
        }
    }

    private void setProgress(int progress, ProgressEvent e) {
        this.setProgressText(progress);
        e.setProgress(progress);
    }

    private void setProgressText(int progress) {
        Label totalLabel = (Label)this.getControl("progress");
        totalLabel.setText(String.valueOf(progress));
    }

    private boolean isFinished() {
        String finished = this.getView().getPageCache().get("key_balanceinv_finished");
        if (StringUtils.isBlank((CharSequence)finished)) {
            return false;
        }
        return Boolean.parseBoolean(finished);
    }

    private void setFinished(boolean finished) {
        this.getView().getPageCache().put("key_balanceinv_finished", String.valueOf(finished));
    }

    private void initProgress() {
        DynamicObject execLog = this.queryProgressLog();
        if (execLog == null) {
            return;
        }
        int progress = execLog.getInt("processrate");
        if (progress >= 100) {
            progress = 99;
        }
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.setPercent(progress);
        this.setProgressText(progress);
    }

    private void setBtnVisible(String ... visibleBtn) {
        ArrayList<String> buttons = new ArrayList<String>(Arrays.asList("btncancel", "btnok", "btnquerylog"));
        buttons.removeAll(Arrays.asList(visibleBtn));
        this.getView().setVisible(Boolean.TRUE, visibleBtn);
        this.getView().setVisible(Boolean.FALSE, buttons.toArray(new String[0]));
    }

    private DynamicObject queryProgressLog() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null) {
            log.info("BalanceInvExecutingEditPlugin#queryProgressLog\uff1acustomParams is null");
            this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u8fd0\u7b97\u65e5\u5fd7\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"BalanceInvExecutingEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            this.closeForm();
            return null;
        }
        Object execLogNum = customParams.get("balanceInvLogNum");
        Object execLogId = customParams.get("balanceInvLogId");
        if (execLogNum == null) {
            this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u8fd0\u7b97\u65e5\u5fd7\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"IM-W-405704", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            this.closeForm();
            return null;
        }
        DynamicObject execLog = QueryServiceHelper.queryOne((String)"im_balanceinv_log", (String)"status,processrate", (QFilter[])new QFilter("id", "=", execLogId).toArray());
        if (execLog == null) {
            this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7f16\u7801\u4e3a\u201c{0}\u201d\u7684\u8fd0\u7b97\u65e5\u5fd7\u3002", (String)"IM-D-153505", (String)"scmc-im-formplugin", (Object[])new Object[]{execLogNum}));
            this.closeForm();
        }
        return execLog;
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.start();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.stop();
    }
}

