/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.botp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.entity.botp.FieldConvertType;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.ImBillBotpHelp;
import kd.scmc.im.business.helper.InvBillCalcHelper;
import kd.scmc.im.business.helper.SetValueForBotpWBHelper;
import kd.scmc.im.business.helper.linetype.BillTypeMaterialHelper;
import kd.scmc.im.business.helper.linetype.LineTypeParam;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;
import org.apache.commons.lang3.StringUtils;

public class InvAfterBotpPlugin
extends AbstractConvertPlugIn {
    private DynamicObject defaultLineType;
    private DynamicObject bizType;
    private boolean isExitLineType = false;

    public void afterConvert(AfterConvertEventArgs e) {
        LineTypeParam lineTypeParam;
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(tgtMainType);
        IDataEntityProperty property = this.getTgtMainType().findProperty("linetype");
        this.isExitLineType = property != null;
        Long defaultLineTypeId = null;
        DynamicObject org = null;
        for (ExtendedDataEntity entity : entitys) {
            this.bizType = entity.getDataEntity().getDynamicObject("bizType");
            org = entity.getDataEntity().getDynamicObject("org");
        }
        if (org == null) {
            return;
        }
        this.checkOrg(org);
        if (this.bizType == null) {
            return;
        }
        ArrayList<Long> bizTypes = new ArrayList<Long>(1);
        bizTypes.add(this.bizType.getLong("id"));
        Map lineTypeByBillType = BillTypeMaterialHelper.getLineTypeByBillType(bizTypes);
        if (lineTypeByBillType.size() != 0 && (lineTypeParam = (LineTypeParam)lineTypeByBillType.get(this.bizType.getLong("id"))) != null && lineTypeParam.isDeafaultEnable()) {
            defaultLineTypeId = lineTypeParam.getDeafaultLineType();
        }
        this.defaultLineType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_linetype", (String)"number", (QFilter[])new QFilter("id", "=", defaultLineTypeId).toArray());
        for (int i = 0; i < entitys.length; ++i) {
            ExtendedDataEntity entity;
            entity = entitys[i];
            DynamicObject obj = entity.getDataEntity();
            DynamicObjectCollection entrycols = obj.getDynamicObjectCollection("billentry");
            if ("im_transdirbill".equalsIgnoreCase(tgtMainType)) {
                this.checkMaterial4InOrg(obj, entrycols);
            }
            if (entrycols.size() <= 0) continue;
            this.addprop(tgtMainType, obj, entrycols);
        }
    }

    private void checkOrg(DynamicObject org) {
        Object pkValue = org.getPkValue();
        QFilter qFilter = new QFilter("startstatus", "=", (Object)"B");
        qFilter.and("org", "=", pkValue);
        boolean exists = QueryServiceHelper.exists((String)"im_invstart", (QFilter[])qFilter.toArray());
        if (!exists) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u2018%s\u2019\u672a\u542f\u7528\u5e93\u5b58\u3002", (String)"InvAfterBotpPlugin", (String)"scmc-im-formplugin", (Object[])new Object[0]), org.getString("name")));
        }
    }

    private void addprop(String tgtMainType, DynamicObject obj, DynamicObjectCollection entrycoll) {
        ImBillBotpHelp.setDefultVaule((String)tgtMainType, (DynamicObject)obj);
        DynamicObject invScheme = obj.getDynamicObject("invscheme");
        ImBillBotpHelp.dealEntryScheme((DynamicObject)obj, (DynamicObjectCollection)entrycoll, (DynamicObject)invScheme);
        String billName = this.getTgtMainType().getName();
        if ("im_purinbill".equals(billName)) {
            SetValueForBotpWBHelper.purInSetValueByImport((DynamicObject)obj);
        }
        Object fieldKeyRule = this.getFieldKeyRule("qtyunit2nd");
        int size = entrycoll.size();
        HashMap cacheMap = new HashMap(size);
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            DynamicObject material;
            DynamicObject entry = (DynamicObject)entrycoll.get(rowIndex);
            DynamicObject linetype = null;
            if (this.isExitLineType) {
                linetype = entry.getDynamicObject("linetype");
            }
            if (linetype == null) {
                entry.set("linetype", (Object)this.defaultLineType);
            } else {
                entry.set("linetype", (Object)linetype);
            }
            String materialname = entry.getString("materialname");
            if ((materialname == null || materialname.equals("")) && (material = entry.getDynamicObject("material")) != null) {
                entry.set("materialname", (Object)material.getString("masterid.name"));
            }
            ImBillBotpHelp.setEntryAuxptyUnit((DynamicObject)entry);
            if (fieldKeyRule == null) {
                InvBillCalcHelper.entryAuxptyQtyCalc((DynamicObject)entry, (String)tgtMainType, cacheMap);
            }
            this.setOtherProp(entry);
        }
    }

    private Object getFieldKeyRule(String tarField) {
        String fieldKeyRule = null;
        List fieldMaps = this.getRule().getFieldMapPolicy().getFieldMaps();
        if (fieldMaps == null) {
            return fieldKeyRule;
        }
        if (tarField == null) {
            return fieldKeyRule;
        }
        for (FieldMapItem fieldMapItem : fieldMaps) {
            String targetFieldKey = fieldMapItem.getTargetFieldKey();
            if (!tarField.equals(targetFieldKey)) continue;
            String sourceFieldKey = fieldMapItem.getSourceFieldKey();
            CRFormula formula = fieldMapItem.getFormula();
            CRFormula constant = fieldMapItem.getConstant();
            CRValByConditions CRValByConditions2 = fieldMapItem.getValByConditions();
            int fieldConvertTypeValue = fieldMapItem.getFieldConvertType().getValue();
            if (fieldConvertTypeValue == FieldConvertType.SourceField.getValue()) {
                fieldKeyRule = sourceFieldKey;
            }
            if (fieldConvertTypeValue == FieldConvertType.Formula.getValue()) {
                fieldKeyRule = formula;
            }
            if (fieldConvertTypeValue == FieldConvertType.ByCondition.getValue()) {
                fieldKeyRule = CRValByConditions2;
            }
            if (fieldConvertTypeValue != FieldConvertType.CONSTANT.getValue()) continue;
            fieldKeyRule = constant;
        }
        return fieldKeyRule;
    }

    private void checkMaterial4InOrg(DynamicObject obj, DynamicObjectCollection entrycoll) {
        DynamicObject inOrg = obj.getDynamicObject("org");
        if (inOrg == null) {
            return;
        }
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)((Long)inOrg.getPkValue()));
        HashMap<Long, DynamicObject> materialMap = new HashMap<Long, DynamicObject>(entrycoll.size());
        for (DynamicObject entry : entrycoll) {
            DynamicObject material = entry.getDynamicObject("material");
            if (material == null) continue;
            materialMap.put(material.getLong("masterid.id"), material);
        }
        if (materialMap.size() == 0) {
            return;
        }
        ArrayList<String> errMaterialList = new ArrayList<String>();
        Map materialInfo = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (String)"enablelot", (QFilter[])new QFilter[]{new QFilter("masterid.id", "in", materialMap.keySet()), baseDataFilter});
        HashSet<Object> inOrgMasterIds = new HashSet<Object>(8);
        if (materialInfo != null) {
            for (Map.Entry materialEntry : materialInfo.entrySet()) {
                DynamicObject materialValue = (DynamicObject)materialEntry.getValue();
                inOrgMasterIds.add(materialValue.get("masterid.id"));
            }
        }
        for (Map.Entry entry : materialMap.entrySet()) {
            DynamicObject entryValue = (DynamicObject)entry.getValue();
            Object masterId = entry.getKey();
            if (inOrgMasterIds.contains(masterId)) continue;
            errMaterialList.add(entryValue.getString("masterid.name"));
        }
        if (errMaterialList.size() > 0) {
            String errMaterials = StringUtils.join(errMaterialList, (char)',');
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_INORG_NOT_MATERIALINFO(), (Object[])new Object[]{errMaterials, inOrg.getString("name")}));
        }
    }

    public void setOtherProp(DynamicObject entry) {
    }
}

