/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.botp;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.helper.InspectionHelper;
import kd.scmc.im.business.helper.InvSchemeHelper;

public class InvInspectBotpPlugin
extends AbstractConvertPlugIn {
    private static Set<String> INSPECT_BILL_TYPES = new HashSet<String>(Arrays.asList("sm_delivernotice", "sm_returnapply", "im_purreceivebill"));
    private static Set<String> TGT_MAIN_BILL_TYPES = new HashSet<String>(Arrays.asList("im_saloutbill", "im_invinspectbill"));

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        this.handleInvTypeAndStatus(e);
    }

    private void handleInvTypeAndStatus(AfterConvertEventArgs e) {
        String tgtMainType = this.getTgtMainType().toString();
        String srcBillType = this.getSrcMainType().toString();
        if (TGT_MAIN_BILL_TYPES.contains(tgtMainType) && INSPECT_BILL_TYPES.contains(srcBillType)) {
            ExtendedDataEntity[] dataEntities;
            ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
            for (ExtendedDataEntity dataEntity : dataEntities = targetExtDataEntitySet.FindByEntityKey(this.getTgtMainType().toString())) {
                DynamicObject targetBill = dataEntity.getDataEntity();
                this.initInvTypeAndStatus(targetBill);
                if (!"im_invinspectbill".equals(tgtMainType)) continue;
                this.setInspectOrg(targetBill);
            }
        }
    }

    private void initInvTypeAndStatus(DynamicObject targetBill) {
        DynamicObject scheme = targetBill.getDynamicObject("invscheme");
        if (scheme == null) {
            return;
        }
        DynamicObjectCollection billEntities = targetBill.getDynamicObjectCollection("billentry");
        if (CollectionUtils.isEmpty((Collection)billEntities)) {
            return;
        }
        DynamicObject billEntryFirst = (DynamicObject)billEntities.get(0);
        String botpInvSchemeNumber = null;
        boolean hasInvType = billEntryFirst.getDataEntityType().getProperties().containsKey((Object)"invtype");
        boolean hasOutInvType = billEntryFirst.getDataEntityType().getProperties().containsKey((Object)"outinvtype");
        boolean isInUpdate = scheme.getBoolean("isinupdate");
        boolean isOutUpdate = scheme.getBoolean("isoutupdate");
        for (DynamicObject billEntity : billEntities) {
            DynamicObject outInvType;
            DynamicObject invType;
            if (hasInvType && (invType = billEntity.getDynamicObject("invtype")) != null) {
                botpInvSchemeNumber = invType.getString("number");
            }
            if (hasOutInvType && StringUtils.isEmpty(botpInvSchemeNumber) && (outInvType = billEntity.getDynamicObject("outinvtype")) != null) {
                botpInvSchemeNumber = outInvType.getString("number");
            }
            if (hasInvType && isInUpdate) {
                DynamicObject invTypeEntry = InvSchemeHelper.getInvTypeEntryByInvType((DynamicObject)scheme, (String)"invtype", (String)botpInvSchemeNumber, (String)"invtypeentry", (String)"invtypeisdefault");
                DynamicObject defaultInvStatus = InvSchemeHelper.getDefaultInvStatus((DynamicObject)scheme);
                DynamicObject invType1 = invTypeEntry.getDynamicObject("invtype");
                String keeperType1 = invTypeEntry.getString("keepertype1");
                String ownerType1 = invTypeEntry.getString("ownertype1");
                InvInspectBotpPlugin.setValueIfNull(billEntity, "invtype", invType1);
                InvInspectBotpPlugin.setValueIfNull(billEntity, "keepertype", keeperType1);
                if (!ownerType1.equals(billEntity.get("ownertype"))) {
                    billEntity.set("ownertype", null);
                    billEntity.set("owner", null);
                }
                InvInspectBotpPlugin.setValueIfNull(billEntity, "ownertype", ownerType1);
                InvInspectBotpPlugin.setValueIfNull(billEntity, "invstatus", defaultInvStatus);
            }
            if (hasOutInvType && isOutUpdate) {
                DynamicObject defaultOutStatus = InvSchemeHelper.getDefaultOutInvStatus((DynamicObject)scheme);
                DynamicObject outInvTypeEntry = InvSchemeHelper.getInvTypeEntryByInvType((DynamicObject)scheme, (String)"outinvtype", (String)botpInvSchemeNumber, (String)"outinvtypeentry", (String)"outinvtypeisdefault");
                DynamicObject outInvType1 = outInvTypeEntry.getDynamicObject("outinvtype");
                String outKeeperType1 = outInvTypeEntry.getString("outkeepertype1");
                String outOwnerType1 = outInvTypeEntry.getString("outownertype1");
                InvInspectBotpPlugin.setValueIfNull(billEntity, "outinvtype", outInvType1);
                InvInspectBotpPlugin.setValueIfNull(billEntity, "outkeepertype", outKeeperType1);
                if (!outOwnerType1.equals(billEntity.get("outownertype"))) {
                    billEntity.set("outownertype", null);
                    billEntity.set("outowner", null);
                }
                InvInspectBotpPlugin.setValueIfNull(billEntity, "outownertype", outOwnerType1);
                InvInspectBotpPlugin.setValueIfNull(billEntity, "outinvstatus", defaultOutStatus);
            }
            botpInvSchemeNumber = null;
        }
    }

    private static void setValueIfNull(DynamicObject obj, String key, Object defaultValue) {
        Object value = obj.get(key);
        if (value == null) {
            obj.set(key, defaultValue);
            return;
        }
        if (value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            obj.set(key, defaultValue);
        }
    }

    private void setInspectOrg(DynamicObject targetBill) {
        DynamicObjectCollection billEntities = targetBill.getDynamicObjectCollection("billentry");
        if (CollectionUtils.isEmpty((Collection)billEntities)) {
            return;
        }
        HashMap<Object, DynamicObject> reqToInspectOrgMap = new HashMap<Object, DynamicObject>();
        for (DynamicObject billEntity : billEntities) {
            DynamicObject requireOrg;
            DynamicObject inspectOrg = billEntity.getDynamicObject("insporg");
            if (inspectOrg != null || (requireOrg = billEntity.getDynamicObject("entryreqorg")) == null) continue;
            if (reqToInspectOrgMap.containsKey(requireOrg.getPkValue())) {
                inspectOrg = (DynamicObject)reqToInspectOrgMap.get(requireOrg.getPkValue());
            } else {
                inspectOrg = InspectionHelper.getInspOrg((DynamicObject)requireOrg);
                reqToInspectOrgMap.put(requireOrg.getPkValue(), inspectOrg);
            }
            billEntity.set("insporg", (Object)inspectOrg);
        }
    }
}

