/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.botp;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.KitManagementHelper;
import kd.scmc.im.business.helper.SystemCallParamHelper;

public class InvToArApKitConvertPlugin
extends AbstractConvertPlugIn {
    private Map<Long, String> priceModelMap = new HashMap<Long, String>(16);
    private List<Map<String, Object>> parameters = new ArrayList<Map<String, Object>>(16);
    private Set<Long> srcBillIds = new HashSet<Long>(16);

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        boolean enableKitSale = SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"KIT0001");
        if (!enableKitSale) {
            return;
        }
        List sourceRows = e.getSourceRows();
        for (DynamicObject sourceRow : sourceRows) {
            this.srcBillIds.add(sourceRow.getLong("id"));
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] extendedDataEntities;
        boolean enableKitSale = SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"KIT0001");
        if (!enableKitSale) {
            return;
        }
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().getName();
        String srcMainType = this.getSrcMainType().getName();
        QFilter billFilter = new QFilter("id", "in", this.srcBillIds);
        String selectProperties = "invscheme.bizdirection,ischargeoff, billentry.kitproducttype, billentry.kitpid, billentry.pricemodel, billentry.material, billentry.baseqty, billentry.unit, billentry.baseunit, billentry.mainbillentity, billentry.mainbillid, billentry.materialmasterid";
        DynamicObject[] srcBills = BusinessDataServiceHelper.load((String)srcMainType, (String)selectProperties, (QFilter[])billFilter.toArray(), null);
        DynamicObjectCollection srcBillEntrys = new DynamicObjectCollection();
        DynamicObjectCollection blueBillEntrys = new DynamicObjectCollection();
        DynamicObjectCollection redBillEntrys = new DynamicObjectCollection();
        for (DynamicObject srcBill : srcBills) {
            boolean blueBill;
            srcBillEntrys.addAll((Collection)srcBill.getDynamicObjectCollection("billentry"));
            String bizDirection = srcBill.getString("invscheme.bizdirection");
            boolean isChargeOff = srcBill.getBoolean("ischargeoff");
            boolean redBill = "1".equalsIgnoreCase(bizDirection) && Boolean.FALSE.equals(isChargeOff) || "0".equals(bizDirection) && Boolean.TRUE.equals(isChargeOff);
            boolean bl = blueBill = "0".equalsIgnoreCase(bizDirection) && Boolean.FALSE.equals(isChargeOff) || "1".equals(bizDirection) && Boolean.TRUE.equals(isChargeOff);
            if (redBill) {
                redBillEntrys.addAll((Collection)srcBill.getDynamicObjectCollection("billentry"));
                continue;
            }
            if (!blueBill) continue;
            blueBillEntrys.addAll((Collection)srcBill.getDynamicObjectCollection("billentry"));
        }
        ArrayList<Long> redPids = new ArrayList<Long>(16);
        ArrayList<Long> bluePids = new ArrayList<Long>(16);
        this.cacheParentEntryParam(blueBillEntrys, redBillEntrys, bluePids, redPids);
        if (this.parameters.isEmpty()) {
            return;
        }
        List<Long> samePids = bluePids.stream().filter(redPids::contains).collect(Collectors.toList());
        this.removeSamePid(samePids, bluePids, redPids);
        String expandKitStructures = (String)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sm", (String)"SalService", (String)"expandKitStructure", (Object[])new Object[]{this.parameters});
        Map kitResult = (Map)JSON.parseObject((String)expandKitStructures, Map.class);
        if (kitResult == null || kitResult.isEmpty()) {
            return;
        }
        Map<Long, BigDecimal> maxKitBaseQtyMap = this.calMaxKitBaseQty(srcMainType, kitResult, bluePids, redPids);
        if (maxKitBaseQtyMap.isEmpty()) {
            return;
        }
        Map<Long, BigDecimal> maxKitQtyMap = this.calMaxKitQty(srcBillEntrys, maxKitBaseQtyMap);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = targetExtDataEntitySet.FindByEntityKey(tgtMainType)) {
            DynamicObject bill = extendedDataEntity.getDataEntity();
            this.setQtyPrice(bill, tgtMainType, maxKitBaseQtyMap, maxKitQtyMap, kitResult);
        }
    }

    private void removeSamePid(List<Long> samePids, List<Long> bluePids, List<Long> redPids) {
        if (samePids.isEmpty()) {
            return;
        }
        QFilter baseQtyFilter = new QFilter("billstatus", "=", (Object)"C").and("id", "in", this.srcBillIds).and("billentry.kitpid", "in", samePids).and("billentry.mainbillentryid", "in", samePids);
        DataSet baseQtyDataSet = QueryServiceHelper.queryDataSet((String)KitManagementHelper.class.getName(), (String)"im_saloutbill", (String)"billentry.kitpid, billentry.baseqty", (QFilter[])baseQtyFilter.toArray(), null);
        DataSet baseQtySum = baseQtyDataSet.groupBy(new String[]{"billentry.kitpid"}).sum("billentry.baseqty").finish();
        for (Row row : baseQtySum) {
            Long pid = row.getLong("billentry.kitpid");
            BigDecimal baseQty = row.getBigDecimal("billentry.baseqty");
            if (baseQty.compareTo(BigDecimal.ZERO) >= 0) {
                redPids.remove(pid);
                continue;
            }
            bluePids.remove(pid);
        }
    }

    private void cacheParentEntryParam(DynamicObjectCollection blueBillEntrys, DynamicObjectCollection redBillEntrys, List<Long> bluePids, List<Long> redPids) {
        this.cacheParam(blueBillEntrys, bluePids);
        this.cacheParam(redBillEntrys, redPids);
    }

    private void cacheParam(DynamicObjectCollection billEntrys, List<Long> pids) {
        for (DynamicObject billEntry : billEntrys) {
            String kitProductType = billEntry.getString("kitproducttype");
            if (!"kitparent".equals(kitProductType)) continue;
            Long parentEntryPid = billEntry.getLong("kitpid");
            String mainBillEntity = billEntry.getString("mainbillentity");
            Long mainBillId = billEntry.getLong("mainbillid");
            BigDecimal baseQty = billEntry.getBigDecimal("baseqty");
            HashMap<String, Object> parameter = new HashMap<String, Object>(4);
            parameter.put("billEntity", mainBillEntity);
            parameter.put("billId", mainBillId);
            parameter.put("billEntryId", parentEntryPid);
            parameter.put("baseQty", baseQty);
            this.parameters.add(parameter);
            String priceModel = billEntry.getString("pricemodel");
            this.priceModelMap.put(parentEntryPid, priceModel);
            pids.add(parentEntryPid);
        }
    }

    private Map<Long, BigDecimal> calMaxKitBaseQty(String srcMainType, Map<Long, Map<String, Object>> kitResult, List<Long> bluePids, List<Long> redPids) {
        Map maxBaseQtyMap = KitManagementHelper.calMaxBaseQty(kitResult, bluePids, redPids);
        Set<Long> pidSet = kitResult.keySet();
        if (pidSet.isEmpty()) {
            return new HashMap<Long, BigDecimal>(1);
        }
        QFilter joinPriceFilter = new QFilter("billentry.kitpid", "in", pidSet);
        DataSet joinPriceData = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)srcMainType, (String)"billentry.kitpid,billentry.joinpricebaseqty", (QFilter[])joinPriceFilter.toArray(), null);
        DataSet joinPriceFinish = joinPriceData.groupBy(new String[]{"billentry.kitpid"}).sum("billentry.joinpricebaseqty").finish();
        HashMap<Long, BigDecimal> maxKitBaseQtyMap = new HashMap<Long, BigDecimal>(16);
        for (Row row : joinPriceFinish) {
            Long pid = row.getLong("billentry.kitpid");
            BigDecimal joinPriceBaseQty = row.getBigDecimal("billentry.joinpricebaseqty");
            Map entryMaxBaseQtyMap = (Map)maxBaseQtyMap.get(pid);
            if (entryMaxBaseQtyMap == null) continue;
            BigDecimal maxOutBaseQty = (BigDecimal)entryMaxBaseQtyMap.get("maxOutBaseQty");
            BigDecimal maxKitBaseQty = maxOutBaseQty.subtract(joinPriceBaseQty);
            maxKitBaseQtyMap.put(pid, maxKitBaseQty);
        }
        return maxKitBaseQtyMap;
    }

    private Map<Long, BigDecimal> calMaxKitQty(DynamicObjectCollection srcBillEntrys, Map<Long, BigDecimal> maxKitBaseQtyMap) {
        HashMap<Long, BigDecimal> maxKitQtyMap = new HashMap<Long, BigDecimal>(16);
        for (DynamicObject srcBillEntry : srcBillEntrys) {
            long pid;
            BigDecimal maxKitBaseQty;
            String kitProductType = srcBillEntry.getString("kitproducttype");
            if (!"kitparent".equals(kitProductType) || (maxKitBaseQty = maxKitBaseQtyMap.get(pid = srcBillEntry.getLong("kitpid"))) == null) continue;
            DynamicObject material = srcBillEntry.getDynamicObject("materialmasterid");
            DynamicObject unit = srcBillEntry.getDynamicObject("unit");
            DynamicObject baseUnit = srcBillEntry.getDynamicObject("baseunit");
            int roundingMode = 1;
            BigDecimal maxKitQty = KitManagementHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)baseUnit, (BigDecimal)maxKitBaseQty, (DynamicObject)unit, (int)roundingMode);
            maxKitQtyMap.put(pid, maxKitQty);
        }
        return maxKitQtyMap;
    }

    private void setQtyPrice(DynamicObject bill, String tgtMainType, Map<Long, BigDecimal> maxKitBaseQtyMap, Map<Long, BigDecimal> maxKitQtyMap, Map<Long, Map<String, Object>> kitResult) {
        DynamicObjectCollection entryCols = bill.getDynamicObjectCollection("entry");
        String qtyField = "e_quantity";
        String baseQtyField = "e_baseunitqty";
        String priceField = "e_unitprice";
        String priceTaxField = "e_taxunitprice";
        String mainBillEntryIdField = "corebillentryid";
        String discountModeField = "e_discountmode";
        String discountRateField = "e_discountrate";
        String discountAmountField = "e_discountamount";
        if ("ar_revcfmbill".equals(tgtMainType)) {
            priceTaxField = "";
            mainBillEntryIdField = "e_corebillentryid";
        }
        DynamicObjectCollection newEntryCols = new DynamicObjectCollection();
        for (DynamicObject entryCol : entryCols) {
            String priceModel;
            long pid = entryCol.getLong(mainBillEntryIdField);
            BigDecimal maxKitQty = maxKitQtyMap.get(pid);
            if (maxKitQty == null || maxKitQty.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal qty = entryCol.getBigDecimal(qtyField);
            BigDecimal maxKitBaseQty = maxKitBaseQtyMap.get(pid);
            if (qty.multiply(maxKitQty).compareTo(BigDecimal.ZERO) < 0) continue;
            if (maxKitQty.abs().compareTo(qty.abs()) < 0) {
                entryCol.set(qtyField, (Object)maxKitQty);
                entryCol.set(baseQtyField, (Object)maxKitBaseQty);
            }
            if ("child".equals(priceModel = this.priceModelMap.get(pid))) {
                Map<String, Object> kitQtyPriceMap = kitResult.get(pid);
                Object status = kitQtyPriceMap.get("status");
                if ("FAIL".equals(status)) continue;
                Map parent = (Map)kitQtyPriceMap.get("parent");
                BigDecimal price = (BigDecimal)parent.get("price");
                BigDecimal priceAndTax = (BigDecimal)parent.get("priceAndTax");
                BigDecimal discountRate = (BigDecimal)parent.get("discountRate");
                BigDecimal discountAmount = (BigDecimal)parent.get("discountAmount");
                entryCol.set(priceField, (Object)price);
                if (StringUtils.isNotBlank((CharSequence)priceTaxField)) {
                    entryCol.set(priceTaxField, (Object)priceAndTax);
                }
                if (discountAmount != null && discountAmount.compareTo(BigDecimal.ZERO) != 0) {
                    entryCol.set(discountModeField, (Object)"PERUNIT");
                    entryCol.set(discountRateField, (Object)discountRate);
                    entryCol.set(discountAmountField, (Object)discountAmount);
                }
            }
            newEntryCols.add((Object)entryCol);
        }
        if (newEntryCols.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u5957\u4ef6\u7269\u6599\u672a\u9f50\u5957\u53d1\u8d27\uff0c\u4e0d\u7b26\u5408\u4e0b\u63a8\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"InvToArApKitConvertPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
        bill.set("entry", (Object)newEntryCols);
    }
}

