/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.botp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.im.business.helper.BillTypeParameterHelper;

public class OccSaloubillPushDeliveryrecordPlugin
extends AbstractConvertPlugIn {
    private static final String BILLENTRY = "deliverydetail";
    private static final String SUBENTRY = "subentryentity";
    private static final String BBC_SALEORDER = "ocbsoc_saleorder";
    private static final String OCBSOC_DELIVERY_RECORD = "ocbsoc_delivery_record";
    private static final String F_BIZTYPE = "biztype";

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("id");
        e.addSrcField(F_BIZTYPE);
        e.addSrcField("billentry.mainbillentryid");
        e.addSrcField("billentry.srcbillentity");
        super.afterBuildQueryParemeter(e);
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        if (entitySet == null) {
            return;
        }
        Map<Long, List<Long>> imSaleOutBillEntryIdsMap = this.getImSaleOutBillEntryIdsMap(e);
        List saleOutBillPushDeliveryRecordIds = (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbsoc", (String)"OCBSOCBosExtendService", (String)"isSaleOutBillPushDeliveryRecords", (Object[])new Object[]{imSaleOutBillEntryIdsMap});
        this.isSaleOutBillPushDeliveryRecord(imSaleOutBillEntryIdsMap, saleOutBillPushDeliveryRecordIds);
        Map saleOutBillEntryFromSaleOrderEntryMap = (Map)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbsoc", (String)"OCBSOCBosExtendService", (String)"getSaleOutBillEntryFromSaleOrderEntryMaps", (Object[])new Object[]{imSaleOutBillEntryIdsMap});
        this.dealDeliveryRecord(e, saleOutBillEntryFromSaleOrderEntryMap);
        this.dealWithChannel(e);
        this.groupTargeBillByChannel(e);
    }

    private void groupTargeBillByChannel(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entitys;
        ExtendedDataEntitySet dataEntitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entryDataEntitys = dataEntitySet.FindByEntityKey(BILLENTRY);
        HashMap entryMap = new HashMap(16);
        for (ExtendedDataEntity entryDataEntity : entryDataEntitys) {
            String channelIdStr = entryDataEntity.getDataEntity().getLong("entryorderchannelid_id") + "_" + entryDataEntity.getDataEntity().getLong("orderchannelid_id") + "_" + entryDataEntity.getDataEntity().getLong("edistributionchannelid_id");
            List list = !entryMap.containsKey(channelIdStr) ? new ArrayList(1) : (List)entryMap.get(channelIdStr);
            list.add(entryDataEntity);
            entryMap.put(channelIdStr, list);
        }
        int size = entryMap.size();
        if (size > 1) {
            ExtendedDataEntity[] billDataEntitys = dataEntitySet.FindByEntityKey(OCBSOC_DELIVERY_RECORD);
            ArrayList<ExtendedDataEntity> billDataEntityList = new ArrayList<ExtendedDataEntity>(size);
            ArrayList<ExtendedDataEntity> entryDataEntityList = new ArrayList<ExtendedDataEntity>(entryDataEntitys.length);
            int dataEntityIndex = 0;
            DynamicObject billDynObj = billDataEntitys[0].getDataEntity();
            for (Map.Entry mapEntry : entryMap.entrySet()) {
                DynamicObject newBillDynObj = BusinessDataServiceHelper.newDynamicObject((String)OCBSOC_DELIVERY_RECORD);
                this.copyProperties(newBillDynObj, billDynObj);
                DynamicObjectCollection entryColl = newBillDynObj.getDynamicObjectCollection(BILLENTRY);
                entryColl.clear();
                int rowIndex = 0;
                for (ExtendedDataEntity entryDataEntity : (List)mapEntry.getValue()) {
                    DynamicObject newEntryDynObj = entryDataEntity.getDataEntity();
                    newEntryDynObj.setParent((Object)newBillDynObj);
                    entryColl.add((Object)newEntryDynObj);
                    ExtendedDataEntity newEntryDataEntity = new ExtendedDataEntity(newEntryDynObj, dataEntityIndex, rowIndex);
                    entryDataEntityList.add(newEntryDataEntity);
                    ++rowIndex;
                }
                ExtendedDataEntity billDataEntity = new ExtendedDataEntity(newBillDynObj, dataEntityIndex, 0);
                billDataEntityList.add(billDataEntity);
                ++dataEntityIndex;
            }
            ExtendedDataEntitySet extendedEntitySet = new ExtendedDataEntitySet();
            extendedEntitySet.AddExtendedDataEntities(OCBSOC_DELIVERY_RECORD, billDataEntityList);
            extendedEntitySet.AddExtendedDataEntities(BILLENTRY, entryDataEntityList);
            e.setTargetExtDataEntitySet(extendedEntitySet);
        }
        for (ExtendedDataEntity entity : entitys = e.getTargetExtDataEntitySet().FindByEntityKey(this.getTgtMainType().toString())) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObjectCollection billentrys = bill.getDynamicObjectCollection(BILLENTRY);
            if (CollectionUtils.isEmpty((Collection)billentrys)) continue;
            bill.set("receivechannelid", (Object)((DynamicObject)billentrys.get(0)).getDynamicObject("orderchannelid"));
            bill.set("customer", (Object)((DynamicObject)billentrys.get(0)).getDynamicObject("entryorderchannelid"));
            bill.set("distributionchannelid", (Object)((DynamicObject)billentrys.get(0)).getDynamicObject("edistributionchannelid"));
        }
    }

    private void copyProperties(DynamicObject toObj, DynamicObject fromObj) {
        DataEntityPropertyCollection toPs = toObj.getDataEntityType().getProperties();
        DataEntityPropertyCollection fromPs = fromObj.getDataEntityType().getProperties();
        HashSet<String> fromPsSet = new HashSet<String>(fromPs.size());
        for (IDataEntityProperty dp : fromPs) {
            fromPsSet.add(dp.getName());
        }
        String toKey = null;
        String fromKey = null;
        int len = toPs.size();
        for (int i = 0; i < len; ++i) {
            toKey = ((IDataEntityProperty)toPs.get(i)).getName();
            fromKey = toKey;
            if (!fromPsSet.contains(fromKey) || BILLENTRY.equals(toKey)) continue;
            toObj.set(toKey, fromObj.get(fromKey));
        }
    }

    private void dealDeliveryRecord(AfterConvertEventArgs e, Map<Long, Map<Long, Long>> saleOutBillEntryFromSaleOrderEntryMap) {
        ExtendedDataEntity[] entitys;
        for (ExtendedDataEntity entity : entitys = e.getTargetExtDataEntitySet().FindByEntityKey(this.getTgtMainType().toString())) {
            DynamicObject bill = entity.getDataEntity();
            Object sourceRows = entity.getValue("ConvertSource");
            boolean isContinue = this.isContinue(e, sourceRows);
            if (isContinue) continue;
            List srcRows = (List)sourceRows;
            DynamicObject outbill = (DynamicObject)srcRows.get(0);
            long outBillId = outbill.getLong((IDataEntityProperty)e.getFldProperties().get("id"));
            Map<Long, Long> saleOutBillEntrySrcBillEntryMap = saleOutBillEntryFromSaleOrderEntryMap.get(outBillId);
            HashSet<Long> srcEntryList = new HashSet<Long>(saleOutBillEntrySrcBillEntryMap.values());
            srcEntryList.remove(0L);
            if (CollectionUtils.isEmpty(srcEntryList)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u975e\u201c\u8981\u8d27\u8ba2\u5355\u201d\u4e0b\u63a8\u7684\u5355\u636e\uff0c\u65e0\u9700\u4e0b\u63a8\u53d1\u8d27\u8bb0\u5f55\u3002", (String)"SaloubillPushDeliveryrecordPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            QFilter qfilter = new QFilter("itementry.subentryentity.id", "in", (Object)srcEntryList.toArray());
            DynamicObjectCollection itementryCollection = QueryServiceHelper.query((String)BBC_SALEORDER, (String)"id,billno,billtypeid,saleorgid,itementry.id,itementry.seq,itementry.itemid,itementry.totaloutstockbaseqty,itementry.auxptyid,itementry.approveqty,itementry.subentryentity.id", (QFilter[])qfilter.toArray());
            if (CollectionUtils.isEmpty((Collection)itementryCollection)) continue;
            this.setBillDynObj(bill, itementryCollection);
            DynamicProperty billentryId = (DynamicProperty)e.getFldProperties().get("billentry.id");
            List<Long> imSaleOutBillEntryIds = this.getEntryIds(srcRows, e);
            this.setBillentrys(bill, itementryCollection, srcRows, imSaleOutBillEntryIds, saleOutBillEntrySrcBillEntryMap, billentryId);
        }
    }

    private void setBillentrys(DynamicObject bill, DynamicObjectCollection itementryCollection, List<DynamicObject> srcRows, List<Long> imSaleOutBillEntryIds, Map<Long, Long> saleOutBillEntrySrcBillEntryMap, DynamicProperty billentryId) {
        DynamicObjectCollection billentrys = bill.getDynamicObjectCollection(BILLENTRY);
        Map<Long, DynamicObject> itemMap = itementryCollection.stream().collect(Collectors.toMap(r -> r.getLong("itementry.subentryentity.id"), r -> r));
        Map<Long, DynamicObject> serialNumberMap = this.getSerialnumberByBillId(imSaleOutBillEntryIds);
        for (int i = 0; i < billentrys.size(); ++i) {
            DynamicObject serialnumber;
            DynamicObject srcenrty = srcRows.get(i);
            DynamicObject billentry = (DynamicObject)billentrys.get(i);
            Long saleOutBillEntryId = srcenrty.getLong((IDataEntityProperty)billentryId);
            Long saleOrderEntryId = saleOutBillEntrySrcBillEntryMap.get(saleOutBillEntryId);
            if (saleOrderEntryId > 0L) {
                DynamicObject saleOrderEntry = itemMap.get(saleOrderEntryId);
                billentry.set("item_id", saleOrderEntry.get("itementry.itemid"));
                billentry.set("auxpty_id", saleOrderEntry.get("itementry.auxptyid"));
                billentry.set("qty", saleOrderEntry.get("itementry.approveqty"));
                billentry.set("mainbillentity", (Object)BBC_SALEORDER);
                billentry.set("mainbillid", saleOrderEntry.get("id"));
                billentry.set("mainbillnumber", saleOrderEntry.get("billno"));
                billentry.set("mainbillentryid", (Object)saleOrderEntryId);
                billentry.set("mainbillentryseq", saleOrderEntry.get("itementry.seq"));
            }
            if ((serialnumber = serialNumberMap.get(saleOutBillEntryId)) != null) {
                this.addSubentryentity(billentry, serialnumber);
                billentry.set("serialqty", billentry.get("deliverbaseqty"));
                billentry.set("serialunit", billentry.get("baseunit"));
                continue;
            }
            billentry.getDynamicObjectCollection(SUBENTRY).clear();
        }
    }

    private void setBillDynObj(DynamicObject bill, DynamicObjectCollection itementryCollection) {
        DynamicObjectCollection billentrys;
        int size;
        String tradetype;
        DynamicObject billTypeParam;
        long bbcSaleOrderBillTypeId = ((DynamicObject)itementryCollection.get(0)).getLong("billtypeid");
        if (bbcSaleOrderBillTypeId > 0L && (billTypeParam = BillTypeParameterHelper.getBillTypeParameter((String)BBC_SALEORDER, (long)bbcSaleOrderBillTypeId)) != null && StringUtils.isNotEmpty((String)(tradetype = billTypeParam.getString("tradetype")))) {
            bill.set("pursalemodel", (Object)tradetype);
        }
        if ((size = (billentrys = bill.getDynamicObjectCollection(BILLENTRY)).size()) > 0) {
            bill.set("receivechannelid", (Object)((DynamicObject)billentrys.get(0)).getDynamicObject("orderchannelid"));
            bill.set("customer", (Object)((DynamicObject)billentrys.get(0)).getDynamicObject("entryorderchannelid"));
        }
    }

    private boolean isContinue(AfterConvertEventArgs e, Object sourceRows) {
        boolean isContinue = true;
        if (sourceRows == null) {
            return isContinue;
        }
        List srcRows = (List)sourceRows;
        if (srcRows.isEmpty()) {
            return isContinue;
        }
        return false;
    }

    private Map<Long, List<Long>> getImSaleOutBillEntryIdsMap(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entitys = e.getTargetExtDataEntitySet().FindByEntityKey(this.getTgtMainType().toString());
        HashMap<Long, List<Long>> imSaleOutBillEntryIdsMap = new HashMap<Long, List<Long>>(entitys.length);
        for (ExtendedDataEntity entity : entitys) {
            Object sourceRows = entity.getValue("ConvertSource");
            if (sourceRows == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u201c\u9500\u552e\u51fa\u5e93\u5355\u201d\u4fe1\u606f\u3002", (String)"SaloubillPushDeliveryrecordPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            List srcRows = (List)sourceRows;
            if (srcRows.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u201c\u9500\u552e\u51fa\u5e93\u5355\u201d\u4fe1\u606f\u3002", (String)"SaloubillPushDeliveryrecordPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            DynamicObject outbill = (DynamicObject)srcRows.get(0);
            List<Long> imSaleOutBillEntryIds = this.getEntryIds(srcRows, e);
            if (imSaleOutBillEntryIds.isEmpty()) continue;
            Long outBillId = outbill.getLong((IDataEntityProperty)e.getFldProperties().get("id"));
            imSaleOutBillEntryIdsMap.put(outBillId, imSaleOutBillEntryIds);
        }
        return imSaleOutBillEntryIdsMap;
    }

    private void isSaleOutBillPushDeliveryRecord(Map<Long, List<Long>> imSaleOutBillEntryIdsMap, List<Long> saleOutBillPushDeliveryRecordIds) {
        Set<Long> allImSaleOutBillEntryIds = imSaleOutBillEntryIdsMap.keySet();
        for (Long saleOutBillPushDeliveryRecordId : saleOutBillPushDeliveryRecordIds) {
            if (!allImSaleOutBillEntryIds.contains(saleOutBillPushDeliveryRecordId)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u9500\u552e\u51fa\u5e93\u5355\u5df2\u4e0b\u63a8\u53d1\u8d27\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u591a\u6b21\u4e0b\u63a8\u3002", (String)"SaloubillPushDeliveryrecordPlugin_2", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
    }

    private List<Long> getEntryIds(List<DynamicObject> srcRows, AfterConvertEventArgs e) {
        if (!CollectionUtils.isEmpty(srcRows)) {
            ArrayList<Long> entryIds = new ArrayList<Long>(srcRows.size());
            for (DynamicObject srcentry : srcRows) {
                entryIds.add(srcentry.getLong((IDataEntityProperty)e.getFldProperties().get("billentry.id")));
            }
            return entryIds;
        }
        return new ArrayList<Long>(0);
    }

    private Map<Long, DynamicObject> getSerialnumberByBillId(List<Long> imSaleOutBillEntryIds) {
        QFilter filter = new QFilter("entryid", "in", imSaleOutBillEntryIds);
        DynamicObject[] serialnumbers = BusinessDataServiceHelper.load((String)"sbs_billsnrelation", (String)"billtype,billid,entrykey,entryid,entryentity.snnumber,entryentity.snmainfileid", (QFilter[])filter.toArray());
        int size = serialnumbers != null && serialnumbers.length > 0 ? serialnumbers.length : 0;
        HashMap<Long, DynamicObject> serialnumberMap = new HashMap<Long, DynamicObject>(size);
        if (size > 0) {
            for (DynamicObject serialnumber : serialnumbers) {
                DynamicObjectCollection entryenties = serialnumber.getDynamicObjectCollection("entryentity");
                if (CollectionUtils.isEmpty((Collection)entryenties)) continue;
                serialnumberMap.put(serialnumber.getLong("entryid"), serialnumber);
            }
        }
        return serialnumberMap;
    }

    private void addSubentryentity(DynamicObject billentry, DynamicObject serialnumber) {
        if (serialnumber != null && serialnumber.getDynamicObjectCollection("entryentity") != null) {
            DynamicObjectCollection numberenties = billentry.getDynamicObjectCollection(SUBENTRY);
            if (!CollectionUtils.isEmpty((Collection)numberenties)) {
                numberenties.clear();
            }
            DynamicObjectCollection entryenties = serialnumber.getDynamicObjectCollection("entryentity");
            HashSet<Object> numberset = new HashSet<Object>(entryenties.size());
            int seq = 1;
            for (DynamicObject entry : entryenties) {
                DynamicObject number = new DynamicObject(numberenties.getDynamicObjectType());
                number.set("seq", (Object)seq);
                number.set("serialnumber", entry.get("snnumber"));
                number.set("scmserialid_id", entry.get("snmainfileid"));
                numberset.add(entry.get("snnumber"));
                numberenties.add((Object)number);
                ++seq;
            }
            if (numberset.size() != entryenties.size()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u5e8f\u5217\u53f7\uff0c\u65e0\u6cd5\u4e0b\u63a8\u53d1\u8d27\u8bb0\u5f55\u3002", (String)"SaloubillPushDeliveryrecordPlugin_4", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            billentry.set(SUBENTRY, (Object)numberenties);
        }
    }

    public void dealWithChannel(AfterConvertEventArgs e) {
        ExtendedDataEntity[] extendedDataEntities;
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        if (entitySet == null) {
            return;
        }
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = entitySet.FindByEntityKey(tgtMainType)) {
            DynamicObject bill = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(BILLENTRY);
            for (DynamicObject entry : entrys) {
                Long orderChannelId = entry.getLong("orderchannelid.id");
                QFilter qFilter1 = new QFilter("ownerchannelid", "=", (Object)orderChannelId);
                QFilter qFilter2 = new QFilter("isdefault", "=", (Object)"1");
                DynamicObject stock = BusinessDataServiceHelper.loadSingle((String)"ococic_warehouse", (String)"id", (QFilter[])new QFilter[]{qFilter1, qFilter2});
                if (stock == null) continue;
                entry.set("stockid", (Object)stock);
            }
        }
    }
}

