/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.botp;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.dataentity.OperateOptionPrivate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.enums.InvalidEnum;
import kd.scmc.im.utils.IMStringUtils;

public class PurOrderToReciveConvertPlugin
extends AbstractConvertPlugIn {
    private static Log logger = LogFactory.getLog(PurOrderToReciveConvertPlugin.class);

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        this.handleOperator(entitys);
        OperateOptionPrivate operation = (OperateOptionPrivate)this.getOption();
        Map paramMap = operation.getVariables();
        if (paramMap.size() == 0) {
            return;
        }
        Set paramKeys = paramMap.keySet();
        String splitStrategy = (String)paramMap.get("splitstrategy");
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:MM:ss");
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObjectCollection billentrys = bill.getDynamicObjectCollection("billentry");
            DynamicObjectCollection splitBillEntrys = new DynamicObjectCollection();
            long seq = 1L;
            for (DynamicObject billentry : billentrys) {
                String mainBillEntryId = billentry.getString("mainbillentryid");
                if (paramKeys.contains(mainBillEntryId) && "splitrow".equals(splitStrategy)) {
                    String entryParamStr = (String)paramMap.get(mainBillEntryId);
                    List entryParamList = (List)SerializationUtils.fromJsonString((String)entryParamStr, List.class);
                    for (Map entryParamsMap : entryParamList) {
                        DynamicObject splitEntry = (DynamicObject)OrmUtils.clone((IDataEntityBase)billentry, (boolean)false, (boolean)true);
                        splitEntry.setParent(billentry.getParent());
                        this.setEntryProp(entryParamsMap, splitEntry, sf);
                        splitEntry.set("seq", (Object)seq);
                        splitBillEntrys.add((Object)splitEntry);
                        ++seq;
                    }
                    continue;
                }
                if (!"splitbill".equals(splitStrategy)) continue;
                this.setEntryProp(paramMap, billentry, sf);
            }
            if (splitBillEntrys.isEmpty()) continue;
            bill.set("billentry", (Object)splitBillEntrys);
        }
    }

    private void setEntryProp(Map<String, String> paramMap, DynamicObject entry, SimpleDateFormat sf) {
        String mainBillEntryId = entry.getString("mainbillentryid");
        String qtystr = paramMap.get("qty_" + mainBillEntryId);
        String saloutNo = paramMap.get("saloutNo_" + mainBillEntryId);
        String saloutId = paramMap.get("saloutId_" + mainBillEntryId);
        String saloutEntryId = paramMap.get("saloutEntryId_" + mainBillEntryId);
        String suplot = paramMap.get("suplot_" + mainBillEntryId);
        String proddate = paramMap.get("proddate_" + mainBillEntryId);
        String duedate = paramMap.get("duedate_" + mainBillEntryId);
        if (StringUtils.isNotBlank((CharSequence)qtystr)) {
            BigDecimal qty = new BigDecimal(qtystr);
            DynamicObject material = entry.getDynamicObject("material");
            DynamicObject baseUnit = entry.getDynamicObject("baseUnit");
            DynamicObject auxptyUnit = entry.getDynamicObject("unit2nd");
            DynamicObject unit = entry.getDynamicObject("unit");
            BigDecimal baseqty = PurOrderToReciveConvertPlugin.getDesQtyConv(material, unit, qty, baseUnit);
            BigDecimal auxQty = PurOrderToReciveConvertPlugin.getDesQtyConv(material, baseUnit, baseqty, auxptyUnit);
            entry.set("qty", (Object)qty);
            entry.set("baseqty", (Object)baseqty);
            entry.set("qtyunit2nd", (Object)auxQty);
        }
        if (StringUtils.isNotBlank((CharSequence)saloutNo)) {
            entry.set("srcsysbillno", (Object)saloutNo);
        }
        if (StringUtils.isNotBlank((CharSequence)saloutId)) {
            entry.set("srcsysbillid", (Object)saloutId);
        }
        if (StringUtils.isNotBlank((CharSequence)saloutEntryId)) {
            entry.set("srcsysbillentryid", (Object)saloutEntryId);
        }
        if (StringUtils.isNotBlank((CharSequence)suplot)) {
            entry.set("suplot", (Object)suplot);
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)proddate)) {
                entry.set("producedate", (Object)sf.parse(proddate));
            }
            if (StringUtils.isNotBlank((CharSequence)duedate)) {
                entry.set("expirydate", (Object)sf.parse(duedate));
            }
        }
        catch (Exception ex) {
            logger.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
        }
    }

    private void handleOperator(ExtendedDataEntity[] entitys) {
        HashMap<String, DynamicObject> deptMap = new HashMap<String, DynamicObject>(entitys.length);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            DynamicObject operator = bill.getDynamicObject("operator");
            DynamicObject operatorGroup = bill.getDynamicObject("operatorgroup");
            if (org == null || operator != null || operatorGroup != null) continue;
            this.setOperator(bill, org, deptMap);
        }
    }

    private void setOperator(DynamicObject bill, DynamicObject org, Map<String, DynamicObject> deptMap) {
        Long orgId = org.getLong("id");
        DynamicObject dept = bill.getDynamicObject("dept");
        QFilter qFilter01 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)org.getLong("id"));
        QFilter qFilter02 = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpTypeEnum.INVENTORYGRP.getValue());
        qFilter02.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter01, qFilter02});
        long userId = UserServiceHelper.getCurrentUserId();
        String cacheKey = IMStringUtils.append((String)orgId.toString(), (Object[])new Object[]{userId});
        if (map.size() != 0) {
            QFilter qFilter1 = new QFilter("operatorgrpid", "in", map.keySet());
            QFilter qFilter2 = new QFilter("operatorid", "=", (Object)userId);
            QFilter qFilter3 = new QFilter("invalid", "=", (Object)InvalidEnum.NO.getValue());
            DynamicObject operator = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_operator", (String)"operatorid,operatornumber,operatorname,operatorgrpid,opergrpnumber,opergrpname,opergrptype", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
            if (operator != null) {
                bill.set("operator", (Object)operator);
                DynamicObject operatorGroup = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_operatorgroup", (String)"id", (QFilter[])new QFilter("id", "=", (Object)operator.getLong("operatorgrpid")).toArray());
                bill.set("operatorgroup", (Object)operatorGroup);
                if (dept == null) {
                    this.initDeptByOperator(bill, deptMap, orgId, operator, cacheKey);
                }
            } else {
                bill.set("operator", null);
                bill.set("operatorgroup", null);
                if (dept == null) {
                    this.initDeptByOrg(bill, deptMap, orgId, cacheKey);
                }
            }
        } else if (dept == null) {
            this.initDeptByOrg(bill, deptMap, orgId, cacheKey);
        }
    }

    private void initDeptByOperator(DynamicObject bill, Map<String, DynamicObject> deptMap, Long orgId, DynamicObject operator, String cacheKey) {
        block4: {
            List deptids;
            List userdeptIds;
            DynamicObject dept;
            block3: {
                dept = deptMap.get(cacheKey);
                if (dept != null) {
                    bill.set("dept", (Object)dept);
                    return;
                }
                userdeptIds = UserServiceHelper.getUserDepartment((long)((Long)operator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
                deptids = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId, (boolean)false);
                if (deptids != null && !deptids.isEmpty()) break block3;
                if (userdeptIds == null || userdeptIds.size() <= 0) break block4;
                Long deptId = (Long)userdeptIds.get(0);
                dept = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
                dept.set("id", (Object)deptId);
                bill.set("dept", (Object)dept);
                deptMap.put(cacheKey, dept);
                break block4;
            }
            HashSet deptIdSet = new HashSet(deptids);
            if (userdeptIds != null && userdeptIds.size() > 0) {
                for (Long deptId : userdeptIds) {
                    if (!deptIdSet.contains(deptId)) continue;
                    dept = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
                    dept.set("id", (Object)deptId);
                    bill.set("dept", (Object)dept);
                    deptMap.put(cacheKey, dept);
                    break;
                }
            }
        }
    }

    private void initDeptByOrg(DynamicObject bill, Map<String, DynamicObject> deptMap, Long orgId, String cacheKey) {
        DynamicObject dept = deptMap.get(cacheKey);
        if (dept != null) {
            bill.set("dept", (Object)dept);
            return;
        }
        List deptIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(orgId), (boolean)true);
        if (deptIds != null && deptIds.size() > 0) {
            Long deptId = (Long)deptIds.get(0);
            dept = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
            dept.set("id", (Object)deptId);
            bill.set("dept", (Object)dept);
            deptMap.put(cacheKey, dept);
            return;
        }
        deptIds = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId, (boolean)true);
        if (deptIds != null && deptIds.size() > 0 && deptIds.contains(orgId)) {
            dept = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
            dept.set("id", (Object)orgId);
            bill.set("dept", (Object)dept);
            deptMap.put(cacheKey, dept);
        }
    }

    public static BigDecimal getDesQtyConv(DynamicObject material, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal qty = BigDecimal.ZERO;
        if (material == null || srcUnit == null || desUnit == null || srcQty == null) {
            qty = BigDecimal.ZERO;
        } else if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
            qty = srcQty;
        } else {
            BigDecimal unitRate;
            Long materialId = material.getLong("masterid.id");
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null && muConv.getInt("numerator") != 0 && (unitRate = new BigDecimal(muConv.getInt("denominator")).divide(new BigDecimal(muConv.getInt("numerator")), 10, 4)) != null && unitRate.compareTo(BigDecimal.ZERO) != 0) {
                int unitPrecision = desUnit.getInt("precision");
                if (StringUtil.isNotBlank((CharSequence)desUnit.getString("precisionaccount"))) {
                    int account = desUnit.getInt("precisionaccount");
                    int unitPrecisionType = 4;
                    if (account == 2) {
                        unitPrecisionType = 1;
                    } else if (account == 3) {
                        unitPrecisionType = 0;
                    }
                    qty = srcQty.divide(unitRate, unitPrecision, unitPrecisionType);
                }
            }
        }
        return qty;
    }
}

