/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.botp;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.OperateOptionPrivate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;

public class PurReturnMatchPushPlugin
extends AbstractConvertPlugIn {
    private static Log log = LogFactory.getLog(PurReturnMatchPushPlugin.class);

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        OperateOptionPrivate operation = (OperateOptionPrivate)this.getOption();
        BigDecimal qty = null;
        Object qtystr = null;
        Map paramMap = operation.getVariables();
        if (paramMap != null && paramMap.size() != 0) {
            DynamicObject material = null;
            DynamicObject baseUnit = null;
            DynamicObject unit = null;
            DynamicObject auxptyUnit = null;
            for (ExtendedDataEntity entity : entitys) {
                DynamicObject bill = entity.getDataEntity();
                DynamicObjectCollection billentrys = bill.getDynamicObjectCollection("billentry");
                for (DynamicObject billentry : billentrys) {
                    String srcbillentryid = billentry.getString("srcbillentryid");
                    qtystr = paramMap.get("qty_" + srcbillentryid);
                    if (qtystr == null || "".equals(qtystr)) continue;
                    qty = new BigDecimal(qtystr.toString());
                    material = billentry.getDynamicObject("material");
                    baseUnit = billentry.getDynamicObject("baseUnit");
                    auxptyUnit = billentry.getDynamicObject("unit2nd");
                    unit = billentry.getDynamicObject("unit");
                    BigDecimal baseqty = PurReturnMatchPushPlugin.getDesQtyConv(material, unit, qty, baseUnit);
                    BigDecimal auxQty = PurReturnMatchPushPlugin.getDesQtyConv(material, baseUnit, baseqty, auxptyUnit);
                    billentry.set("qty", (Object)qty);
                    billentry.set("baseqty", (Object)baseqty);
                    billentry.set("qtyunit2nd", (Object)auxQty);
                }
            }
        }
    }

    public static BigDecimal getDesQtyConv(DynamicObject material, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal qty = BigDecimal.ZERO;
        if (material != null && srcUnit != null && desUnit != null && srcQty != null) {
            if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
                qty = srcQty;
            } else {
                BigDecimal unitRate;
                Long materialId = material.getLong("masterid.id");
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
                if (muConv != null && muConv.getInt("numerator") != 0 && (unitRate = new BigDecimal(muConv.getInt("denominator")).divide(new BigDecimal(muConv.getInt("numerator")), 10, 4)) != null && unitRate.compareTo(BigDecimal.ZERO) != 0) {
                    int unitPrecision = desUnit.getInt("precision");
                    if (StringUtils.isNotEmpty((String)desUnit.getString("precisionaccount"))) {
                        int account = desUnit.getInt("precisionaccount");
                        int unitPrecisionType = 4;
                        if (account == 2) {
                            unitPrecisionType = 1;
                        } else if (account == 3) {
                            unitPrecisionType = 0;
                        }
                        qty = srcQty.divide(unitRate, unitPrecision, unitPrecisionType);
                    }
                }
            }
        } else {
            qty = BigDecimal.ZERO;
        }
        return qty;
    }
}

