/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.botp;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.CurrencyHelper;

public class ReqBillCurrencyConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] entities = entitySet.FindByEntityKey(tgtMainType);
        HashMap<Long, DynamicObject> orgToCurrencyMapping = new HashMap<Long, DynamicObject>(entities.length);
        for (ExtendedDataEntity entity : entities) {
            this.initCurrency(entity, orgToCurrencyMapping);
            this.initSettleOrg(entity);
        }
    }

    private void initSettleOrg(ExtendedDataEntity entity) {
        String tgtMainType = this.getTgtMainType().toString();
        DynamicObject dataEntity = entity.getDataEntity();
        DynamicObject org = null;
        if ("im_materialreqbill".equals(tgtMainType)) {
            org = dataEntity.getDynamicObject("org");
        } else if ("im_materialreqoutbill".equals(tgtMainType)) {
            org = dataEntity.getDynamicObject("bizorg");
        }
        if (org == null) {
            return;
        }
        Long orgId = (Long)org.getPkValue();
        Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        Object settleOrgId = null;
        if (map != null) {
            settleOrgId = map.get("id");
        }
        if (settleOrgId == null) {
            return;
        }
        DynamicObject settleOrg = BusinessDataServiceHelper.loadSingle(settleOrgId, (String)"bos_org");
        dataEntity.set("settleorg", (Object)settleOrg);
    }

    private void initCurrency(ExtendedDataEntity entity, Map<Long, DynamicObject> orgToCurrencyMapping) {
        DynamicObject bill = entity.getDataEntity();
        DynamicObject org = bill.getDynamicObject("org");
        if (org == null) {
            return;
        }
        long orgId = org.getLong("id");
        if (orgToCurrencyMapping.containsKey(orgId)) {
            bill.set("settlecurrency", (Object)orgToCurrencyMapping.get(orgId));
            return;
        }
        Map map = CurrencyHelper.getCurrencyAndExRateTable((Long)orgId);
        if (map == null) {
            bill.set("settlecurrency", null);
            return;
        }
        DynamicObject currency = BusinessDataServiceHelper.loadSingle(map.get("baseCurrencyID"), (String)"bd_currency");
        bill.set("settlecurrency", (Object)currency);
        orgToCurrencyMapping.put(orgId, currency);
    }
}

