/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.botp;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ReqOutBill2TransferBotpPlugin
extends AbstractConvertPlugIn {
    private static final Log log = LogFactory.getLog(ReqOutBill2TransferBotpPlugin.class);
    private final BigDecimal ZERO = BigDecimal.ZERO;

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entitys;
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity entity : entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString())) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                this.initQty(entry);
            }
        }
    }

    private void initQty(DynamicObject entry) {
        DynamicObject material = entry.getDynamicObject("material");
        if (material == null) {
            return;
        }
        DynamicObject master = material.getDynamicObject("masterid");
        if (master == null) {
            return;
        }
        DynamicObject unit = entry.getDynamicObject("unit");
        BigDecimal qty = entry.getBigDecimal("qty");
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        BigDecimal baseQty = entry.getBigDecimal("baseqty");
        if (qty != null && baseQty != null && qty.compareTo(this.ZERO) != 0 && baseQty.compareTo(this.ZERO) != 0) {
            return;
        }
        if (baseUnit == null) {
            baseUnit = master.getDynamicObject("baseunit");
            entry.set("baseunit", (Object)baseUnit);
        }
        if (unit == null) {
            unit = material.getDynamicObject("inventoryunit");
            entry.set("unit", (Object)unit);
        }
        if ((qty == null || qty.compareTo(this.ZERO) == 0) && baseQty != null && baseQty.compareTo(this.ZERO) != 0) {
            qty = this.getDesQtyConv((Long)material.getPkValue(), baseUnit, baseQty, unit);
            entry.set("qty", (Object)qty);
        } else if ((baseQty == null || baseQty.compareTo(this.ZERO) == 0) && qty != null && qty.compareTo(this.ZERO) != 0) {
            baseQty = this.getDesQtyConv((Long)material.getPkValue(), unit, qty, baseUnit);
            entry.set("baseqty", (Object)baseQty);
        }
    }

    private BigDecimal getDesQtyConv(Long materialId, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal desQty = this.ZERO;
        if (materialId == null || srcUnit == null || desUnit == null || srcQty == null) {
            desQty = this.ZERO;
        } else if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
            desQty = srcQty;
        } else {
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null) {
                int numerator = muConv.getInt("numerator");
                int denominator = muConv.getInt("denominator");
                if (denominator != 0) {
                    int unitPrecision = desUnit.getInt("precision");
                    int account = desUnit.getInt("precisionaccount");
                    int unitPrecisionType = 4;
                    if (account == 2) {
                        unitPrecisionType = 1;
                    } else if (account == 3) {
                        unitPrecisionType = 0;
                    }
                    desQty = srcQty.multiply(new BigDecimal(numerator)).divide(new BigDecimal(denominator), unitPrecision, unitPrecisionType);
                }
            }
        }
        return desQty;
    }
}

