/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.botp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class SaloubillPushDeliveryrecordPlugin
extends AbstractConvertPlugIn {
    private static final String BILLENTRY = "deliverydetail";
    private static final String SUBENTRY = "subentryentity";
    private static final String BBC_SALEORDER = "bbc_saleorder";
    private static final long BIZTYPE = 422876630176775168L;

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("id");
        e.addSrcField("biztype");
        e.addSrcField("billentry.mainbillentryid");
        e.addSrcField("billentry.srcbillentity");
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        if (entitySet == null) {
            return;
        }
        Map<Long, List<Long>> imSaleOutBillEntryIdsMap = this.getImSaleOutBillEntryIdsMap(e);
        List saleOutBillPushDeliveryRecordIds = (List)DispatchServiceHelper.invokeBizService((String)"drp", (String)"bbc", (String)"BBCBosExtendService", (String)"isSaleOutBillPushDeliveryRecords", (Object[])new Object[]{imSaleOutBillEntryIdsMap});
        this.isSaleOutBillPushDeliveryRecord(imSaleOutBillEntryIdsMap, saleOutBillPushDeliveryRecordIds);
        Map saleOutBillEntryFromSaleOrderEntryMap = (Map)DispatchServiceHelper.invokeBizService((String)"drp", (String)"bbc", (String)"BBCBosExtendService", (String)"getSaleOutBillEntryFromSaleOrderEntryMaps", (Object[])new Object[]{imSaleOutBillEntryIdsMap});
        this.dealDeliveryRecord(e, saleOutBillEntryFromSaleOrderEntryMap);
    }

    private void dealDeliveryRecord(AfterConvertEventArgs e, Map<Long, Map<Long, Long>> saleOutBillEntryFromSaleOrderEntryMap) {
        ExtendedDataEntity[] entitys;
        for (ExtendedDataEntity entity : entitys = e.getTargetExtDataEntitySet().FindByEntityKey(this.getTgtMainType().toString())) {
            DynamicObject outbill;
            List srcRows;
            DynamicObject bill = entity.getDataEntity();
            Object sourceRows = entity.getValue("ConvertSource");
            if (sourceRows == null || (srcRows = (List)sourceRows) == null || srcRows.isEmpty() || 422876630176775168L != (outbill = (DynamicObject)srcRows.get(0)).getLong((IDataEntityProperty)e.getFldProperties().get("biztype"))) continue;
            Long outBillId = outbill.getLong((IDataEntityProperty)e.getFldProperties().get("id"));
            List<Long> imSaleOutBillEntryIds = this.getEntryIds(srcRows, e);
            if (imSaleOutBillEntryIds == null || imSaleOutBillEntryIds.isEmpty()) continue;
            Map<Long, Long> saleOutBillEntrySrcBillEntryMap = saleOutBillEntryFromSaleOrderEntryMap.get(outBillId);
            HashSet<Long> srcEntryList = new HashSet<Long>(saleOutBillEntrySrcBillEntryMap.values());
            srcEntryList.remove(0L);
            if (srcEntryList.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u975e\u201c\u8981\u8d27\u8ba2\u5355\u201d\u4e0b\u63a8\u7684\u5355\u636e\uff0c\u65e0\u9700\u4e0b\u63a8\u53d1\u8d27\u8bb0\u5f55\u3002", (String)"SaloubillPushDeliveryrecordPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            QFilter qfilter = new QFilter("itementry.id", "in", (Object)srcEntryList.toArray());
            DynamicObjectCollection itementryCollection = QueryServiceHelper.query((String)BBC_SALEORDER, (String)"id,billno,customer.id,owner.id,saleorgid,itementry.id,itementry.seq,itementry.item_id,itementry.assistattr_id,itementry.deliveredqty", (QFilter[])qfilter.toArray());
            if (itementryCollection == null || itementryCollection.size() <= 0) continue;
            DynamicObjectCollection billentrys = bill.getDynamicObjectCollection(BILLENTRY);
            Map<Long, DynamicObject> itemMap = itementryCollection.stream().collect(Collectors.toMap(r -> r.getLong("itementry.id"), r -> r));
            Map<Long, DynamicObject> serialNumberMap = this.getSerialnumberByBillId(imSaleOutBillEntryIds, billentrys);
            HashSet<Long> saleorgIds = new HashSet<Long>(billentrys.size());
            for (int i = 0; i < billentrys.size(); ++i) {
                DynamicObject serialnumber;
                DynamicObject srcenrty = (DynamicObject)srcRows.get(i);
                DynamicObject billentry = (DynamicObject)billentrys.get(i);
                Long saleOutBillEntryId = srcenrty.getLong((IDataEntityProperty)e.getFldProperties().get("billentry.id"));
                Long saleOrderEntryId = saleOutBillEntrySrcBillEntryMap.get(saleOutBillEntryId);
                if (saleOrderEntryId > 0L) {
                    DynamicObject saleOrderEntry = itemMap.get(saleOrderEntryId);
                    billentry.set("item_id", saleOrderEntry.get("itementry.item_id"));
                    billentry.set("assistattr_id", saleOrderEntry.get("itementry.assistattr_id"));
                    billentry.set("deliveredqty", saleOrderEntry.get("itementry.deliveredqty"));
                    billentry.set("mainbillentity", (Object)BBC_SALEORDER);
                    billentry.set("mainbillid", saleOrderEntry.get("id"));
                    billentry.set("mainbillnumber", saleOrderEntry.get("billno"));
                    billentry.set("mainbillentryid", (Object)saleOrderEntryId);
                    billentry.set("supplychannelid_id", saleOrderEntry.get("owner.id"));
                    billentry.set("orderchannelid_id", saleOrderEntry.get("customer.id"));
                    billentry.set("saleorg_id", saleOrderEntry.get("saleorgid"));
                    billentry.set("mainbillentryseq", saleOrderEntry.get("itementry.seq"));
                    saleorgIds.add(saleOrderEntry.getLong("saleorgid"));
                }
                if ((serialnumber = serialNumberMap.get(saleOutBillEntryId)) == null) continue;
                this.addSubentryentity(billentry, serialnumber);
                billentry.set("serialqty", billentry.get("deliverbaseqty"));
                billentry.set("serialunit", billentry.get("baseunit"));
            }
            this.setSaleOrgChannelid(billentrys, saleorgIds);
        }
    }

    private Map<Long, List<Long>> getImSaleOutBillEntryIdsMap(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entitys = e.getTargetExtDataEntitySet().FindByEntityKey(this.getTgtMainType().toString());
        HashMap<Long, List<Long>> imSaleOutBillEntryIdsMap = new HashMap<Long, List<Long>>(entitys.length);
        for (ExtendedDataEntity entity : entitys) {
            Object sourceRows = entity.getValue("ConvertSource");
            if (sourceRows == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u201c\u9500\u552e\u51fa\u5e93\u5355\u201d\u4fe1\u606f\u3002", (String)"SaloubillPushDeliveryrecordPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            List srcRows = (List)sourceRows;
            if (srcRows == null || srcRows.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u201c\u9500\u552e\u51fa\u5e93\u5355\u201d\u4fe1\u606f\u3002", (String)"SaloubillPushDeliveryrecordPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            DynamicObject outbill = (DynamicObject)srcRows.get(0);
            if (422876630176775168L != outbill.getLong((IDataEntityProperty)e.getFldProperties().get("biztype"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u975e\u7269\u6599\u7c7b\u9500\u552e\u4e1a\u52a1\u7c7b\u578b\uff0c\u65e0\u9700\u4e0b\u63a8\u53d1\u8d27\u8bb0\u5f55\u3002", (String)"SaloubillPushDeliveryrecordPlugin_3", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            List<Long> imSaleOutBillEntryIds = this.getEntryIds(srcRows, e);
            if (imSaleOutBillEntryIds == null || imSaleOutBillEntryIds.isEmpty()) continue;
            Long outBillId = outbill.getLong((IDataEntityProperty)e.getFldProperties().get("id"));
            imSaleOutBillEntryIdsMap.put(outBillId, imSaleOutBillEntryIds);
        }
        return imSaleOutBillEntryIdsMap;
    }

    private void isSaleOutBillPushDeliveryRecord(Map<Long, List<Long>> imSaleOutBillEntryIdsMap, List<Long> saleOutBillPushDeliveryRecordIds) {
        Set<Long> allImSaleOutBillEntryIds = imSaleOutBillEntryIdsMap.keySet();
        for (Long saleOutBillPushDeliveryRecordId : saleOutBillPushDeliveryRecordIds) {
            if (!allImSaleOutBillEntryIds.contains(saleOutBillPushDeliveryRecordId)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u9500\u552e\u51fa\u5e93\u5355\u5df2\u4e0b\u63a8\u53d1\u8d27\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u591a\u6b21\u4e0b\u63a8\u3002", (String)"SaloubillPushDeliveryrecordPlugin_2", (String)"scmc-im-formplugin", (Object[])new Object[0]));
        }
    }

    private void setSaleOrgChannelid(DynamicObjectCollection billentrys, Set<Long> saleorgIds) {
        QFilter qfilter = new QFilter("bizgroup", "in", saleorgIds);
        qfilter.and("isinnerorg", "=", (Object)true);
        DynamicObject[] customers = BusinessDataServiceHelper.load((String)"mdr_customer", (String)"id,bizgroup.id", (QFilter[])qfilter.toArray());
        if (customers != null && customers.length > 0) {
            HashMap<Long, Long> saleorgMap = new HashMap<Long, Long>(customers.length);
            for (DynamicObject customer : customers) {
                saleorgMap.put(customer.getLong("bizgroup.id"), customer.getLong("id"));
            }
            for (DynamicObject billentry : billentrys) {
                Long customerId = (Long)saleorgMap.get(billentry.getLong("saleorg_id"));
                billentry.set("saleorgchannelid_id", (Object)customerId);
            }
        }
    }

    private List<Long> getEntryIds(List<DynamicObject> srcRows, AfterConvertEventArgs e) {
        if (srcRows != null && srcRows.size() > 0) {
            ArrayList<Long> entryIds = new ArrayList<Long>(srcRows.size());
            for (DynamicObject srcentry : srcRows) {
                entryIds.add(srcentry.getLong((IDataEntityProperty)e.getFldProperties().get("billentry.id")));
            }
            return entryIds;
        }
        return null;
    }

    private Map<Long, DynamicObject> getSerialnumberByBillId(List<Long> imSaleOutBillEntryIds, DynamicObjectCollection billentrys) {
        QFilter filter = new QFilter("entryid", "in", imSaleOutBillEntryIds);
        DynamicObject[] serialnumbers = BusinessDataServiceHelper.load((String)"sbs_billsnrelation", (String)"billtype,billid,entrykey,entryid,entryentity.snnumber,entryentity.snmainfileid", (QFilter[])filter.toArray());
        int size = serialnumbers != null && serialnumbers.length > 0 ? serialnumbers.length : 0;
        HashMap<Long, DynamicObject> serialnumberMap = new HashMap<Long, DynamicObject>(size);
        if (size > 0) {
            for (DynamicObject serialnumber : serialnumbers) {
                DynamicObjectCollection entryenties = serialnumber.getDynamicObjectCollection("entryentity");
                if (entryenties == null || entryenties.size() <= 0) continue;
                serialnumberMap.put(serialnumber.getLong("entryid"), serialnumber);
            }
        }
        return serialnumberMap;
    }

    private void addSubentryentity(DynamicObject billentry, DynamicObject serialnumber) {
        if (serialnumber != null && serialnumber.getDynamicObjectCollection("entryentity") != null) {
            DynamicObjectCollection numberenties = billentry.getDynamicObjectCollection(SUBENTRY);
            DynamicObjectCollection entryenties = serialnumber.getDynamicObjectCollection("entryentity");
            HashSet<Object> numberset = new HashSet<Object>(entryenties.size());
            for (DynamicObject entry : entryenties) {
                DynamicObject number = new DynamicObject(numberenties.getDynamicObjectType());
                number.set("serialnumber", entry.get("snnumber"));
                number.set("scmserialid_id", entry.get("snmainfileid"));
                numberset.add(entry.get("snnumber"));
                numberenties.add((Object)number);
            }
            if (numberset.size() != entryenties.size()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u5e8f\u5217\u53f7\uff0c\u65e0\u6cd5\u4e0b\u63a8\u53d1\u8d27\u8bb0\u5f55\u3002", (String)"SaloubillPushDeliveryrecordPlugin_4", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
            billentry.set(SUBENTRY, (Object)numberenties);
        }
    }
}

