/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.botp;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.enums.PrecisionAccountEnum;

public class SaloutBillEntrustQtyBotpPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(SaloutBillEntrustQtyBotpPlugin.class);

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] entryRows;
        String mainKey = null;
        try {
            mainKey = this.getOption().getVariableValue("writeoff_mainKey");
        }
        catch (Exception e1) {
            logger.info("\u975e\u6838\u9500\u5355\u636e\u81ea\u52a8\u4e0b\u63a8");
        }
        if (mainKey == null) {
            return;
        }
        String variableValue = this.getOption().getVariableValue("entryKey");
        String srcEntryKey = this.getOption().getVariableValue("srcbillentrykey");
        ExtendedDataEntitySet dataEntitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity entryRow : entryRows = dataEntitySet.FindByEntityKey(variableValue)) {
            List srcRows = (List)entryRow.getValue("ConvertSource");
            BigDecimal baseqty = BigDecimal.ZERO;
            BigDecimal oriqtyunit2nd = BigDecimal.ZERO;
            BigDecimal oribaseqty = BigDecimal.ZERO;
            for (DynamicObject row : srcRows) {
                Map fieldmap = e.getFldProperties();
                Object pk = ((DynamicProperty)fieldmap.get(srcEntryKey + ".id")).getValue((Object)row);
                String rowqty = this.getOption().getVariableValue(String.valueOf(pk));
                baseqty = baseqty.add(new BigDecimal(rowqty));
                BigDecimal roworiqtyunit2nd = (BigDecimal)((DynamicProperty)fieldmap.get("qtyunit2nd")).getValue((Object)row);
                BigDecimal roworibaseqty = (BigDecimal)((DynamicProperty)fieldmap.get("baseqty")).getValue((Object)row);
                oriqtyunit2nd = oriqtyunit2nd.add(roworiqtyunit2nd);
                oribaseqty = oribaseqty.add(roworibaseqty);
            }
            entryRow.setValue("baseqty", (Object)baseqty);
            entryRow.setValue(mainKey, (Object)baseqty);
            DynamicObject unit2nd = entryRow.getDataEntity().getDynamicObject("unit2nd");
            if (unit2nd != null && oribaseqty.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal qty2nd = oriqtyunit2nd.multiply(baseqty).divide(oribaseqty, unit2nd.getInt("precision"), PrecisionAccountEnum.getEnumByVal((int)unit2nd.getInt("precisionaccount")));
                entryRow.setValue("qtyunit2nd", (Object)qty2nd);
                continue;
            }
            entryRow.setValue("qtyunit2nd", (Object)BigDecimal.ZERO);
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(tgtMainType);
        for (int i = 0; i < entitys.length; ++i) {
            DynamicObject bill = entitys[i].getDataEntity();
            DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
            HashMap cacheMap = new HashMap(billentry.size());
            for (DynamicObject row : billentry) {
                BigDecimal baseQty = row.getBigDecimal("baseqty");
                Object material = row.get("materialmasterid");
                Long materialmasterid = material instanceof DynamicObject ? (Long)((DynamicObject)material).getPkValue() : (material == null ? Long.valueOf(0L) : (Long)material);
                DynamicObject baseUnit = row.getDynamicObject("baseunit");
                DynamicObject unit = row.getDynamicObject("unit");
                BigDecimal unitRate = BillUnitAndQtytHelper.getUnitRateConv((Long)materialmasterid, (Long)((Long)unit.getPkValue()), (Long)((Long)baseUnit.getPkValue()), cacheMap);
                BigDecimal qty = null;
                qty = unit == null || baseQty.compareTo(BigDecimal.ZERO) == 0 || unitRate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : baseQty.divide(unitRate, unit.getInt("precision"), PrecisionAccountEnum.getEnumByVal((int)unit.getInt("precisionaccount")));
                row.set("qty", (Object)qty);
                row.set("remainreturnbaseqty", (Object)baseQty);
                row.set("remainreturnqty", (Object)qty);
                row.set("remainjoinpricebaseqty", (Object)baseQty);
                row.set("remainjoinpriceqty", (Object)qty);
                row.set("unverifybaseqty", (Object)baseQty);
                row.set("unverifyqty", (Object)qty);
                row.set("entrustunverifybaseqty", (Object)baseQty);
                row.set("entrustunverifyqty", (Object)qty);
            }
        }
    }
}

