/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.botp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TransApplyBillBotpPlugin
extends AbstractConvertPlugIn {
    private static final String MAINBILLID = "mainbillid";
    private static final String MAINBILLENTRYID = "mainbillentryid";
    private static final String IN_WARE_HOUSE_KEY = "inwarehouse";
    private static final String IN_LOCATION_KEY = "inlocation";
    private static final String WAREHOUSE = "warehouse";
    private static final String LOCATION = "location";

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        this.handleLotAndShelflife(entitys);
        Map<Object, DynamicObject> dynamicObjectMap = this.getDynamicObjectMap(entitys);
        if (dynamicObjectMap != null && !dynamicObjectMap.isEmpty()) {
            for (ExtendedDataEntity entity : entitys) {
                DynamicObject bill = entity.getDataEntity();
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    Object mainBillId = entry.get(MAINBILLID);
                    String mainBillEntryId = String.valueOf(entry.get(MAINBILLENTRYID));
                    Map<String, Object> inWareHouseAndLocation = this.getInWareHouseAndLocation(dynamicObjectMap, mainBillId, mainBillEntryId);
                    Object warehouse = inWareHouseAndLocation.get(IN_WARE_HOUSE_KEY);
                    Object location = inWareHouseAndLocation.get(IN_LOCATION_KEY);
                    entry.set(WAREHOUSE, warehouse);
                    entry.set(LOCATION, location);
                }
            }
        }
    }

    private void handleLotAndShelflife(ExtendedDataEntity[] entitys) {
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                DynamicObject material = entry.getDynamicObject("material");
                String formId = material.getDataEntityType().getName();
                if (!"bd_materialinventoryinfo".equals(formId)) {
                    return;
                }
                if (!material.getBoolean("enablelot")) {
                    entry.set("lotnumber", (Object)"");
                    entry.set("lot", null);
                }
                if (material.getBoolean("enableshelflifemgr")) continue;
                entry.set("producedate", null);
                entry.set("expirydate", null);
            }
        }
    }

    private Map<String, Object> getInWareHouseAndLocation(Map<Object, DynamicObject> dynamicObjectMap, Object mainBillId, String mainBillEntryId) {
        DynamicObject transApplyBill;
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (mainBillId != null && (transApplyBill = dynamicObjectMap.get(mainBillId)) != null) {
            DynamicObjectCollection transApplyEntrys = transApplyBill.getDynamicObjectCollection("billentry");
            for (DynamicObject applyEntry : transApplyEntrys) {
                String pkValue = String.valueOf(applyEntry.getPkValue());
                if (!mainBillEntryId.equals(pkValue)) continue;
                Object inWareHouse = applyEntry.get(IN_WARE_HOUSE_KEY);
                Object inLocation = applyEntry.get(IN_LOCATION_KEY);
                map.put(IN_WARE_HOUSE_KEY, inWareHouse);
                map.put(IN_LOCATION_KEY, inLocation);
            }
        }
        return map;
    }

    private Map<Object, DynamicObject> getDynamicObjectMap(ExtendedDataEntity[] entitys) {
        HashMap<Object, DynamicObject> dynamicObjectMap = new HashMap<Object, DynamicObject>(entitys.length);
        HashSet<Object> mainBillIds = new HashSet<Object>(entitys.length);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                Object mainBillId = entry.get(MAINBILLID);
                if (mainBillId == null) continue;
                mainBillIds.add(mainBillId);
            }
        }
        if (!mainBillIds.isEmpty()) {
            DynamicObject[] transApplyObjs;
            QFilter filter = new QFilter("id", "in", mainBillIds);
            for (DynamicObject transApplyObj : transApplyObjs = BusinessDataServiceHelper.load((String)"im_transapply", (String)"id,billentry.id,billentry.inwarehouse,billentry.inlocation", (QFilter[])filter.toArray())) {
                dynamicObjectMap.put(transApplyObj.getPkValue(), transApplyObj);
            }
        }
        return dynamicObjectMap;
    }
}

