/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.calcost;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.im.business.helper.calcost.FormShowHelper;
import kd.scmc.im.business.helper.calcost.strategy.CalCostEntryStrategy;
import kd.scmc.im.business.helper.calcost.strategy.EntryFieldStrategy;
import kd.scmc.im.business.helper.calcost.strategy.HeadFieldStrategy;
import kd.scmc.im.utils.FormUtils;
import kd.scmc.sbs.business.common.colsAssist.IColsSelectStrategy;

public class QueryPriceEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"billentry", "billfilter", "pricefield", "exratedatefield", "amountfield", "formula"});
        FormUtils.addF7Listener((BeforeF7SelectListener)this, (String[])new String[]{"imbill"});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propertyName = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if ("imbill".equals(propertyName)) {
            this.beforeF7Bill(showParameter);
        }
    }

    public void afterCopyData(EventObject e) {
        this.getModel().setValue("ispreset", (Object)Boolean.FALSE);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowHelper.setOperationItems((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"imbill", (String)"operation");
    }

    public void click(EventObject evt) {
        String field;
        super.click(evt);
        IDataModel model = this.getModel();
        Control control = (Control)evt.getSource();
        switch (field = control.getKey()) {
            case "billentry": {
                this.clickBillEntry(model);
                break;
            }
            case "billfilter": {
                this.clickBillFilter(model);
                break;
            }
            case "pricefield": {
                this.clickPriceField(model);
                break;
            }
            case "exratedatefield": {
                this.clickExrateDateField(model);
                break;
            }
            case "amountfield": {
                this.clickAmountField(model);
                break;
            }
            case "formula": {
                this.clickFormula(model);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        IDataModel model = this.getModel();
        String returnData = (String)evt.getReturnData();
        String actionId = evt.getActionId();
        IPageCache pageCache = this.getPageCache();
        if (returnData == null || actionId == null) {
            return;
        }
        switch (actionId) {
            case "billentryCB": {
                FormShowHelper.closeCallSetField((IDataModel)model, (String)returnData, (String)"billentry", (String)"billentrykey");
                break;
            }
            case "billfilterCB": {
                FormShowHelper.closeCallSetFilter((IDataModel)model, (IPageCache)pageCache, (String)returnData, (String)"billfilter", (String)"billfilterjson_tag", (String)"billfilterscript_tag");
                break;
            }
            case "pricefieldCB": {
                FormShowHelper.closeCallSetField((IDataModel)model, (String)returnData, (String)"pricefield", (String)"pricefieldkey");
                break;
            }
            case "exratedatefieldCB": {
                FormShowHelper.closeCallSetField((IDataModel)model, (String)returnData, (String)"exratedatefield", (String)"exratedatefieldkey");
                break;
            }
            case "amountfieldCB": {
                this.closeCallSetEntryField(model, pageCache, returnData, "amountfield", "amountfieldkey");
                break;
            }
            case "formulajsonCB": {
                FormShowHelper.closeCallSetEntryFormula((IDataModel)model, (IPageCache)pageCache, (String)returnData, (String)"formula", (String)"formulajson_tag", (String)"formulascript_tag");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        int rowIndex = changeSet[0].getRowIndex();
        switch (propertyName) {
            case "imbill": {
                this.imBillChange(oldValue);
                break;
            }
            case "billentry": {
                this.billEntryChange(newValue, oldValue);
                break;
            }
            case "operation": {
                this.operationChange(newValue);
                break;
            }
            case "pricefield": {
                this.fieldChange(newValue, "pricefieldkey");
                break;
            }
            case "exratedatefield": {
                this.fieldChange(newValue, "exratedatefieldkey");
                break;
            }
            case "billfilter": {
                this.filterChange(newValue);
                break;
            }
            case "amountfield": {
                this.entryFieldChange(newValue, rowIndex);
                break;
            }
            case "formula": {
                this.entryFormulaChange(newValue, rowIndex);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent closedEvent) {
        super.confirmCallBack(closedEvent);
        String callBackId = closedEvent.getCallBackId();
        MessageBoxResult result = closedEvent.getResult();
        String customValue = closedEvent.getCustomVaule();
        switch (callBackId) {
            case "imbillCB": {
                this.imBillConfirmCb(result, customValue);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("applyorg".equals(key)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            boolean fromDatabase = dataEntity.getDataEntityState().getFromDatabase();
            if (!fromDatabase) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u83b7\u53d6\u5355\u4f4d\u6210\u672c\u914d\u7f6e\u3002", (String)"FormShowHelper_0", (String)"scmc-im-business", (Object[])new Object[0]));
                return;
            }
            long priceConfId = dataEntity.getLong("id");
            FormShowHelper.showApplyOrgForm((IFormView)this.getView(), (Object)priceConfId);
        }
    }

    private void beforeF7Bill(ListShowParameter showParameter) {
        QFilter billFilter = new QFilter("modeltype", "=", (Object)"BillFormModel");
        showParameter.getListFilterParameter().setFilter(billFilter);
    }

    private void clickBillEntry(IDataModel model) {
        DynamicObject imBill = model.getDataEntity().getDynamicObject("imbill");
        if (imBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4e1a\u52a1\u5355\u636e\u3002", (String)"QueryPriceEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        String imBillNum = imBill.getString("number");
        FormShowHelper.showEntrySelectForm((AbstractFormPlugin)this, (String)imBillNum, (IColsSelectStrategy)new CalCostEntryStrategy(), (String)"billentryCB");
    }

    private void clickBillFilter(IDataModel model) {
        DynamicObject bill = model.getDataEntity().getDynamicObject("imbill");
        if (bill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4e1a\u52a1\u5355\u636e\u3002", (String)"QueryPriceEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        String billNum = bill.getString("number");
        FormShowHelper.showFilterForm((AbstractFormPlugin)this, (IDataModel)model, (String)billNum, (String)"billfilterjson_tag", (String)"billfilterCB");
    }

    private void clickPriceField(IDataModel model) {
        DynamicObject imBill = model.getDataEntity().getDynamicObject("imbill");
        if (imBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4e1a\u52a1\u5355\u636e\u3002", (String)"QueryPriceEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        String billEntry = model.getDataEntity().getString("billentrykey");
        String imBillNum = imBill.getString("number");
        EntryFieldStrategy fieldStrategy = new EntryFieldStrategy(billEntry, new IDataEntityProperty[]{new PriceProp()});
        ArrayList<String> filterList = new ArrayList<String>(16);
        String priceFieldKey = model.getDataEntity().getString("pricefieldkey");
        if (StringUtils.isNotBlank((CharSequence)priceFieldKey)) {
            filterList.add(priceFieldKey);
        }
        FormShowHelper.showColsTreeForm((AbstractFormPlugin)this, (String)imBillNum, (int)-1, (IColsSelectStrategy)fieldStrategy, null, filterList, (String)"pricefieldCB");
    }

    private void clickExrateDateField(IDataModel model) {
        DynamicObject imBill = model.getDataEntity().getDynamicObject("imbill");
        if (imBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4e1a\u52a1\u5355\u636e\u3002", (String)"QueryPriceEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        String imBillNum = imBill.getString("number");
        HeadFieldStrategy fieldStrategy = new HeadFieldStrategy(new IDataEntityProperty[]{new DateTimeProp()});
        ArrayList<String> filterList = new ArrayList<String>(16);
        String exrateDateFieldKey = model.getDataEntity().getString("exratedatefieldkey");
        if (StringUtils.isNotBlank((CharSequence)exrateDateFieldKey)) {
            filterList.add(exrateDateFieldKey);
        }
        FormShowHelper.showColsTreeForm((AbstractFormPlugin)this, (String)imBillNum, (int)-1, (IColsSelectStrategy)fieldStrategy, null, filterList, (String)"exratedatefieldCB");
    }

    private void clickAmountField(IDataModel model) {
        DynamicObject imBill = model.getDataEntity().getDynamicObject("imbill");
        if (imBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4e1a\u52a1\u5355\u636e\u3002", (String)"QueryPriceEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        String priceKey = (String)model.getValue("pricefieldkey");
        if (StringUtils.isBlank((CharSequence)priceKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u4f4d\u6210\u672c\u56de\u586b\u5b57\u6bb5\u3002", (String)"SBS-E-716514", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowIndex = model.getEntryCurrentRowIndex("amountcalentry");
        String billEntry = model.getDataEntity().getString("billentrykey");
        String imBillNum = imBill.getString("number");
        EntryFieldStrategy fieldStrategy = new EntryFieldStrategy(billEntry, new IDataEntityProperty[]{new AmountProp()});
        ArrayList<String> filterList = new ArrayList<String>(16);
        DynamicObjectCollection calEntrys = model.getDataEntity(true).getDynamicObjectCollection("amountcalentry");
        for (DynamicObject calEntry : calEntrys) {
            String amountField = calEntry.getString("amountfieldkey");
            if (!StringUtils.isNotBlank((CharSequence)amountField)) continue;
            filterList.add(amountField);
        }
        FormShowHelper.showColsTreeForm((AbstractFormPlugin)this, (String)imBillNum, (int)rowIndex, (IColsSelectStrategy)fieldStrategy, null, filterList, (String)"amountfieldCB");
    }

    private void clickFormula(IDataModel model) {
        DynamicObject imBill = model.getDataEntity().getDynamicObject("imbill");
        if (imBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4e1a\u52a1\u5355\u636e\u3002", (String)"QueryPriceEditPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            return;
        }
        String imBillNum = imBill.getString("number");
        int rowIndex = model.getEntryCurrentRowIndex("amountcalentry");
        String formulaJson = (String)model.getValue("formulajson_tag", rowIndex);
        FormShowHelper.showEntryFormulaForm((AbstractFormPlugin)this, (int)rowIndex, (String)imBillNum, (String)formulaJson, (String)"formulajsonCB");
    }

    private void imBillChange(Object oldValue) {
        if (oldValue != null) {
            DynamicObject oldImBill = (DynamicObject)oldValue;
            HashMap<String, Object> confirmInfo = new HashMap<String, Object>(16);
            confirmInfo.put("imbill", oldImBill.getPkValue());
            String msg = ResManager.loadKDString((String)"\u5207\u6362\u4e1a\u52a1\u5355\u636e\u5c06\u6e05\u9664\u9875\u9762\u7684\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"QueryPriceEditPlugin_1", (String)"scmc-im-formplugin", (Object[])new Object[0]);
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("imbillCB", (IFormPlugin)this);
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(confirmInfo));
        } else {
            FormShowHelper.setOperationItems((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"imbill", (String)"operation");
        }
    }

    private void billEntryChange(Object newValue, Object oldValue) {
        if (StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue("billentrykey", null);
            this.getModel().setValue("pricefield", null);
            this.getModel().deleteEntryData("amountcalentry");
        } else if (StringUtils.isNotBlank((Object)newValue) && StringUtils.isNotBlank((Object)oldValue)) {
            this.getModel().setValue("pricefield", null);
            this.getModel().deleteEntryData("amountcalentry");
        }
    }

    private void operationChange(Object newValue) {
        if (newValue != null) {
            DynamicObject imBill = this.getModel().getDataEntity().getDynamicObject("imbill");
            if (imBill == null) {
                return;
            }
            String imBillNum = imBill.getString("number");
            List operations = EntityMetadataCache.getDataEntityOperate((String)imBillNum);
            for (Map operation : operations) {
                String opKey = (String)operation.get("key");
                if (!opKey.equals(newValue)) continue;
                this.getModel().setValue("operationname", operation.get("name"));
            }
        } else {
            this.getModel().setValue("operationname", null);
        }
    }

    private void fieldChange(Object newValue, String filedKey) {
        int count = this.getModel().getEntryRowCount("amountcalentry");
        for (int i = 0; i < count; ++i) {
            this.getModel().setValue("amountfieldkey", null, i);
            this.getModel().setValue("amountfield", null, i);
        }
        if (StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue(filedKey, null);
        }
    }

    private void filterChange(Object newValue) {
        if (StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue("billfilterjson_tag", null);
            this.getModel().setValue("billfilterscript_tag", null);
        }
    }

    private void entryFieldChange(Object newValue, int rowIndex) {
        if (StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue("amountfieldkey", null, rowIndex);
        }
    }

    private void entryFormulaChange(Object newValue, int rowIndex) {
        if (StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue("formulajson_tag", null, rowIndex);
            this.getModel().setValue("formulascript_tag", null, rowIndex);
        }
    }

    private void imBillConfirmCb(MessageBoxResult result, String customValue) {
        if (StringUtils.isBlank((CharSequence)customValue)) {
            return;
        }
        Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.getModel().setValue("billentry", null);
            FormShowHelper.setOperationItems((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"imbill", (String)"operation");
            this.getModel().setValue("operation", null);
            this.getModel().setValue("billfilter", null);
            this.getModel().setValue("billfilterjson_tag", null);
            this.getModel().setValue("billfilterscript_tag", null);
            this.getModel().setValue("pricefield", null);
            this.getModel().setValue("pricefieldkey", null);
            this.getModel().setValue("exratedatefield", null);
            this.getModel().setValue("exratedatefieldkey", null);
            this.getModel().deleteEntryData("amountcalentry");
        } else {
            Object imBill = confirmInfo.get("imbill");
            this.getModel().beginInit();
            this.getModel().setValue("imbill", imBill);
            this.getModel().endInit();
            this.getView().updateView("imbill");
        }
    }

    private void closeCallSetEntryField(IDataModel dataModel, IPageCache pageCache, String returnData, String field, String fieldKey) {
        JSONArray fieldArr = (JSONArray)SerializationUtils.fromJsonString((String)returnData, JSONArray.class);
        if (fieldArr != null && !fieldArr.isEmpty()) {
            String costKey;
            String rowIndex = pageCache.get("rowindex");
            Map fieldMap = (Map)fieldArr.get(0);
            String amountKey = (String)fieldMap.get("id");
            if (StringUtils.isNotBlank((CharSequence)amountKey) && StringUtils.isNotBlank((CharSequence)(costKey = (String)dataModel.getValue("pricefieldkey")))) {
                String[] costKeys = costKey.split("\\.");
                String[] amountKeys = amountKey.split("\\.");
                String formId = (String)dataModel.getValue("imbill_id");
                if (StringUtils.isBlank((CharSequence)formId)) {
                    return;
                }
                MainEntityType entity = MetadataServiceHelper.getDataEntityType((String)formId);
                IDataEntityProperty costProp = entity.findProperty(costKeys[costKeys.length - 1]);
                IDataEntityProperty amProp = entity.findProperty(amountKeys[amountKeys.length - 1]);
                if (!(costProp instanceof AmountProp) || !(amProp instanceof AmountProp)) {
                    return;
                }
                if (!((AmountProp)costProp).getControlPropName().equals(((AmountProp)amProp).getControlPropName())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u7b97\u5b57\u6bb5\u4e0e\u5355\u4f4d\u6210\u672c\u7684\u5e01\u522b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SBS-E-141282", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            dataModel.setValue(field, fieldMap.get("text"), Integer.parseInt(rowIndex));
            dataModel.setValue(fieldKey, fieldMap.get("id"), Integer.parseInt(rowIndex));
        }
    }
}

