/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.im.formplugin.calcost;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.im.business.helper.calcost.FormShowHelper;
import kd.scmc.im.formplugin.calcost.OperationListDataProvider;

public class QueryPriceListPlugin
extends AbstractTreeListPlugin {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new OperationListDataProvider());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("applyorg".equals(key)) {
            Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            if (primaryKeyValues.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"QueryCalCostListPlugin_0", (String)"scmc-im-formplugin", (Object[])new Object[0]));
                return;
            }
            Object priceConfId = primaryKeyValues[0];
            FormShowHelper.showApplyOrgForm((IFormView)this.getView(), (Object)priceConfId);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if ("imbill.name".equals(args.getFieldName()) || "imbill.id".equals(args.getFieldName())) {
            args.addCustomQFilter(this.getBillFilter());
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List columns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        DynamicObjectCollection imBills = QueryServiceHelper.query((String)"bos_entityobject", (String)"id,name", (QFilter[])this.getBillFilter().toArray());
        for (FilterColumn filterColumn : columns) {
            if (!"imbill.name".equals(filterColumn.getFieldName())) continue;
            ArrayList<ComboItem> combos = new ArrayList<ComboItem>(imBills.size());
            for (DynamicObject imBill : imBills) {
                ComboItem customFilter = new ComboItem();
                customFilter.setCaption(new LocaleString(imBill.getString("name")));
                customFilter.setValue(String.valueOf(imBill.get("id")));
                combos.add(customFilter);
            }
            CommonFilterColumn billColumn = (CommonFilterColumn)filterColumn;
            billColumn.setComboItems(combos);
            billColumn.setType("enum");
        }
    }

    private QFilter getBillFilter() {
        QFilter billFilter = new QFilter("modeltype", "=", (Object)"BillFormModel");
        billFilter.and("bizappid.number", "=", (Object)"im");
        return billFilter;
    }
}

